/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.IProject;
import org.omegat.core.data.NotLoadedProject;
import org.omegat.core.segmentation.Segmenter;
import org.omegat.core.spellchecker.ISpellChecker;
import org.omegat.core.spellchecker.SpellChecker;
import org.omegat.core.tagvalidation.ITagValidation;
import org.omegat.core.tagvalidation.TagValidationTool;
import org.omegat.core.threads.IAutoSave;
import org.omegat.core.threads.SaveThread;
import org.omegat.core.threads.VersionCheckThread;
import org.omegat.filters2.IFilter;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.gui.comments.CommentsTextArea;
import org.omegat.gui.comments.IComments;
import org.omegat.gui.dictionaries.DictionariesTextArea;
import org.omegat.gui.dictionaries.IDictionaries;
import org.omegat.gui.editor.EditorController;
import org.omegat.gui.editor.IEditor;
import org.omegat.gui.editor.MarkerController;
import org.omegat.gui.editor.mark.IMarker;
import org.omegat.gui.exttrans.IMachineTranslation;
import org.omegat.gui.exttrans.MachineTranslateTextArea;
import org.omegat.gui.glossary.GlossaryManager;
import org.omegat.gui.glossary.GlossaryTextArea;
import org.omegat.gui.glossary.IGlossaries;
import org.omegat.gui.issues.IIssues;
import org.omegat.gui.issues.IssuesPanelController;
import org.omegat.gui.main.ConsoleWindow;
import org.omegat.gui.main.IMainWindow;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.matches.IMatcher;
import org.omegat.gui.matches.MatchesTextArea;
import org.omegat.gui.multtrans.MultipleTransPane;
import org.omegat.gui.notes.INotes;
import org.omegat.gui.notes.NotesTextArea;
import org.omegat.gui.properties.SegmentPropertiesArea;
import org.omegat.languagetools.LanguageToolWrapper;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.Preferences;
import org.omegat.util.gui.UIDesignManager;

public final class Core {
    private static IProject currentProject;
    private static IMainWindow mainWindow;
    protected static IEditor editor;
    private static ITagValidation tagValidation;
    private static IIssues issuesWindow;
    private static IMatcher matcher;
    private static ISpellChecker spellChecker;
    private static FilterMaster filterMaster;
    protected static IAutoSave saveThread;
    private static final ReentrantLock EXCLUSIVE_RUN_LOCK;
    protected static IGlossaries glossary;
    private static GlossaryManager glossaryManager;
    private static MachineTranslateTextArea machineTranslatePane;
    private static DictionariesTextArea dictionaries;
    private static MultipleTransPane multiple;
    private static INotes notes;
    private static IComments comments;
    private static Segmenter segmenter;
    private static Map<String, String> cmdLineParams;
    private static final List<String> PLUGINS_LOADING_ERRORS;
    private static final List<IMarker> MARKERS;
    private static StackTraceElement[] runningStackTrace;

    private Core() {
    }

    public static IProject getProject() {
        return currentProject;
    }

    public static void setProject(IProject newCurrentProject) {
        currentProject = newCurrentProject;
    }

    public static IMainWindow getMainWindow() {
        return mainWindow;
    }

    public static IEditor getEditor() {
        return editor;
    }

    public static ITagValidation getTagValidation() {
        return tagValidation;
    }

    public static IIssues getIssues() {
        return issuesWindow;
    }

    public static IMatcher getMatcher() {
        return matcher;
    }

    public static ISpellChecker getSpellChecker() {
        return spellChecker;
    }

    public static FilterMaster getFilterMaster() {
        return filterMaster;
    }

    public static void setFilterMaster(FilterMaster newFilterMaster) {
        filterMaster = newFilterMaster;
        EntryKey.setIgnoreFileContext(newFilterMaster.getConfig().isIgnoreFileContext());
    }

    public static MachineTranslateTextArea getMachineTranslatePane() {
        return machineTranslatePane;
    }

    public static IAutoSave getAutoSave() {
        return saveThread;
    }

    public static IGlossaries getGlossary() {
        return glossary;
    }

    public static GlossaryManager getGlossaryManager() {
        return glossaryManager;
    }

    public static INotes getNotes() {
        return notes;
    }

    public static IComments getComments() {
        return comments;
    }

    public static IDictionaries getDictionaries() {
        return dictionaries;
    }

    public static Segmenter getSegmenter() {
        return segmenter;
    }

    public static void setSegmenter(Segmenter newSegmenter) {
        segmenter = newSegmenter;
    }

    public static void initializeGUI(ClassLoader classLoader, Map<String, String> params) throws Exception {
        cmdLineParams = params;
        currentProject = new NotLoadedProject();
        UIDesignManager.initialize(classLoader);
        MainWindow me = new MainWindow();
        mainWindow = me;
        MarkerController.init();
        LanguageToolWrapper.init();
        segmenter = new Segmenter(Preferences.getSRX());
        filterMaster = new FilterMaster(Preferences.getFilters());
        editor = new EditorController(me);
        tagValidation = new TagValidationTool();
        issuesWindow = new IssuesPanelController(me);
        matcher = new MatchesTextArea(me);
        GlossaryTextArea glossaryArea = new GlossaryTextArea(me);
        glossary = glossaryArea;
        glossaryManager = new GlossaryManager(glossaryArea);
        notes = new NotesTextArea(me);
        comments = new CommentsTextArea(me);
        machineTranslatePane = new MachineTranslateTextArea(me);
        dictionaries = new DictionariesTextArea(me);
        spellChecker = new SpellChecker();
        multiple = new MultipleTransPane(me);
        new SegmentPropertiesArea(me);
        SaveThread th = new SaveThread();
        saveThread = th;
        th.start();
        new VersionCheckThread(10).start();
    }

    public static void initializeConsole(Map<String, String> params) throws Exception {
        cmdLineParams = params;
        tagValidation = new TagValidationTool();
        currentProject = new NotLoadedProject();
        mainWindow = new ConsoleWindow();
    }

    protected static void setMainWindow(IMainWindow mainWindow) {
        Core.mainWindow = mainWindow;
    }

    protected static void setCurrentProject(IProject currentProject) {
        Core.currentProject = currentProject;
    }

    public static void registerMarker(IMarker marker) {
        MARKERS.add(marker);
    }

    public static List<IMarker> getMarkers() {
        return MARKERS;
    }

    public static Map<String, String> getParams() {
        return cmdLineParams;
    }

    public static void registerFilterClass(Class<? extends IFilter> clazz) {
        PluginUtils.getFilterClasses().add(clazz);
    }

    public static void registerMachineTranslationClass(Class<? extends IMachineTranslation> clazz) {
        PluginUtils.getMachineTranslationClasses().add(clazz);
    }

    public static void registerMarkerClass(Class<? extends IMarker> clazz) {
        PluginUtils.getMarkerClasses().add(clazz);
    }

    public static void registerTokenizerClass(Class<? extends ITokenizer> clazz) {
        PluginUtils.getTokenizerClasses().add(clazz);
    }

    public static List<String> getPluginsLoadingErrors() {
        return PLUGINS_LOADING_ERRORS;
    }

    public static void pluginLoadingError(String errorText) {
        PLUGINS_LOADING_ERRORS.add(errorText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeExclusively(boolean waitForUnlock, RunnableWithException run) throws Exception {
        if (!EXCLUSIVE_RUN_LOCK.tryLock(waitForUnlock ? 180000L : 1L, TimeUnit.MILLISECONDS)) {
            TimeoutException ex = new TimeoutException("Timeout waiting for previous exclusive execution");
            Exception cause = new Exception("Previous exclusive execution");
            if (runningStackTrace != null) {
                cause.setStackTrace(runningStackTrace);
                ex.initCause(cause);
            }
            throw ex;
        }
        try {
            runningStackTrace = new Exception().getStackTrace();
            run.run();
        }
        finally {
            runningStackTrace = null;
            EXCLUSIVE_RUN_LOCK.unlock();
        }
    }

    static {
        EXCLUSIVE_RUN_LOCK = new ReentrantLock();
        cmdLineParams = Collections.emptyMap();
        PLUGINS_LOADING_ERRORS = Collections.synchronizedList(new ArrayList());
        MARKERS = new ArrayList<IMarker>();
    }

    public static interface RunnableWithException {
        public void run() throws Exception;
    }
}

