/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.core.rollup.action.RollupJobCaps;
import org.elasticsearch.xpack.core.rollup.job.RollupJobConfig;

public class RollupIndexCaps
implements Writeable,
ToXContentFragment {
    private static ParseField ROLLUP_JOBS = new ParseField("rollup_jobs", new String[0]);
    private static ParseField DOC_FIELD = new ParseField("_doc", new String[0]);
    private static ParseField META_FIELD = new ParseField("_meta", new String[0]);
    private static ParseField ROLLUP_FIELD = new ParseField("_rollup", new String[0]);
    private static final ObjectParser<RollupIndexCaps, Void> METADATA_PARSER = new ObjectParser("cluster:monitor/xpack/rollup/get/caps", true, RollupIndexCaps::new);
    private List<RollupJobCaps> jobCaps = Collections.emptyList();
    private String rollupIndexName;

    private RollupIndexCaps() {
    }

    public RollupIndexCaps(String rollupIndexName, List<RollupJobConfig> jobs) {
        this.rollupIndexName = rollupIndexName;
        this.jobCaps = Objects.requireNonNull(jobs, "List of Rollup Jobs cannot be null").stream().map(RollupJobCaps::new).collect(Collectors.toList());
    }

    RollupIndexCaps(StreamInput in) throws IOException {
        this.rollupIndexName = in.readString();
        this.jobCaps = in.readList(RollupJobCaps::new);
    }

    protected List<RollupJobCaps> getJobCaps() {
        return this.jobCaps;
    }

    List<RollupJobCaps> getJobCapsByIndexPattern(String index) {
        return this.jobCaps.stream().filter(cap -> index.equals("_all") || cap.getIndexPattern().equals(index)).collect(Collectors.toList());
    }

    void setJobs(List<RollupJobConfig> jobs) {
        this.jobCaps = jobs.stream().map(RollupJobCaps::new).collect(Collectors.toList());
    }

    boolean hasCaps() {
        return !this.jobCaps.isEmpty();
    }

    public List<String> getRollupIndices() {
        return this.jobCaps.stream().map(RollupJobCaps::getRollupIndex).collect(Collectors.toList());
    }

    static RollupIndexCaps parseMetadataXContent(BytesReference source, String indexName) {
        XContentParser parser;
        try {
            parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)source, (XContentType)XContentType.JSON);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to parse mapping metadata for index [" + indexName + "]", e);
        }
        return (RollupIndexCaps)METADATA_PARSER.apply(parser, null);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.rollupIndexName);
        out.writeList(this.jobCaps);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.rollupIndexName);
        builder.field(ROLLUP_JOBS.getPreferredName(), this.jobCaps);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RollupIndexCaps that = (RollupIndexCaps)other;
        return Objects.equals(this.rollupIndexName, that.rollupIndexName) && Objects.equals(this.jobCaps, that.jobCaps);
    }

    public int hashCode() {
        return Objects.hash(this.rollupIndexName, this.jobCaps);
    }

    static {
        METADATA_PARSER.declareField((parser, rollupIndexCaps, aVoid) -> rollupIndexCaps.setJobs(((DocParser)DocParser.DOC_PARSER.apply((XContentParser)parser, (Object)aVoid)).jobs), DOC_FIELD, ObjectParser.ValueType.OBJECT);
    }

    private static class MetaParser {
        private static final ObjectParser<List<RollupJobConfig>, Void> META_PARSER = new ObjectParser("_rollup_meta_parser", true, ArrayList::new);

        private MetaParser() {
        }

        static {
            META_PARSER.declareField((parser, jobs, aVoid) -> {
                while (!parser.nextToken().equals((Object)XContentParser.Token.END_OBJECT)) {
                    jobs.add(RollupJobConfig.fromXContent((XContentParser)parser, null));
                }
            }, ROLLUP_FIELD, ObjectParser.ValueType.OBJECT);
        }
    }

    private static class DocParser {
        public List<RollupJobConfig> jobs;
        private static final ConstructingObjectParser<DocParser, Void> DOC_PARSER = new ConstructingObjectParser("_rollup_doc_parser", true, a -> {
            ArrayList<RollupJobConfig> j = new ArrayList<RollupJobConfig>();
            for (Object o : (List)a[0]) {
                if (!(o instanceof RollupJobConfig)) continue;
                j.add((RollupJobConfig)o);
            }
            return new DocParser(j);
        });

        DocParser(List<RollupJobConfig> jobs) {
            this.jobs = jobs;
        }

        static {
            DOC_PARSER.declareField(ConstructingObjectParser.constructorArg(), (arg_0, arg_1) -> ((ObjectParser)MetaParser.META_PARSER).apply(arg_0, arg_1), META_FIELD, ObjectParser.ValueType.OBJECT);
        }
    }
}

