/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import com.maxmind.db.NoCache;
import com.maxmind.db.NodeCache;
import com.maxmind.db.Reader;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.model.AbstractResponse;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.geoip.DatabaseReaderLazyLoader;
import org.elasticsearch.ingest.geoip.GeoIpProcessor;
import org.elasticsearch.plugins.IngestPlugin;
import org.elasticsearch.plugins.Plugin;

public class IngestGeoIpPlugin
extends Plugin
implements IngestPlugin,
Closeable {
    public static final Setting<Long> CACHE_SIZE = Setting.longSetting((String)"ingest.geoip.cache_size", (long)1000L, (long)0L, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static String[] DEFAULT_DATABASE_FILENAMES = new String[]{"GeoLite2-ASN.mmdb", "GeoLite2-City.mmdb", "GeoLite2-Country.mmdb"};
    private Map<String, DatabaseReaderLazyLoader> databaseReaders;

    public List<Setting<?>> getSettings() {
        return Arrays.asList(CACHE_SIZE);
    }

    public Map<String, Processor.Factory> getProcessors(Processor.Parameters parameters) {
        if (this.databaseReaders != null) {
            throw new IllegalStateException("getProcessors called twice for geoip plugin!!");
        }
        Path geoIpDirectory = this.getGeoIpDirectory(parameters);
        Path geoIpConfigDirectory = parameters.env.configFile().resolve("ingest-geoip");
        long cacheSize = (Long)CACHE_SIZE.get(parameters.env.settings());
        try {
            this.databaseReaders = IngestGeoIpPlugin.loadDatabaseReaders(geoIpDirectory, geoIpConfigDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Collections.singletonMap("geoip", new GeoIpProcessor.Factory(this.databaseReaders, new GeoIpCache(cacheSize)));
    }

    @SuppressForbidden(reason="PathUtils#get")
    private Path getGeoIpDirectory(Processor.Parameters parameters) {
        Path geoIpDirectory = parameters.env.settings().get("ingest.geoip.database_path") == null ? parameters.env.modulesFile().resolve("ingest-geoip") : PathUtils.get((String)parameters.env.settings().get("ingest.geoip.database_path"), (String[])new String[0]);
        return geoIpDirectory;
    }

    static Map<String, DatabaseReaderLazyLoader> loadDatabaseReaders(Path geoIpDirectory, Path geoIpConfigDirectory) throws IOException {
        DatabaseReaderLazyLoader loader;
        IngestGeoIpPlugin.assertDatabaseExistence(geoIpDirectory, true);
        IngestGeoIpPlugin.assertDatabaseExistence(geoIpConfigDirectory, false);
        boolean loadDatabaseOnHeap = Booleans.parseBoolean((String)System.getProperty("es.geoip.load_db_on_heap", "false"));
        HashMap<String, DatabaseReaderLazyLoader> databaseReaders = new HashMap<String, DatabaseReaderLazyLoader>();
        for (String databaseFilename : DEFAULT_DATABASE_FILENAMES) {
            Path databasePath = geoIpDirectory.resolve(databaseFilename);
            loader = IngestGeoIpPlugin.createLoader(databasePath, loadDatabaseOnHeap);
            databaseReaders.put(databaseFilename, loader);
        }
        if (Files.exists(geoIpConfigDirectory, new LinkOption[0])) {
            try (Stream<Path> databaseFiles = Files.list(geoIpConfigDirectory);){
                PathMatcher pathMatcher = geoIpConfigDirectory.getFileSystem().getPathMatcher("glob:**.mmdb");
                Iterator iterator = databaseFiles.iterator();
                while (iterator.hasNext()) {
                    Path databasePath = (Path)iterator.next();
                    if (!Files.isRegularFile(databasePath, new LinkOption[0]) || !pathMatcher.matches(databasePath)) continue;
                    String databaseFileName = databasePath.getFileName().toString();
                    loader = IngestGeoIpPlugin.createLoader(databasePath, loadDatabaseOnHeap);
                    databaseReaders.put(databaseFileName, loader);
                }
            }
        }
        return Collections.unmodifiableMap(databaseReaders);
    }

    private static DatabaseReaderLazyLoader createLoader(Path databasePath, boolean loadDatabaseOnHeap) {
        return new DatabaseReaderLazyLoader(databasePath, (CheckedSupplier<DatabaseReader, IOException>)((CheckedSupplier)() -> {
            DatabaseReader.Builder builder = IngestGeoIpPlugin.createDatabaseBuilder(databasePath).withCache((NodeCache)NoCache.getInstance());
            if (loadDatabaseOnHeap) {
                builder.fileMode(Reader.FileMode.MEMORY);
            } else {
                builder.fileMode(Reader.FileMode.MEMORY_MAPPED);
            }
            return builder.build();
        }));
    }

    private static void assertDatabaseExistence(Path path, boolean exists) throws IOException {
        for (String database : DEFAULT_DATABASE_FILENAMES) {
            if (Files.exists(path.resolve(database), new LinkOption[0]) == exists) continue;
            String message = "expected database [" + database + "] to " + (exists ? "" : "not ") + "exist in [" + path + "]";
            throw new IOException(message);
        }
    }

    @SuppressForbidden(reason="Maxmind API requires java.io.File")
    private static DatabaseReader.Builder createDatabaseBuilder(Path databasePath) {
        return new DatabaseReader.Builder(databasePath.toFile());
    }

    @Override
    public void close() throws IOException {
        if (this.databaseReaders != null) {
            IOUtils.close(this.databaseReaders.values());
        }
    }

    static class GeoIpCache {
        private final Cache<CacheKey, AbstractResponse> cache;

        GeoIpCache(long maxSize) {
            if (maxSize < 0L) {
                throw new IllegalArgumentException("geoip max cache size must be 0 or greater");
            }
            this.cache = CacheBuilder.builder().setMaximumWeight(maxSize).build();
        }

        <T extends AbstractResponse> T putIfAbsent(InetAddress ip, Class<T> responseType, Function<InetAddress, AbstractResponse> retrieveFunction) {
            CacheKey cacheKey = new CacheKey(ip, responseType);
            AbstractResponse response = (AbstractResponse)this.cache.get(cacheKey);
            if (response == null) {
                response = retrieveFunction.apply(ip);
                this.cache.put(cacheKey, (Object)response);
            }
            return (T)((AbstractResponse)responseType.cast(response));
        }

        <T extends AbstractResponse> T get(InetAddress ip, Class<T> responseType) {
            CacheKey cacheKey = new CacheKey(ip, responseType);
            return (T)((AbstractResponse)responseType.cast(this.cache.get(cacheKey)));
        }

        private static class CacheKey<T extends AbstractResponse> {
            private final InetAddress ip;
            private final Class<T> responseType;

            private CacheKey(InetAddress ip, Class<T> responseType) {
                this.ip = ip;
                this.responseType = responseType;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                CacheKey cacheKey = (CacheKey)o;
                return Objects.equals(this.ip, cacheKey.ip) && Objects.equals(this.responseType, cacheKey.responseType);
            }

            public int hashCode() {
                return Objects.hash(this.ip, this.responseType);
            }
        }
    }
}

