/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xpack.core.ml.job.results.Bucket;
import org.elasticsearch.xpack.core.ml.job.results.Result;
import org.elasticsearch.xpack.ml.job.persistence.ResultsFilterBuilder;

public final class BucketsQueryBuilder {
    public static final int DEFAULT_SIZE = 100;
    private int from = 0;
    private int size = 100;
    private boolean expand = false;
    private boolean includeInterim = false;
    private double anomalyScoreFilter = 0.0;
    private String start;
    private String end;
    private String timestamp;
    private String sortField = Result.TIMESTAMP.getPreferredName();
    private boolean sortDescending = false;

    public BucketsQueryBuilder from(int from) {
        this.from = from;
        return this;
    }

    public BucketsQueryBuilder size(int size) {
        this.size = size;
        return this;
    }

    public BucketsQueryBuilder expand(boolean expand) {
        this.expand = expand;
        return this;
    }

    public boolean isExpand() {
        return this.expand;
    }

    public BucketsQueryBuilder includeInterim(boolean include) {
        this.includeInterim = include;
        return this;
    }

    public boolean isIncludeInterim() {
        return this.includeInterim;
    }

    public BucketsQueryBuilder anomalyScoreThreshold(Double anomalyScoreFilter) {
        if (anomalyScoreFilter != null) {
            this.anomalyScoreFilter = anomalyScoreFilter;
        }
        return this;
    }

    public BucketsQueryBuilder sortField(String sortField) {
        this.sortField = sortField;
        return this;
    }

    public BucketsQueryBuilder sortDescending(boolean sortDescending) {
        this.sortDescending = sortDescending;
        return this;
    }

    public BucketsQueryBuilder start(String startTime) {
        this.start = startTime;
        return this;
    }

    public BucketsQueryBuilder end(String endTime) {
        this.end = endTime;
        return this;
    }

    public BucketsQueryBuilder timestamp(String timestamp) {
        this.timestamp = timestamp;
        this.size = 1;
        return this;
    }

    public boolean hasTimestamp() {
        return this.timestamp != null;
    }

    public SearchSourceBuilder build() {
        if (this.timestamp != null && (this.start != null || this.end != null)) {
            throw new IllegalStateException("Either specify timestamp or start/end");
        }
        ResultsFilterBuilder rfb = new ResultsFilterBuilder();
        if (this.hasTimestamp()) {
            rfb.timeRange(Result.TIMESTAMP.getPreferredName(), this.timestamp);
        } else {
            rfb.timeRange(Result.TIMESTAMP.getPreferredName(), this.start, this.end).score(Bucket.ANOMALY_SCORE.getPreferredName(), this.anomalyScoreFilter).interim(this.includeInterim);
        }
        SortBuilder sortBuilder = new FieldSortBuilder(this.sortField).order(this.sortDescending ? SortOrder.DESC : SortOrder.ASC);
        BoolQueryBuilder boolQuery = new BoolQueryBuilder().filter(rfb.build()).filter((QueryBuilder)QueryBuilders.termQuery((String)Result.RESULT_TYPE.getPreferredName(), (String)"bucket"));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.sort(sortBuilder);
        searchSourceBuilder.query((QueryBuilder)boolQuery);
        searchSourceBuilder.from(this.from);
        searchSourceBuilder.size(this.size);
        if (!Result.TIMESTAMP.getPreferredName().equals(this.sortField)) {
            searchSourceBuilder.sort(Result.TIMESTAMP.getPreferredName(), this.sortDescending ? SortOrder.DESC : SortOrder.ASC);
        }
        return searchSourceBuilder;
    }
}

