/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.protocol.xpack;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.protocol.xpack.XPackInfoRequest;
import org.elasticsearch.protocol.xpack.license.LicenseStatus;

public class XPackInfoResponse
extends ActionResponse
implements ToXContentObject {
    public static final long BASIC_SELF_GENERATED_LICENSE_EXPIRATION_MILLIS = Long.MAX_VALUE - TimeUnit.HOURS.toMillis(8760L);
    @Nullable
    private BuildInfo buildInfo;
    @Nullable
    private LicenseInfo licenseInfo;
    @Nullable
    private FeatureSetsInfo featureSetsInfo;

    public XPackInfoResponse() {
    }

    public XPackInfoResponse(@Nullable BuildInfo buildInfo, @Nullable LicenseInfo licenseInfo, @Nullable FeatureSetsInfo featureSetsInfo) {
        this.buildInfo = buildInfo;
        this.licenseInfo = licenseInfo;
        this.featureSetsInfo = featureSetsInfo;
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public LicenseInfo getLicenseInfo() {
        return this.licenseInfo;
    }

    public FeatureSetsInfo getFeatureSetsInfo() {
        return this.featureSetsInfo;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalWriteable((Writeable)this.buildInfo);
        out.writeOptionalWriteable((Writeable)this.licenseInfo);
        out.writeOptionalWriteable((Writeable)this.featureSetsInfo);
    }

    public void readFrom(StreamInput in) throws IOException {
        this.buildInfo = (BuildInfo)in.readOptionalWriteable(BuildInfo::new);
        this.licenseInfo = (LicenseInfo)in.readOptionalWriteable(LicenseInfo::new);
        this.featureSetsInfo = (FeatureSetsInfo)in.readOptionalWriteable(FeatureSetsInfo::new);
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        if (this == other) {
            return true;
        }
        XPackInfoResponse rhs = (XPackInfoResponse)((Object)other);
        return Objects.equals(this.buildInfo, rhs.buildInfo) && Objects.equals(this.licenseInfo, rhs.licenseInfo) && Objects.equals(this.featureSetsInfo, rhs.featureSetsInfo);
    }

    public int hashCode() {
        return Objects.hash(this.buildInfo, this.licenseInfo, this.featureSetsInfo);
    }

    public String toString() {
        return Strings.toString((ToXContent)this, (boolean)true, (boolean)false);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.buildInfo != null) {
            builder.field("build", (ToXContent)this.buildInfo, params);
        }
        EnumSet<XPackInfoRequest.Category> categories = XPackInfoRequest.Category.toSet(Strings.splitStringByCommaToArray((String)params.param("categories", "_all")));
        if (this.licenseInfo != null) {
            builder.field("license", (ToXContent)this.licenseInfo, params);
        } else if (categories.contains((Object)XPackInfoRequest.Category.LICENSE)) {
            builder.nullField("license");
        }
        if (this.featureSetsInfo != null) {
            builder.field("features", (ToXContent)this.featureSetsInfo, params);
        }
        if (params.paramAsBoolean("human", true)) {
            builder.field("tagline", "You know, for X");
        }
        return builder.endObject();
    }

    public static class FeatureSetsInfo
    implements ToXContentObject,
    Writeable {
        private final Map<String, FeatureSet> featureSets;

        public FeatureSetsInfo(Set<FeatureSet> featureSets) {
            HashMap<String, FeatureSet> map = new HashMap<String, FeatureSet>(featureSets.size());
            for (FeatureSet featureSet : featureSets) {
                map.put(featureSet.name, featureSet);
            }
            this.featureSets = Collections.unmodifiableMap(map);
        }

        public FeatureSetsInfo(StreamInput in) throws IOException {
            int size = in.readVInt();
            HashMap<String, FeatureSet> featureSets = new HashMap<String, FeatureSet>(size);
            for (int i = 0; i < size; ++i) {
                FeatureSet featureSet = new FeatureSet(in);
                featureSets.put(featureSet.name, featureSet);
            }
            this.featureSets = Collections.unmodifiableMap(featureSets);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.featureSets.size());
            for (FeatureSet featureSet : this.featureSets.values()) {
                featureSet.writeTo(out);
            }
        }

        public Map<String, FeatureSet> getFeatureSets() {
            return this.featureSets;
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            if (this == other) {
                return true;
            }
            FeatureSetsInfo rhs = (FeatureSetsInfo)other;
            return Objects.equals(this.featureSets, rhs.featureSets);
        }

        public int hashCode() {
            return Objects.hash(this.featureSets);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            List names = new ArrayList<String>(this.featureSets.keySet()).stream().sorted().collect(Collectors.toList());
            for (String name : names) {
                builder.field(name, (ToXContent)this.featureSets.get(name), params);
            }
            return builder.endObject();
        }

        public static class FeatureSet
        implements ToXContentObject,
        Writeable {
            private final String name;
            @Nullable
            private final String description;
            private final boolean available;
            private final boolean enabled;
            @Nullable
            private final Map<String, Object> nativeCodeInfo;

            public FeatureSet(String name, @Nullable String description, boolean available, boolean enabled, @Nullable Map<String, Object> nativeCodeInfo) {
                this.name = name;
                this.description = description;
                this.available = available;
                this.enabled = enabled;
                this.nativeCodeInfo = nativeCodeInfo;
            }

            public FeatureSet(StreamInput in) throws IOException {
                this(in.readString(), in.readOptionalString(), in.readBoolean(), in.readBoolean(), in.getVersion().onOrAfter(Version.V_5_4_0) ? in.readMap() : null);
            }

            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.name);
                out.writeOptionalString(this.description);
                out.writeBoolean(this.available);
                out.writeBoolean(this.enabled);
                if (out.getVersion().onOrAfter(Version.V_5_4_0)) {
                    out.writeMap(this.nativeCodeInfo);
                }
            }

            public String name() {
                return this.name;
            }

            @Nullable
            public String description() {
                return this.description;
            }

            public boolean available() {
                return this.available;
            }

            public boolean enabled() {
                return this.enabled;
            }

            @Nullable
            public Map<String, Object> nativeCodeInfo() {
                return this.nativeCodeInfo;
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                if (this == other) {
                    return true;
                }
                FeatureSet rhs = (FeatureSet)other;
                return Objects.equals(this.name, rhs.name) && Objects.equals(this.description, rhs.description) && this.available == rhs.available && this.enabled == rhs.enabled && Objects.equals(this.nativeCodeInfo, rhs.nativeCodeInfo);
            }

            public int hashCode() {
                return Objects.hash(this.name, this.description, this.available, this.enabled, this.nativeCodeInfo);
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                if (this.description != null) {
                    builder.field("description", this.description);
                }
                builder.field("available", this.available);
                builder.field("enabled", this.enabled);
                if (this.nativeCodeInfo != null) {
                    builder.field("native_code_info", this.nativeCodeInfo);
                }
                return builder.endObject();
            }
        }
    }

    public static class BuildInfo
    implements ToXContentObject,
    Writeable {
        private final String hash;
        private final String timestamp;
        private static final ConstructingObjectParser<BuildInfo, Void> PARSER = new ConstructingObjectParser("build_info", true, (a, v) -> new BuildInfo((String)a[0], (String)a[1]));

        public BuildInfo(String hash, String timestamp) {
            this.hash = hash;
            this.timestamp = timestamp;
        }

        public BuildInfo(StreamInput input) throws IOException {
            this(input.readString(), input.readString());
        }

        public void writeTo(StreamOutput output) throws IOException {
            output.writeString(this.hash);
            output.writeString(this.timestamp);
        }

        public String getHash() {
            return this.hash;
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            if (this == other) {
                return true;
            }
            BuildInfo rhs = (BuildInfo)other;
            return Objects.equals(this.hash, rhs.hash) && Objects.equals(this.timestamp, rhs.timestamp);
        }

        public int hashCode() {
            return Objects.hash(this.hash, this.timestamp);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field("hash", this.hash).field("date", this.timestamp).endObject();
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("hash", new String[0]));
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("date", new String[0]));
        }
    }

    public static class LicenseInfo
    implements ToXContentObject,
    Writeable {
        private final String uid;
        private final String type;
        private final String mode;
        private final LicenseStatus status;
        private final long expiryDate;

        public LicenseInfo(String uid, String type, String mode, LicenseStatus status, long expiryDate) {
            this.uid = uid;
            this.type = type;
            this.mode = mode;
            this.status = status;
            this.expiryDate = expiryDate;
        }

        public LicenseInfo(StreamInput in) throws IOException {
            this(in.readString(), in.readString(), in.readString(), LicenseStatus.readFrom(in), in.readLong());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.uid);
            out.writeString(this.type);
            out.writeString(this.mode);
            this.status.writeTo(out);
            out.writeLong(this.expiryDate);
        }

        public String getUid() {
            return this.uid;
        }

        public String getType() {
            return this.type;
        }

        public String getMode() {
            return this.mode;
        }

        public long getExpiryDate() {
            return this.expiryDate;
        }

        public LicenseStatus getStatus() {
            return this.status;
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            if (this == other) {
                return true;
            }
            LicenseInfo rhs = (LicenseInfo)other;
            return Objects.equals(this.uid, rhs.uid) && Objects.equals(this.type, rhs.type) && Objects.equals(this.mode, rhs.mode) && Objects.equals((Object)this.status, (Object)rhs.status) && this.expiryDate == rhs.expiryDate;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.uid, this.type, this.mode, this.status, this.expiryDate});
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject().field("uid", this.uid).field("type", this.type).field("mode", this.mode).field("status", this.status.label());
            if (this.expiryDate != BASIC_SELF_GENERATED_LICENSE_EXPIRATION_MILLIS) {
                builder.timeField("expiry_date_in_millis", "expiry_date", this.expiryDate);
            }
            return builder.endObject();
        }
    }
}

