/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.util.Providers;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.XPackClientActionPlugin;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.monitoring.MonitoringField;
import org.elasticsearch.xpack.core.monitoring.action.MonitoringBulkAction;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.monitoring.MonitoringFeatureSet;
import org.elasticsearch.xpack.monitoring.MonitoringService;
import org.elasticsearch.xpack.monitoring.action.TransportMonitoringBulkAction;
import org.elasticsearch.xpack.monitoring.cleaner.CleanerService;
import org.elasticsearch.xpack.monitoring.collector.Collector;
import org.elasticsearch.xpack.monitoring.collector.ccr.StatsCollector;
import org.elasticsearch.xpack.monitoring.collector.cluster.ClusterStatsCollector;
import org.elasticsearch.xpack.monitoring.collector.indices.IndexRecoveryCollector;
import org.elasticsearch.xpack.monitoring.collector.indices.IndexStatsCollector;
import org.elasticsearch.xpack.monitoring.collector.ml.JobStatsCollector;
import org.elasticsearch.xpack.monitoring.collector.node.NodeStatsCollector;
import org.elasticsearch.xpack.monitoring.collector.shards.ShardsCollector;
import org.elasticsearch.xpack.monitoring.exporter.Exporter;
import org.elasticsearch.xpack.monitoring.exporter.Exporters;
import org.elasticsearch.xpack.monitoring.exporter.http.HttpExporter;
import org.elasticsearch.xpack.monitoring.exporter.local.LocalExporter;
import org.elasticsearch.xpack.monitoring.rest.action.RestMonitoringBulkAction;

public class Monitoring
extends Plugin
implements ActionPlugin {
    public static final Setting<Boolean> CLEAN_WATCHER_HISTORY = Setting.boolSetting((String)"xpack.watcher.history.cleaner_service.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    protected final Settings settings;
    private final boolean enabled;
    private final boolean transportClientMode;
    private final boolean tribeNode;

    public Monitoring(Settings settings) {
        this.settings = settings;
        this.transportClientMode = XPackPlugin.transportClientMode((Settings)settings);
        this.enabled = (Boolean)XPackSettings.MONITORING_ENABLED.get(settings);
        this.tribeNode = XPackClientActionPlugin.isTribeNode((Settings)settings);
    }

    protected SSLService getSslService() {
        return XPackPlugin.getSharedSslService();
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    protected LicenseService getLicenseService() {
        return XPackPlugin.getSharedLicenseService();
    }

    boolean isEnabled() {
        return this.enabled;
    }

    boolean isTransportClient() {
        return this.transportClientMode;
    }

    public Collection<Module> createGuiceModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.add(b -> {
            XPackPlugin.bindFeatureSet((Binder)b, MonitoringFeatureSet.class);
            if (this.transportClientMode || !this.enabled || this.tribeNode) {
                b.bind(MonitoringService.class).toProvider(Providers.of(null));
                b.bind(Exporters.class).toProvider(Providers.of(null));
            }
        });
        return modules;
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry) {
        if (!this.enabled || this.tribeNode) {
            return Collections.emptyList();
        }
        ClusterSettings clusterSettings = clusterService.getClusterSettings();
        CleanerService cleanerService = new CleanerService(this.settings, clusterSettings, threadPool, this.getLicenseState());
        SSLService dynamicSSLService = this.getSslService().createDynamicSSLService();
        HashMap<String, Exporter.Factory> exporterFactories = new HashMap<String, Exporter.Factory>();
        exporterFactories.put("http", config -> new HttpExporter(config, dynamicSSLService, threadPool.getThreadContext()));
        exporterFactories.put("local", config -> new LocalExporter(config, client, cleanerService));
        Exporters exporters = new Exporters(this.settings, exporterFactories, clusterService, this.getLicenseState(), threadPool.getThreadContext());
        HashSet<Collector> collectors = new HashSet<Collector>();
        collectors.add(new IndexStatsCollector(clusterService, this.getLicenseState(), client));
        collectors.add(new ClusterStatsCollector(this.settings, clusterService, this.getLicenseState(), client, this.getLicenseService()));
        collectors.add(new ShardsCollector(clusterService, this.getLicenseState()));
        collectors.add(new NodeStatsCollector(clusterService, this.getLicenseState(), client));
        collectors.add(new IndexRecoveryCollector(clusterService, this.getLicenseState(), client));
        collectors.add(new JobStatsCollector(this.settings, clusterService, this.getLicenseState(), client));
        collectors.add(new StatsCollector(this.settings, clusterService, this.getLicenseState(), client));
        MonitoringService monitoringService = new MonitoringService(this.settings, clusterService, threadPool, collectors, exporters);
        return Arrays.asList(new Object[]{monitoringService, exporters, cleanerService});
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        if (!this.enabled || this.tribeNode) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new ActionPlugin.ActionHandler((GenericAction)MonitoringBulkAction.INSTANCE, TransportMonitoringBulkAction.class, new Class[0]));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        if (!this.enabled || this.tribeNode) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new RestMonitoringBulkAction(settings, restController));
    }

    public List<Setting<?>> getSettings() {
        ArrayList<Object> settings = new ArrayList<Object>();
        settings.add(MonitoringField.HISTORY_DURATION);
        settings.add(CLEAN_WATCHER_HISTORY);
        settings.add(MonitoringService.ENABLED);
        settings.add(MonitoringService.ELASTICSEARCH_COLLECTION_ENABLED);
        settings.add(MonitoringService.INTERVAL);
        settings.add(Collector.INDICES);
        settings.add(ClusterStatsCollector.CLUSTER_STATS_TIMEOUT);
        settings.add(IndexRecoveryCollector.INDEX_RECOVERY_TIMEOUT);
        settings.add(IndexRecoveryCollector.INDEX_RECOVERY_ACTIVE_ONLY);
        settings.add(IndexStatsCollector.INDEX_STATS_TIMEOUT);
        settings.add(JobStatsCollector.JOB_STATS_TIMEOUT);
        settings.add(StatsCollector.CCR_STATS_TIMEOUT);
        settings.add(NodeStatsCollector.NODE_STATS_TIMEOUT);
        settings.addAll(Exporters.getSettings());
        return Collections.unmodifiableList(settings);
    }

    public List<String> getSettingsFilter() {
        String exportersKey = "xpack.monitoring.exporters.";
        return Collections.unmodifiableList(Arrays.asList("xpack.monitoring.exporters.*.auth.*", "xpack.monitoring.exporters.*.ssl.*"));
    }
}

