/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.elementparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.uibinder.rebind.FieldManager;
import com.google.gwt.uibinder.rebind.FieldWriter;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;

class IsRenderableInterpreter
implements XMLElement.Interpreter<String> {
    private final String fieldName;
    private final UiBinderWriter uiWriter;

    public IsRenderableInterpreter(String fieldName, UiBinderWriter writer) {
        this.fieldName = fieldName;
        this.uiWriter = writer;
        assert (writer.useLazyWidgetBuilders());
    }

    public String interpretElement(XMLElement elem) throws UnableToCompleteException {
        if (!this.uiWriter.isRenderableElement(elem)) {
            return null;
        }
        String stamper = this.uiWriter.declareRenderableStamper();
        FieldManager fieldManager = this.uiWriter.getFieldManager();
        FieldWriter fieldWriter = fieldManager.require(this.fieldName);
        FieldWriter childFieldWriter = this.uiWriter.parseElementToField(elem);
        fieldWriter.addAttachStatement("%s.claimElement(%s.findStampedElement());", new Object[]{fieldManager.convertFieldToGetter(childFieldWriter.getName()), fieldManager.convertFieldToGetter(stamper)});
        fieldWriter.addDetachStatement("%s.initializeClaimedElement();", new Object[]{fieldManager.convertFieldToGetter(childFieldWriter.getName())});
        fieldWriter.addDetachStatement("%s.logicalAdd(%s);", new Object[]{fieldManager.convertFieldToGetter(this.fieldName), fieldManager.convertFieldToGetter(childFieldWriter.getName())});
        String elementHtml = fieldManager.convertFieldToGetter(childFieldWriter.getName()) + ".render(" + fieldManager.convertFieldToGetter(stamper) + ")";
        return this.uiWriter.tokenForSafeHtmlExpression(elem, elementHtml);
    }
}

