/*
 * Copyright 2014 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=25
//  date=$Date: 2013-08-29 04:32:04 +0200 (Thu, 29 Aug 2013) $
//  number=$Revision: 9287 $
//  type=uz

/**
 * Localized names for the "uz_Cyrl" locale.
 */
public class LocalizedNamesImpl_uz_Cyrl extends LocalizedNamesImpl_uz {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "UZ",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "QO",
        "UZ",
        "AU",
        "AT",
        "AX",
        "AL",
        "AS",
        "AI",
        "AO",
        "AD",
        "AQ",
        "AG",
        "AR",
        "AM",
        "AW",
        "AF",
        "VI",
        "UM",
        "BS",
        "BD",
        "BB",
        "BH",
        "BZ",
        "BY",
        "BE",
        "BJ",
        "BM",
        "AE",
        "GB",
        "BG",
        "BO",
        "BA",
        "BW",
        "BR",
        "VG",
        "IO",
        "BN",
        "BV",
        "BF",
        "BI",
        "BT",
        "VU",
        "VA",
        "HU",
        "VE",
        "AC",
        "VN",
        "GA",
        "HT",
        "GM",
        "GH",
        "GY",
        "GP",
        "GT",
        "GN",
        "GW",
        "HM",
        "GG",
        "GI",
        "HN",
        "HK",
        "GD",
        "GL",
        "GR",
        "GE",
        "GU",
        "DK",
        "JE",
        "DJ",
        "DG",
        "DM",
        "DO",
        "EU",
        "DZ",
        "ZA",
        "GS",
        "KR",
        "SS",
        "ZM",
        "ZW",
        "ID",
        "JO",
        "IE",
        "IQ",
        "IS",
        "ES",
        "IL",
        "IT",
        "CV",
        "KY",
        "KH",
        "CM",
        "CA",
        "IC",
        "BQ",
        "KE",
        "CY",
        "KI",
        "CP",
        "CC",
        "CO",
        "KM",
        "CG",
        "CD",
        "XK",
        "CR",
        "CI",
        "CU",
        "KW",
        "CK",
        "CW",
        "LA",
        "LV",
        "LS",
        "LR",
        "LB",
        "LY",
        "LT",
        "LI",
        "LU",
        "MU",
        "MR",
        "MG",
        "YT",
        "MO",
        "MK",
        "MW",
        "MY",
        "ML",
        "MV",
        "MT",
        "CF",
        "MA",
        "MQ",
        "MH",
        "MX",
        "FM",
        "EG",
        "MZ",
        "MD",
        "MC",
        "MS",
        "MN",
        "BL",
        "SH",
        "MM",
        "IM",
        "NA",
        "NR",
        "NP",
        "NE",
        "NG",
        "NL",
        "NI",
        "NU",
        "NO",
        "NF",
        "AZ",
        "DE",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PK",
        "PL",
        "PT",
        "PR",
        "RE",
        "CX",
        "RU",
        "RW",
        "RO",
        "SJ",
        "WS",
        "SM",
        "ST",
        "SA",
        "SZ",
        "EA",
        "SC",
        "SN",
        "VC",
        "KN",
        "LC",
        "MF",
        "PM",
        "RS",
        "SG",
        "SX",
        "SK",
        "SI",
        "SB",
        "SO",
        "SD",
        "SR",
        "SY",
        "SL",
        "TW",
        "TH",
        "TZ",
        "TG",
        "TJ",
        "TK",
        "TO",
        "TT",
        "TA",
        "TV",
        "TN",
        "TR",
        "TM",
        "TC",
        "UG",
        "UA",
        "OM",
        "UY",
        "WF",
        "PS",
        "FO",
        "FJ",
        "PH",
        "FI",
        "FK",
        "FR",
        "TF",
        "GF",
        "PF",
        "CN",
        "HR",
        "TD",
        "ME",
        "CZ",
        "CL",
        "TL",
        "CH",
        "SE",
        "KP",
        "MP",
        "LK",
        "EC",
        "GQ",
        "SV",
        "ER",
        "IR",
        "EE",
        "ET",
        "JM",
        "YE",
        "NZ",
        "NC",
        "JP",
        "EH",
        "QA",
        "KG",
        "KZ",
        "US",
        "IN",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Дунё");
    namesMap.put("002", "Африка");
    namesMap.put("003", "Шимолий Америка");
    namesMap.put("005", "Жанубий Америка");
    namesMap.put("009", "Океания");
    namesMap.put("011", "Ғарбий Африка");
    namesMap.put("013", "Марказий Америка");
    namesMap.put("014", "Шарқий Африка");
    namesMap.put("015", "Шимолий Африка");
    namesMap.put("017", "Марказий Африка");
    namesMap.put("018", "Жануби-Африка");
    namesMap.put("019", "Америка");
    namesMap.put("021", "Шимоли-Америка");
    namesMap.put("029", "Кариб ҳавзаси");
    namesMap.put("030", "Шарқий Осиё");
    namesMap.put("034", "Жанубий Осиё");
    namesMap.put("035", "Жанубий-Шарқий Осиё");
    namesMap.put("039", "Жанубий Европа");
    namesMap.put("053", "Австралазия");
    namesMap.put("054", "Меланезия");
    namesMap.put("057", "Микронезия минтақаси");
    namesMap.put("061", "Полинезия");
    namesMap.put("142", "Осиё");
    namesMap.put("143", "Марказий Осиё");
    namesMap.put("145", "Ғарбий Осиё");
    namesMap.put("150", "Европа");
    namesMap.put("151", "Шарқий Европа");
    namesMap.put("154", "Шимолий Европа");
    namesMap.put("155", "Ғарбий Европа");
    namesMap.put("419", "Лотин Америкаси");
    namesMap.put("AC", "Вознесение ороли");
    namesMap.put("AD", "Андорра");
    namesMap.put("AE", "Бирлашган Араб Амирликлари");
    namesMap.put("AF", "Афғонистон");
    namesMap.put("AG", "Антигуа ва Барбадос");
    namesMap.put("AI", "Ангила");
    namesMap.put("AL", "Албания");
    namesMap.put("AM", "Арманистон");
    namesMap.put("AO", "Ангола");
    namesMap.put("AQ", "Антарктика");
    namesMap.put("AR", "Аргентина");
    namesMap.put("AS", "Америка Самоаси");
    namesMap.put("AT", "Австрия");
    namesMap.put("AU", "Австралия");
    namesMap.put("AW", "Аруба");
    namesMap.put("AX", "Аланд ороллари");
    namesMap.put("AZ", "Озарбайжон");
    namesMap.put("BA", "Босния ва Герцеговина");
    namesMap.put("BB", "Барбадос");
    namesMap.put("BD", "Бангладеш");
    namesMap.put("BE", "Бельгия");
    namesMap.put("BF", "Буркина-Фасо");
    namesMap.put("BG", "Болгария");
    namesMap.put("BH", "Баҳрайн");
    namesMap.put("BI", "Бурунди");
    namesMap.put("BJ", "Бенин");
    namesMap.put("BL", "Муқаддас Варфаломей");
    namesMap.put("BM", "Бермуда");
    namesMap.put("BN", "Бруней");
    namesMap.put("BO", "Боливия");
    namesMap.put("BQ", "Кариб Нидерландияси");
    namesMap.put("BR", "Бразилия");
    namesMap.put("BS", "Багама ороллари");
    namesMap.put("BT", "Бутан");
    namesMap.put("BV", "Бувет ороли");
    namesMap.put("BW", "Ботсванна");
    namesMap.put("BY", "Белорусия");
    namesMap.put("BZ", "Белиз");
    namesMap.put("CA", "Канада");
    namesMap.put("CC", "Кокос (Килинг) ороллари");
    namesMap.put("CD", "Конго-Киншаса");
    namesMap.put("CF", "Марказий Африка Республикаси");
    namesMap.put("CG", "Конго Браззавиль");
    namesMap.put("CH", "Швейцария");
    namesMap.put("CI", "Кот-д-Ивуар");
    namesMap.put("CK", "Кук ороллари");
    namesMap.put("CL", "Чили");
    namesMap.put("CM", "Камерун");
    namesMap.put("CN", "Хитой");
    namesMap.put("CO", "Колумбия");
    namesMap.put("CP", "Клиппертон ороли");
    namesMap.put("CR", "Коста-Рика");
    namesMap.put("CU", "Куба");
    namesMap.put("CV", "Кабо-Верде");
    namesMap.put("CW", "Курасао");
    namesMap.put("CX", "Рождество ороли");
    namesMap.put("CY", "Кипр");
    namesMap.put("CZ", "Чехия Республикаси");
    namesMap.put("DE", "Олмония");
    namesMap.put("DG", "Диего Гарсия");
    namesMap.put("DJ", "Джибути");
    namesMap.put("DK", "Дания");
    namesMap.put("DM", "Доминика");
    namesMap.put("DO", "Доминикан Республикаси");
    namesMap.put("DZ", "Жазоир");
    namesMap.put("EA", "Сейта ва Мелилла");
    namesMap.put("EC", "Эквадор");
    namesMap.put("EE", "Эстония");
    namesMap.put("EG", "Миср");
    namesMap.put("EH", "Ғарбий Саҳрои Кабир");
    namesMap.put("ER", "Эритрея");
    namesMap.put("ES", "Испания");
    namesMap.put("ET", "Эфиопия");
    namesMap.put("EU", "Европа Иттифоқи");
    namesMap.put("FI", "Финляндия");
    namesMap.put("FJ", "Фижи ороллари");
    namesMap.put("FK", "Фолькленд ороллари");
    namesMap.put("FM", "Микронезия");
    namesMap.put("FO", "Фарер ороллари");
    namesMap.put("FR", "Франция");
    namesMap.put("GA", "Габон");
    namesMap.put("GB", "Бирлашган Қироллик");
    namesMap.put("GD", "Гренада");
    namesMap.put("GE", "Грузия");
    namesMap.put("GF", "Француз Гвианаси");
    namesMap.put("GG", "Гернси");
    namesMap.put("GH", "Гана");
    namesMap.put("GI", "Гибралтар");
    namesMap.put("GL", "Гренландия");
    namesMap.put("GM", "Гамбия");
    namesMap.put("GN", "Гвинея");
    namesMap.put("GP", "Гваделупе");
    namesMap.put("GQ", "Экваториал Гвинея");
    namesMap.put("GR", "Греция");
    namesMap.put("GS", "Жанубий Джорджия ва Жанубий Сендвич ороллари");
    namesMap.put("GT", "Гватемала");
    namesMap.put("GU", "Гуам");
    namesMap.put("GW", "Гвинея-Бисау");
    namesMap.put("GY", "Гаяна");
    namesMap.put("HK", "Гонконг Хитой ММҲ");
    namesMap.put("HM", "Герд ороли ва МакДоналд ороллари");
    namesMap.put("HN", "Гондурас");
    namesMap.put("HR", "Хорватия");
    namesMap.put("HT", "Гаити");
    namesMap.put("HU", "Венгрия");
    namesMap.put("IC", "Канар ороллари");
    namesMap.put("ID", "Индонезия");
    namesMap.put("IE", "Ирландия");
    namesMap.put("IL", "Исроил");
    namesMap.put("IM", "Мэн ороли");
    namesMap.put("IN", "Ҳиндистон");
    namesMap.put("IO", "Британия Ҳинд океани ҳудуди");
    namesMap.put("IQ", "Ироқ");
    namesMap.put("IR", "Эрон");
    namesMap.put("IS", "Исландия");
    namesMap.put("IT", "Италия");
    namesMap.put("JE", "Джерси");
    namesMap.put("JM", "Ямайка");
    namesMap.put("JO", "Иордания");
    namesMap.put("JP", "Япония");
    namesMap.put("KE", "Кения");
    namesMap.put("KG", "Қирғизистон");
    namesMap.put("KH", "Камбоджа");
    namesMap.put("KI", "Кирибати");
    namesMap.put("KM", "Комор ороллари");
    namesMap.put("KN", "Сент-Китс ва Невис");
    namesMap.put("KP", "Шимолий Корея");
    namesMap.put("KR", "Жанубий Корея");
    namesMap.put("KW", "Кувайт");
    namesMap.put("KY", "Кайман ороллари");
    namesMap.put("KZ", "Қозоғистон");
    namesMap.put("LA", "Лаос");
    namesMap.put("LB", "Ливан");
    namesMap.put("LC", "Сент-Люсия");
    namesMap.put("LI", "Лихтенштейн");
    namesMap.put("LK", "Шри-Ланка");
    namesMap.put("LR", "Либерия");
    namesMap.put("LS", "Лесото");
    namesMap.put("LT", "Литва");
    namesMap.put("LU", "Люксембург");
    namesMap.put("LV", "Латвия");
    namesMap.put("LY", "Ливия");
    namesMap.put("MA", "Марокаш");
    namesMap.put("MC", "Монако");
    namesMap.put("MD", "Молдова");
    namesMap.put("ME", "Черногория");
    namesMap.put("MF", "Сент-Мартин");
    namesMap.put("MG", "Мадагаскар");
    namesMap.put("MH", "Маршал ороллари");
    namesMap.put("MK", "Македония");
    namesMap.put("ML", "Мали");
    namesMap.put("MM", "Мьянма (Бирма)");
    namesMap.put("MN", "Муғулистон");
    namesMap.put("MO", "Макао Хитой ММҲ");
    namesMap.put("MP", "Шимолий Марианна ороллари");
    namesMap.put("MQ", "Мартиника");
    namesMap.put("MR", "Мавритания");
    namesMap.put("MS", "Монтсеррат");
    namesMap.put("MT", "Мальта");
    namesMap.put("MU", "Маврикий");
    namesMap.put("MV", "Мальдив ороллари");
    namesMap.put("MW", "Малави");
    namesMap.put("MX", "Мексика");
    namesMap.put("MY", "Малайзия");
    namesMap.put("MZ", "Мозамбик");
    namesMap.put("NA", "Намибия");
    namesMap.put("NC", "Янги Каледония");
    namesMap.put("NE", "Нигер");
    namesMap.put("NF", "Норфолк ороллари");
    namesMap.put("NG", "Нигерия");
    namesMap.put("NI", "Никарагуа");
    namesMap.put("NL", "Нидерландия");
    namesMap.put("NO", "Норвегия");
    namesMap.put("NP", "Непал");
    namesMap.put("NR", "Науру");
    namesMap.put("NU", "Ниуе");
    namesMap.put("NZ", "Янги Зеландия");
    namesMap.put("OM", "Уммон");
    namesMap.put("PA", "Панама");
    namesMap.put("PE", "Перу");
    namesMap.put("PF", "Француз Полинезияси");
    namesMap.put("PG", "Папуа Янги Гвинея");
    namesMap.put("PH", "Филиппин");
    namesMap.put("PK", "Покистон");
    namesMap.put("PL", "Польша");
    namesMap.put("PM", "Сент-Пьер ва Микелон");
    namesMap.put("PN", "Питкарин ороллари");
    namesMap.put("PR", "Пуэрто-Рико");
    namesMap.put("PS", "Фаластин ҳудуди");
    namesMap.put("PT", "Португалия");
    namesMap.put("PW", "Палау");
    namesMap.put("PY", "Парагвай");
    namesMap.put("QA", "Қатар");
    namesMap.put("QO", "Ёндош Океания");
    namesMap.put("RE", "Реюньон");
    namesMap.put("RO", "Руминия");
    namesMap.put("RS", "Сербия");
    namesMap.put("RU", "Россия");
    namesMap.put("RW", "Руанда");
    namesMap.put("SA", "Саудия Арабистони");
    namesMap.put("SB", "Соломон ороллари");
    namesMap.put("SC", "Сейшел ороллари");
    namesMap.put("SD", "Судан");
    namesMap.put("SE", "Швеция");
    namesMap.put("SG", "Сингапур");
    namesMap.put("SH", "Муқаддас Елена ороллари");
    namesMap.put("SI", "Словения");
    namesMap.put("SJ", "Савльбард ва Жан Маен");
    namesMap.put("SK", "Словакия");
    namesMap.put("SL", "Сьерра-Леоне");
    namesMap.put("SM", "Сан-Марино");
    namesMap.put("SN", "Сенегал");
    namesMap.put("SO", "Сомали");
    namesMap.put("SR", "Суринам");
    namesMap.put("SS", "Жанубий Судан");
    namesMap.put("ST", "Сан-Томе ва Принсипи");
    namesMap.put("SV", "Эль-Сальвадор");
    namesMap.put("SX", "Синт-Маартен");
    namesMap.put("SY", "Сурия");
    namesMap.put("SZ", "Свазиленд");
    namesMap.put("TA", "Тристан де Куна");
    namesMap.put("TC", "Туркс ва Кайкос ороллари");
    namesMap.put("TD", "Чад");
    namesMap.put("TF", "Франция жанубий худудлари");
    namesMap.put("TG", "Того");
    namesMap.put("TH", "Тайланд");
    namesMap.put("TJ", "Тожикистон");
    namesMap.put("TK", "Токелау");
    namesMap.put("TL", "Шарқий-Тимор");
    namesMap.put("TM", "Туркманистон");
    namesMap.put("TN", "Тунис");
    namesMap.put("TO", "Тонга");
    namesMap.put("TR", "Туркия");
    namesMap.put("TT", "Тринидад ва Тобаго");
    namesMap.put("TV", "Тувалу");
    namesMap.put("TW", "Тайван");
    namesMap.put("TZ", "Танзания");
    namesMap.put("UA", "Украина");
    namesMap.put("UG", "Уганда");
    namesMap.put("UM", "АҚШ ёндош ороллари");
    namesMap.put("US", "Қўшма Штатлар");
    namesMap.put("UY", "Уругвай");
    namesMap.put("UZ", "Ўзбекистон");
    namesMap.put("VA", "Ватикан");
    namesMap.put("VC", "Сент-Винсент ва Гренадин");
    namesMap.put("VE", "Венесуэла");
    namesMap.put("VG", "Британия Вирджиния ороллари");
    namesMap.put("VI", "АҚШ Вирджиния ороллари");
    namesMap.put("VN", "Вьетнам");
    namesMap.put("VU", "Вануату");
    namesMap.put("WF", "Уэллис ва Футуна");
    namesMap.put("WS", "Самоа");
    namesMap.put("XK", "Косово");
    namesMap.put("YE", "Яман");
    namesMap.put("YT", "Майотта");
    namesMap.put("ZA", "Жанубий Африка");
    namesMap.put("ZM", "Замбия");
    namesMap.put("ZW", "Зимбабве");
    namesMap.put("ZZ", "Номаълум минтақа");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Дунё",
        "002": "Африка",
        "003": "Шимолий Америка",
        "005": "Жанубий Америка",
        "009": "Океания",
        "011": "Ғарбий Африка",
        "013": "Марказий Америка",
        "014": "Шарқий Африка",
        "015": "Шимолий Африка",
        "017": "Марказий Африка",
        "018": "Жануби-Африка",
        "019": "Америка",
        "021": "Шимоли-Америка",
        "029": "Кариб ҳавзаси",
        "030": "Шарқий Осиё",
        "034": "Жанубий Осиё",
        "035": "Жанубий-Шарқий Осиё",
        "039": "Жанубий Европа",
        "053": "Австралазия",
        "054": "Меланезия",
        "057": "Микронезия минтақаси",
        "061": "Полинезия",
        "142": "Осиё",
        "143": "Марказий Осиё",
        "145": "Ғарбий Осиё",
        "150": "Европа",
        "151": "Шарқий Европа",
        "154": "Шимолий Европа",
        "155": "Ғарбий Европа",
        "419": "Лотин Америкаси",
        "AC": "Вознесение ороли",
        "AD": "Андорра",
        "AE": "Бирлашган Араб Амирликлари",
        "AF": "Афғонистон",
        "AG": "Антигуа ва Барбадос",
        "AI": "Ангила",
        "AL": "Албания",
        "AM": "Арманистон",
        "AO": "Ангола",
        "AQ": "Антарктика",
        "AR": "Аргентина",
        "AS": "Америка Самоаси",
        "AT": "Австрия",
        "AU": "Австралия",
        "AW": "Аруба",
        "AX": "Аланд ороллари",
        "AZ": "Озарбайжон",
        "BA": "Босния ва Герцеговина",
        "BB": "Барбадос",
        "BD": "Бангладеш",
        "BE": "Бельгия",
        "BF": "Буркина-Фасо",
        "BG": "Болгария",
        "BH": "Баҳрайн",
        "BI": "Бурунди",
        "BJ": "Бенин",
        "BL": "Муқаддас Варфаломей",
        "BM": "Бермуда",
        "BN": "Бруней",
        "BO": "Боливия",
        "BQ": "Кариб Нидерландияси",
        "BR": "Бразилия",
        "BS": "Багама ороллари",
        "BT": "Бутан",
        "BV": "Бувет ороли",
        "BW": "Ботсванна",
        "BY": "Белорусия",
        "BZ": "Белиз",
        "CA": "Канада",
        "CC": "Кокос (Килинг) ороллари",
        "CD": "Конго-Киншаса",
        "CF": "Марказий Африка Республикаси",
        "CG": "Конго Браззавиль",
        "CH": "Швейцария",
        "CI": "Кот-д-Ивуар",
        "CK": "Кук ороллари",
        "CL": "Чили",
        "CM": "Камерун",
        "CN": "Хитой",
        "CO": "Колумбия",
        "CP": "Клиппертон ороли",
        "CR": "Коста-Рика",
        "CU": "Куба",
        "CV": "Кабо-Верде",
        "CW": "Курасао",
        "CX": "Рождество ороли",
        "CY": "Кипр",
        "CZ": "Чехия Республикаси",
        "DE": "Олмония",
        "DG": "Диего Гарсия",
        "DJ": "Джибути",
        "DK": "Дания",
        "DM": "Доминика",
        "DO": "Доминикан Республикаси",
        "DZ": "Жазоир",
        "EA": "Сейта ва Мелилла",
        "EC": "Эквадор",
        "EE": "Эстония",
        "EG": "Миср",
        "EH": "Ғарбий Саҳрои Кабир",
        "ER": "Эритрея",
        "ES": "Испания",
        "ET": "Эфиопия",
        "EU": "Европа Иттифоқи",
        "FI": "Финляндия",
        "FJ": "Фижи ороллари",
        "FK": "Фолькленд ороллари",
        "FM": "Микронезия",
        "FO": "Фарер ороллари",
        "FR": "Франция",
        "GA": "Габон",
        "GB": "Бирлашган Қироллик",
        "GD": "Гренада",
        "GE": "Грузия",
        "GF": "Француз Гвианаси",
        "GG": "Гернси",
        "GH": "Гана",
        "GI": "Гибралтар",
        "GL": "Гренландия",
        "GM": "Гамбия",
        "GN": "Гвинея",
        "GP": "Гваделупе",
        "GQ": "Экваториал Гвинея",
        "GR": "Греция",
        "GS": "Жанубий Джорджия ва Жанубий Сендвич ороллари",
        "GT": "Гватемала",
        "GU": "Гуам",
        "GW": "Гвинея-Бисау",
        "GY": "Гаяна",
        "HK": "Гонконг Хитой ММҲ",
        "HM": "Герд ороли ва МакДоналд ороллари",
        "HN": "Гондурас",
        "HR": "Хорватия",
        "HT": "Гаити",
        "HU": "Венгрия",
        "IC": "Канар ороллари",
        "ID": "Индонезия",
        "IE": "Ирландия",
        "IL": "Исроил",
        "IM": "Мэн ороли",
        "IN": "Ҳиндистон",
        "IO": "Британия Ҳинд океани ҳудуди",
        "IQ": "Ироқ",
        "IR": "Эрон",
        "IS": "Исландия",
        "IT": "Италия",
        "JE": "Джерси",
        "JM": "Ямайка",
        "JO": "Иордания",
        "JP": "Япония",
        "KE": "Кения",
        "KG": "Қирғизистон",
        "KH": "Камбоджа",
        "KI": "Кирибати",
        "KM": "Комор ороллари",
        "KN": "Сент-Китс ва Невис",
        "KP": "Шимолий Корея",
        "KR": "Жанубий Корея",
        "KW": "Кувайт",
        "KY": "Кайман ороллари",
        "KZ": "Қозоғистон",
        "LA": "Лаос",
        "LB": "Ливан",
        "LC": "Сент-Люсия",
        "LI": "Лихтенштейн",
        "LK": "Шри-Ланка",
        "LR": "Либерия",
        "LS": "Лесото",
        "LT": "Литва",
        "LU": "Люксембург",
        "LV": "Латвия",
        "LY": "Ливия",
        "MA": "Марокаш",
        "MC": "Монако",
        "MD": "Молдова",
        "ME": "Черногория",
        "MF": "Сент-Мартин",
        "MG": "Мадагаскар",
        "MH": "Маршал ороллари",
        "MK": "Македония",
        "ML": "Мали",
        "MM": "Мьянма (Бирма)",
        "MN": "Муғулистон",
        "MO": "Макао Хитой ММҲ",
        "MP": "Шимолий Марианна ороллари",
        "MQ": "Мартиника",
        "MR": "Мавритания",
        "MS": "Монтсеррат",
        "MT": "Мальта",
        "MU": "Маврикий",
        "MV": "Мальдив ороллари",
        "MW": "Малави",
        "MX": "Мексика",
        "MY": "Малайзия",
        "MZ": "Мозамбик",
        "NA": "Намибия",
        "NC": "Янги Каледония",
        "NE": "Нигер",
        "NF": "Норфолк ороллари",
        "NG": "Нигерия",
        "NI": "Никарагуа",
        "NL": "Нидерландия",
        "NO": "Норвегия",
        "NP": "Непал",
        "NR": "Науру",
        "NU": "Ниуе",
        "NZ": "Янги Зеландия",
        "OM": "Уммон",
        "PA": "Панама",
        "PE": "Перу",
        "PF": "Француз Полинезияси",
        "PG": "Папуа Янги Гвинея",
        "PH": "Филиппин",
        "PK": "Покистон",
        "PL": "Польша",
        "PM": "Сент-Пьер ва Микелон",
        "PN": "Питкарин ороллари",
        "PR": "Пуэрто-Рико",
        "PS": "Фаластин ҳудуди",
        "PT": "Португалия",
        "PW": "Палау",
        "PY": "Парагвай",
        "QA": "Қатар",
        "QO": "Ёндош Океания",
        "RE": "Реюньон",
        "RO": "Руминия",
        "RS": "Сербия",
        "RU": "Россия",
        "RW": "Руанда",
        "SA": "Саудия Арабистони",
        "SB": "Соломон ороллари",
        "SC": "Сейшел ороллари",
        "SD": "Судан",
        "SE": "Швеция",
        "SG": "Сингапур",
        "SH": "Муқаддас Елена ороллари",
        "SI": "Словения",
        "SJ": "Савльбард ва Жан Маен",
        "SK": "Словакия",
        "SL": "Сьерра-Леоне",
        "SM": "Сан-Марино",
        "SN": "Сенегал",
        "SO": "Сомали",
        "SR": "Суринам",
        "SS": "Жанубий Судан",
        "ST": "Сан-Томе ва Принсипи",
        "SV": "Эль-Сальвадор",
        "SX": "Синт-Маартен",
        "SY": "Сурия",
        "SZ": "Свазиленд",
        "TA": "Тристан де Куна",
        "TC": "Туркс ва Кайкос ороллари",
        "TD": "Чад",
        "TF": "Франция жанубий худудлари",
        "TG": "Того",
        "TH": "Тайланд",
        "TJ": "Тожикистон",
        "TK": "Токелау",
        "TL": "Шарқий-Тимор",
        "TM": "Туркманистон",
        "TN": "Тунис",
        "TO": "Тонга",
        "TR": "Туркия",
        "TT": "Тринидад ва Тобаго",
        "TV": "Тувалу",
        "TW": "Тайван",
        "TZ": "Танзания",
        "UA": "Украина",
        "UG": "Уганда",
        "UM": "АҚШ ёндош ороллари",
        "US": "Қўшма Штатлар",
        "UY": "Уругвай",
        "UZ": "Ўзбекистон",
        "VA": "Ватикан",
        "VC": "Сент-Винсент ва Гренадин",
        "VE": "Венесуэла",
        "VG": "Британия Вирджиния ороллари",
        "VI": "АҚШ Вирджиния ороллари",
        "VN": "Вьетнам",
        "VU": "Вануату",
        "WF": "Уэллис ва Футуна",
        "WS": "Самоа",
        "XK": "Косово",
        "YE": "Яман",
        "YT": "Майотта",
        "ZA": "Жанубий Африка",
        "ZM": "Замбия",
        "ZW": "Зимбабве",
        "ZZ": "Номаълум минтақа"
    };
  }-*/;
}
