# -*- tcl -*-
#
# Author:       James Brister <brister@vix.com> -- berkeley-unix --
# Start Date:   Sat, 24 Aug 1996 23:45:34 +0200
# Project:      INN
# File:         innshellvars.tcl
# Description:  Set up any and all variables that an INN tcl script
#               might need.  Also sets umask.

set env(LC_CTYPE) "C"

set prefix "/usr/pkg"
set exec_prefix "${prefix}"
eval [exec /usr/pkg/libexec/inn/innconfval -t]

set inn_newshome "$inn_pathnews"
set inn_spooldir "$inn_pathspool"
set inn_most_logs "$inn_pathlog"
set env(NEWSHOME) "$inn_newshome"
set env(SPOOLDIR) "$inn_spooldir"
set env(MOST_LOGS) "$inn_most_logs"

set inn_newsbin "${inn_pathbin}"
set inn_newsetc "${inn_pathetc}"
set inn_newslib "${exec_prefix}/lib"
set inn_innddir "${inn_pathrun}"
set inn_locks "${inn_pathrun}"
set env(NEWSBIN) "$inn_newsbin"
set env(NEWSETC) "$inn_newsetc"
set env(NEWSLIB) "$inn_newslib"
set env(INNDDIR) "$inn_innddir"
set env(LOCKS) "$inn_locks"

set inn_errlog "${inn_most_logs}/errlog"
set inn_log "${inn_most_logs}/news"

set inn_archivedir "${inn_patharchive}"
set inn_spool "${inn_patharticles}"
set inn_batch "${inn_pathoutgoing}"
set inn_incoming "${inn_pathincoming}"
set inn_overviewdir "${inn_pathoverview}"
set inn_spoolnews "${inn_pathincoming}"
set inn_badnews "${inn_pathincoming}/bad"

set inn_active "${inn_pathdb}/active"
set inn_activetimes "${inn_pathdb}/active.times"
set inn_ctlfile "${inn_newsetc}/control.ctl"
set inn_ctlwatch "${inn_newsetc}/innwatch.ctl"
set inn_history "${inn_pathdb}/history"
set inn_newactive "${inn_pathdb}/active.tmp"
set inn_newsfeeds "${inn_newsetc}/newsfeeds"
set inn_newsgroups "${inn_pathdb}/newsgroups"
set inn_oldactive "${inn_pathdb}/active.old"
set inn_path_motd_innd "${inn_newsetc}/motd.innd"
set inn_path_motd_nnrpd "${inn_newsetc}/motd.nnrpd"
set inn_path_motd "${inn_path_motd_nnrpd}"
set inn_expirectl "${inn_newsetc}/expire.ctl"
set inn_localgroups "${inn_newsetc}/localgroups"

set inn_controlprogs "${inn_pathcontrol}"
set inn_innconfval "${inn_newsbin}/innconfval"
set inn_innd "${inn_newsbin}/innd"
set inn_innwatch "${inn_newsbin}/innwatch"
set inn_inews "${inn_newsbin}/inews"
set inn_rnews "${inn_newsbin}/rnews"
set inn_perl_startup_innd "${inn_pathfilter}/startup_innd.pl"
set inn_perl_filter_innd "${inn_pathfilter}/filter_innd.pl"
set inn_perl_filter_nnrpd "${inn_pathfilter}/filter_nnrpd.pl"
set inn_python_filter_innd "${inn_pathfilter}/filter_innd.py"
set inn_path_python_inn_module "${inn_pathfilter}/INN.py"
set inn_path_tcl_startup "${inn_pathfilter}/startup.tcl"
set inn_path_tcl_filter "${inn_pathfilter}/filter.tcl"

set inn_daily "${inn_locks}/locks/LOCK.news.daily"

set inn_newscontrol "${inn_innddir}/control"
set inn_nntpconnect "${inn_innddir}/nntpin"
set inn_serverpid "${inn_innddir}/innd.pid"
set inn_innwstatus "${inn_innddir}/innwatch.status"
set inn_watchpid "${inn_innddir}/innwatch.pid"

set inn_awk "/usr/bin/awk"
set inn_sed "/usr/bin/sed"
set inn_inndf "${inn_newsbin}/inndf"
set inn_egrep "/usr/bin/egrep"
set inn_perl "/usr/pkg/bin/perl"
set inn_gpgv "/usr/pkg/bin/gpgv2"
set inn_gpg "/usr/pkg/bin/gpg2"
set inn_pgp ""
set inn_sort "/usr/bin/sort"
set inn_getftp "/usr/pkg/libexec/inn/simpleftp"
set inn_uustat ""
set inn_uux "uux"

set inn_bzip2 "/usr/bin/bzip2"
set inn_compress "/usr/bin/compress"
set inn_gzip "/usr/bin/gzip"
set inn_uncompress "/usr/bin/gzip -d"
set inn_log_compress "/usr/bin/gzip"
set inn_z ".gz"

if { $inn_ovmethod == "ovdb" } {
    set inn_db_home "${inn_pathoverview}"
    set env(DB_HOME) "${inn_db_home}"
}

set inn_tempsock [ eval exec basename ${inn_innddir}/ctlinndXXXXXX | $inn_sed -e {s/XXXXXX$/*/} ]
set inn_tempsockdir [ exec echo ${inn_innddir}/ctlinndXXXXXX | $inn_sed -e {s@/[^/]*$@@} ]

set inn_newsmaster "usenet"
set inn_newsuser "${inn_runasuser}"
set inn_newsgroup "${inn_runasgroup}"

scan "0664" "%o" inn_filemode
scan "02555" "%o" inn_inewsmode
scan "0500" "%o" inn_rnewsmode

set do_dbz_tagged_hash "DONT"
set inn_gpg_has_allow_weak_digest_algos_flag 1

set inn_tmpdir "$inn_pathtmp"
set env(TMPDIR) "$inn_pathtmp"

set inn_spooltemp "$inn_pathtmp"

set inn_newslbin "${inn_newshome}/local"
set env(NEWSLBIN) "$inn_newslbin"

scan "02" "%o" inn_umask
catch {umask 02}

set inn_syslog_facility [ exec echo [string tolower "LOG_NEWS"] | $inn_sed -e {s/log_//} ]

set inn_path "$inn_newslbin:$inn_newsbin:$env(PATH):/bin:/usr/bin"
set env(PATH) "$inn_path"

set inn_home "$inn_pathnews"


##  Load another script that can override or add variables.
if {[file executable "${inn_pathetc}/innshellvars.tcl.local"] == 1} {
    source "${inn_pathetc}/innshellvars.tcl.local"
}
