/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jicofo.ConferenceStore;
import org.jitsi.jicofo.JicofoServices;
import org.jitsi.jicofo.PinnedConference;
import org.jitsi.jicofo.TaskPools;
import org.jitsi.jicofo.conference.ConferenceMetrics;
import org.jitsi.jicofo.conference.JitsiMeetConference;
import org.jitsi.jicofo.conference.JitsiMeetConferenceImpl;
import org.jitsi.jicofo.jibri.BaseJibri;
import org.jitsi.jicofo.jibri.JibriRecorder;
import org.jitsi.jicofo.jibri.JibriSession;
import org.jitsi.jicofo.jibri.JibriSipGateway;
import org.jitsi.jicofo.jibri.JibriStats;
import org.jitsi.jicofo.metrics.JicofoMetricsContainer;
import org.jitsi.jicofo.xmpp.XmppProvider;
import org.jitsi.metrics.CounterMetric;
import org.jitsi.metrics.LongGaugeMetric;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.utils.queue.QueueStatistics;
import org.jitsi.utils.stats.BucketStats;
import org.jitsi.utils.stats.ConferenceSizeBuckets;
import org.json.simple.JSONObject;
import org.jxmpp.jid.EntityBareJid;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001JB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0015H\u0016J\u0010\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020\fH\u0016J8\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u000b2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0(2\b\b\u0002\u0010)\u001a\u00020*2\b\b\u0002\u0010+\u001a\u00020,H\u0007J4\u0010-\u001a\u00020\f2\u0006\u0010&\u001a\u00020\u000b2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0(2\u0006\u0010.\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010/\u001a\u00020!2\u0006\u00100\u001a\u000201H\u0002J\u000e\u00102\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0010\u00103\u001a\u0004\u0018\u00010\u000e2\u0006\u00104\u001a\u00020\u000bJ\u0012\u00105\u001a\u0004\u0018\u00010\u00112\u0006\u00106\u001a\u00020\u000bH\u0016J\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u000e\u00108\u001a\u00020\u001d2\u0006\u00109\u001a\u00020,J\u000e\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;H\u0016J\u000e\u0010=\u001a\u00020,2\u0006\u00106\u001a\u00020\u000bJ\u0018\u0010>\u001a\u00020,2\u0006\u0010$\u001a\u00020\f2\u0006\u0010?\u001a\u00020\u000eH\u0016J \u0010@\u001a\u00020!2\u0006\u00104\u001a\u00020\u000b2\u0006\u0010A\u001a\u00020\u000e2\u0006\u0010B\u001a\u00020CH\u0016J\u0010\u0010D\u001a\u00020!2\u0006\u0010E\u001a\u00020,H\u0016J\u0010\u0010F\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0015H\u0016J\u0006\u0010G\u001a\u00020!J\u0010\u0010H\u001a\u00020!2\u0006\u00104\u001a\u00020\u000bH\u0016J\b\u0010I\u001a\u00020!H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\b\u0012\u00060\u001bR\u00020\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006K"}, d2={"Lorg/jitsi/jicofo/FocusManager;", "Lorg/jitsi/jicofo/conference/JitsiMeetConferenceImpl$ConferenceListener;", "Lorg/jitsi/jicofo/ConferenceStore;", "Lorg/jitsi/jicofo/xmpp/XmppProvider$Listener;", "jicofoServices", "Lorg/jitsi/jicofo/JicofoServices;", "clock", "Ljava/time/Clock;", "(Lorg/jitsi/jicofo/JicofoServices;Ljava/time/Clock;)V", "conferences", "", "Lorg/jxmpp/jid/EntityBareJid;", "Lorg/jitsi/jicofo/conference/JitsiMeetConferenceImpl;", "conferencesByMeetingId", "", "conferencesCache", "", "Lorg/jitsi/jicofo/conference/JitsiMeetConference;", "conferencesSyncRoot", "", "listeners", "Lorg/jitsi/jicofo/ConferenceStore$Listener;", "logger", "Lorg/jitsi/utils/logging2/Logger;", "getLogger", "()Lorg/jitsi/utils/logging2/Logger;", "pinnedConferences", "Lorg/jitsi/jicofo/FocusManager$PinnedConferenceState;", "stats", "Lorg/jitsi/utils/OrderedJsonObject;", "getStats", "()Lorg/jitsi/utils/OrderedJsonObject;", "addListener", "", "listener", "conferenceEnded", "conference", "conferenceRequest", "room", "properties", "", "loggingLevel", "Ljava/util/logging/Level;", "includeInStatistics", "", "createConference", "logLevel", "expirePins", "curTime", "Ljava/time/Instant;", "getAllConferences", "getBridgeVersionForConference", "roomName", "getConference", "jid", "getConferences", "getDebugState", "full", "getPinnedConferences", "", "Lorg/jitsi/jicofo/PinnedConference;", "hasBreakoutRooms", "meetingIdSet", "meetingId", "pinConference", "jvbVersion", "duration", "Ljava/time/Duration;", "registrationChanged", "registered", "removeListener", "start", "unpinConference", "updateMetrics", "PinnedConferenceState", "jicofo"})
@SourceDebugExtension(value={"SMAP\nFocusManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FocusManager.kt\norg/jitsi/jicofo/FocusManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,379:1\n1755#2,3:380\n1782#2,4:384\n1782#2,4:388\n1782#2,4:392\n1863#2,2:398\n1#3:383\n216#4,2:396\n*S KotlinDebug\n*F\n+ 1 FocusManager.kt\norg/jitsi/jicofo/FocusManager\n*L\n82#1:380,3\n261#1:384,4\n264#1:388,4\n267#1:392,4\n376#1:398,2\n359#1:396,2\n*E\n"})
public final class FocusManager
implements JitsiMeetConferenceImpl.ConferenceListener,
ConferenceStore,
XmppProvider.Listener {
    @NotNull
    private final JicofoServices jicofoServices;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Map<EntityBareJid, JitsiMeetConferenceImpl> conferences;
    @NotNull
    private final List<JitsiMeetConference> conferencesCache;
    @NotNull
    private final Map<String, JitsiMeetConferenceImpl> conferencesByMeetingId;
    @NotNull
    private final Object conferencesSyncRoot;
    @NotNull
    private final List<ConferenceStore.Listener> listeners;
    @NotNull
    private final Map<EntityBareJid, PinnedConferenceState> pinnedConferences;

    public FocusManager(@NotNull JicofoServices jicofoServices, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)jicofoServices, (String)"jicofoServices");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.jicofoServices = jicofoServices;
        this.clock = clock;
        this.logger = LoggerExtensionsKt.createLogger$default((Object)this, null, null, (int)3, null);
        this.conferences = new ConcurrentHashMap();
        this.conferencesCache = new CopyOnWriteArrayList();
        this.conferencesByMeetingId = new ConcurrentHashMap();
        this.conferencesSyncRoot = new Object();
        this.listeners = new ArrayList();
        this.pinnedConferences = new HashMap();
    }

    public /* synthetic */ FocusManager(JicofoServices jicofoServices, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC(...)");
            clock = clock2;
        }
        this(jicofoServices, clock);
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public final void start() {
        JicofoMetricsContainer.Companion.getInstance().getMetricsUpdater().addUpdateTask((Function0)new Function0<Unit>(this){
            final /* synthetic */ FocusManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                FocusManager.access$updateMetrics(this.this$0);
            }
        });
    }

    public final boolean hasBreakoutRooms(@NotNull EntityBareJid jid) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)jid, (String)"jid");
            Iterable $this$any$iv = this.conferences.values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    JitsiMeetConferenceImpl it = (JitsiMeetConferenceImpl)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getMainRoomJid(), (Object)jid)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    @NotNull
    public final JitsiMeetConference conferenceRequest(@NotNull EntityBareJid room, @NotNull Map<String, String> properties, @NotNull Level loggingLevel, boolean includeInStatistics) throws Exception {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)loggingLevel, (String)"loggingLevel");
        JitsiMeetConferenceImpl conference = null;
        boolean isConferenceCreator = false;
        Object object = this.conferencesSyncRoot;
        synchronized (object) {
            boolean bl = false;
            JitsiMeetConferenceImpl existingConference = this.conferences.get(room);
            JitsiMeetConferenceImpl jitsiMeetConferenceImpl = existingConference;
            if (jitsiMeetConferenceImpl == null) {
                jitsiMeetConferenceImpl = this.createConference(room, properties, loggingLevel, includeInStatistics);
            }
            conference = jitsiMeetConferenceImpl;
            isConferenceCreator = existingConference == null;
            Unit unit = Unit.INSTANCE;
        }
        try {
            if (isConferenceCreator) {
                conference.start();
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)"Exception while trying to start the conference", (Throwable)e);
            throw e;
        }
        return conference;
    }

    public static /* synthetic */ JitsiMeetConference conferenceRequest$default(FocusManager focusManager, EntityBareJid entityBareJid, Map map, Level level, boolean bl, int n, Object object) throws Exception {
        if ((n & 4) != 0) {
            Level level2 = Level.ALL;
            Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"ALL");
            level = level2;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        return focusManager.conferenceRequest(entityBareJid, map, level, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final JitsiMeetConferenceImpl createConference(EntityBareJid room, Map<String, String> properties, Level logLevel, boolean includeInStatistics) {
        JitsiMeetConferenceImpl conference = null;
        Object object = this.conferencesSyncRoot;
        synchronized (object) {
            boolean bl = false;
            String jvbVersion = this.getBridgeVersionForConference(room);
            conference = new JitsiMeetConferenceImpl(room, this, properties, logLevel, jvbVersion, includeInStatistics, this.jicofoServices);
            this.conferences.put(room, conference);
            boolean bl2 = this.conferencesCache.add(conference);
        }
        if (includeInStatistics) {
            LongGaugeMetric.inc$default((LongGaugeMetric)ConferenceMetrics.conferenceCount, null, (int)1, null);
            CounterMetric.inc$default((CounterMetric)ConferenceMetrics.conferencesCreated, null, (int)1, null);
        }
        return conference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void conferenceEnded(@NotNull JitsiMeetConferenceImpl conference) {
        Intrinsics.checkNotNullParameter((Object)conference, (String)"conference");
        EntityBareJid entityBareJid = conference.getRoomName();
        Intrinsics.checkNotNullExpressionValue((Object)entityBareJid, (String)"getRoomName(...)");
        EntityBareJid roomName = entityBareJid;
        Object object = this.conferencesSyncRoot;
        synchronized (object) {
            Object mainRoomJid;
            boolean bl = false;
            this.conferences.remove(roomName);
            this.conferencesCache.remove(conference);
            Map<String, JitsiMeetConferenceImpl> map = this.conferencesByMeetingId;
            String string = conference.getMeetingId();
            TypeIntrinsics.asMutableMap(map).remove(string);
            if (conference.includeInStatistics()) {
                LongGaugeMetric.dec$default((LongGaugeMetric)ConferenceMetrics.conferenceCount, null, (int)1, null);
            }
            EntityBareJid entityBareJid2 = conference.getMainRoomJid();
            if (entityBareJid2 != null) {
                mainRoomJid = entityBareJid2;
                boolean bl2 = false;
                JitsiMeetConferenceImpl jitsiMeetConferenceImpl = this.conferences.get(mainRoomJid);
                if (jitsiMeetConferenceImpl != null) {
                    JitsiMeetConferenceImpl it = jitsiMeetConferenceImpl;
                    boolean bl3 = false;
                    TaskPools.Companion.getIoPool().submit(() -> FocusManager.conferenceEnded$lambda$7$lambda$5$lambda$4$lambda$3(it));
                }
            }
            ArrayList listeners = null;
            mainRoomJid = this.listeners;
            synchronized (mainRoomJid) {
                boolean bl4 = false;
                listeners = new ArrayList(this.listeners);
                Unit unit = Unit.INSTANCE;
            }
            for (ConferenceStore.Listener listener : (Iterable)listeners) {
                listener.conferenceEnded(roomName);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean meetingIdSet(@NotNull JitsiMeetConferenceImpl conference, @NotNull String meetingId) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)conference, (String)"conference");
        Intrinsics.checkNotNullParameter((Object)meetingId, (String)"meetingId");
        Object object = this.conferencesSyncRoot;
        synchronized (object) {
            boolean bl2;
            boolean bl3 = false;
            JitsiMeetConferenceImpl jitsiMeetConferenceImpl = this.conferencesByMeetingId.get(meetingId);
            if (jitsiMeetConferenceImpl != null) {
                JitsiMeetConferenceImpl it = jitsiMeetConferenceImpl;
                boolean bl4 = false;
                this.logger.warn((Object)("Meeting ID " + meetingId + " already exists for " + it.getRoomName() + "."));
                bl2 = false;
            } else {
                FocusManager $this$meetingIdSet_u24lambda_u2410_u24lambda_u249 = this;
                boolean bl5 = false;
                $this$meetingIdSet_u24lambda_u2410_u24lambda_u249.conferencesByMeetingId.put(meetingId, conference);
                bl2 = true;
            }
            bl = bl2;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public JitsiMeetConference getConference(@NotNull EntityBareJid jid) {
        Intrinsics.checkNotNullParameter((Object)jid, (String)"jid");
        Object object = this.conferencesSyncRoot;
        synchronized (object) {
            boolean bl = false;
            JitsiMeetConference jitsiMeetConference = this.conferences.get(jid);
            return jitsiMeetConference;
        }
    }

    @Override
    @NotNull
    public List<JitsiMeetConference> getAllConferences() {
        return this.getConferences();
    }

    @NotNull
    public final List<JitsiMeetConference> getConferences() {
        return this.conferencesCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(@NotNull ConferenceStore.Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        List<ConferenceStore.Listener> list = this.listeners;
        synchronized (list) {
            boolean bl = false;
            boolean bl2 = this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(@NotNull ConferenceStore.Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        List<ConferenceStore.Listener> list = this.listeners;
        synchronized (list) {
            boolean bl = false;
            boolean bl2 = this.listeners.remove(listener);
        }
    }

    private final void updateMetrics() {
        int n;
        int n2;
        JibriSession it;
        int count$iv;
        int n3;
        Iterable $this$count$iv;
        int numParticipants = 0;
        int largestConferenceSize = 0;
        ConferenceSizeBuckets conferenceSizes = new ConferenceSizeBuckets();
        int endpointPairs = 0;
        Set jibriSessions = new HashSet();
        int conferencesWithVisitors = 0;
        long visitors = 0L;
        for (JitsiMeetConference conference : this.getConferences()) {
            BaseJibri it2;
            if (!conference.includeInStatistics()) continue;
            int confSize = conference.getParticipantCount();
            long conferenceVisitors = conference.getVisitorCount();
            visitors += conferenceVisitors;
            if (conferenceVisitors > 0L) {
                ++conferencesWithVisitors;
            }
            if (confSize == 0) {
                confSize = 1;
            }
            numParticipants += confSize;
            endpointPairs += confSize * confSize;
            largestConferenceSize = RangesKt.coerceAtLeast((int)largestConferenceSize, (int)confSize);
            conferenceSizes.addValue((long)confSize);
            if (conference.getJibriRecorder() != null) {
                boolean bl = false;
                jibriSessions.addAll((Collection)((JibriRecorder)it2).getJibriSessions());
            }
            if (conference.getJibriSipGateway() == null) continue;
            boolean bl = false;
            jibriSessions.addAll((Collection)((JibriSipGateway)it2).getJibriSessions());
        }
        LongGaugeMetric.set$default((LongGaugeMetric)ConferenceMetrics.largestConference, (long)largestConferenceSize, null, (int)2, null);
        LongGaugeMetric.set$default((LongGaugeMetric)ConferenceMetrics.currentParticipants, (long)numParticipants, null, (int)2, null);
        ConferenceMetrics.conferenceSizes = conferenceSizes;
        LongGaugeMetric.set$default((LongGaugeMetric)ConferenceMetrics.participantPairs, (long)endpointPairs, null, (int)2, null);
        LongGaugeMetric.set$default((LongGaugeMetric)ConferenceMetrics.conferencesWithVisitors, (long)conferencesWithVisitors, null, (int)2, null);
        LongGaugeMetric.set$default((LongGaugeMetric)ConferenceMetrics.currentVisitors, (long)visitors, null, (int)2, null);
        Iterable iterable = jibriSessions;
        LongGaugeMetric longGaugeMetric = JibriStats.liveStreamingActive;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n3 = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (JibriSession)element$iv;
                boolean bl = false;
                if (!(it.getJibriType() == JibriSession.Type.LIVE_STREAMING && it.isActive()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n3 = count$iv;
        }
        int n4 = n3;
        LongGaugeMetric.set$default((LongGaugeMetric)longGaugeMetric, (long)n4, null, (int)2, null);
        $this$count$iv = jibriSessions;
        longGaugeMetric = JibriStats.recordingActive;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n2 = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (JibriSession)element$iv;
                boolean bl = false;
                if (!(it.getJibriType() == JibriSession.Type.RECORDING && it.isActive()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        n4 = n2;
        LongGaugeMetric.set$default((LongGaugeMetric)longGaugeMetric, (long)n4, null, (int)2, null);
        $this$count$iv = jibriSessions;
        longGaugeMetric = JibriStats.sipActive;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (JibriSession)element$iv;
                boolean bl = false;
                if (!(it.getJibriType() == JibriSession.Type.SIP_CALL && it.isActive()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        n4 = n;
        LongGaugeMetric.set$default((LongGaugeMetric)longGaugeMetric, (long)n4, null, (int)2, null);
    }

    @NotNull
    public final OrderedJsonObject getStats() {
        JSONObject jSONObject;
        OrderedJsonObject stats2 = new OrderedJsonObject();
        ((Map)stats2).put("total_participants", ConferenceMetrics.participants.get());
        ((Map)stats2).put("total_conferences_created", ConferenceMetrics.conferencesCreated.get());
        ((Map)stats2).put("conferences", ConferenceMetrics.conferenceCount.get());
        ((Map)stats2).put("conferences_with_visitors", ConferenceMetrics.conferencesWithVisitors.get());
        JSONObject bridgeFailures = new JSONObject();
        ((Map)bridgeFailures).put("participants_moved", ConferenceMetrics.participantsMoved.get());
        ((Map)bridgeFailures).put("bridges_removed", ConferenceMetrics.bridgesRemoved.get());
        ((Map)stats2).put("bridge_failures", bridgeFailures);
        JSONObject participantNotifications = new JSONObject();
        ((Map)participantNotifications).put("ice_failed", ConferenceMetrics.participantsIceFailed.get());
        ((Map)participantNotifications).put("request_restart", ConferenceMetrics.participantsRequestedRestart.get());
        ((Map)stats2).put("participant_notifications", participantNotifications);
        ((Map)stats2).put("largest_conference", ConferenceMetrics.largestConference.get());
        ((Map)stats2).put("participants", ConferenceMetrics.currentParticipants.get());
        ((Map)stats2).put("visitors", ConferenceMetrics.currentVisitors.get());
        ((Map)stats2).put("conference_sizes", BucketStats.toJson$default((BucketStats)((BucketStats)ConferenceMetrics.conferenceSizes), null, (int)1, null));
        ((Map)stats2).put("endpoint_pairs", ConferenceMetrics.participantPairs.get());
        Map map = (Map)stats2;
        String string = "jibri";
        JSONObject $this$_get_stats__u24lambda_u2419 = jSONObject = new JSONObject();
        boolean bl = false;
        $this$_get_stats__u24lambda_u2419.put((Object)"total_sip_call_failures", (Object)JibriStats.sipFailures.get());
        $this$_get_stats__u24lambda_u2419.put((Object)"total_live_streaming_failures", (Object)JibriStats.liveStreamingFailures.get());
        $this$_get_stats__u24lambda_u2419.put((Object)"total_recording_failures", (Object)JibriStats.recordingFailures.get());
        $this$_get_stats__u24lambda_u2419.put((Object)"live_streaming_active", (Object)JibriStats.liveStreamingActive.get());
        $this$_get_stats__u24lambda_u2419.put((Object)"recording_active", (Object)JibriStats.recordingActive.get());
        $this$_get_stats__u24lambda_u2419.put((Object)"sip_call_active", (Object)JibriStats.sipActive.get());
        map.put(string, jSONObject);
        ((Map)stats2).put("queues", QueueStatistics.Companion.getStatistics());
        return stats2;
    }

    @NotNull
    public final OrderedJsonObject getDebugState(boolean full) {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$getDebugState_u24lambda_u2420 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        for (JitsiMeetConference conference : this.getConferences()) {
            if (full) {
                OrderedJsonObject orderedJsonObject2;
                Map map = (Map)$this$getDebugState_u24lambda_u2420;
                String string = conference.getRoomName().toString();
                Intrinsics.checkNotNullExpressionValue((Object)conference.getDebugState(), (String)"getDebugState(...)");
                map.put(string, orderedJsonObject2);
                continue;
            }
            ((Map)$this$getDebugState_u24lambda_u2420).put(conference.getRoomName().toString(), conference.getParticipantCount());
        }
        return orderedJsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pinConference(@NotNull EntityBareJid roomName, @NotNull String jvbVersion, @NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)roomName, (String)"roomName");
        Intrinsics.checkNotNullParameter((Object)jvbVersion, (String)"jvbVersion");
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        PinnedConferenceState pc = new PinnedConferenceState(jvbVersion, duration);
        Object object = this.conferencesSyncRoot;
        synchronized (object) {
            boolean bl = false;
            PinnedConferenceState prev = this.pinnedConferences.remove(roomName);
            if (prev != null) {
                this.logger.info((Object)("Modifying pin for " + roomName));
            }
            PinnedConferenceState pinnedConferenceState = this.pinnedConferences.put(roomName, pc);
        }
        this.logger.info((Object)("Pinning " + roomName + " to version \"" + jvbVersion + "\" for " + duration.toMinutes() + " minute(s)."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unpinConference(@NotNull EntityBareJid roomName) {
        Intrinsics.checkNotNullParameter((Object)roomName, (String)"roomName");
        Object object = this.conferencesSyncRoot;
        synchronized (object) {
            boolean bl = false;
            PinnedConferenceState prev = this.pinnedConferences.remove(roomName);
            this.logger.info((Object)(prev != null ? "Removing pin for " + roomName : "Unpin failed: " + roomName));
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void expirePins(Instant curTime) {
        if (this.pinnedConferences.values().removeIf(arg_0 -> FocusManager.expirePins$lambda$23((Function1)new Function1<PinnedConferenceState, Boolean>(curTime){
            final /* synthetic */ Instant $curTime;
            {
                this.$curTime = $curTime;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull PinnedConferenceState it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getExpiresAt().isBefore(this.$curTime);
            }
        }, arg_0))) {
            this.logger.info((Object)"Some pins have expired.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String getBridgeVersionForConference(@NotNull EntityBareJid roomName) {
        Intrinsics.checkNotNullParameter((Object)roomName, (String)"roomName");
        Object object = this.conferencesSyncRoot;
        synchronized (object) {
            boolean bl = false;
            Instant instant = this.clock.instant();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"instant(...)");
            this.expirePins(instant);
            PinnedConferenceState pinnedConferenceState = this.pinnedConferences.get(roomName);
            String string = pinnedConferenceState != null ? pinnedConferenceState.getJvbVersion() : null;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<PinnedConference> getPinnedConferences() {
        List list;
        List $this$getPinnedConferences_u24lambda_u2427 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Object object = this.conferencesSyncRoot;
        synchronized (object) {
            boolean bl2 = false;
            Instant instant = this.clock.instant();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"instant(...)");
            this.expirePins(instant);
            Map<EntityBareJid, PinnedConferenceState> $this$forEach$iv = this.pinnedConferences;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<EntityBareJid, PinnedConferenceState>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<EntityBareJid, PinnedConferenceState> element$iv;
                Map.Entry<EntityBareJid, PinnedConferenceState> entry = element$iv = iterator.next();
                boolean bl3 = false;
                EntityBareJid conferenceId = entry.getKey();
                PinnedConferenceState p = entry.getValue();
                String string = conferenceId.toString();
                String string2 = p.getJvbVersion();
                String string3 = p.getExpiresAt().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                $this$getPinnedConferences_u24lambda_u2427.add(new PinnedConference(string, string2, string3));
            }
            Unit unit = Unit.INSTANCE;
        }
        return CollectionsKt.build((List)list);
    }

    public void registrationChanged(boolean registered) {
        Iterable $this$forEach$iv = this.conferencesCache;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JitsiMeetConference it = (JitsiMeetConference)element$iv;
            boolean bl = false;
            it.registrationChanged(registered);
        }
    }

    public void componentsChanged(@NotNull Set<XmppProvider.Component> components) {
        XmppProvider.Listener.DefaultImpls.componentsChanged((XmppProvider.Listener)this, components);
    }

    @JvmOverloads
    @NotNull
    public final JitsiMeetConference conferenceRequest(@NotNull EntityBareJid room, @NotNull Map<String, String> properties, @NotNull Level loggingLevel) throws Exception {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)loggingLevel, (String)"loggingLevel");
        return FocusManager.conferenceRequest$default(this, room, properties, loggingLevel, false, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final JitsiMeetConference conferenceRequest(@NotNull EntityBareJid room, @NotNull Map<String, String> properties) throws Exception {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        return FocusManager.conferenceRequest$default(this, room, properties, null, false, 12, null);
    }

    private static final void conferenceEnded$lambda$7$lambda$5$lambda$4$lambda$3(JitsiMeetConferenceImpl $it) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        $it.breakoutConferenceEnded();
    }

    private static final boolean expirePins$lambda$23(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$updateMetrics(FocusManager $this) {
        $this.updateMetrics();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jitsi/jicofo/FocusManager$PinnedConferenceState;", "", "jvbVersion", "", "duration", "Ljava/time/Duration;", "(Lorg/jitsi/jicofo/FocusManager;Ljava/lang/String;Ljava/time/Duration;)V", "expiresAt", "Ljava/time/Instant;", "getExpiresAt", "()Ljava/time/Instant;", "getJvbVersion", "()Ljava/lang/String;", "jicofo"})
    private final class PinnedConferenceState {
        @NotNull
        private final String jvbVersion;
        @NotNull
        private final Instant expiresAt;

        public PinnedConferenceState(@NotNull String jvbVersion, Duration duration) {
            Intrinsics.checkNotNullParameter((Object)jvbVersion, (String)"jvbVersion");
            Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
            this.jvbVersion = jvbVersion;
            Instant instant = FocusManager.this.clock.instant().plus(duration).truncatedTo(ChronoUnit.SECONDS);
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"truncatedTo(...)");
            this.expiresAt = instant;
        }

        @NotNull
        public final String getJvbVersion() {
            return this.jvbVersion;
        }

        @NotNull
        public final Instant getExpiresAt() {
            return this.expiresAt;
        }
    }
}

