/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.codec.av1;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.RtpEncodingDesc;
import org.jitsi.nlj.RtpLayerDesc;
import org.jitsi.nlj.rtp.codec.av1.Av1DDRtpLayerDesc;
import org.jitsi.rtp.rtp.header_extensions.Av1DependencyDescriptorHeaderExtension;
import org.jitsi.rtp.rtp.header_extensions.DecodeTargetLayer;
import org.jitsi.rtp.rtp.header_extensions.FrameInfo;
import org.jitsi.rtp.rtp.header_extensions.Resolution;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u001a(\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006\u001a\u0016\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006\u001a\u0016\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006\u00a8\u0006\u0012"}, d2={"getScalabilityStructure", "Lorg/jitsi/nlj/RtpEncodingDesc;", "Lorg/jitsi/rtp/rtp/header_extensions/Av1DependencyDescriptorHeaderExtension;", "ssrc", "", "eid", "", "baseFrameRate", "", "containsDecodeTarget", "", "dt", "getTemplateIdDelta", "a", "b", "applyTemplateIdDelta", "start", "delta", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nAv1DDPacket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Av1DDPacket.kt\norg/jitsi/nlj/rtp/codec/av1/Av1DDPacketKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,232:1\n1863#2,2:233\n1872#2,3:238\n13346#3,2:235\n1#4:237\n*S KotlinDebug\n*F\n+ 1 Av1DDPacket.kt\norg/jitsi/nlj/rtp/codec/av1/Av1DDPacketKt\n*L\n174#1:233,2\n197#1:238,3\n184#1:235,2\n*E\n"})
public final class Av1DDPacketKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final RtpEncodingDesc getScalabilityStructure(@NotNull Av1DependencyDescriptorHeaderExtension $this$getScalabilityStructure, long ssrc, int eid, double baseFrameRate) {
        int n;
        Intrinsics.checkNotNullParameter($this$getScalabilityStructure, "<this>");
        Integer n2 = $this$getScalabilityStructure.getActiveDecodeTargetsBitmask();
        if (n2 == null) {
            return null;
        }
        int activeDecodeTargetsBitmask = n2;
        int n3 = 0;
        int n4 = $this$getScalabilityStructure.getStructure().getMaxSpatialId() + 1;
        Object object = new int[n4][];
        while (n3 < n4) {
            int n5 = n3++;
            object[n5] = new int[$this$getScalabilityStructure.getStructure().getMaxTemporalId() + 1];
        }
        int[][] layerCounts = object;
        Object[] $this$forEach$iv = (Object[])$this$getScalabilityStructure.getStructure().getTemplateInfo();
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            Object element$iv = object.next();
            FrameInfo t2 = (FrameInfo)element$iv;
            boolean bl = false;
            if (!t2.hasInterPictureDependency()) continue;
            int[] nArray = layerCounts[t2.getSpatialId()];
            n = t2.getTemporalId();
            int n6 = nArray[n];
            nArray[n] = n6 + 1;
        }
        $this$forEach$iv = (Object[])layerCounts;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int[] a = (int[])element$iv;
            boolean bl = false;
            int total = 0;
            int i = 0;
            int n7 = a.length;
            while (i < n7) {
                int entry = a[i];
                int n8 = i++;
                a[n8] = a[n8] + total;
                total += entry;
            }
        }
        Object[] $i$f$forEach2 = (Object[])layerCounts;
        if ($i$f$forEach2.length == 0) {
            throw new NoSuchElementException();
        }
        int[] it22 = (int[])$i$f$forEach2[0];
        int n9 = 0;
        Integer n10 = ArraysKt.maxOrNull(it22);
        Intrinsics.checkNotNull(n10);
        int it22 = n10;
        n9 = 1;
        int element$iv = ArraysKt.getLastIndex($i$f$forEach2);
        if (n9 <= element$iv) {
            while (true) {
                int[] it = (int[])$i$f$forEach2[n9];
                boolean bl = false;
                Integer n11 = ArraysKt.maxOrNull(it);
                Intrinsics.checkNotNull(n11);
                int n12 = n11;
                if (it22 < n12) {
                    it22 = n12;
                }
                if (n9 == element$iv) break;
                ++n9;
            }
        }
        int maxFrameGroup = it22;
        ArrayList<Av1DDRtpLayerDesc> layers = new ArrayList<Av1DDRtpLayerDesc>();
        Iterable $this$forEachIndexed$iv = $this$getScalabilityStructure.getStructure().getDecodeTargetLayers();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n13;
            void dt;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            DecodeTargetLayer i = (DecodeTargetLayer)item$iv;
            int i2 = n;
            boolean bl = false;
            if (!Av1DDPacketKt.containsDecodeTarget(activeDecodeTargetsBitmask, i2)) continue;
            if (CollectionsKt.getOrNull($this$getScalabilityStructure.getStructure().getMaxRenderResolutions(), dt.getSpatialId()) != null) {
                Resolution it;
                boolean bl2 = false;
                n13 = Math.min(it.getWidth(), it.getHeight());
            } else {
                n13 = -1;
            }
            int height = n13;
            double frameRate = baseFrameRate * (double)layerCounts[dt.getSpatialId()][dt.getTemporalId()] / (double)maxFrameGroup;
            layers.add(new Av1DDRtpLayerDesc(eid, i2, dt.getTemporalId(), dt.getSpatialId(), height, frameRate));
        }
        RtpLayerDesc[] rtpLayerDescArray = layers.toArray(new RtpLayerDesc[0]);
        Intrinsics.checkNotNullExpressionValue(rtpLayerDescArray, "toArray(...)");
        return new RtpEncodingDesc(ssrc, rtpLayerDescArray, eid);
    }

    public static /* synthetic */ RtpEncodingDesc getScalabilityStructure$default(Av1DependencyDescriptorHeaderExtension av1DependencyDescriptorHeaderExtension, long l, int n, double d, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            d = 30.0;
        }
        return Av1DDPacketKt.getScalabilityStructure(av1DependencyDescriptorHeaderExtension, l, n, d);
    }

    public static final boolean containsDecodeTarget(int $this$containsDecodeTarget, int dt) {
        return (1 << dt & $this$containsDecodeTarget) != 0;
    }

    public static final int getTemplateIdDelta(int a, int b) {
        return (a - b + 64) % 64;
    }

    public static final int applyTemplateIdDelta(int start2, int delta) {
        return (start2 + delta) % 64;
    }
}

