/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IcmpV6CommonPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.IpV6NeighborDiscoveryOptionType;
import org.pcap4j.util.ByteArrays;

public final class IcmpV6RouterAdvertisementPacket
extends AbstractPacket {
    private static final long serialVersionUID = -537286641023282344L;
    private final IcmpV6RouterAdvertisementHeader header;

    public static IcmpV6RouterAdvertisementPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new IcmpV6RouterAdvertisementPacket(rawData, offset, length);
    }

    private IcmpV6RouterAdvertisementPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.header = new IcmpV6RouterAdvertisementHeader(rawData, offset, length);
    }

    private IcmpV6RouterAdvertisementPacket(Builder builder2) {
        if (builder2 == null || builder2.options == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder2).append(" builder.options: ").append(builder2.options);
            throw new NullPointerException(sb.toString());
        }
        this.header = new IcmpV6RouterAdvertisementHeader(builder2);
    }

    @Override
    public IcmpV6RouterAdvertisementHeader getHeader() {
        return this.header;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class IcmpV6RouterAdvertisementHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = -3300835116087515662L;
        private static final int CUR_HOP_LIMIT_OFFSET = 0;
        private static final int CUR_HOP_LIMIT_SIZE = 1;
        private static final int M_O_RESERVED_OFFSET = 1;
        private static final int M_O_RESERVED_SIZE = 1;
        private static final int ROUTER_LIFETIME_OFFSET = 2;
        private static final int ROUTER_LIFETIME_SIZE = 2;
        private static final int REACHABLE_TIME_OFFSET = 4;
        private static final int REACHABLE_TIME_SIZE = 4;
        private static final int RETRANS_TIMER_OFFSET = 8;
        private static final int RETRANS_TIMER_SIZE = 4;
        private static final int OPTIONS_OFFSET = 12;
        private final byte curHopLimit;
        private final boolean managedAddressConfigurationFlag;
        private final boolean otherConfigurationFlag;
        private final byte reserved;
        private final short routerLifetime;
        private final int reachableTime;
        private final int retransTimer;
        private final List<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption> options;

        private IcmpV6RouterAdvertisementHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            IcmpV6CommonPacket.IpV6NeighborDiscoveryOption newOne;
            if (length < 12) {
                StringBuilder sb = new StringBuilder(120);
                sb.append("The raw data must be more than ").append(11).append("bytes").append(" to build this header. raw data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            this.curHopLimit = ByteArrays.getByte(rawData, 0 + offset);
            byte tmp = ByteArrays.getByte(rawData, 1 + offset);
            this.managedAddressConfigurationFlag = (tmp & 0x80) != 0;
            this.otherConfigurationFlag = (tmp & 0x40) != 0;
            this.reserved = (byte)(0x3F & tmp);
            this.routerLifetime = ByteArrays.getShort(rawData, 2 + offset);
            this.reachableTime = ByteArrays.getInt(rawData, 4 + offset);
            this.retransTimer = ByteArrays.getInt(rawData, 8 + offset);
            this.options = new ArrayList<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption>();
            for (int currentOffsetInHeader = 12; currentOffsetInHeader < length; currentOffsetInHeader += newOne.length()) {
                IpV6NeighborDiscoveryOptionType type = IpV6NeighborDiscoveryOptionType.getInstance(rawData[currentOffsetInHeader + offset]);
                try {
                    newOne = PacketFactories.getFactory(IcmpV6CommonPacket.IpV6NeighborDiscoveryOption.class, IpV6NeighborDiscoveryOptionType.class).newInstance(rawData, currentOffsetInHeader + offset, length - currentOffsetInHeader, type);
                }
                catch (Exception e) {
                    break;
                }
                this.options.add(newOne);
            }
        }

        private IcmpV6RouterAdvertisementHeader(Builder builder2) {
            if ((builder2.reserved & 0xC0) != 0) {
                throw new IllegalArgumentException("Invalid reserved: " + builder2.reserved);
            }
            this.curHopLimit = builder2.curHopLimit;
            this.managedAddressConfigurationFlag = builder2.managedAddressConfigurationFlag;
            this.otherConfigurationFlag = builder2.otherConfigurationFlag;
            this.reserved = builder2.reserved;
            this.routerLifetime = builder2.routerLifetime;
            this.reachableTime = builder2.reachableTime;
            this.retransTimer = builder2.retransTimer;
            this.options = new ArrayList<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption>(builder2.options);
        }

        public byte getCurHopLimit() {
            return this.curHopLimit;
        }

        public int getCurHopLimitAsInt() {
            return this.curHopLimit & 0xFF;
        }

        public boolean getManagedAddressConfigurationFlag() {
            return this.managedAddressConfigurationFlag;
        }

        public boolean getOtherConfigurationFlag() {
            return this.otherConfigurationFlag;
        }

        public int getReserved() {
            return this.reserved;
        }

        public short getRouterLifetime() {
            return this.routerLifetime;
        }

        public int getRouterLifetimeAsInt() {
            return this.routerLifetime & 0xFFFF;
        }

        public int getReachableTime() {
            return this.reachableTime;
        }

        public long getReachableTimeAsLong() {
            return (long)this.reachableTime & 0xFFFFFFFFL;
        }

        public int getRetransTimer() {
            return this.retransTimer;
        }

        public long getRetransTimerAsLong() {
            return (long)this.retransTimer & 0xFFFFFFFFL;
        }

        public List<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption> getOptions() {
            return new ArrayList<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption>(this.options);
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray(this.curHopLimit));
            byte tmp = (byte)(0x3F & this.reserved);
            if (this.managedAddressConfigurationFlag) {
                tmp = (byte)(tmp | 0x80);
            }
            if (this.otherConfigurationFlag) {
                tmp = (byte)(tmp | 0x40);
            }
            rawFields.add(new byte[]{tmp});
            rawFields.add(ByteArrays.toByteArray(this.routerLifetime));
            rawFields.add(ByteArrays.toByteArray(this.reachableTime));
            rawFields.add(ByteArrays.toByteArray(this.retransTimer));
            for (IcmpV6CommonPacket.IpV6NeighborDiscoveryOption o : this.options) {
                rawFields.add(o.getRawData());
            }
            return rawFields;
        }

        @Override
        protected int calcLength() {
            int len = 0;
            for (IcmpV6CommonPacket.IpV6NeighborDiscoveryOption o : this.options) {
                len += o.length();
            }
            return len + 12;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[ICMPv6 Router Advertisement Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Cur Hop Limit: ").append(this.getCurHopLimitAsInt()).append(ls);
            sb.append("  Managed address configuration flag: ").append(this.managedAddressConfigurationFlag).append(ls);
            sb.append("  Other configuration flag: ").append(this.otherConfigurationFlag).append(ls);
            sb.append("  Reserved: ").append(this.reserved).append(ls);
            sb.append("  Router Lifetime: ").append(this.getRouterLifetimeAsInt()).append(ls);
            sb.append("  Reachable Time: ").append(this.getReachableTimeAsLong()).append(ls);
            sb.append("  Retrans Timer: ").append(this.getRetransTimerAsLong()).append(ls);
            for (IcmpV6CommonPacket.IpV6NeighborDiscoveryOption opt : this.options) {
                sb.append("  Option: ").append(opt).append(ls);
            }
            return sb.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            IcmpV6RouterAdvertisementHeader other = (IcmpV6RouterAdvertisementHeader)obj;
            return this.routerLifetime == other.routerLifetime && this.reachableTime == other.reachableTime && this.retransTimer == other.retransTimer && this.curHopLimit == other.curHopLimit && this.managedAddressConfigurationFlag == other.managedAddressConfigurationFlag && this.otherConfigurationFlag == other.otherConfigurationFlag && this.reserved == other.reserved && this.options.equals(other.options);
        }

        @Override
        protected int calcHashCode() {
            int result = 17;
            result = 31 * result + this.curHopLimit;
            result = 31 * result + (this.managedAddressConfigurationFlag ? 1231 : 1237);
            result = 31 * result + (this.otherConfigurationFlag ? 1231 : 1237);
            result = 31 * result + this.reserved;
            result = 31 * result + this.routerLifetime;
            result = 31 * result + this.reachableTime;
            result = 31 * result + this.retransTimer;
            result = 31 * result + this.options.hashCode();
            return result;
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder {
        private byte curHopLimit;
        private boolean managedAddressConfigurationFlag;
        private boolean otherConfigurationFlag;
        private byte reserved;
        private short routerLifetime;
        private int reachableTime;
        private int retransTimer;
        private List<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption> options;

        public Builder() {
        }

        private Builder(IcmpV6RouterAdvertisementPacket packet) {
            this.curHopLimit = packet.header.curHopLimit;
            this.managedAddressConfigurationFlag = packet.header.managedAddressConfigurationFlag;
            this.otherConfigurationFlag = packet.header.otherConfigurationFlag;
            this.reserved = packet.header.reserved;
            this.routerLifetime = packet.header.routerLifetime;
            this.reachableTime = packet.header.reachableTime;
            this.retransTimer = packet.header.retransTimer;
            this.options = packet.header.options;
        }

        public Builder curHopLimit(byte curHopLimit) {
            this.curHopLimit = curHopLimit;
            return this;
        }

        public Builder managedAddressConfigurationFlag(boolean managedAddressConfigurationFlag) {
            this.managedAddressConfigurationFlag = managedAddressConfigurationFlag;
            return this;
        }

        public Builder otherConfigurationFlag(boolean otherConfigurationFlag) {
            this.otherConfigurationFlag = otherConfigurationFlag;
            return this;
        }

        public Builder reserved(byte reserved) {
            this.reserved = reserved;
            return this;
        }

        public Builder routerLifetime(short routerLifetime) {
            this.routerLifetime = routerLifetime;
            return this;
        }

        public Builder reachableTime(int reachableTime) {
            this.reachableTime = reachableTime;
            return this;
        }

        public Builder retransTimer(int retransTimer) {
            this.retransTimer = retransTimer;
            return this;
        }

        public Builder options(List<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption> options2) {
            this.options = options2;
            return this;
        }

        @Override
        public IcmpV6RouterAdvertisementPacket build() {
            return new IcmpV6RouterAdvertisementPacket(this);
        }
    }
}

