/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import kafka.admin.ConfigCommand;
import kafka.admin.ConfigCommand$;
import kafka.admin.ConfigCommandTest;
import kafka.admin.ConfigCommandTest$CredentialChange$4$;
import kafka.common.InvalidConfigException;
import kafka.server.ConfigEntityName$;
import kafka.utils.Exit$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.ScramCredentialUtils;
import org.apache.kafka.common.utils.Sanitizer;
import org.easymock.EasyMock;
import org.easymock.IExpectationSetters;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\u0005Eg\u0001B\u0001\u0003\u0001\u001d\u0011\u0011cQ8oM&<7i\\7nC:$G+Z:u\u0015\t\u0019A!A\u0003bI6LgNC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\tIA\"D\u0001\u000b\u0015\tYA!\u0001\u0002{W&\u0011QB\u0003\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001eDQ!\u0006\u0001\u0005\u0002Y\ta\u0001P5oSRtD#A\f\u0011\u0005a\u0001Q\"\u0001\u0002\t\u000bi\u0001A\u0011A\u000e\u0002KMDw.\u001e7e\u000bbLGoV5uQ:{gNW3s_N#\u0018\r^;t\u001f:\f%oZ#se>\u0014H#\u0001\u000f\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0003}\tQa]2bY\u0006L!!\t\u0010\u0003\tUs\u0017\u000e\u001e\u0015\u00033\r\u0002\"\u0001J\u0015\u000e\u0003\u0015R!AJ\u0014\u0002\u000b),h.\u001b;\u000b\u0003!\n1a\u001c:h\u0013\tQSE\u0001\u0003UKN$\b\"\u0002\u0017\u0001\t\u0003Y\u0012aK:i_VdG-\u0012=ji^KG\u000f\u001b(p]j+'o\\*uCR,8o\u00148[W\u000e{W.\\1oI\u0016\u0013(o\u001c:)\u0005-\u001a\u0003\"B\u0018\u0001\t\u0003Y\u0012aL:i_VdG-\u0012=ji^KG\u000f\u001b(p]j+'o\\*uCR,8o\u00148Ce>\\WM]\"p[6\fg\u000eZ#se>\u0014\bF\u0001\u0018$\u0011\u0015\u0011\u0004\u0001\"\u00034\u0003]\t7o]3si:{gNW3s_N#\u0018\r^;t\u000bbLG\u000f\u0006\u0002\u001di!)Q'\ra\u0001m\u0005!\u0011M]4t!\rir'O\u0005\u0003qy\u0011Q!\u0011:sCf\u0004\"AO!\u000f\u0005mz\u0004C\u0001\u001f\u001f\u001b\u0005i$B\u0001 \u0007\u0003\u0019a$o\\8u}%\u0011\u0001IH\u0001\u0007!J,G-\u001a4\n\u0005\t\u001b%AB*ue&twM\u0003\u0002A=!)Q\t\u0001C\u00017\u0005A3\u000f[8vY\u0012\u0004\u0016M]:f\u0003J<W/\\3oiN4uN]\"mS\u0016tGo]#oi&$\u0018\u0010V=qK\"\u0012Ai\t\u0005\u0006\u0011\u0002!\taG\u0001(g\"|W\u000f\u001c3QCJ\u001cX-\u0011:hk6,g\u000e^:G_J$v\u000e]5dg\u0016sG/\u001b;z)f\u0004X\r\u000b\u0002HG!)1\n\u0001C\u00017\u0005A3\u000f[8vY\u0012\u0004\u0016M]:f\u0003J<W/\\3oiN4uN\u001d\"s_.,'o]#oi&$\u0018\u0010V=qK\"\u0012!j\t\u0005\u0006\u001d\u0002!\taT\u0001\u0012i\u0016\u001cH/\u0011:hk6,g\u000e\u001e)beN,GC\u0001\u000fQ\u0011\u0015\tV\n1\u0001:\u0003))g\u000e^5usRK\b/\u001a\u0005\u0006'\u0002!\taG\u0001#g\"|W\u000f\u001c3GC&d\u0017JZ+oe\u0016\u001cwn\u001a8jg\u0016$WI\u001c;jif$\u0016\u0010]3)\tI\u001bSKV\u0001\tKb\u0004Xm\u0019;fI\u000e\nq\u000b\u0005\u0002Y;:\u0011\u0011l\u0017\b\u0003yiK\u0011aH\u0005\u00039z\tq\u0001]1dW\u0006<W-\u0003\u0002_?\nA\u0012\n\u001c7fO\u0006d\u0017I]4v[\u0016tG/\u0012=dKB$\u0018n\u001c8\u000b\u0005qs\u0002\"B1\u0001\t\u0003Y\u0012!F:i_VdG-\u00113e\u00072LWM\u001c;D_:4\u0017n\u001a\u0015\u0003A\u000eBQ\u0001\u001a\u0001\u0005\u0002m\tAc\u001d5pk2$\u0017\t\u001a3U_BL7mQ8oM&<\u0007FA2$\u0011\u00159\u0007\u0001\"\u0001\u001c\u0003i\u0019\bn\\;mI\u0006#GM\u0011:pW\u0016\u0014\u0018+^8uC\u000e{gNZ5hQ\t17\u0005C\u0003k\u0001\u0011\u00051$\u0001\u000ftQ>,H\u000eZ!eI\n\u0013xn[3s\tft\u0017-\\5d\u0007>tg-[4)\u0005%\u001c\u0003\"B7\u0001\t\u0003Y\u0012aI:i_VdG-\u00113e\t\u00164\u0017-\u001e7u\u0005J|7.\u001a:Es:\fW.[2D_:4\u0017n\u001a\u0015\u0003Y\u000eBQ\u0001\u001d\u0001\u0005\u0002E\fqC^3sS\u001aL\u0018\t\u001c;fe\n\u0013xn[3s\u0007>tg-[4\u0015\tq\u0011Xp \u0005\u0006g>\u0004\r\u0001^\u0001\u0005]>$W\r\u0005\u0002vw6\taO\u0003\u0002xq\u000611m\\7n_:T!!B=\u000b\u0005i<\u0013AB1qC\u000eDW-\u0003\u0002}m\n!aj\u001c3f\u0011\u0015qx\u000e1\u0001:\u00031\u0011Xm]8ve\u000e,g*Y7f\u0011\u001d\t\ta\u001ca\u0001\u0003\u0007\tAB]3t_V\u00148-Z(qiN\u0004B\u0001WA\u0003s%\u0019\u0011qA0\u0003\t1K7\u000f\u001e\u0005\u0007\u0003\u0017\u0001A\u0011A\u000e\u0002CMDw.\u001e7e'V\u0004\bo\u001c:u\u0007>lW.Y*fa\u0006\u0014\u0018\r^3e-\u0006dW/Z:)\u0007\u0005%1\u0005\u0003\u0004\u0002\u0012\u0001!\taG\u00011g\"|W\u000f\u001c3O_R,\u0006\u000fZ1uK\n\u0013xn[3s\u0007>tg-[4JM6\u000bGNZ8s[\u0016$WI\u001c;jift\u0015-\\3)\u000b\u0005=1%\u0016,\t\r\u0005]\u0001\u0001\"\u0001\u001c\u0003A\u001a\bn\\;mI:{G/\u00169eCR,G)\u001f8b[&\u001c'I]8lKJ\u001cuN\u001c4jOV\u001b\u0018N\\4[_>\\U-\u001a9fe\"*\u0011QC\u0012V-\"1\u0011Q\u0004\u0001\u0005\u0002m\tAf\u001d5pk2$gj\u001c;Va\u0012\fG/\u001a\"s_.,'oQ8oM&<\u0017JZ'bY\u001a|'/\\3e\u0007>tg-[4)\u000b\u0005m1%\u0016,\t\r\u0005\r\u0002\u0001\"\u0001\u001c\u0003M\u001a\bn\\;mI:{G/\u00169eCR,'I]8lKJ\u001cuN\u001c4jO&3W*\u00197g_JlW\r\u001a\"sC\u000e\\W\r^\"p]\u001aLw\rK\u0003\u0002\"\r*f\u000b\u0003\u0004\u0002*\u0001!\taG\u00018g\"|W\u000f\u001c3O_R,\u0006\u000fZ1uK\n\u0013xn[3s\u0007>tg-[4JM:{g.\u0012=jgRLgnZ\"p]\u001aLw-S:EK2,G/\u001a3)\r\u0005\u001d2%VA\u0017G\t\ty\u0003\u0005\u0003\u00022\u0005URBAA\u001a\u0015\t9H!\u0003\u0003\u00028\u0005M\"AF%om\u0006d\u0017\u000eZ\"p]\u001aLw-\u0012=dKB$\u0018n\u001c8\t\r\u0005m\u0002\u0001\"\u0001\u001c\u0003a\u0019\bn\\;mI\u0012+G.\u001a;f\u0005J|7.\u001a:D_:4\u0017n\u001a\u0015\u0004\u0003s\u0019\u0003BBA!\u0001\u0011\u00051$\u0001\u000buKN$8k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d\u0015\u0004\u0003\u007f\u0019\u0003BBA$\u0001\u0011\u00051$A\u000buKN$\u0018+^8uC\u000e{gNZ5h\u000b:$\u0018\u000e^=)\u0007\u0005\u00153\u0005\u0003\u0004\u0002N\u0001!\taG\u0001\u0018i\u0016\u001cH/V:fe\u000ec\u0017.\u001a8u#V|G/Y(qiND3!a\u0013$\u0011\u0019\t\u0019\u0006\u0001C\u00017\u0005IB/Z:u#V|G/\u0019#fg\u000e\u0014\u0018NY3F]RLG/[3tQ\r\t\tf\t\u0004\u0007\u00033\u0002\u0001!a\u0017\u0003%\u0011+X.\\=BI6LgNW6DY&,g\u000e^\n\u0005\u0003/\ni\u0006E\u0002\n\u0003?J1!!\u0019\u000b\u00055\tE-\\5o5.\u001cE.[3oi\"Y\u0011QMA,\u0005\u0003\u0005\u000b\u0011BA4\u0003!Q8n\u00117jK:$\bcA\u0005\u0002j%\u0019\u00111\u000e\u0006\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u\u0011\u001d)\u0012q\u000bC\u0001\u0003_\"B!!\u001d\u0002vA!\u00111OA,\u001b\u0005\u0001\u0001\u0002CA3\u0003[\u0002\r!a\u001a\t\u0011\u0005e\u0014q\u000bC!\u0003w\n!c\u00195b]\u001e,'I]8lKJ\u001cuN\u001c4jOR)A$! \u0002\u000e\"A\u0011qPA<\u0001\u0004\t\t)A\u0005ce>\\WM]%egB)\u0001,a!\u0002\b&\u0019\u0011QQ0\u0003\u0007M+\u0017\u000fE\u0002\u001e\u0003\u0013K1!a#\u001f\u0005\rIe\u000e\u001e\u0005\t\u0003\u001f\u000b9\b1\u0001\u0002\u0012\u000691m\u001c8gS\u001e\u001c\b\u0003BAJ\u0003;k!!!&\u000b\t\u0005]\u0015\u0011T\u0001\u0005kRLGN\u0003\u0002\u0002\u001c\u0006!!.\u0019<b\u0013\u0011\ty*!&\u0003\u0015A\u0013x\u000e]3si&,7\u000f\u0003\u0005\u0002$\u0006]C\u0011IAS\u0003E1W\r^2i\u000b:$\u0018\u000e^=D_:4\u0017n\u001a\u000b\u0007\u0003#\u000b9+!+\t\rE\u000b\t\u000b1\u0001:\u0011\u001d\tY+!)A\u0002e\n!\"\u001a8uSRLh*Y7f\u0011!\ty+a\u0016\u0005B\u0005E\u0016\u0001F2iC:<Wm\u00117jK:$\u0018\nZ\"p]\u001aLw\rF\u0003\u001d\u0003g\u000b9\fC\u0004\u00026\u00065\u0006\u0019A\u001d\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012D\u0001\"a$\u0002.\u0002\u0007\u0011\u0011\u0013\u0005\t\u0003w\u000b9\u0006\"\u0011\u0002>\u0006q2\r[1oO\u0016,6/\u001a:PeV\u001bXM]\"mS\u0016tG/\u00133D_:4\u0017n\u001a\u000b\u00069\u0005}\u00161\u0019\u0005\b\u0003\u0003\fI\f1\u0001:\u0003M\u0019\u0018M\\5uSj,G-\u00128uSRLh*Y7f\u0011!\ty)!/A\u0002\u0005E\u0005\u0002CAd\u0003/\"\t%!3\u0002#\rD\u0017M\\4f)>\u0004\u0018nY\"p]\u001aLw\rF\u0003\u001d\u0003\u0017\fy\rC\u0004\u0002N\u0006\u0015\u0007\u0019A\u001d\u0002\u000bQ|\u0007/[2\t\u0011\u0005=\u0015Q\u0019a\u0001\u0003#\u0003")
public class ConfigCommandTest
extends ZooKeeperTestHarness {
    @Test
    public void shouldExitWithNonZeroStatusOnArgError() {
        this.assertNonZeroStatusExit((String[])((Object[])new String[]{"--blah"}));
    }

    @Test
    public void shouldExitWithNonZeroStatusOnZkCommandError() {
        this.assertNonZeroStatusExit((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "message.max.size=100000"}));
    }

    @Test
    public void shouldExitWithNonZeroStatusOnBrokerCommandError() {
        this.assertNonZeroStatusExit((String[])((Object[])new String[]{"--bootstrap-server", "invalid host", "--entity-type", "brokers", "--entity-name", "1", "--describe"}));
    }

    private void assertNonZeroStatusExit(String[] args) {
        ObjectRef exitStatus = ObjectRef.create((Object)None$.MODULE$);
        Exit$.MODULE$.setExitProcedure((Function2 & Serializable & scala.Serializable)(status, x$1) -> ConfigCommandTest.$anonfun$assertNonZeroStatusExit$1(exitStatus, BoxesRunTime.unboxToInt((Object)status), x$1));
        try {
            try {
                ConfigCommand$.MODULE$.main(args);
            }
            catch (RuntimeException runtimeException) {}
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)((Option)exitStatus.elem));
    }

    @Test
    public void shouldParseArgumentsForClientsEntityType() {
        this.testArgumentParse("clients");
    }

    @Test
    public void shouldParseArgumentsForTopicsEntityType() {
        this.testArgumentParse("topics");
    }

    @Test
    public void shouldParseArgumentsForBrokersEntityType() {
        this.testArgumentParse("brokers");
    }

    public void testArgumentParse(String entityType) {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "x", "--entity-type", entityType, "--describe"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "x", "--entity-type", entityType, "--alter", "--add-config", "a=b,c=d"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "x", "--entity-type", entityType, "--alter", "--delete-config", "a,b,c"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "x", "--entity-type", entityType, "--alter", "--add-config", "a=b,c=d", "--delete-config", "a"}));
        createOpts.checkArgs();
        Properties addedProps = ConfigCommand$.MODULE$.parseConfigsToBeAdded(createOpts);
        Assert.assertEquals((long)2L, (long)addedProps.size());
        Assert.assertEquals((Object)"b", (Object)addedProps.getProperty("a"));
        Assert.assertEquals((Object)"d", (Object)addedProps.getProperty("c"));
        Seq deletedProps = ConfigCommand$.MODULE$.parseConfigsToBeDeleted(createOpts);
        Assert.assertEquals((long)1L, (long)deletedProps.size());
        Assert.assertEquals((Object)"a", (Object)deletedProps.head());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfUnrecognisedEntityType() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "client", "--entity-type", "not-recognised", "--alter", "--add-config", "a=b,c=d"}));
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test
    public void shouldAddClientConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-client-id", "--entity-type", "clients", "--alter", "--add-config", "a=b,c=d"}));
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$1
        extends AdminZkClient {
            public void changeClientIdConfig(String clientId, Properties configChange) {
                Assert.assertEquals((Object)"my-client-id", (Object)clientId);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d", (Object)configChange.get("c"));
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$1(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$1(null, this.zkClient()));
    }

    @Test
    public void shouldAddTopicConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--add-config", "a=b,c=d"}));
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$2
        extends AdminZkClient {
            public void changeTopicConfig(String topic, Properties configChange) {
                Assert.assertEquals((Object)"my-topic", (Object)topic);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d", (Object)configChange.get("c"));
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$2(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$2(null, this.zkClient()));
    }

    @Test
    public void shouldAddBrokerQuotaConfig() {
        ConfigCommand.ConfigCommandOptions alterOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "leader.replication.throttled.rate=10,follower.replication.throttled.rate=20"}));
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$3
        extends AdminZkClient {
            public void changeBrokerConfig(Seq<Object> brokerIds, Properties configChange) {
                Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), brokerIds);
                Assert.assertEquals((Object)"10", (Object)configChange.get("leader.replication.throttled.rate"));
                Assert.assertEquals((Object)"20", (Object)configChange.get("follower.replication.throttled.rate"));
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$3(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfig(null, alterOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$3(null, this.zkClient()));
    }

    @Test
    public void shouldAddBrokerDynamicConfig() {
        Node node = new Node(1, "localhost", 9092);
        this.verifyAlterBrokerConfig(node, "1", (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "1"})));
    }

    @Test
    public void shouldAddDefaultBrokerDynamicConfig() {
        Node node = new Node(1, "localhost", 9092);
        this.verifyAlterBrokerConfig(node, "", (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-default"})));
    }

    public void verifyAlterBrokerConfig(Node node, String resourceName, List<String> resourceOpts) {
        List optsList = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", "brokers", "--alter", "--add-config", "message.max.bytes=10"})).$plus$plus(resourceOpts, List$.MODULE$.canBuildFrom());
        ConfigCommand.ConfigCommandOptions alterOpts = new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class)));
        scala.collection.mutable.Map brokerConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"num.io.threads"), (Object)"5")}));
        ConfigResource resource = new ConfigResource(ConfigResource.Type.BROKER, resourceName);
        java.util.List<ConfigEntry> configEntries = Collections.singletonList(new ConfigEntry("num.io.threads", "5"));
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(resource, new Config(configEntries)));
        DescribeConfigsResult describeResult = (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        EasyMock.expect((Object)describeResult.all()).andReturn((Object)future).once();
        KafkaFutureImpl alterFuture = new KafkaFutureImpl();
        alterFuture.complete(null);
        AlterConfigsResult alterResult = (AlterConfigsResult)EasyMock.createNiceMock(AlterConfigsResult.class);
        EasyMock.expect((Object)alterResult.all()).andReturn((Object)alterFuture);
        MockAdminClient mockAdminClient = new MockAdminClient(null, node, resourceName, brokerConfigs, describeResult, alterResult){
            private final String resourceName$1;
            private final scala.collection.mutable.Map brokerConfigs$1;
            private final DescribeConfigsResult describeResult$1;
            private final AlterConfigsResult alterResult$1;

            public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assert.assertEquals((long)1L, (long)resources.size());
                ConfigResource resource = resources.iterator().next();
                Assert.assertEquals((Object)ConfigResource.Type.BROKER, (Object)resource.type());
                Assert.assertEquals((Object)this.resourceName$1, (Object)resource.name());
                return this.describeResult$1;
            }

            public AlterConfigsResult alterConfigs(Map<ConfigResource, Config> configs, AlterConfigsOptions options) {
                Assert.assertEquals((long)1L, (long)configs.size());
                Map.Entry<ConfigResource, Config> entry = configs.entrySet().iterator().next();
                ConfigResource resource = entry.getKey();
                Config config = entry.getValue();
                Assert.assertEquals((Object)ConfigResource.Type.BROKER, (Object)resource.type());
                ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).foreach((Function1 & Serializable & scala.Serializable)e -> $this.brokerConfigs$1.put((Object)e.name(), (Object)e.value()));
                return this.alterResult$1;
            }
            {
                this.resourceName$1 = resourceName$1;
                this.brokerConfigs$1 = brokerConfigs$1;
                this.describeResult$1 = describeResult$1;
                this.alterResult$1 = alterResult$1;
                super(Collections.singletonList(node$1), node$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$alterConfigs$1(kafka.admin.ConfigCommandTest$$anon$1 org.apache.kafka.clients.admin.ConfigEntry )}, serializedLambda);
            }
        };
        EasyMock.replay((Object[])new Object[]{alterResult, describeResult});
        ConfigCommand$.MODULE$.alterBrokerConfig((AdminClient)mockAdminClient, alterOpts, resourceName);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.max.bytes"), (Object)"10"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"num.io.threads"), (Object)"5")})), (Object)brokerConfigs.toMap(Predef$.MODULE$.$conforms()));
        EasyMock.reset((Object[])new Object[]{alterResult, describeResult});
    }

    @Test
    public void shouldSupportCommaSeparatedValues() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--add-config", "a=b,c=[d,e ,f],g=[h,i]"}));
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$4
        extends AdminZkClient {
            public void changeBrokerConfig(Seq<Object> brokerIds, Properties configChange) {
                Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), brokerIds);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d,e ,f", (Object)configChange.get("c"));
                Assert.assertEquals((Object)"h,i", (Object)configChange.get("g"));
            }

            public void changeTopicConfig(String topic, Properties configs) {
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$4(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$4(null, this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedEntityName() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1,2,3", "--entity-type", "brokers", "--alter", "--add-config", "leader.replication.throttled.rate=10"}));
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateDynamicBrokerConfigUsingZooKeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "message.max.size=100000"}));
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a="}));
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedBracketConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=[b,c,d=e"}));
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=InvalidConfigException.class)
    public void shouldNotUpdateBrokerConfigIfNonExistingConfigIsDeleted() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--delete-config", "missing_config1, missing_config2"}));
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test
    public void shouldDeleteBrokerConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--delete-config", "a,c"}));
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$5
        extends AdminZkClient {
            /*
             * WARNING - void declaration
             */
            public Properties fetchEntityConfig(String entityType, String entityName) {
                void var3_3;
                Properties properties = new Properties();
                properties.put("a", "b");
                properties.put("c", "d");
                properties.put("e", "f");
                return var3_3;
            }

            public void changeBrokerConfig(Seq<Object> brokerIds, Properties configChange) {
                Assert.assertEquals((Object)"f", (Object)configChange.get("e"));
                Assert.assertEquals((long)1L, (long)configChange.size());
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$5(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$5(null, this.zkClient()));
    }

    @Test
    public void testScramCredentials() {
        LazyRef CredentialChange$module = new LazyRef();
        scala.collection.mutable.Map credentials = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ConfigCommand.ConfigCommandOptions optsA = this.createOpts$1("userA", "SCRAM-SHA-256=[iterations=8192,password=abc, def]");
        public class Kafka_admin_ConfigCommandTest$CredentialChange$3
        extends AdminZkClient
        implements Product,
        scala.Serializable {
            private final String user;
            private final Set<String> mechanisms;
            private final int iterations;
            private final /* synthetic */ ConfigCommandTest $outer;
            private final scala.collection.mutable.Map credentials$1;

            public String user() {
                return this.user;
            }

            public Set<String> mechanisms() {
                return this.mechanisms;
            }

            public int iterations() {
                return this.iterations;
            }

            public Properties fetchEntityConfig(String entityType, String entityName) {
                return (Properties)this.credentials$1.getOrElse((Object)entityName, (Function0 & Serializable & scala.Serializable)() -> new Properties());
            }

            public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configChange) {
                Assert.assertEquals((Object)this.user(), (Object)sanitizedEntityName);
                Assert.assertEquals(this.mechanisms(), (Object)JavaConverters$.MODULE$.asScalaSetConverter(configChange.keySet()).asScala());
                this.mechanisms().foreach((Function1 & Serializable & scala.Serializable)mechanism -> {
                    String value = configChange.getProperty((String)mechanism);
                    Assert.assertEquals((long)-1L, (long)value.indexOf("password="));
                    ScramCredential scramCredential = ScramCredentialUtils.credentialFromString((String)value);
                    Assert.assertEquals((long)this.iterations(), (long)scramCredential.iterations());
                    return configChange != null ? $this.credentials$1.put((Object)this.user(), (Object)configChange) : BoxedUnit.UNIT;
                });
            }

            public Kafka_admin_ConfigCommandTest$CredentialChange$3 copy(String user, Set<String> mechanisms, int iterations) {
                return new Kafka_admin_ConfigCommandTest$CredentialChange$3(this.$outer, user, mechanisms, iterations, this.credentials$1);
            }

            public String copy$default$1() {
                return this.user();
            }

            public Set<String> copy$default$2() {
                return this.mechanisms();
            }

            public int copy$default$3() {
                return this.iterations();
            }

            public String productPrefix() {
                return "CredentialChange";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    case 0: {
                        object = this.user();
                        break;
                    }
                    case 1: {
                        object = this.mechanisms();
                        break;
                    }
                    case 2: {
                        object = BoxesRunTime.boxToInteger((int)this.iterations());
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Kafka_admin_ConfigCommandTest$CredentialChange$3;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.user()));
                n = Statics.mix((int)n, (int)Statics.anyHash(this.mechanisms()));
                n = Statics.mix((int)n, (int)this.iterations());
                return Statics.finalizeHash((int)n, (int)3);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Kafka_admin_ConfigCommandTest$CredentialChange$3)) return false;
                boolean bl = true;
                if (!bl) return false;
                Kafka_admin_ConfigCommandTest$CredentialChange$3 var4_4 = (Kafka_admin_ConfigCommandTest$CredentialChange$3)((Object)x$1);
                String string = this.user();
                String string2 = var4_4.user();
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                Set<String> set = this.mechanisms();
                Set<String> set2 = var4_4.mechanisms();
                if (set == null) {
                    if (set2 != null) {
                        return false;
                    }
                } else if (!set.equals(set2)) return false;
                if (this.iterations() != var4_4.iterations()) return false;
                if (!var4_4.canEqual((Object)((Object)this))) return false;
                return true;
            }

            /*
             * WARNING - void declaration
             */
            public Kafka_admin_ConfigCommandTest$CredentialChange$3(ConfigCommandTest $outer, String user, Set<String> mechanisms, int iterations) {
                void var5_5;
                this.user = user;
                this.mechanisms = mechanisms;
                this.iterations = iterations;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.credentials$1 = var5_5;
                super($outer.zkClient());
                Product.$init$((Product)this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$fetchEntityConfig$1(), $anonfun$changeUserOrUserClientIdConfig$1(kafka.admin.ConfigCommandTest$CredentialChange$3 java.util.Properties java.lang.String )}, serializedLambda);
            }
        }
        ConfigCommand$.MODULE$.alterConfig(null, optsA, (AdminZkClient)this.CredentialChange$2(credentials, CredentialChange$module).apply("userA", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-256"}))), 8192));
        ConfigCommand.ConfigCommandOptions optsB = this.createOpts$1("userB", "SCRAM-SHA-256=[iterations=4096,password=abc, def],SCRAM-SHA-512=[password=1234=abc]");
        ConfigCommand$.MODULE$.alterConfig(null, optsB, (AdminZkClient)this.CredentialChange$2(credentials, CredentialChange$module).apply("userB", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-256", "SCRAM-SHA-512"}))), 4096));
        ConfigCommand.ConfigCommandOptions del256 = this.deleteOpts$1("userB", "SCRAM-SHA-256");
        ConfigCommand$.MODULE$.alterConfig(null, del256, (AdminZkClient)this.CredentialChange$2(credentials, CredentialChange$module).apply("userB", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-512"}))), 4096));
        ConfigCommand.ConfigCommandOptions del512 = this.deleteOpts$1("userB", "SCRAM-SHA-512");
        ConfigCommand$.MODULE$.alterConfig(null, del512, (AdminZkClient)this.CredentialChange$2(credentials, CredentialChange$module).apply("userB", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)), 4096));
    }

    @Test
    public void testQuotaConfigEntity() {
        String[] describeOpts = (String[])((Object[])new String[]{"--describe"});
        String[] alterOpts = (String[])((Object[])new String[]{"--alter", "--add-config", "a=b,c=d"});
        String clientId = "client-1";
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{describeOpts, alterOpts}))).foreach((Function1 & Serializable & scala.Serializable)opts -> {
            ConfigCommandTest.$anonfun$testQuotaConfigEntity$1(this, clientId, opts);
            return BoxedUnit.UNIT;
        });
        this.checkEntity$1("clients", (Option)None$.MODULE$, "", describeOpts);
        this.checkInvalidEntity$1("clients", (Option)None$.MODULE$, alterOpts);
        String principal = "CN=ConfigCommandTest,O=Apache,L=<default>";
        String sanitizedPrincipal = Sanitizer.sanitize((String)principal);
        Assert.assertEquals((long)-1L, (long)sanitizedPrincipal.indexOf(61));
        Assert.assertEquals((Object)principal, (Object)Sanitizer.desanitize((String)sanitizedPrincipal));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{describeOpts, alterOpts}))).foreach((Function1 & Serializable & scala.Serializable)opts -> {
            ConfigCommandTest.$anonfun$testQuotaConfigEntity$2(this, principal, sanitizedPrincipal, opts);
            return BoxedUnit.UNIT;
        });
        this.checkEntity$1("users", (Option)None$.MODULE$, "", describeOpts);
        this.checkInvalidEntity$1("users", (Option)None$.MODULE$, alterOpts);
        String userClient = sanitizedPrincipal + "/clients/" + clientId;
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{describeOpts, alterOpts}))).foreach((Function1 & Serializable & scala.Serializable)opts -> {
            ConfigCommandTest.$anonfun$testQuotaConfigEntity$3(this, describeOpts, clientId, principal, sanitizedPrincipal, userClient, opts);
            return BoxedUnit.UNIT;
        });
        this.checkEntity$1("users", (Option)new Some((Object)principal), sanitizedPrincipal + "/clients", (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeOpts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--entity-type", "clients"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        this.checkInvalidEntity$1("users", (Option)new Some((Object)principal), (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])alterOpts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--entity-type", "clients"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        this.checkInvalidEntity$1("users", (Option)None$.MODULE$, (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])alterOpts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ConfigCommandTest.clientIdOpts$1(clientId))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        this.checkInvalidEntity$1("users", (Option)None$.MODULE$, (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])alterOpts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--entity-type", "clients"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
    }

    @Test
    public void testUserClientQuotaOpts() {
        this.checkEntity$2("users", Sanitizer.sanitize((String)"<default>"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "users", "--entity-name", "<default>", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("clients", Sanitizer.sanitize((String)"<default>"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-name", "<default>", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", Sanitizer.sanitize((String)"CN=user1") + "/clients/client1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "users", "--entity-name", "CN=user1", "--entity-type", "clients", "--entity-name", "client1", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", Sanitizer.sanitize((String)"CN=user1") + "/clients/client1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "CN=user1", "--entity-type", "users", "--entity-name", "client1", "--entity-type", "clients", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", Sanitizer.sanitize((String)"CN=user1") + "/clients/client1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-name", "client1", "--entity-type", "users", "--entity-name", "CN=user1", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", Sanitizer.sanitize((String)"CN=user1") + "/clients/client1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "client1", "--entity-type", "clients", "--entity-name", "CN=user1", "--entity-type", "users", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", Sanitizer.sanitize((String)"CN=user1") + "/clients", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-name", "CN=user1", "--entity-type", "users", "--describe"}));
        this.checkEntity$2("users", "/clients", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-type", "users", "--describe"}));
        this.checkEntity$2("users", Sanitizer.sanitize((String)"CN=user1") + "/clients/" + Sanitizer.sanitize((String)"client1?@%"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "client1?@%", "--entity-type", "clients", "--entity-name", "CN=user1", "--entity-type", "users", "--alter", "--add-config", "a=b,c=d"}));
    }

    @Test
    public void testQuotaDescribeEntities() {
        KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);
        String clientId = "a-client";
        String principal = "CN=ConfigCommandTest.testQuotaDescribeEntities , O=Apache, L=<default>";
        String sanitizedPrincipal = Sanitizer.sanitize((String)principal);
        String userClient = sanitizedPrincipal + "/clients/" + clientId;
        String[] opts = (String[])((Object[])new String[]{"--entity-type", "clients", "--entity-name", clientId});
        ConfigCommandTest.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{clientId})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "clients", "--entity-default"});
        ConfigCommandTest.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>"})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "clients"});
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clients"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{clientId})))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{clientId})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal});
        ConfigCommandTest.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sanitizedPrincipal})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-default"});
        ConfigCommandTest.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>"})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users"});
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"users"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>", sanitizedPrincipal})))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>", sanitizedPrincipal})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal, "--entity-type", "clients", "--entity-name", clientId});
        ConfigCommandTest.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{userClient})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal, "--entity-type", "clients", "--entity-default"});
        ConfigCommandTest.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sanitizedPrincipal + "/clients/<default>"})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal, "--entity-type", "clients"});
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)("users/" + sanitizedPrincipal + "/clients")), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-4"})))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sanitizedPrincipal + "/clients/client-4"})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-default", "--entity-type", "clients"});
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"users/<default>/clients"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-5"})))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>/clients/client-5"})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-type", "clients"});
        scala.collection.immutable.Map userMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)("users/" + sanitizedPrincipal + "/clients")), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-2"})))}));
        scala.collection.immutable.Map defaultUserMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"users/<default>/clients"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-3"})))}));
        ConfigCommandTest.checkEntities$1(opts, ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"users"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>", sanitizedPrincipal})))}))).$plus$plus((GenTraversableOnce)defaultUserMap).$plus$plus((GenTraversableOnce)userMap), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>/clients/client-3", sanitizedPrincipal + "/clients/client-2"})), zkClient);
    }

    public static final /* synthetic */ Nothing$ $anonfun$assertNonZeroStatusExit$1(ObjectRef exitStatus$1, int status, Option x$1) {
        exitStatus$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)status));
        throw new RuntimeException();
    }

    private final ConfigCommand.ConfigCommandOptions createOpts$1(String user, String config) {
        return new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", user, "--entity-type", "users", "--alter", "--add-config", config}));
    }

    private final ConfigCommand.ConfigCommandOptions deleteOpts$1(String user, String mechanism) {
        return new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", user, "--entity-type", "users", "--alter", "--delete-config", mechanism}));
    }

    private final /* synthetic */ ConfigCommandTest$CredentialChange$4$ CredentialChange$lzycompute$1(scala.collection.mutable.Map credentials$1, LazyRef CredentialChange$module$1) {
        ConfigCommandTest$CredentialChange$4$ configCommandTest$CredentialChange$4$;
        LazyRef lazyRef = CredentialChange$module$1;
        synchronized (lazyRef) {
            configCommandTest$CredentialChange$4$ = CredentialChange$module$1.initialized() ? (ConfigCommandTest$CredentialChange$4$)((Object)CredentialChange$module$1.value()) : (ConfigCommandTest$CredentialChange$4$)((Object)CredentialChange$module$1.initialize((Object)new ConfigCommandTest$CredentialChange$4$(this, credentials$1)));
        }
        return configCommandTest$CredentialChange$4$;
    }

    private final ConfigCommandTest$CredentialChange$4$ CredentialChange$2(scala.collection.mutable.Map credentials$1, LazyRef CredentialChange$module$1) {
        return CredentialChange$module$1.initialized() ? (ConfigCommandTest$CredentialChange$4$)((Object)CredentialChange$module$1.value()) : this.CredentialChange$lzycompute$1(credentials$1, CredentialChange$module$1);
    }

    private final ConfigCommand.ConfigCommandOptions createOpts$2(String entityType, Option entityName, String[] otherArgs) {
        String[] stringArray;
        String[] optArray = (String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-type", entityType});
        Option option = entityName;
        if (option instanceof Some) {
            Some some = (Some)option;
            String name = (String)some.value();
            stringArray = (String[])((Object[])new String[]{"--entity-name", name});
        } else if (None$.MODULE$.equals(option)) {
            stringArray = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        } else {
            throw new MatchError((Object)option);
        }
        String[] nameArray = stringArray;
        return new ConfigCommand.ConfigCommandOptions((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])optArray)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nameArray)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])otherArgs)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
    }

    private final void checkEntity$1(String entityType, Option entityName, String expectedEntityName, String[] otherArgs) {
        ConfigCommand.ConfigCommandOptions opts = this.createOpts$2(entityType, entityName, otherArgs);
        opts.checkArgs();
        ConfigCommand.ConfigEntity entity = ConfigCommand$.MODULE$.parseEntity(opts);
        Assert.assertEquals((Object)entityType, (Object)entity.root().entityType());
        Assert.assertEquals((Object)expectedEntityName, (Object)entity.fullSanitizedName());
    }

    private final void checkInvalidEntity$1(String entityType, Option entityName, String[] otherArgs) {
        ConfigCommand.ConfigCommandOptions opts = this.createOpts$2(entityType, entityName, otherArgs);
        try {
            opts.checkArgs();
            ConfigCommand$.MODULE$.parseEntity(opts);
            throw this.fail("Did not fail with invalid argument list", new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 432));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigEntity$1(ConfigCommandTest $this, String clientId$1, String[] opts) {
        $this.checkEntity$1("clients", (Option)new Some((Object)clientId$1), clientId$1, opts);
        $this.checkEntity$1("clients", (Option)new Some((Object)""), ConfigEntityName$.MODULE$.Default(), opts);
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigEntity$2(ConfigCommandTest $this, String principal$1, String sanitizedPrincipal$1, String[] opts) {
        $this.checkEntity$1("users", (Option)new Some((Object)principal$1), sanitizedPrincipal$1, opts);
        $this.checkEntity$1("users", (Option)new Some((Object)""), ConfigEntityName$.MODULE$.Default(), opts);
    }

    private static final String[] clientIdOpts$1(String name) {
        return (String[])((Object[])new String[]{"--entity-type", "clients", "--entity-name", name});
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigEntity$3(ConfigCommandTest $this, String[] describeOpts$1, String clientId$1, String principal$1, String sanitizedPrincipal$1, String userClient$1, String[] opts) {
        $this.checkEntity$1("users", (Option)new Some((Object)principal$1), userClient$1, (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])opts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ConfigCommandTest.clientIdOpts$1(clientId$1))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        $this.checkEntity$1("users", (Option)new Some((Object)principal$1), sanitizedPrincipal$1 + "/clients/" + ConfigEntityName$.MODULE$.Default(), (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])opts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ConfigCommandTest.clientIdOpts$1(""))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        $this.checkEntity$1("users", (Option)new Some((Object)""), ConfigEntityName$.MODULE$.Default() + "/clients/" + clientId$1, (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeOpts$1)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ConfigCommandTest.clientIdOpts$1(clientId$1))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        $this.checkEntity$1("users", (Option)new Some((Object)""), ConfigEntityName$.MODULE$.Default() + "/clients/" + ConfigEntityName$.MODULE$.Default(), (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])opts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ConfigCommandTest.clientIdOpts$1(""))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
    }

    private final void checkEntity$2(String expectedEntityType, String expectedEntityName, Seq args) {
        ConfigCommand.ConfigCommandOptions opts = new ConfigCommand.ConfigCommandOptions((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--zookeeper", this.zkConnect()})).$plus$plus((GenTraversableOnce)args, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        opts.checkArgs();
        ConfigCommand.ConfigEntity entity = ConfigCommand$.MODULE$.parseEntity(opts);
        Assert.assertEquals((Object)expectedEntityType, (Object)entity.root().entityType());
        Assert.assertEquals((Object)expectedEntityName, (Object)entity.fullSanitizedName());
    }

    private static final void checkEntities$1(String[] opts, scala.collection.immutable.Map expectedFetches, Seq expectedEntityNames, KafkaZkClient zkClient$1) {
        ConfigCommand.ConfigEntity entity = ConfigCommand$.MODULE$.parseEntity(new ConfigCommand.ConfigCommandOptions((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])opts)).$colon$plus((Object)"--describe", ClassTag$.MODULE$.apply(String.class))));
        expectedFetches.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            Seq values = (Seq)tuple2._2();
            IExpectationSetters iExpectationSetters = EasyMock.expect((Object)zkClient$1.getAllEntitiesWithConfig(name)).andReturn((Object)values);
            return iExpectationSetters;
        });
        EasyMock.replay((Object[])new Object[]{zkClient$1});
        Seq entities = entity.getAllEntities(zkClient$1);
        Assert.assertEquals((Object)expectedEntityNames, (Object)entities.map((Function1 & Serializable & scala.Serializable)e -> e.fullSanitizedName(), Seq$.MODULE$.canBuildFrom()));
        EasyMock.reset((Object[])new Object[]{zkClient$1});
    }

    public class DummyAdminZkClient
    extends AdminZkClient {
        public void changeBrokerConfig(Seq<Object> brokerIds, Properties configs) {
        }

        public Properties fetchEntityConfig(String entityType, String entityName) {
            return new Properties();
        }

        public void changeClientIdConfig(String clientId, Properties configs) {
        }

        public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configs) {
        }

        public void changeTopicConfig(String topic, Properties configs) {
        }

        public /* synthetic */ ConfigCommandTest kafka$admin$ConfigCommandTest$DummyAdminZkClient$$$outer() {
            return ConfigCommandTest.this;
        }

        public DummyAdminZkClient(KafkaZkClient zkClient) {
            if (ConfigCommandTest.this == null) {
                throw null;
            }
            super(zkClient);
        }
    }
}

