/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.processor.StateStoreSupplier;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.SessionBytesStoreSupplier;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.internals.InMemoryKeyValueStore;
import org.apache.kafka.streams.state.internals.InMemoryKeyValueStoreSupplier;
import org.apache.kafka.streams.state.internals.InMemoryLRUCacheStoreSupplier;
import org.apache.kafka.streams.state.internals.KeyValueStoreBuilder;
import org.apache.kafka.streams.state.internals.MemoryNavigableLRUCache;
import org.apache.kafka.streams.state.internals.RocksDBKeyValueStoreSupplier;
import org.apache.kafka.streams.state.internals.RocksDBSessionStoreSupplier;
import org.apache.kafka.streams.state.internals.RocksDBWindowStoreSupplier;
import org.apache.kafka.streams.state.internals.RocksDbKeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.internals.RocksDbSessionBytesStoreSupplier;
import org.apache.kafka.streams.state.internals.RocksDbWindowBytesStoreSupplier;
import org.apache.kafka.streams.state.internals.SessionStoreBuilder;
import org.apache.kafka.streams.state.internals.WindowStoreBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public class Stores {
    private static final Logger log = LoggerFactory.getLogger(Stores.class);

    public static KeyValueBytesStoreSupplier persistentKeyValueStore(String name) {
        Objects.requireNonNull(name, "name cannot be null");
        return new RocksDbKeyValueBytesStoreSupplier(name);
    }

    public static KeyValueBytesStoreSupplier inMemoryKeyValueStore(final String name) {
        Objects.requireNonNull(name, "name cannot be null");
        return new KeyValueBytesStoreSupplier(){

            @Override
            public String name() {
                return name;
            }

            @Override
            public KeyValueStore<Bytes, byte[]> get() {
                return new InMemoryKeyValueStore<Bytes, byte[]>(name, Serdes.Bytes(), Serdes.ByteArray());
            }

            @Override
            public String metricsScope() {
                return "in-memory-state";
            }
        };
    }

    public static KeyValueBytesStoreSupplier lruMap(final String name, final int maxCacheSize) {
        Objects.requireNonNull(name, "name cannot be null");
        if (maxCacheSize < 0) {
            throw new IllegalArgumentException("maxCacheSize cannot be negative");
        }
        return new KeyValueBytesStoreSupplier(){

            @Override
            public String name() {
                return name;
            }

            @Override
            public KeyValueStore<Bytes, byte[]> get() {
                return new MemoryNavigableLRUCache<Bytes, byte[]>(name, maxCacheSize, Serdes.Bytes(), Serdes.ByteArray());
            }

            @Override
            public String metricsScope() {
                return "in-memory-lru-state";
            }
        };
    }

    public static WindowBytesStoreSupplier persistentWindowStore(String name, long retentionPeriod, int numSegments, long windowSize, boolean retainDuplicates) {
        Objects.requireNonNull(name, "name cannot be null");
        if (retentionPeriod < 0L) {
            throw new IllegalArgumentException("retentionPeriod cannot be negative");
        }
        if (numSegments < 1) {
            throw new IllegalArgumentException("numSegments cannot must smaller than 1");
        }
        if (windowSize < 0L) {
            throw new IllegalArgumentException("windowSize cannot be negative");
        }
        return new RocksDbWindowBytesStoreSupplier(name, retentionPeriod, numSegments, windowSize, retainDuplicates);
    }

    public static SessionBytesStoreSupplier persistentSessionStore(String name, long retentionPeriod) {
        Objects.requireNonNull(name, "name cannot be null");
        if (retentionPeriod < 0L) {
            throw new IllegalArgumentException("retentionPeriod cannot be negative");
        }
        return new RocksDbSessionBytesStoreSupplier(name, retentionPeriod);
    }

    public static <K, V> StoreBuilder<WindowStore<K, V>> windowStoreBuilder(WindowBytesStoreSupplier supplier, Serde<K> keySerde, Serde<V> valueSerde) {
        Objects.requireNonNull(supplier, "supplier cannot be null");
        return new WindowStoreBuilder<K, V>(supplier, keySerde, valueSerde, Time.SYSTEM);
    }

    public static <K, V> StoreBuilder<KeyValueStore<K, V>> keyValueStoreBuilder(KeyValueBytesStoreSupplier supplier, Serde<K> keySerde, Serde<V> valueSerde) {
        Objects.requireNonNull(supplier, "supplier cannot be null");
        return new KeyValueStoreBuilder<K, V>(supplier, keySerde, valueSerde, Time.SYSTEM);
    }

    public static <K, V> StoreBuilder<SessionStore<K, V>> sessionStoreBuilder(SessionBytesStoreSupplier supplier, Serde<K> keySerde, Serde<V> valueSerde) {
        Objects.requireNonNull(supplier, "supplier cannot be null");
        return new SessionStoreBuilder<K, V>(supplier, keySerde, valueSerde, Time.SYSTEM);
    }

    @Deprecated
    public static StoreFactory create(final String name) {
        return new StoreFactory(){

            @Override
            public <K> ValueFactory<K> withKeys(final Serde<K> keySerde) {
                return new ValueFactory<K>(){

                    @Override
                    public <V> KeyValueFactory<K, V> withValues(final Serde<V> valueSerde) {
                        return new KeyValueFactory<K, V>(){

                            @Override
                            public InMemoryKeyValueFactory<K, V> inMemory() {
                                return new InMemoryKeyValueFactory<K, V>(){
                                    private int capacity = Integer.MAX_VALUE;
                                    private final Map<String, String> logConfig = new HashMap<String, String>();
                                    private boolean logged = true;

                                    @Override
                                    public InMemoryKeyValueFactory<K, V> maxEntries(int capacity) {
                                        if (capacity < 1) {
                                            throw new IllegalArgumentException("The capacity must be positive");
                                        }
                                        this.capacity = capacity;
                                        return this;
                                    }

                                    @Override
                                    public InMemoryKeyValueFactory<K, V> enableLogging(Map<String, String> config) {
                                        this.logged = true;
                                        this.logConfig.putAll(config);
                                        return this;
                                    }

                                    @Override
                                    public InMemoryKeyValueFactory<K, V> disableLogging() {
                                        this.logged = false;
                                        this.logConfig.clear();
                                        return this;
                                    }

                                    @Override
                                    public StateStoreSupplier build() {
                                        log.trace("Defining InMemory Store name={} capacity={} logged={}", new Object[]{name, this.capacity, this.logged});
                                        if (this.capacity < Integer.MAX_VALUE) {
                                            return new InMemoryLRUCacheStoreSupplier(name, this.capacity, keySerde, valueSerde, this.logged, this.logConfig);
                                        }
                                        return new InMemoryKeyValueStoreSupplier(name, keySerde, valueSerde, this.logged, this.logConfig);
                                    }
                                };
                            }

                            @Override
                            public PersistentKeyValueFactory<K, V> persistent() {
                                return new PersistentKeyValueFactory<K, V>(){
                                    boolean cachingEnabled;
                                    private long windowSize;
                                    private final Map<String, String> logConfig = new HashMap<String, String>();
                                    private int numSegments = 0;
                                    private long retentionPeriod = 0L;
                                    private boolean retainDuplicates = false;
                                    private boolean sessionWindows;
                                    private boolean logged = true;

                                    @Override
                                    public PersistentKeyValueFactory<K, V> windowed(long windowSize, long retentionPeriod, int numSegments, boolean retainDuplicates) {
                                        if (numSegments < 2) {
                                            throw new IllegalArgumentException("numSegments must be >= 2");
                                        }
                                        this.windowSize = windowSize;
                                        this.numSegments = numSegments;
                                        this.retentionPeriod = retentionPeriod;
                                        this.retainDuplicates = retainDuplicates;
                                        this.sessionWindows = false;
                                        return this;
                                    }

                                    @Override
                                    public PersistentKeyValueFactory<K, V> sessionWindowed(long retentionPeriod) {
                                        this.sessionWindows = true;
                                        this.retentionPeriod = retentionPeriod;
                                        return this;
                                    }

                                    @Override
                                    public PersistentKeyValueFactory<K, V> enableLogging(Map<String, String> config) {
                                        this.logged = true;
                                        this.logConfig.putAll(config);
                                        return this;
                                    }

                                    @Override
                                    public PersistentKeyValueFactory<K, V> disableLogging() {
                                        this.logged = false;
                                        this.logConfig.clear();
                                        return this;
                                    }

                                    @Override
                                    public PersistentKeyValueFactory<K, V> enableCaching() {
                                        this.cachingEnabled = true;
                                        return this;
                                    }

                                    @Override
                                    public StateStoreSupplier build() {
                                        log.trace("Defining RocksDb Store name={} numSegments={} logged={}", new Object[]{name, this.numSegments, this.logged});
                                        if (this.sessionWindows) {
                                            return new RocksDBSessionStoreSupplier(name, this.retentionPeriod, keySerde, valueSerde, this.logged, this.logConfig, this.cachingEnabled);
                                        }
                                        if (this.numSegments > 0) {
                                            return new RocksDBWindowStoreSupplier(name, this.retentionPeriod, this.numSegments, this.retainDuplicates, keySerde, valueSerde, this.windowSize, this.logged, this.logConfig, this.cachingEnabled);
                                        }
                                        return new RocksDBKeyValueStoreSupplier(name, keySerde, valueSerde, this.logged, this.logConfig, this.cachingEnabled);
                                    }
                                };
                            }
                        };
                    }
                };
            }
        };
    }

    @Deprecated
    public static interface PersistentKeyValueFactory<K, V> {
        public PersistentKeyValueFactory<K, V> windowed(long var1, long var3, int var5, boolean var6);

        public PersistentKeyValueFactory<K, V> sessionWindowed(long var1);

        public PersistentKeyValueFactory<K, V> enableLogging(Map<String, String> var1);

        public PersistentKeyValueFactory<K, V> disableLogging();

        public PersistentKeyValueFactory<K, V> enableCaching();

        public StateStoreSupplier build();
    }

    @Deprecated
    public static interface InMemoryKeyValueFactory<K, V> {
        public InMemoryKeyValueFactory<K, V> maxEntries(int var1);

        public InMemoryKeyValueFactory<K, V> enableLogging(Map<String, String> var1);

        public InMemoryKeyValueFactory<K, V> disableLogging();

        public StateStoreSupplier build();
    }

    public static interface KeyValueFactory<K, V> {
        public InMemoryKeyValueFactory<K, V> inMemory();

        public PersistentKeyValueFactory<K, V> persistent();
    }

    public static abstract class ValueFactory<K> {
        public KeyValueFactory<K, String> withStringValues() {
            return this.withValues(Serdes.String());
        }

        public KeyValueFactory<K, Integer> withIntegerValues() {
            return this.withValues(Serdes.Integer());
        }

        public KeyValueFactory<K, Long> withLongValues() {
            return this.withValues(Serdes.Long());
        }

        public KeyValueFactory<K, Double> withDoubleValues() {
            return this.withValues(Serdes.Double());
        }

        public KeyValueFactory<K, ByteBuffer> withByteBufferValues() {
            return this.withValues(Serdes.ByteBuffer());
        }

        public KeyValueFactory<K, byte[]> withByteArrayValues() {
            return this.withValues(Serdes.ByteArray());
        }

        public <V> KeyValueFactory<K, V> withValues(Class<V> valueClass) {
            return this.withValues(Serdes.serdeFrom(valueClass));
        }

        public abstract <V> KeyValueFactory<K, V> withValues(Serde<V> var1);
    }

    public static abstract class StoreFactory {
        public ValueFactory<String> withStringKeys() {
            return this.withKeys(Serdes.String());
        }

        public ValueFactory<Integer> withIntegerKeys() {
            return this.withKeys(Serdes.Integer());
        }

        public ValueFactory<Long> withLongKeys() {
            return this.withKeys(Serdes.Long());
        }

        public ValueFactory<Double> withDoubleKeys() {
            return this.withKeys(Serdes.Double());
        }

        public ValueFactory<ByteBuffer> withByteBufferKeys() {
            return this.withKeys(Serdes.ByteBuffer());
        }

        public ValueFactory<byte[]> withByteArrayKeys() {
            return this.withKeys(Serdes.ByteArray());
        }

        public <K> ValueFactory<K> withKeys(Class<K> keyClass) {
            return this.withKeys(Serdes.serdeFrom(keyClass));
        }

        public abstract <K> ValueFactory<K> withKeys(Serde<K> var1);
    }
}

