/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateRestoreCallback;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.InMemoryKeyValueLoggedStore;

public class MemoryLRUCache<K, V>
implements KeyValueStore<K, V> {
    private final Serde<K> keySerde;
    private final Serde<V> valueSerde;
    private final String name;
    protected final Map<K, V> map;
    private StateSerdes<K, V> serdes;
    private boolean restoring = false;
    private volatile boolean open = true;
    private EldestEntryRemovalListener<K, V> listener;

    MemoryLRUCache(String name, final int maxCacheSize, Serde<K> keySerde, Serde<V> valueSerde) {
        this.name = name;
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
        this.map = new LinkedHashMap<K, V>(maxCacheSize + 1, 1.01f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                boolean evict;
                boolean bl = evict = super.size() > maxCacheSize;
                if (evict && !MemoryLRUCache.this.restoring && MemoryLRUCache.this.listener != null) {
                    MemoryLRUCache.this.listener.apply(eldest.getKey(), eldest.getValue());
                }
                return evict;
            }
        };
    }

    KeyValueStore<K, V> enableLogging() {
        return new InMemoryKeyValueLoggedStore<K, V>(this, this.keySerde, this.valueSerde);
    }

    MemoryLRUCache<K, V> whenEldestRemoved(EldestEntryRemovalListener<K, V> listener) {
        this.listener = listener;
        return this;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        this.serdes = new StateSerdes(ProcessorStateManager.storeChangelogTopic(context.applicationId(), this.name), (Serde<?>)(this.keySerde == null ? context.keySerde() : this.keySerde), (Serde<?>)(this.valueSerde == null ? context.valueSerde() : this.valueSerde));
        context.register(root, false, new StateRestoreCallback(){

            @Override
            public void restore(byte[] key, byte[] value) {
                MemoryLRUCache.this.restoring = true;
                if (value == null) {
                    MemoryLRUCache.this.delete(MemoryLRUCache.this.serdes.keyFrom(key));
                } else {
                    MemoryLRUCache.this.put(MemoryLRUCache.this.serdes.keyFrom(key), MemoryLRUCache.this.serdes.valueFrom(value));
                }
                MemoryLRUCache.this.restoring = false;
            }
        });
    }

    @Override
    public boolean persistent() {
        return false;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public synchronized V get(K key) {
        Objects.requireNonNull(key);
        return this.map.get(key);
    }

    @Override
    public synchronized void put(K key, V value) {
        Objects.requireNonNull(key);
        if (value == null) {
            this.map.remove(key);
        } else {
            this.map.put(key, value);
        }
    }

    @Override
    public synchronized V putIfAbsent(K key, V value) {
        Objects.requireNonNull(key);
        V originalValue = this.get(key);
        if (originalValue == null) {
            this.put(key, value);
        }
        return originalValue;
    }

    @Override
    public void putAll(List<KeyValue<K, V>> entries) {
        for (KeyValue<K, V> entry : entries) {
            this.put(entry.key, entry.value);
        }
    }

    @Override
    public synchronized V delete(K key) {
        Objects.requireNonNull(key);
        return this.map.remove(key);
    }

    @Override
    public KeyValueIterator<K, V> range(K from, K to) {
        throw new UnsupportedOperationException("MemoryLRUCache does not support range() function.");
    }

    @Override
    public KeyValueIterator<K, V> all() {
        throw new UnsupportedOperationException("MemoryLRUCache does not support all() function.");
    }

    @Override
    public long approximateNumEntries() {
        return this.map.size();
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this.open = false;
    }

    public int size() {
        return this.map.size();
    }

    public static interface EldestEntryRemovalListener<K, V> {
        public void apply(K var1, V var2);
    }
}

