/*****************************************************************************
 * state.h: DVD Video Manager library, functions to access private members
 * of dvdplay_ptr.
 *****************************************************************************
 * Copyright (C) 2002 VideoLAN
 * $Id: state.h,v 1.3 2003/01/29 20:55:26 sam Exp $
 *
 * Authors: Stphane Borel <stef@via.ecp.fr>
 *
 * Adapted from Ogle - A video player
 * Copyright (C) 2000, 2001 Hkan Hjort
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

#ifndef _DVDPLAY_STATE_H
#define _DVDPLAY_STATE_H  1

#ifdef __cplusplus
extern "C" {
#endif

/*****************************************************************************
 * Exported prototypes
 *****************************************************************************/

extern int           dvdplay_state_block ( dvdplay_ptr );
extern int           dvdplay_state_cell  ( dvdplay_ptr );
extern int           dvdplay_state_pg    ( dvdplay_ptr );
extern int           dvdplay_state_pgc   ( dvdplay_ptr );
extern int           dvdplay_state_vts   ( dvdplay_ptr );
extern off_t         dvdplay_position    ( dvdplay_ptr );
//extern pgc_t *       dvdplay_state_pgc_t ( dvdplay_ptr );
//extern dvd_reader_t* dvdplay_dvdread     ( dvdplay_ptr );
//extern dvd_file_t *  dvdplay_file        ( dvdplay_ptr );
//extern ifo_handle_t* dvdplay_vmgi        ( dvdplay_ptr );
//extern ifo_handle_t* dvdplay_vtsi        ( dvdplay_ptr );

#ifdef __cplusplus
}
#endif

#endif /* <dvdplay/state.h> */
