/* example3.c -- This program draws a vector field for a flow representing
 * rigid body rotation.
 */
#include <stdio.h>
#include <math.h>
#include "pgraf.h"
#define MAX 15
float x,y,vx[MAX][MAX],vy[MAX][MAX];
int ix,iy;

main()
{
/* define flow field */
  for (ix = 0; ix < MAX; ix++) {
    for (iy = 0; iy < MAX; iy++) {
      x = ix - MAX/2;
      y = iy - MAX/2;
      vx[ix][iy] = -y;
      vy[ix][iy] = x;
    }
  }
/* graphics preliminaries */
  gopen();
  gclear();
  window(1,3.,13.,0.,10.);
/* make some axes */
  axes(1,-7.,7.,5,"x",-7.,7.,5,"y");
/* since largest velocity component is about 8, make grid-interval-length
   arrows equal to 10 */
  vector(1,MAX,MAX,10.,10.,vx,vy);
/* finish up */
  gpause();
  gclose();
}
