/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import{LitElement as y,html as D}from"lit";import{customElement as g,query as N}from"lit/decorators.js";import"@typo3/backend/element/icon-element.js";import{SeverityEnum as T}from"@typo3/backend/enum/severity.js";import"@typo3/backend/tree/tree-toolbar.js";import{TreeNodePositionEnum as d}from"@typo3/backend/tree/tree-node.js";import{FileStorageTree as E}from"@typo3/backend/tree/file-storage-tree.js";import{TreeModuleState as R}from"@typo3/backend/tree/tree-module-state.js";import I from"@typo3/backend/context-menu.js";import C from"@typo3/backend/notification.js";import{ModuleStateStorage as O}from"@typo3/backend/storage/module-state-storage.js";import{ModuleUtility as F}from"@typo3/backend/module.js";import{FileListDragDropEvent as b}from"@typo3/filelist/file-list-dragdrop.js";import{Resource as U}from"@typo3/backend/resource/resource.js";import{DataTransferTypes as p}from"@typo3/backend/enum/data-transfer-types.js";var m=function(l,e,t,r){var o=arguments.length,n=o<3?e:r===null?r=Object.getOwnPropertyDescriptor(e,t):r,i;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")n=Reflect.decorate(l,e,t,r);else for(var s=l.length-1;s>=0;s--)(i=l[s])&&(n=(o<3?i(n):o>3?i(e,t,n):i(e,t))||n);return o>3&&n&&Object.defineProperty(e,t,n),n};const w="typo3-backend-navigation-component-filestoragetree";let h=class extends E{constructor(){super(...arguments),this.allowNodeDrag=!0}handleNodeMove(e,t,r){if(!this.isDropAllowed(t,e))return;const o=this.getDropCommandDetails(t,e,r);if(o===null)return;const n=f.fromNodePositionOptions(o),i=n.getConflictingOperationsForTreeNode(o.target);if(i.length>0){i.forEach(s=>{C.showMessage(TYPO3.lang["drop.conflict"],TYPO3.lang["mess.drop.conflict"].replace("%s",s.resource.name).replace("%s",decodeURIComponent(o.target.identifier)),T.error)});return}this.initiateDropAction(n)}createDataTransferItemsFromNode(e){return[{type:p.treenode,data:this.getNodeTreeIdentifier(e)},{type:p.falResources,data:JSON.stringify([c.fromTreeNode(e)])}]}handleNodeDragOver(e){if(super.handleNodeDragOver(e))return!0;if(e.dataTransfer.types.includes(p.falResources)){const t=this.getNodeFromDragEvent(e);return t===null?!1:(this.cleanDrag(),this.getElementFromNode(t).classList.add("node-hover"),t.hasChildren&&!t.__expanded?this.openNodeTimeout.targetNode!=t&&(this.openNodeTimeout.targetNode=t,clearTimeout(this.openNodeTimeout.timeout),this.openNodeTimeout.timeout=setTimeout(()=>{this.showChildren(this.openNodeTimeout.targetNode),this.openNodeTimeout.targetNode=null,this.openNodeTimeout.timeout=null},1e3)):(clearTimeout(this.openNodeTimeout.timeout),this.openNodeTimeout.targetNode=null,this.openNodeTimeout.timeout=null),e.preventDefault(),!0)}return!1}getTooltipDescription(e){return decodeURIComponent(e.identifier)}handleNodeDrop(e){if(super.handleNodeDrop(e))return!0;if(e.dataTransfer.types.includes(p.falResources)){const t=this.getNodeFromDragEvent(e);if(t===null)return!1;if(t){const r=c.fromTreeNode(t),o=f.fromDataTransfer(e.dataTransfer,r),n=o.getConflictingOperationsForTreeNode(t);return n.length>0?(n.forEach(i=>{C.showMessage(TYPO3.lang["drop.conflict"],TYPO3.lang["mess.drop.conflict"].replace("%s",i.resource.name).replace("%s",decodeURIComponent(t.identifier)),T.error)}),!1):(e.preventDefault(),this.initiateDropAction(o),!0)}}return!1}getDropCommandDetails(e,t,r){const o=this.nodes,n=t.identifier;let i=e;if(n===i.identifier)return null;if(r===d.BEFORE){const s=o.indexOf(e),a=this.setNodePositionAndTarget(s);if(a===null)return null;r=a.position,i=a.target}return{node:t,identifier:n,target:i,position:r}}setNodePositionAndTarget(e){const t=this.nodes,o=t[e].depth;e>0&&e--;const i=t[e].depth,s=this.nodes[e];if(i===o)return{position:d.AFTER,target:s};if(i<o)return{position:d.INSIDE,target:s};for(let a=e;a>=0;a--){if(t[a].depth===o)return{position:d.AFTER,target:this.nodes[a]};if(t[a].depth<o)return{position:d.AFTER,target:t[a]}}return null}isDropAllowed(e,t){return!(e===t||!this.isOverRoot)}initiateDropAction(e){const t={action:"transfer",resources:e.getResources(),target:e.target};top.document.dispatchEvent(new CustomEvent(b.transfer,{detail:t}))}};h=m([g("typo3-backend-navigation-component-filestorage-tree")],h);let u=class extends R(y){constructor(){super(...arguments),this.moduleStateType="media",this.refresh=()=>{this.tree.refreshOrFilterTree()},this.selectFirstNode=()=>{const e=this.tree.nodes[0];e&&this.tree.selectNode(e,!0)},this.loadContent=e=>{const t=e.detail.node;if(!t?.checked||(O.updateWithTreeIdentifier("media",decodeURIComponent(t.identifier),decodeURIComponent(t.__treeIdentifier)),e.detail.propagate===!1))return;const r=top.TYPO3.ModuleMenu.App;let o=F.getFromName(r.getCurrentModule()).link;o+=o.includes("?")?"&":"?",top.TYPO3.Backend.ContentContainer.setUrl(o+"id="+t.identifier)},this.showContextMenu=e=>{const t=e.detail.node;t&&I.show(t.recordType,decodeURIComponent(t.identifier),"tree","","",this.tree.getElementFromNode(t),e.detail.originalEvent)}}connectedCallback(){super.connectedCallback(),document.addEventListener("typo3:filestoragetree:refresh",this.refresh),document.addEventListener("typo3:filestoragetree:selectFirstNode",this.selectFirstNode)}disconnectedCallback(){document.removeEventListener("typo3:filestoragetree:refresh",this.refresh),document.removeEventListener("typo3:filestoragetree:selectFirstNode",this.selectFirstNode),super.disconnectedCallback()}createRenderRoot(){return this}render(){const e={dataUrl:top.TYPO3.settings.ajaxUrls.filestorage_tree_data,rootlineUrl:top.TYPO3.settings.ajaxUrls.filestorage_tree_rootline,filterUrl:top.TYPO3.settings.ajaxUrls.filestorage_tree_filter,showIcons:!0};return D`<div id=typo3-filestoragetree class=tree><typo3-backend-tree-toolbar .tree=${this.tree} id=filestoragetree-toolbar></typo3-backend-tree-toolbar><div class=navigation-tree-container><typo3-backend-navigation-component-filestorage-tree id=typo3-filestoragetree-tree class=tree-wrapper .setup=${e} @typo3:tree:node-selected=${this.loadContent} @typo3:tree:node-context=${this.showContextMenu} @typo3:tree:nodes-prepared=${this.selectActiveNodeInLoadedNodes} @tree:initialized=${this.fetchActiveNodeIfMissing}></typo3-backend-navigation-component-filestorage-tree></div></div>`}firstUpdated(){this.toolbar.tree=this.tree}transformModuleStateIdentifierToNodeIdentifier(e){return encodeURIComponent(e)}transformNodeIdentifierToModuleStateIdentifier(e){return decodeURIComponent(e)}};m([N(".tree-wrapper")],u.prototype,"tree",void 0),m([N("typo3-backend-tree-toolbar")],u.prototype,"toolbar",void 0),u=m([g("typo3-backend-navigation-component-filestoragetree")],u);class v{constructor(e,t=d.INSIDE){this.resource=e,this.position=t}hasConflictWithTreeNode(e){return this.resource.type==="folder"&&(e.identifier===this.resource.identifier||e.__parents[0]==this.resource.identifier||e.__parents.includes(this.resource.identifier))}}class c extends U{static fromTreeNode(e){return new c(decodeURIComponent(e.resourceType),decodeURIComponent(e.identifier),decodeURIComponent(e.name))}}class f{constructor(e,t){this.operations=e,this.target=t}static fromDataTransfer(e,t){return f.fromArray(JSON.parse(e.getData(p.falResources)),t)}static fromArray(e,t){const r=[];for(const o of e)r.push(new v(o,d.INSIDE));return new f(r,t)}static fromNodePositionOptions(e){const t=c.fromTreeNode(e.node),r=c.fromTreeNode(e.target),o=[new v(t,e.position)];return new f(o,r)}getConflictingOperationsForTreeNode(e){return this.operations.filter(t=>t.hasConflictWithTreeNode(e))}getResources(){const e=[];return this.operations.forEach(t=>{e.push(t.resource)}),e}}export{h as EditableFileStorageTree,u as FileStorageTreeNavigationComponent,w as navigationComponentName};
