/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.unwrap.UnwrapDescriptor;
import com.intellij.codeInsight.unwrap.Unwrapper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UnwrapDescriptorBase
implements UnwrapDescriptor {
    private Unwrapper[] myUnwrappers;

    @NotNull
    public final Unwrapper[] getUnwrappers() {
        if (this.myUnwrappers == null) {
            this.myUnwrappers = this.createUnwrappers();
        }
        if (this.myUnwrappers == null) {
            UnwrapDescriptorBase.$$$reportNull$$$0(0);
        }
        return this.myUnwrappers;
    }

    @Override
    @NotNull
    public List<Pair<PsiElement, Unwrapper>> collectUnwrappers(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            UnwrapDescriptorBase.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            UnwrapDescriptorBase.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            UnwrapDescriptorBase.$$$reportNull$$$0(3);
        }
        ArrayList<Pair<PsiElement, Unwrapper>> result2 = new ArrayList<Pair<PsiElement, Unwrapper>>();
        HashSet<PsiElement> ignored = new HashSet<PsiElement>();
        for (PsiElement e = this.findTargetElement(editor, file2); e != null; e = e.getParent()) {
            for (Unwrapper u : this.getUnwrappers()) {
                if (!u.isApplicableTo(e) || ignored.contains(e)) continue;
                result2.add((Pair<PsiElement, Unwrapper>)Pair.create((Object)e, (Object)u));
                u.collectElementsToIgnore(e, ignored);
            }
        }
        ArrayList<Pair<PsiElement, Unwrapper>> arrayList = result2;
        if (arrayList == null) {
            UnwrapDescriptorBase.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    protected abstract Unwrapper[] createUnwrappers();

    @Nullable
    protected PsiElement findTargetElement(Editor editor, PsiFile file2) {
        PsiElement startElement;
        int offset = editor.getCaretModel().getOffset();
        PsiElement endElement = file2.findElementAt(offset);
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection() && selectionModel.getSelectionStart() < offset && (startElement = file2.findElementAt(selectionModel.getSelectionStart())) != null && startElement != endElement && startElement.getTextRange().getEndOffset() == offset) {
            return startElement;
        }
        return endElement;
    }

    @Override
    public boolean showOptionsDialog() {
        return true;
    }

    @Override
    public boolean shouldTryToRestoreCaretPosition() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/unwrap/UnwrapDescriptorBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnwrappers";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/unwrap/UnwrapDescriptorBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectUnwrappers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectUnwrappers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

