/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;

public class RegExReplacementBuilder {
    @NotNull
    private final Matcher myMatcher;
    private String myTemplate;
    private int myCursor;
    private StringBuilder myReplacement;
    private List<CaseConversionRegion> myConversionRegions;

    public RegExReplacementBuilder(@NotNull Matcher matcher) {
        if (matcher == null) {
            RegExReplacementBuilder.$$$reportNull$$$0(0);
        }
        this.myMatcher = matcher;
    }

    public String createReplacement(String template) {
        this.myTemplate = template;
        this.resetState();
        while (this.myCursor < this.myTemplate.length()) {
            char nextChar;
            if ((nextChar = this.myTemplate.charAt(this.myCursor++)) == '\\') {
                this.processEscapedChar();
                continue;
            }
            if (nextChar == '$') {
                this.processGroupValue();
                continue;
            }
            this.myReplacement.append(nextChar);
        }
        return this.generateResult();
    }

    private void resetState() {
        this.myCursor = 0;
        this.myReplacement = new StringBuilder();
        this.myConversionRegions = new ArrayList<CaseConversionRegion>();
    }

    private void processEscapedChar() {
        if (this.myCursor == this.myTemplate.length()) {
            throw new IllegalArgumentException("character to be escaped is missing");
        }
        char nextChar = this.myTemplate.charAt(this.myCursor++);
        switch (nextChar) {
            case 'n': {
                this.myReplacement.append('\n');
                break;
            }
            case 'r': {
                this.myReplacement.append('\r');
                break;
            }
            case 'b': {
                this.myReplacement.append('\b');
                break;
            }
            case 't': {
                this.myReplacement.append('\t');
                break;
            }
            case 'f': {
                this.myReplacement.append('\f');
                break;
            }
            case 'x': {
                if (this.myCursor + 4 > this.myTemplate.length()) break;
                try {
                    int code = Integer.parseInt(this.myTemplate.substring(this.myCursor, this.myCursor + 4), 16);
                    this.myCursor += 4;
                    this.myReplacement.append((char)code);
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case 'l': {
                this.startConversionForCharacter(false);
                break;
            }
            case 'u': {
                this.startConversionForCharacter(true);
                break;
            }
            case 'L': {
                this.startConversionForRegion(false);
                break;
            }
            case 'U': {
                this.startConversionForRegion(true);
                break;
            }
            case 'E': {
                this.resetConversionState();
                break;
            }
            default: {
                this.myReplacement.append(nextChar);
            }
        }
    }

    private void processGroupValue() {
        String group;
        char nextChar;
        if (this.myCursor == this.myTemplate.length()) {
            throw new IllegalArgumentException("Illegal group reference: group index is missing");
        }
        if ((nextChar = this.myTemplate.charAt(this.myCursor++)) == '{') {
            StringBuilder gsb = new StringBuilder();
            while (this.myCursor < this.myTemplate.length() && (RegExReplacementBuilder.isLatinLetter(nextChar = this.myTemplate.charAt(this.myCursor)) || RegExReplacementBuilder.isDigit(nextChar))) {
                gsb.append(nextChar);
                ++this.myCursor;
            }
            if (gsb.length() == 0) {
                throw new IllegalArgumentException("named capturing group has 0 length name");
            }
            if (nextChar != '}') {
                throw new IllegalArgumentException("named capturing group is missing trailing '}'");
            }
            String gname = gsb.toString();
            if (RegExReplacementBuilder.isDigit(gname.charAt(0))) {
                throw new IllegalArgumentException("capturing group name {" + gname + "} starts with digit character");
            }
            ++this.myCursor;
            group = this.myMatcher.group(gname);
        } else {
            int nextDigit;
            int refNum = nextChar - 48;
            if (refNum < 0 || refNum > 9) {
                throw new IllegalArgumentException("Illegal group reference");
            }
            while (this.myCursor < this.myTemplate.length() && (nextDigit = this.myTemplate.charAt(this.myCursor) - 48) >= 0 && nextDigit <= 9) {
                int newRefNum = refNum * 10 + nextDigit;
                if (this.myMatcher.groupCount() < newRefNum) break;
                refNum = newRefNum;
                ++this.myCursor;
            }
            group = this.myMatcher.group(refNum);
        }
        if (group != null) {
            this.myReplacement.append(group);
        }
    }

    private String generateResult() {
        StringBuilder result2;
        if (this.myConversionRegions.isEmpty()) {
            result2 = this.myReplacement;
        } else {
            CaseConversionRegion lastRegion = this.myConversionRegions.get(this.myConversionRegions.size() - 1);
            if (lastRegion.end < 0 || lastRegion.end > this.myReplacement.length()) {
                lastRegion.end = this.myReplacement.length();
            }
            result2 = new StringBuilder();
            int currentOffset = 0;
            for (CaseConversionRegion conversionRegion : this.myConversionRegions) {
                result2.append(this.myReplacement, currentOffset, conversionRegion.start);
                String region = this.myReplacement.substring(conversionRegion.start, conversionRegion.end);
                result2.append(conversionRegion.toUpperCase ? region.toUpperCase(Locale.getDefault()) : region.toLowerCase(Locale.getDefault()));
                currentOffset = conversionRegion.end;
            }
            result2.append(this.myReplacement, currentOffset, this.myReplacement.length());
        }
        return result2.toString();
    }

    private void startConversionForCharacter(boolean toUpperCase) {
        CaseConversionRegion lastRegion;
        int currentOffset = this.myReplacement.length();
        CaseConversionRegion caseConversionRegion = lastRegion = this.myConversionRegions.isEmpty() ? null : this.myConversionRegions.get(this.myConversionRegions.size() - 1);
        if (lastRegion == null || lastRegion.end >= 0 && lastRegion.end <= currentOffset) {
            this.myConversionRegions.add(new CaseConversionRegion(currentOffset, currentOffset + 1, toUpperCase));
        }
    }

    private void startConversionForRegion(boolean toUpperCase) {
        CaseConversionRegion lastRegion;
        int currentOffset = this.myReplacement.length();
        CaseConversionRegion caseConversionRegion = lastRegion = this.myConversionRegions.isEmpty() ? null : this.myConversionRegions.get(this.myConversionRegions.size() - 1);
        if (lastRegion == null) {
            this.myConversionRegions.add(new CaseConversionRegion(currentOffset, -1, toUpperCase));
        } else if (lastRegion.start == currentOffset) {
            lastRegion.end = -1;
            lastRegion.toUpperCase = toUpperCase;
        } else {
            if (lastRegion.end == -1) {
                if (lastRegion.toUpperCase == toUpperCase) {
                    return;
                }
                lastRegion.end = currentOffset;
            }
            this.myConversionRegions.add(new CaseConversionRegion(currentOffset, -1, toUpperCase));
        }
    }

    private void resetConversionState() {
        if (!this.myConversionRegions.isEmpty()) {
            int currentOffset = this.myReplacement.length();
            int lastIndex = this.myConversionRegions.size() - 1;
            CaseConversionRegion lastRegion = this.myConversionRegions.get(lastIndex);
            if (lastRegion.start >= currentOffset) {
                this.myConversionRegions.remove(lastIndex);
            } else if (lastRegion.end == -1) {
                lastRegion.end = currentOffset;
            }
        }
    }

    private static boolean isLatinLetter(int ch) {
        return (ch - 97 | 122 - ch) >= 0 || (ch - 65 | 90 - ch) >= 0;
    }

    private static boolean isDigit(int ch) {
        return (ch - 48 | 57 - ch) >= 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/find/impl/RegExReplacementBuilder", "<init>"));
    }

    private static class CaseConversionRegion {
        private final int start;
        private int end;
        private boolean toUpperCase;

        private CaseConversionRegion(int start2, int end, boolean toUpperCase) {
            this.start = start2;
            this.end = end;
            this.toUpperCase = toUpperCase;
        }
    }
}

