/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl;

import com.intellij.facet.FacetType;
import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.FacetBasedFrameworkDetector;
import com.intellij.framework.detection.FrameworkDetector;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworkDetectionUtil {
    private FrameworkDetectionUtil() {
    }

    @Nullable
    public static FrameworkType findFrameworkTypeForFacetDetector(@NotNull FacetType<?, ?> facetType) {
        if (facetType == null) {
            FrameworkDetectionUtil.$$$reportNull$$$0(0);
        }
        for (FrameworkDetector detector : (FrameworkDetector[])FrameworkDetector.EP_NAME.getExtensions()) {
            if (!(detector instanceof FacetBasedFrameworkDetector) || !((FacetBasedFrameworkDetector)detector).getFacetType().equals(facetType)) continue;
            return detector.getFrameworkType();
        }
        return null;
    }

    public static List<? extends DetectedFrameworkDescription> removeDisabled(List<? extends DetectedFrameworkDescription> descriptions) {
        return FrameworkDetectionUtil.removeDisabled(descriptions, Collections.emptyList());
    }

    public static List<DetectedFrameworkDescription> getDisabledDescriptions(@NotNull List<? extends DetectedFrameworkDescription> currentDescriptions, @NotNull List<? extends DetectedFrameworkDescription> otherDescriptions) {
        if (currentDescriptions == null) {
            FrameworkDetectionUtil.$$$reportNull$$$0(1);
        }
        if (otherDescriptions == null) {
            FrameworkDetectionUtil.$$$reportNull$$$0(2);
        }
        return FrameworkDetectionUtil.doGetDisabledDescriptions(currentDescriptions, ContainerUtil.concat(currentDescriptions, otherDescriptions));
    }

    private static List<DetectedFrameworkDescription> doGetDisabledDescriptions(@NotNull List<? extends DetectedFrameworkDescription> currentDescriptions, @NotNull List<? extends DetectedFrameworkDescription> allDescriptions) {
        if (currentDescriptions == null) {
            FrameworkDetectionUtil.$$$reportNull$$$0(3);
        }
        if (allDescriptions == null) {
            FrameworkDetectionUtil.$$$reportNull$$$0(4);
        }
        ArrayList<DetectedFrameworkDescription> disabled = new ArrayList<DetectedFrameworkDescription>();
        for (DetectedFrameworkDescription detectedFrameworkDescription : currentDescriptions) {
            if (detectedFrameworkDescription.canSetupFramework(allDescriptions)) continue;
            disabled.add(detectedFrameworkDescription);
        }
        if (!disabled.isEmpty()) {
            ArrayList<? extends DetectedFrameworkDescription> remaining = new ArrayList<DetectedFrameworkDescription>(currentDescriptions);
            remaining.removeAll(disabled);
            disabled.addAll(FrameworkDetectionUtil.doGetDisabledDescriptions(remaining, allDescriptions));
        }
        return disabled;
    }

    public static List<? extends DetectedFrameworkDescription> removeDisabled(@NotNull List<? extends DetectedFrameworkDescription> currentDescriptions, @NotNull List<? extends DetectedFrameworkDescription> otherDescriptions) {
        List<DetectedFrameworkDescription> disabled;
        if (currentDescriptions == null) {
            FrameworkDetectionUtil.$$$reportNull$$$0(5);
        }
        if (otherDescriptions == null) {
            FrameworkDetectionUtil.$$$reportNull$$$0(6);
        }
        if ((disabled = FrameworkDetectionUtil.getDisabledDescriptions(currentDescriptions, otherDescriptions)).isEmpty()) {
            return currentDescriptions;
        }
        ArrayList<? extends DetectedFrameworkDescription> descriptions = new ArrayList<DetectedFrameworkDescription>(currentDescriptions);
        descriptions.removeAll(disabled);
        return descriptions;
    }

    public static void setupFrameworks(List<? extends DetectedFrameworkDescription> descriptions, ModifiableModelsProvider modelsProvider, ModulesProvider modulesProvider) {
        WriteAction.run(() -> {
            ArrayList<DetectedFrameworkDescription> sortedDescriptions = new ArrayList<DetectedFrameworkDescription>();
            for (DetectedFrameworkDescription description : descriptions) {
                if (description.getDetector().getUnderlyingFrameworkType() != null) continue;
                sortedDescriptions.add(description);
            }
            for (DetectedFrameworkDescription description : descriptions) {
                if (description.getDetector().getUnderlyingFrameworkType() == null) continue;
                sortedDescriptions.add(description);
            }
            for (DetectedFrameworkDescription description : sortedDescriptions) {
                description.setupFramework(modelsProvider, modulesProvider);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetType";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentDescriptions";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherDescriptions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allDescriptions";
                break;
            }
        }
        objectArray2[1] = "com/intellij/framework/detection/impl/FrameworkDetectionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findFrameworkTypeForFacetDetector";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getDisabledDescriptions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doGetDisabledDescriptions";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "removeDisabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

