/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import java.util.List;
import java.util.Map;

public class ModuleGroupUtil {
    private ModuleGroupUtil() {
    }

    public static <T> T buildModuleGroupPath(ModuleGroup group, T parentNode, Map<ModuleGroup, T> map, Consumer<? super ParentChildRelation<T>> insertNode, Function<? super ModuleGroup, ? extends T> createNewNode) {
        List<String> groupPath = group.getGroupPathList();
        for (int i = 0; i < groupPath.size(); ++i) {
            ModuleGroup moduleGroup = new ModuleGroup(groupPath.subList(0, i + 1));
            Object moduleGroupNode = map.get(moduleGroup);
            if (moduleGroupNode == null) {
                moduleGroupNode = createNewNode.fun((Object)moduleGroup);
                map.put(moduleGroup, moduleGroupNode);
                insertNode.consume(new ParentChildRelation<T>(parentNode, moduleGroupNode));
            }
            parentNode = moduleGroupNode;
        }
        return parentNode;
    }

    public static <T> T updateModuleGroupPath(ModuleGroup group, T parentNode, Function<? super ModuleGroup, ? extends T> needToCreateNode, Consumer<? super ParentChildRelation<T>> insertNode, Function<? super ModuleGroup, ? extends T> createNewNode) {
        List<String> groupPath = group.getGroupPathList();
        for (int i = 0; i < groupPath.size(); ++i) {
            ModuleGroup moduleGroup = new ModuleGroup(groupPath.subList(0, i + 1));
            Object moduleGroupNode = needToCreateNode.fun((Object)moduleGroup);
            if (moduleGroupNode == null) {
                moduleGroupNode = createNewNode.fun((Object)moduleGroup);
                insertNode.consume(new ParentChildRelation<Object>(parentNode, moduleGroupNode));
            }
            parentNode = moduleGroupNode;
        }
        return parentNode;
    }

    public static class ParentChildRelation<T> {
        private final T myParent;
        private final T myChild;

        ParentChildRelation(T parent, T child2) {
            this.myParent = parent;
            this.myChild = child2;
        }

        public T getParent() {
            return this.myParent;
        }

        public T getChild() {
            return this.myChild;
        }
    }
}

