/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.connection.statements;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.audit.AdvancedAuditService;
import com.intellij.database.dataSource.connection.statements.CallableStatementData;
import com.intellij.database.dataSource.connection.statements.ClosableResultsProducer;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.ExecutionResult;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.SmartStatementMark;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.SmartStatementsUtil;
import com.intellij.database.dataSource.connection.statements.StagedException;
import com.intellij.database.dataSource.connection.statements.StatementHolder;
import com.intellij.database.dataSource.connection.statements.UniversalResultsProducerKt;
import com.intellij.database.util.JdbcUtil;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0005/0123B3\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001dH\u0002J\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020 H\u0016J\b\u0010\"\u001a\u00020 H\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u0010H\u0016J\b\u0010&\u001a\u00020\u001bH\u0002J\b\u0010'\u001a\u00020\u001bH\u0002J!\u0010(\u001a\u0002H)\"\u0004\b\u0001\u0010)2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H)0+H\u0016\u00a2\u0006\u0002\u0010,J\u0016\u0010-\u001a\u00020 2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020 0+H\u0016J\b\u0010.\u001a\u00020\u001bH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer;", "T", "Ljava/sql/Statement;", "Lcom/intellij/database/dataSource/connection/statements/ClosableResultsProducer;", "statement", "Lcom/intellij/database/dataSource/connection/statements/StatementHolder$CloseableRef;", "mark", "Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;", "configuration", "Lcom/intellij/database/dataSource/connection/statements/Configuration;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "result", "Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;", "(Lcom/intellij/database/dataSource/connection/statements/StatementHolder$CloseableRef;Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;Lcom/intellij/database/dataSource/connection/statements/Configuration;Lcom/intellij/database/dataSource/DatabaseConnection;Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;)V", "currentResultSetIndex", "", "currentResults", "Ljava/sql/ResultSet;", "currentResultsIndex", "parameters", "", "Lcom/intellij/database/dataSource/connection/statements/CallableStatementData$OutParameter;", "source", "Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Source;", "updateCount", "advance", "", "advanceContentAndSource", "Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Verdict;", "advanceCurrentSourceContent", "clearCurrentResults", "", "close", "closeResultSet", "getParameterValue", "", "index", "hasResults", "hasUpdateCount", "processCurrent", "R", "processor", "Lcom/intellij/database/dataSource/connection/statements/ResultsProducer$Processor;", "(Lcom/intellij/database/dataSource/connection/statements/ResultsProducer$Processor;)Ljava/lang/Object;", "processRemaining", "requestedResultsReached", "ParametersSource", "ResultSource", "Source", "StatementSource", "Verdict", "intellij.database.impl"})
public final class UniversalResultsProducer<T extends Statement>
implements ClosableResultsProducer {
    private ResultSet currentResults;
    private int updateCount;
    private List<CallableStatementData.OutParameter> parameters;
    private int currentResultSetIndex;
    private int currentResultsIndex;
    private Source source;
    private final StatementHolder.CloseableRef<T> statement;
    private final SmartStatementMark mark;
    private final Configuration configuration;
    private final DatabaseConnection connection;

    @Override
    public void processRemaining(@NotNull ResultsProducer.Processor<Unit> processor) {
        Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
        while (this.advance()) {
            this.processCurrent((ResultsProducer.Processor)new ResultsProducer.Processor<Unit>(processor){
                final /* synthetic */ ResultsProducer.Processor $processor;

                public void results(@NotNull ResultSet resultSet, int index2) {
                    Intrinsics.checkParameterIsNotNull((Object)resultSet, (String)"resultSet");
                    this.$processor.results(resultSet, index2);
                }

                public void updateCount(int count2, int index2) {
                    this.$processor.updateCount(count2, index2);
                }
                {
                    this.$processor = $captured_local_variable$0;
                }
            });
        }
    }

    public <R> R processCurrent(@NotNull ResultsProducer.Processor<R> processor) {
        R r;
        Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
        if (this.hasResults()) {
            ResultSet resultSet = this.currentResults;
            if (resultSet == null) {
                Intrinsics.throwNpe();
            }
            r = processor.results(resultSet, this.currentResultSetIndex);
        } else if (this.hasUpdateCount()) {
            r = processor.updateCount(this.updateCount, this.currentResultSetIndex);
        } else {
            throw (Throwable)new IllegalStateException("Please, call advance before processCurrent() and make sure that results exits");
        }
        return r;
    }

    @Override
    @Nullable
    public Object getParameterValue(int index2) {
        Object object;
        if (index2 < 1) {
            object = null;
        } else {
            Object v1;
            block3: {
                Iterable iterable;
                Iterable iterable2 = iterable = (Iterable)this.parameters;
                for (Object t : iterable2) {
                    CallableStatementData.OutParameter it = (CallableStatementData.OutParameter)t;
                    if (!(it.getIndex() == index2)) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            CallableStatementData.OutParameter outParameter = v1;
            object = outParameter != null ? UniversalResultsProducerKt.access$retrieve(outParameter, (Statement)this.statement.getValue()) : null;
        }
        return object;
    }

    @Override
    public boolean advance() throws StagedException {
        Verdict state = this.advanceContentAndSource();
        while (state == Verdict.CONTINUE) {
            state = this.advanceContentAndSource();
        }
        return state == Verdict.STOP_ON_RESULT;
    }

    @Override
    public void close() {
        this.connection.getAuditService().getWarningsListener().printStatementWarnings((Statement)this.statement.getValue(), this.mark);
        this.closeResultSet();
        this.connection.getAuditService().resultsProcessed(this.mark);
        JdbcUtil.closeSafe((AutoCloseable)this.statement);
    }

    private final Verdict advanceContentAndSource() {
        Verdict state = this.advanceCurrentSourceContent();
        this.source = this.source.advance(this.hasResults() || this.hasUpdateCount());
        return state;
    }

    private final Verdict advanceCurrentSourceContent() {
        this.clearCurrentResults();
        this.updateCount = -1;
        if (this.source.hasMoreResultSets()) {
            this.currentResults = (ResultSet)SmartStatementsUtil.runReportingAndGet(this.connection, StagedException.Stage.GET_RESULT_SET, this.mark, (Function0)new Function0<ResultSet>(this){
                final /* synthetic */ UniversalResultsProducer this$0;

                @Nullable
                public final ResultSet invoke() {
                    return UniversalResultsProducer.access$getSource$p(this.this$0).getResultSet();
                }
                {
                    this.this$0 = universalResultsProducer;
                    super(0);
                }
            });
            AdvancedAuditService advancedAuditService = this.connection.getAuditService();
            ResultSet resultSet = this.currentResults;
            if (resultSet == null) {
                Intrinsics.throwNpe();
            }
            advancedAuditService.resultsOpened(resultSet, this.mark);
            int n = this.currentResultSetIndex;
            this.currentResultSetIndex = n + 1;
            n = this.currentResultsIndex;
            this.currentResultsIndex = n + 1;
            n = SmartStatements.Companion.getMaxResults();
            if (1 <= n && this.currentResultSetIndex > n) {
                this.connection.getAuditService().message("The maximum number of result sets per query is reached (" + SmartStatements.Companion.getMaxResults() + ").", this.mark);
                return Verdict.CONTINUE;
            }
            if (!this.requestedResultsReached()) {
                this.connection.getAuditService().message("Skipping result set", this.mark);
                return Verdict.CONTINUE;
            }
        } else {
            this.updateCount = ((Number)SmartStatementsUtil.runReportingAndGet(this.connection, StagedException.Stage.GET_UPDATE_COUNT, this.mark, (Function0)new Function0<Integer>(this){
                final /* synthetic */ UniversalResultsProducer this$0;

                public final int invoke() {
                    return UniversalResultsProducer.access$getSource$p(this.this$0).getUpdateCount();
                }
                {
                    this.this$0 = universalResultsProducer;
                    super(0);
                }
            })).intValue();
            if (!this.hasUpdateCount()) {
                return this.source.noResultsVerdict();
            }
            this.connection.getAuditService().updateCount(this.updateCount, this.mark);
            int n = this.currentResultsIndex;
            this.currentResultsIndex = n + 1;
        }
        return Verdict.STOP_ON_RESULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closeResultSet() {
        ResultSet lastResults = this.currentResults;
        try {
            this.clearCurrentResults();
        }
        finally {
            JdbcUtil.closeSafe((AutoCloseable)lastResults);
        }
    }

    private final void clearCurrentResults() {
        if (this.currentResults != null) {
            AdvancedAuditService advancedAuditService = this.connection.getAuditService();
            ResultSet resultSet = this.currentResults;
            if (resultSet == null) {
                Intrinsics.throwNpe();
            }
            advancedAuditService.beforeResultsClosing(resultSet, this.mark);
        }
        this.currentResults = null;
    }

    private final boolean hasUpdateCount() {
        return this.updateCount != -1;
    }

    private final boolean hasResults() {
        return this.currentResults != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean requestedResultsReached() {
        if (this.configuration.getResultsIndex() == null) return true;
        if (this.configuration.getResultsIndex() <= 0) return true;
        Integer n = this.configuration.getResultsIndex();
        int n2 = this.currentResultSetIndex;
        if (n == null) return false;
        if (n != n2) return false;
        return true;
    }

    public UniversalResultsProducer(@NotNull StatementHolder.CloseableRef<T> statement, @NotNull SmartStatementMark mark2, @NotNull Configuration configuration, @NotNull DatabaseConnection connection2, @NotNull ExecutionResult result2) {
        Intrinsics.checkParameterIsNotNull(statement, (String)"statement");
        Intrinsics.checkParameterIsNotNull((Object)mark2, (String)"mark");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)connection2, (String)"connection");
        Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
        this.statement = statement;
        this.mark = mark2;
        this.configuration = configuration;
        this.connection = connection2;
        this.updateCount = -1;
        this.parameters = result2.getOutParameters();
        this.source = new ResultSource(result2, (Statement)this.statement.getValue());
    }

    @Override
    public boolean advanceSafe() {
        return ClosableResultsProducer.DefaultImpls.advanceSafe(this);
    }

    @NotNull
    public static final /* synthetic */ Source access$getSource$p(UniversalResultsProducer $this) {
        return $this.source;
    }

    public static final /* synthetic */ void access$setSource$p(UniversalResultsProducer $this, @NotNull Source source) {
        $this.source = source;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Verdict;", "", "(Ljava/lang/String;I)V", "CONTINUE", "STOP_ON_RESULT", "FINISH", "intellij.database.impl"})
    private static final class Verdict
    extends Enum<Verdict> {
        public static final /* enum */ Verdict CONTINUE;
        public static final /* enum */ Verdict STOP_ON_RESULT;
        public static final /* enum */ Verdict FINISH;
        private static final /* synthetic */ Verdict[] $VALUES;

        static {
            Verdict[] verdictArray = new Verdict[3];
            Verdict[] verdictArray2 = verdictArray;
            verdictArray[0] = CONTINUE = new Verdict();
            verdictArray[1] = STOP_ON_RESULT = new Verdict();
            verdictArray[2] = FINISH = new Verdict();
            $VALUES = verdictArray;
        }

        public static Verdict[] values() {
            return (Verdict[])$VALUES.clone();
        }

        public static Verdict valueOf(String string) {
            return Enum.valueOf(Verdict.class, string);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004H&J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H&J\b\u0010\u0007\u001a\u00020\bH&J\b\u0010\t\u001a\u00020\u0004H&J\b\u0010\n\u001a\u00020\u000bH&\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Source;", "", "advance", "hasSomething", "", "getResultSet", "Ljava/sql/ResultSet;", "getUpdateCount", "", "hasMoreResultSets", "noResultsVerdict", "Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Verdict;", "intellij.database.impl"})
    private static interface Source {
        @Nullable
        public ResultSet getResultSet();

        public int getUpdateCount();

        public boolean hasMoreResultSets();

        @NotNull
        public Source advance(boolean var1);

        @NotNull
        public Verdict noResultsVerdict();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\nH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$ResultSource;", "Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Source;", "executionResult", "Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;", "statement", "Ljava/sql/Statement;", "(Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;Ljava/sql/Statement;)V", "advance", "Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$StatementSource;", "hasSomething", "", "getResultSet", "Ljava/sql/ResultSet;", "getUpdateCount", "", "hasMoreResultSets", "noResultsVerdict", "Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Verdict;", "intellij.database.impl"})
    private static final class ResultSource
    implements Source {
        private final ExecutionResult executionResult;
        private final Statement statement;

        @Override
        public boolean hasMoreResultSets() {
            return this.executionResult.hasResultSet();
        }

        @Override
        @Nullable
        public ResultSet getResultSet() {
            return this.executionResult.getResultSet();
        }

        @Override
        public int getUpdateCount() {
            return this.executionResult.getUpdateCount();
        }

        @Override
        @NotNull
        public StatementSource advance(boolean hasSomething) {
            return new StatementSource(this.statement, this.executionResult);
        }

        @Override
        @NotNull
        public Verdict noResultsVerdict() {
            return Verdict.CONTINUE;
        }

        public ResultSource(@NotNull ExecutionResult executionResult, @NotNull Statement statement) {
            Intrinsics.checkParameterIsNotNull((Object)executionResult, (String)"executionResult");
            Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
            this.executionResult = executionResult;
            this.statement = statement;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$StatementSource;", "Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Source;", "statement", "Ljava/sql/Statement;", "executionResult", "Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;", "(Ljava/sql/Statement;Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;)V", "advance", "hasSomething", "", "getResultSet", "Ljava/sql/ResultSet;", "getUpdateCount", "", "hasMoreResultSets", "noResultsVerdict", "Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Verdict;", "shouldCheckOutParameters", "intellij.database.impl"})
    private static final class StatementSource
    implements Source {
        private final Statement statement;
        private final ExecutionResult executionResult;

        @Override
        public boolean hasMoreResultSets() {
            return this.statement.getMoreResults();
        }

        @Override
        @Nullable
        public ResultSet getResultSet() {
            return this.statement.getResultSet();
        }

        @Override
        public int getUpdateCount() {
            return this.statement.getUpdateCount();
        }

        @Override
        @NotNull
        public Source advance(boolean hasSomething) {
            Source source;
            if (hasSomething || !this.shouldCheckOutParameters()) {
                source = this;
            } else {
                Statement statement = this.statement;
                if (statement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.sql.CallableStatement");
                }
                source = new ParametersSource((CallableStatement)statement, this.executionResult.getOutParameters());
            }
            return source;
        }

        @Override
        @NotNull
        public Verdict noResultsVerdict() {
            return this.shouldCheckOutParameters() ? Verdict.CONTINUE : Verdict.FINISH;
        }

        private final boolean shouldCheckOutParameters() {
            Collection collection;
            return this.statement instanceof CallableStatement && !(collection = (Collection)this.executionResult.getOutParameters()).isEmpty();
        }

        public StatementSource(@NotNull Statement statement, @NotNull ExecutionResult executionResult) {
            Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
            Intrinsics.checkParameterIsNotNull((Object)executionResult, (String)"executionResult");
            this.statement = statement;
            this.executionResult = executionResult;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\u0010\u001a\u00020\tH\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u000bH\u0002J\b\u0010\u0013\u001a\u00020\tH\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$ParametersSource;", "Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Source;", "statement", "Ljava/sql/CallableStatement;", "params", "", "Lcom/intellij/database/dataSource/connection/statements/CallableStatementData$OutParameter;", "(Ljava/sql/CallableStatement;Ljava/util/List;)V", "currentIdx", "", "currentResults", "Ljava/sql/ResultSet;", "advance", "hasSomething", "", "getResultSet", "getUpdateCount", "hasMoreResultSets", "nextResultSet", "nextResultsIndex", "noResultsVerdict", "Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Verdict;", "remaining", "intellij.database.impl"})
    private static final class ParametersSource
    implements Source {
        private int currentIdx;
        private ResultSet currentResults;
        private final CallableStatement statement;
        private final List<CallableStatementData.OutParameter> params;

        @Override
        @Nullable
        public ResultSet getResultSet() {
            this.currentResults = this.nextResultSet();
            return this.currentResults;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasMoreResultSets() {
            boolean bl;
            try {
                bl = this.nextResultsIndex() != -1;
            }
            finally {
                JdbcUtil.closeSafe((AutoCloseable)this.currentResults);
            }
            return bl;
        }

        @Override
        public int getUpdateCount() {
            return -1;
        }

        @Override
        @NotNull
        public Source advance(boolean hasSomething) {
            return this;
        }

        @Override
        @NotNull
        public Verdict noResultsVerdict() {
            return Verdict.FINISH;
        }

        private final ResultSet nextResultSet() {
            ResultSet resultSet;
            int index2 = this.nextResultsIndex();
            List<CallableStatementData.OutParameter> remaining = this.remaining();
            int n = this.currentIdx = index2 == -1 ? this.params.size() : index2 + this.currentIdx + 1;
            if (index2 == -1) {
                resultSet = null;
            } else {
                Object object = UniversalResultsProducerKt.access$retrieve(remaining.get(index2), this.statement);
                if (!(object instanceof ResultSet)) {
                    object = null;
                }
                resultSet = (ResultSet)object;
            }
            return resultSet;
        }

        private final int nextResultsIndex() {
            int n;
            block2: {
                List<CallableStatementData.OutParameter> $receiver$iv = this.remaining();
                int index$iv = 0;
                for (CallableStatementData.OutParameter item$iv : $receiver$iv) {
                    CallableStatementData.OutParameter it = item$iv;
                    if (it.getExpectsResultSet()) {
                        n = index$iv;
                        break block2;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            return n;
        }

        private final List<CallableStatementData.OutParameter> remaining() {
            return this.currentIdx < this.params.size() ? this.params.subList(this.currentIdx, this.params.size()) : CollectionsKt.emptyList();
        }

        public ParametersSource(@NotNull CallableStatement statement, @NotNull List<CallableStatementData.OutParameter> params) {
            Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
            Intrinsics.checkParameterIsNotNull(params, (String)"params");
            this.statement = statement;
            this.params = params;
        }
    }
}

