/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text.minimatch;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SmartList;
import com.intellij.util.containers.Stack;
import com.intellij.util.text.minimatch.DefaultPathAdapter;
import com.intellij.util.text.minimatch.GlobStar;
import com.intellij.util.text.minimatch.LiteralItem;
import com.intellij.util.text.minimatch.MagicItem;
import com.intellij.util.text.minimatch.MinimatchKt;
import com.intellij.util.text.minimatch.MinimatchOptions;
import com.intellij.util.text.minimatch.ParseContext;
import com.intellij.util.text.minimatch.ParseItem;
import com.intellij.util.text.minimatch.ParseResult;
import com.intellij.util.text.minimatch.PathAdapter;
import com.intellij.util.text.minimatch.PatternListItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J#\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0013\u0010\u0019\u001a\u00020\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u001b\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u001cJG\u0010\u001d\u001a.\u0012*\u0012(\u0012\f\u0012\n \u001e*\u0004\u0018\u00010\u00030\u0003 \u001e*\u0014\u0012\u000e\b\u0001\u0012\n \u001e*\u0004\u0018\u00010\u00030\u0003\u0018\u00010\u00130\u00130\u00102\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013H\u0002\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020!H\u0016J\u0014\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u0010H\u0002J3\u0010#\u001a\u00020\b\"\u0004\b\u0000\u0010$2\u0006\u0010%\u001a\u0002H$2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H$0'2\b\b\u0002\u0010(\u001a\u00020\bH\u0007\u00a2\u0006\u0002\u0010)J\u001a\u0010#\u001a\u00020\b2\u0006\u0010%\u001a\u00020\u00032\b\b\u0002\u0010(\u001a\u00020\bH\u0007J\u001e\u0010#\u001a\u00020\b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u00102\b\b\u0002\u0010(\u001a\u00020\bJ,\u0010,\u001a\u00020\b2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020+0\u00102\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010(\u001a\u00020\bH\u0002J\u0018\u0010.\u001a\u00020/2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00100\u001a\u00020\bH\u0002J\b\u00101\u001a\u00020\u0003H\u0016J\u001c\u00101\u001a\u00020+2\u0012\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00130\u0010H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/util/text/minimatch/Minimatch;", "", "pattern", "", "options", "Lcom/intellij/util/text/minimatch/MinimatchOptions;", "(Ljava/lang/String;Lcom/intellij/util/text/minimatch/MinimatchOptions;)V", "comment", "", "empty", "negate", "getNegate", "()Z", "getOptions", "()Lcom/intellij/util/text/minimatch/MinimatchOptions;", "set", "", "Lcom/intellij/util/text/minimatch/ParseItem;", "braceExpand", "", "(Ljava/lang/String;Lcom/intellij/util/text/minimatch/MinimatchOptions;)[Ljava/lang/String;", "clearStateChar", "", "ctx", "Lcom/intellij/util/text/minimatch/ParseContext;", "equals", "other", "expand", "(Ljava/lang/String;)[Ljava/lang/String;", "globParts", "kotlin.jvm.PlatformType", "([Ljava/lang/String;)Ljava/util/List;", "hashCode", "", "make", "match", "T", "input", "adapter", "Lcom/intellij/util/text/minimatch/PathAdapter;", "partial", "(Ljava/lang/Object;Lcom/intellij/util/text/minimatch/PathAdapter;Z)Z", "path", "", "matchOne", "file", "parse", "Lcom/intellij/util/text/minimatch/ParseResult;", "isSub", "toString", "intellij.nodeJS"})
public final class Minimatch {
    private final boolean comment;
    private final boolean empty = false;
    private final boolean negate;
    private final List<List<ParseItem>> set;
    private final String pattern;
    @NotNull
    private final MinimatchOptions options;

    public final boolean getNegate() {
        return this.negate;
    }

    /*
     * WARNING - void declaration
     */
    private final List<List<ParseItem>> make() {
        List list;
        Object object;
        Object object2;
        Object[] set = this.braceExpand(this.pattern, this.options);
        Logger $receiver$iv = MinimatchKt.access$getLOG$p();
        Exception e$iv = null;
        if ($receiver$iv.isDebugEnabled()) {
            object2 = $receiver$iv;
            object = this.pattern + ' ' + Arrays.toString(set);
            object2.debug((String)object, (Throwable)e$iv);
        }
        List<String[]> globParts = this.globParts((String[])set);
        Logger $receiver$iv2 = MinimatchKt.access$getLOG$p();
        Exception e$iv2 = null;
        if ($receiver$iv2.isDebugEnabled()) {
            object2 = $receiver$iv2;
            object = this.pattern + ' ' + this.toString(globParts);
            object2.debug((String)object, (Throwable)e$iv2);
        }
        Collection $receiver$iv3 = globParts;
        int size$iv = $receiver$iv3.size();
        switch (size$iv) {
            case 1: {
                List list2;
                void it;
                SmartList smartList;
                String[] $i$a$1$debug = (String[])CollectionsKt.first((Iterable)$receiver$iv3);
                object = smartList;
                object2 = smartList;
                void v1 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                void $receiver$iv4 = v1;
                int size$iv2 = ((void)$receiver$iv4).length;
                switch (size$iv2) {
                    case 1: {
                        void it2;
                        SmartList smartList2;
                        void var9_15 = $receiver$iv4[0];
                        SmartList smartList3 = smartList2;
                        SmartList smartList4 = smartList2;
                        void v3 = it2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
                        ParseItem parseItem = this.parse((String)v3, false).getItem();
                        smartList3((Object)parseItem);
                        list2 = (List)smartList4;
                        break;
                    }
                    case 0: {
                        list2 = (List)new SmartList();
                        break;
                    }
                    default: {
                        void $receiver$iv$iv2;
                        void var13_26 = $receiver$iv4;
                        Collection destination$iv$iv = new ArrayList(size$iv2);
                        void var15_30 = $receiver$iv$iv2;
                        int n = ((void)var15_30).length;
                        for (int i = 0; i < n; ++i) {
                            void item$iv$iv;
                            void it2 = item$iv$iv = var15_30[i];
                            Collection collection = destination$iv$iv;
                            void v5 = it2;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"it");
                            ParseItem parseItem = this.parse((String)v5, false).getItem();
                            collection.add(parseItem);
                        }
                        list2 = (List)destination$iv$iv;
                    }
                }
                List list3 = list2;
                object((Object)list3);
                list = (List)object2;
                break;
            }
            case 0: {
                list = CollectionsKt.emptyList();
                break;
            }
            default: {
                void $receiver$iv$iv;
                Iterable iterable = $receiver$iv3;
                Collection destination$iv$iv = new ArrayList(size$iv);
                for (Object item$iv$iv : $receiver$iv$iv) {
                    List list4;
                    String[] it = (String[])item$iv$iv;
                    object2 = destination$iv$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                    String[] $receiver$iv5 = it;
                    int size$iv3 = $receiver$iv5.length;
                    switch (size$iv3) {
                        case 1: {
                            SmartList smartList;
                            String it3 = $receiver$iv5[0];
                            Object object3 = smartList;
                            Object object4 = smartList;
                            String string = it3;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                            ParseItem parseItem = this.parse(string, false).getItem();
                            object3((Object)parseItem);
                            list4 = (List)object4;
                            break;
                        }
                        case 0: {
                            list4 = (List)new SmartList();
                            break;
                        }
                        default: {
                            Object object4;
                            Object object3;
                            String it3;
                            String[] $receiver$iv$iv2 = $receiver$iv5;
                            Collection destination$iv$iv2 = new ArrayList(size$iv3);
                            String[] stringArray = $receiver$iv$iv2;
                            int n = stringArray.length;
                            for (int i = 0; i < n; ++i) {
                                String item$iv$iv2;
                                it3 = item$iv$iv2 = stringArray[i];
                                object4 = destination$iv$iv2;
                                String string = it3;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                                object3 = this.parse(string, false).getItem();
                                object4.add(object3);
                            }
                            list4 = (List)destination$iv$iv2;
                        }
                    }
                    object = list4;
                    object2.add(object);
                }
                list = (List)destination$iv$iv;
            }
        }
        List results = list;
        $receiver$iv3 = MinimatchKt.access$getLOG$p();
        Exception e$iv3 = null;
        if ($receiver$iv3.isDebugEnabled()) {
            object2 = $receiver$iv3;
            object = this.pattern + ' ' + results;
            object2.debug((String)object, (Throwable)e$iv3);
        }
        return results;
    }

    private final CharSequence toString(List<String[]> globParts) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (Object[] objectArray : globParts) {
            sb.append(Arrays.toString(objectArray));
            sb.append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(']');
        return sb;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String[]> globParts(String[] set) {
        List list;
        String[] $receiver$iv = set;
        int size$iv = $receiver$iv.length;
        switch (size$iv) {
            case 1: {
                void it;
                SmartList smartList;
                String string = $receiver$iv[0];
                SmartList smartList2 = smartList;
                SmartList smartList3 = smartList;
                String[] stringArray = MinimatchKt.access$getSlashSplit$p().split((CharSequence)it, Integer.MAX_VALUE);
                smartList2((Object)stringArray);
                list = (List)smartList3;
                break;
            }
            case 0: {
                list = (List)new SmartList();
                break;
            }
            default: {
                void $receiver$iv$iv;
                String[] stringArray = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(size$iv);
                void var8_13 = $receiver$iv$iv;
                int n = ((void)var8_13).length;
                for (int i = 0; i < n; ++i) {
                    void item$iv$iv;
                    void it = item$iv$iv = var8_13[i];
                    Collection collection = destination$iv$iv;
                    String[] stringArray2 = MinimatchKt.access$getSlashSplit$p().split((CharSequence)it, Integer.MAX_VALUE);
                    collection.add(stringArray2);
                }
                list = (List)destination$iv$iv;
            }
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final ParseResult parse(String pattern, boolean isSub) {
        CharSequence sb22;
        String string;
        CharSequence charSequence;
        Object object;
        char c22;
        if (!this.options.getNoglobstar() && Intrinsics.areEqual((Object)"**", (Object)pattern)) {
            return new ParseResult(MinimatchKt.access$getGLOBSTAR$p(), false);
        }
        CharSequence charSequence2 = pattern;
        if (charSequence2.length() == 0) {
            return new ParseResult(ParseItem.Empty, false);
        }
        ParseContext ctx = new ParseContext();
        ctx.re = "";
        ctx.hasMagic = this.options.getNocase();
        boolean escaping = false;
        Stack patternListStack = new Stack();
        Stack negativeListStack = new Stack();
        boolean inClass = false;
        int reClassStart = -1;
        int classStart = -1;
        String patternStart = pattern.charAt(0) == '.' ? "" : (this.options.getDot() ? "(?!(?:^|\\/)\\.{1,2}(?:$|\\/))" : "(?!\\.)");
        int n = 0;
        int n2 = pattern.length() - 1;
        if (n <= n2) {
            while (true) {
                void i;
                c22 = pattern.charAt((int)i);
                Logger $receiver$iv = MinimatchKt.access$getLOG$p();
                Object e$iv = null;
                if ($receiver$iv.isDebugEnabled()) {
                    object = $receiver$iv;
                    charSequence = pattern + '\t' + (int)i + ' ' + ctx.re + " \"" + c22 + '\"';
                    object.debug((String)charSequence, (Throwable)e$iv);
                }
                if (escaping && StringsKt.contains$default((CharSequence)"().*{}+?[]^$\\!", (char)c22, (boolean)false, (int)2, null)) {
                    ctx.re = ctx.re + "\\" + c22;
                    escaping = false;
                } else {
                    switch (c22) {
                        case '/': {
                            throw (Throwable)new IllegalStateException();
                        }
                        case '\\': {
                            this.clearStateChar(ctx);
                            escaping = true;
                            break;
                        }
                        case '!': 
                        case '*': 
                        case '+': 
                        case '?': 
                        case '@': {
                            $receiver$iv = MinimatchKt.access$getLOG$p();
                            e$iv = null;
                            if ($receiver$iv.isDebugEnabled()) {
                                object = $receiver$iv;
                                charSequence = pattern + '\t' + (int)i + ' ' + ctx.re + " \"" + c22 + "\" <-- stateChar";
                                object.debug((String)charSequence, (Throwable)e$iv);
                            }
                            if (inClass) {
                                MinimatchKt.access$getLOG$p().debug("  in class");
                                if (c22 == '!' && i == classStart + 1) {
                                    c22 = '^';
                                }
                                ctx.re = ctx.re + c22;
                                break;
                            }
                            $receiver$iv = MinimatchKt.access$getLOG$p();
                            e$iv = null;
                            if ($receiver$iv.isDebugEnabled()) {
                                object = $receiver$iv;
                                charSequence = "call clearStateChar \"" + ctx.stateChar + '\"';
                                object.debug((String)charSequence, (Throwable)e$iv);
                            }
                            this.clearStateChar(ctx);
                            ctx.stateChar = Character.valueOf(c22);
                            if (!this.options.getNoext()) break;
                            this.clearStateChar(ctx);
                            break;
                        }
                        case '(': {
                            if (inClass) {
                                ctx.re = ctx.re + "(";
                                break;
                            }
                            if (ctx.stateChar == null) {
                                ctx.re = ctx.re + "\\(";
                                break;
                            }
                            Character c = ctx.stateChar;
                            if (c == null) {
                                Intrinsics.throwNpe();
                            }
                            char plType = c.charValue();
                            patternListStack.push((Object)new PatternListItem(plType, (int)(i - true), ctx.re.length(), 0, 8, null));
                            Character c3 = ctx.stateChar;
                            ctx.re = ctx.re + (c3 != null && c3.charValue() == '!' ? "(?:(?!(?:" : "(?:");
                            $receiver$iv = MinimatchKt.access$getLOG$p();
                            e$iv = null;
                            if ($receiver$iv.isDebugEnabled()) {
                                object = $receiver$iv;
                                charSequence = "plType \"" + ctx.stateChar + "\" \"" + ctx.re + '\"';
                                object.debug((String)charSequence, (Throwable)e$iv);
                            }
                            ctx.stateChar = null;
                            break;
                        }
                        case ')': {
                            if (inClass || patternListStack.isEmpty()) {
                                ctx.re = ctx.re + "\\)";
                                break;
                            }
                            this.clearStateChar(ctx);
                            ctx.hasMagic = true;
                            ctx.re = ctx.re + ")";
                            PatternListItem pl = (PatternListItem)patternListStack.pop();
                            char plType = pl.getType();
                            switch (plType) {
                                case '!': {
                                    negativeListStack.push((Object)pl);
                                    ctx.re = ctx.re + ")[^/]*?)";
                                    pl.setReEnd(ctx.re.length());
                                    break;
                                }
                                case '*': 
                                case '+': 
                                case '?': {
                                    ctx.re = ctx.re + plType;
                                }
                            }
                            break;
                        }
                        case '|': {
                            if (inClass || patternListStack.size() == 0 || escaping) {
                                ctx.re = ctx.re + "\\|";
                                escaping = false;
                                break;
                            }
                            this.clearStateChar(ctx);
                            ctx.re = ctx.re + '|';
                            break;
                        }
                        case '[': {
                            this.clearStateChar(ctx);
                            if (inClass) {
                                ctx.re = ctx.re + '\\' + c22;
                                break;
                            }
                            inClass = true;
                            classStart = i;
                            reClassStart = ctx.re.length();
                            ctx.re = ctx.re + c22;
                            break;
                        }
                        case ']': {
                            if (i == classStart + 1 || !inClass) {
                                ctx.re = ctx.re + "\\" + c22;
                                escaping = false;
                                break;
                            }
                            if (inClass) {
                                String cs2;
                                e$iv = pattern;
                                int $i$f$debug = classStart + 1;
                                Object object2 = e$iv;
                                if (object2 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                }
                                Intrinsics.checkExpressionValueIsNotNull((Object)((String)object2).substring($i$f$debug, (int)i), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                try {
                                    Pattern.compile('[' + cs2 + ']');
                                }
                                catch (Throwable e) {
                                    ParseResult sp = this.parse(cs2, true);
                                    String string2 = ctx.re;
                                    int $i$a$4$debug = 0;
                                    charSequence = new StringBuilder();
                                    object = ctx;
                                    String string3 = string2;
                                    if (string3 == null) {
                                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                    }
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string3.substring($i$a$4$debug, reClassStart), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                    ((ParseContext)object).re = ((StringBuilder)charSequence).append(string).append("\\[").append(sp.getItem().getSource()).append("\\]").toString();
                                    ctx.hasMagic = ctx.hasMagic || sp.isB();
                                    inClass = false;
                                    break;
                                }
                            }
                            ctx.hasMagic = true;
                            inClass = false;
                            ctx.re = ctx.re + c22;
                            break;
                        }
                        default: {
                            this.clearStateChar(ctx);
                            if (escaping) {
                                escaping = false;
                            } else if (StringsKt.contains$default((CharSequence)"().*{}+?[]^$\\!", (char)c22, (boolean)false, (int)2, null) && (c22 != '^' || !inClass)) {
                                ctx.re = ctx.re + "\\";
                            }
                            ctx.re = ctx.re + c22;
                        }
                    }
                }
                if (i == n2) break;
                ++i;
            }
        }
        if (inClass) {
            String string4 = pattern;
            c22 = classStart + 1;
            String string5 = string4;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(c22);
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
            String cs = string6;
            ParseResult sp = this.parse(cs, true);
            String c22 = ctx.re;
            int cs2 = 0;
            charSequence = new StringBuilder();
            object = ctx;
            String string7 = c22;
            if (string7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string8 = string7.substring(cs2, reClassStart);
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string = string8;
            ((ParseContext)object).re = ((StringBuilder)charSequence).append(string).append("\\[").append(sp.getItem().getSource()).toString();
            boolean bl = ctx.hasMagic = ctx.hasMagic || sp.isB();
        }
        while (!patternListStack.isEmpty()) {
            int n3;
            PatternListItem pl = (PatternListItem)patternListStack.pop();
            String c22 = ctx.re;
            int cs2 = pl.getReStart() + 3;
            String string9 = c22;
            if (string9 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string10 = string9.substring(cs2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"(this as java.lang.String).substring(startIndex)");
            charSequence = string10;
            CharSequence tail = charSequence;
            Pattern p = Pattern.compile("((?:\\\\{2})*)(\\\\?)\\|");
            Matcher m = p.matcher(tail);
            sb22 = new StringBuilder();
            int lastEnd22 = 0;
            while (m.find()) {
                String g1 = m.group(1);
                String g2 = m.group(2);
                CharSequence charSequence3 = g2;
                if (charSequence3 == null || charSequence3.length() == 0) {
                    g2 = "\\";
                }
                charSequence3 = tail;
                n3 = m.start();
                object = sb22;
                charSequence = ((Object)charSequence3.subSequence(lastEnd22, n3)).toString();
                ((StringBuilder)object).append((String)charSequence);
                ((StringBuilder)sb22).append(g1).append(g1).append(g2).append("|");
                lastEnd22 = m.end();
            }
            ((StringBuilder)sb22).append(tail, lastEnd22, tail.length());
            tail = sb22;
            Logger $receiver$iv = MinimatchKt.access$getLOG$p();
            Object e$iv22 = null;
            if ($receiver$iv.isDebugEnabled()) {
                object = $receiver$iv;
                charSequence = "tail=" + tail;
                object.debug((String)charSequence, (Throwable)e$iv22);
            }
            String t22 = '*' == pl.getType() ? MinimatchKt.access$getSTAR$p() : ('?' == pl.getType() ? MinimatchKt.access$getQMARK$p() : "\\" + pl.getType());
            ctx.hasMagic = true;
            e$iv22 = ctx.re;
            int $i$f$debug = 0;
            n3 = pl.getReStart();
            charSequence = new StringBuilder();
            object = ctx;
            Object object3 = e$iv22;
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)((String)object3).substring($i$f$debug, n3), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            ((ParseContext)object).re = ((StringBuilder)charSequence).append(string).append(t22).append("\\(").append(tail).toString();
        }
        this.clearStateChar(ctx);
        if (escaping) {
            ctx.re = ctx.re + "\\\\";
        }
        boolean addPatternStart = false;
        switch (ctx.re.charAt(0)) {
            case '(': 
            case '.': 
            case '[': {
                addPatternStart = true;
            }
        }
        while (!negativeListStack.isEmpty()) {
            String nlFirst;
            Collection thisCollection$iv22;
            List list;
            CharSequence charSequence4;
            Collection $receiver$iv;
            String nlBefore;
            PatternListItem nl = (PatternListItem)negativeListStack.pop();
            String m = ctx.re;
            int sb22 = 0;
            int lastEnd22 = nl.getReStart();
            String string11 = m;
            if (string11 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string11.substring(sb22, lastEnd22), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            sb22 = ctx.re;
            lastEnd22 = nl.getReStart();
            int t22 = nl.getReEnd() - 8;
            CharSequence charSequence5 = sb22;
            if (charSequence5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)((String)charSequence5).substring(lastEnd22, t22), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String lastEnd22 = ctx.re;
            t22 = nl.getReEnd() - 8;
            int e$iv22 = nl.getReEnd();
            String string12 = lastEnd22;
            if (string12 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string13 = string12.substring(t22, e$iv22);
            Intrinsics.checkExpressionValueIsNotNull((Object)string13, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String nlLast = string13;
            String t22 = ctx.re;
            e$iv22 = nl.getReEnd();
            String string14 = t22;
            if (string14 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string15 = string14.substring(e$iv22);
            Intrinsics.checkExpressionValueIsNotNull((Object)string15, (String)"(this as java.lang.String).substring(startIndex)");
            String nlAfter = string15;
            nlLast = nlLast + nlAfter;
            Object e$iv22 = nlBefore;
            Regex $i$f$debug = new Regex("\\(");
            int n4 = 0;
            e$iv22 = $i$f$debug.split((CharSequence)e$iv22, n4);
            if (!$receiver$iv.isEmpty()) {
                ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String p1 = (String)iterator$iv.previous();
                    charSequence4 = p1;
                    if (charSequence4.length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$receiver$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $receiver$iv = list;
            if ($receiver$iv == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            String[] stringArray = thisCollection$iv22.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            int openParensBefore = stringArray.length - 1;
            String cleanAfter = nlAfter;
            int thisCollection$iv22 = 0;
            int n5 = openParensBefore - 1;
            if (thisCollection$iv22 <= n5) {
                while (true) {
                    void i;
                    charSequence4 = cleanAfter;
                    Regex regex = new Regex("\\)[+*?]?");
                    String string16 = "";
                    cleanAfter = regex.replace(charSequence4, string16);
                    if (i == n5) break;
                    ++i;
                }
            }
            nlAfter = cleanAfter;
            String dollar = "";
            CharSequence charSequence6 = nlAfter;
            if (charSequence6.length() == 0 && !isSub) {
                dollar = "$";
            }
            ctx.re = nlBefore + nlFirst + nlAfter + dollar + nlLast;
        }
        CharSequence charSequence7 = ctx.re;
        if (!(charSequence7.length() == 0) && ctx.hasMagic) {
            ctx.re = "(?=.)" + ctx.re;
        }
        if (addPatternStart) {
            ctx.re = patternStart + ctx.re;
        }
        if (isSub) {
            return new ParseResult(new LiteralItem(ctx.re), ctx.hasMagic);
        }
        if (!ctx.hasMagic) {
            return new ParseResult(new LiteralItem(MinimatchKt.globUnescape(pattern)), false);
        }
        return new ParseResult(new MagicItem(ctx.re, this.options), false);
    }

    private final void clearStateChar(ParseContext ctx) {
        if (ctx.stateChar != null) {
            Character c;
            Character c2 = c = ctx.stateChar;
            if (c2 != null && c2.charValue() == '*') {
                ctx.re = ctx.re + MinimatchKt.access$getSTAR$p();
                ctx.hasMagic = true;
            } else {
                Character c3 = c;
                if (c3 != null && c3.charValue() == '?') {
                    ctx.re = ctx.re + MinimatchKt.access$getQMARK$p();
                    ctx.hasMagic = true;
                } else {
                    StringBuilder stringBuilder = new StringBuilder().append(ctx.re).append('\\');
                    Character c4 = ctx.stateChar;
                    if (c4 == null) {
                        Intrinsics.throwNpe();
                    }
                    ctx.re = stringBuilder.append(c4.charValue()).toString();
                }
            }
            Logger $receiver$iv = MinimatchKt.access$getLOG$p();
            Exception e$iv = null;
            if ($receiver$iv.isDebugEnabled()) {
                Logger logger = $receiver$iv;
                String string = "clearStateChar \"" + ctx.stateChar + "\" \"" + ctx.re + '\"';
                logger.debug(string, (Throwable)e$iv);
            }
            ctx.stateChar = null;
        }
    }

    private final String[] braceExpand(String pattern, MinimatchOptions options) {
        String[] stringArray;
        if (options.getNobrace() || !MinimatchKt.access$getHasBraces$p().matcher(pattern).matches()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = pattern;
        } else {
            stringArray = this.expand(pattern);
        }
        return stringArray;
    }

    private final String[] expand(String pattern) {
        return new String[]{pattern};
    }

    public final boolean match(@NotNull List<? extends CharSequence> path, boolean partial) {
        CharSequence $i$f$debug;
        int i;
        Intrinsics.checkParameterIsNotNull(path, (String)"path");
        Logger $receiver$iv = MinimatchKt.access$getLOG$p();
        Exception e$iv = null;
        if ($receiver$iv.isDebugEnabled()) {
            Logger logger = $receiver$iv;
            String string = this.pattern + " set " + this.set;
            logger.debug(string, (Throwable)e$iv);
        }
        CharSequence filename = null;
        for (i = path.size() - 1; i >= 0 && ($i$f$debug = (filename = path.get(i))).length() == 0; --i) {
        }
        for (i = 0; i < this.set.size(); ++i) {
            List<ParseItem> pattern = this.set.get(i);
            List file = path;
            if (this.options.getMatchBase() && pattern.size() == 1) {
                CharSequence charSequence = filename;
                if (charSequence == null) {
                    Intrinsics.throwNpe();
                }
                file = (List)new SmartList((Object)charSequence);
            }
            if (!this.matchOne(file, pattern, partial)) continue;
            return this.options.getFlipNegate() || !this.negate;
        }
        if (this.options.getFlipNegate()) {
            return false;
        }
        return this.negate;
    }

    public static /* synthetic */ boolean match$default(Minimatch minimatch, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return minimatch.match(list, bl);
    }

    private final boolean matchOne(List<? extends CharSequence> file, List<? extends ParseItem> pattern, boolean partial) {
        int pi;
        String string;
        Logger logger;
        Logger $receiver$iv = MinimatchKt.access$getLOG$p();
        Exception e$iv = null;
        if ($receiver$iv.isDebugEnabled()) {
            logger = $receiver$iv;
            string = "matchOne\n\tOptions: " + this.options + "\n\tfile: " + file + "\n\tpattern: " + pattern;
            logger.debug(string, (Throwable)e$iv);
        }
        $receiver$iv = MinimatchKt.access$getLOG$p();
        e$iv = null;
        if ($receiver$iv.isDebugEnabled()) {
            logger = $receiver$iv;
            string = "matchOne " + file.size() + ' ' + pattern.size();
            logger.debug(string, (Throwable)e$iv);
        }
        int fi = 0;
        int fl = file.size();
        int pl = pattern.size();
        for (pi = 0; fi < fl && pi < pl; ++fi, ++pi) {
            ParseItem p = pattern.get(pi);
            CharSequence f = file.get(fi);
            Logger $receiver$iv2 = MinimatchKt.access$getLOG$p();
            Exception e$iv2 = null;
            if ($receiver$iv2.isDebugEnabled()) {
                logger = $receiver$iv2;
                string = "" + pattern + ' ' + p + ' ' + f;
                logger.debug(string, (Throwable)e$iv2);
            }
            if (p instanceof GlobStar) {
                $receiver$iv2 = MinimatchKt.access$getLOG$p();
                e$iv2 = null;
                if ($receiver$iv2.isDebugEnabled()) {
                    logger = $receiver$iv2;
                    string = "GLOBSTAR [" + pattern + ", " + p + ", " + f + ']';
                    logger.debug(string, (Throwable)e$iv2);
                }
                int fr = fi;
                int pr = pi + 1;
                if (pr == pl) {
                    MinimatchKt.access$getLOG$p().debug("** at the end");
                    while (fi < fl) {
                        CharSequence item = file.get(fi);
                        if (Intrinsics.areEqual((Object)item, (Object)".") || Intrinsics.areEqual((Object)item, (Object)"..") || !this.options.getDot() && StringsKt.startsWith$default((CharSequence)item, (char)'.', (boolean)false, (int)2, null)) {
                            return false;
                        }
                        ++fi;
                    }
                    return true;
                }
                while (fr < fl) {
                    CharSequence swallowee = file.get(fr);
                    Logger $receiver$iv3 = MinimatchKt.access$getLOG$p();
                    Exception e$iv3 = null;
                    if ($receiver$iv3.isDebugEnabled()) {
                        logger = $receiver$iv3;
                        string = "\nglobstar while " + file + ' ' + fr + ' ' + pattern + ' ' + pr + ' ' + swallowee;
                        logger.debug(string, (Throwable)e$iv3);
                    }
                    if (this.matchOne(file.subList(fr, file.size()), pattern.subList(pr, pattern.size()), partial)) {
                        $receiver$iv3 = MinimatchKt.access$getLOG$p();
                        e$iv3 = null;
                        if ($receiver$iv3.isDebugEnabled()) {
                            logger = $receiver$iv3;
                            string = "globstar found match! " + fr + ' ' + fl + ' ' + swallowee;
                            logger.debug(string, (Throwable)e$iv3);
                        }
                        return true;
                    }
                    if (Intrinsics.areEqual((Object)swallowee, (Object)".") || Intrinsics.areEqual((Object)swallowee, (Object)"..") || !this.options.getDot() && StringsKt.startsWith$default((CharSequence)swallowee, (char)'.', (boolean)false, (int)2, null)) {
                        $receiver$iv3 = MinimatchKt.access$getLOG$p();
                        e$iv3 = null;
                        if (!$receiver$iv3.isDebugEnabled()) break;
                        logger = $receiver$iv3;
                        string = "dot detected! " + file + ' ' + fr + ' ' + pattern + ' ' + pr;
                        logger.debug(string, (Throwable)e$iv3);
                        break;
                    }
                    MinimatchKt.access$getLOG$p().debug("globstar swallow a segment, and continue");
                    int $receiver$iv22 = fr;
                    fr = $receiver$iv22 + 1;
                }
                if (partial) {
                    Logger $receiver$iv4 = MinimatchKt.access$getLOG$p();
                    Exception e$iv4 = null;
                    if ($receiver$iv4.isDebugEnabled()) {
                        logger = $receiver$iv4;
                        string = "\n>>> no match, partial? " + file + ' ' + fr + ' ' + pattern + ' ' + pr;
                        logger.debug(string, (Throwable)e$iv4);
                    }
                    if (fr == fl) {
                        return true;
                    }
                }
                return false;
            }
            if (!p.match(f, this.options)) {
                $receiver$iv2 = MinimatchKt.access$getLOG$p();
                e$iv2 = null;
                if ($receiver$iv2.isDebugEnabled()) {
                    logger = $receiver$iv2;
                    string = "pattern match " + p + ' ' + f + " false";
                    logger.debug(string, (Throwable)e$iv2);
                }
                return false;
            }
            $receiver$iv2 = MinimatchKt.access$getLOG$p();
            e$iv2 = null;
            if (!$receiver$iv2.isDebugEnabled()) continue;
            logger = $receiver$iv2;
            string = "pattern match " + p + ' ' + f + " true";
            logger.debug(string, (Throwable)e$iv2);
        }
        if (fi == fl && pi == pl) {
            return true;
        }
        if (fi == fl) {
            return partial;
        }
        if (pi == pl) {
            CharSequence charSequence;
            return fi == fl - 1 && (charSequence = file.get(fi)).length() == 0;
        }
        throw (Throwable)new IllegalStateException("");
    }

    @JvmOverloads
    public final boolean match(@NotNull String input, boolean partial) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return this.match(input, DefaultPathAdapter.INSTANCE, partial);
    }

    @JvmOverloads
    public static /* synthetic */ boolean match$default(Minimatch minimatch, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return minimatch.match(string, bl);
    }

    @JvmOverloads
    public final boolean match(@NotNull String input) {
        return Minimatch.match$default(this, input, false, 2, null);
    }

    @JvmOverloads
    public final <T> boolean match(T input, @NotNull PathAdapter<? super T> adapter, boolean partial) {
        String string;
        Logger logger;
        Intrinsics.checkParameterIsNotNull(adapter, (String)"adapter");
        Logger $receiver$iv = MinimatchKt.access$getLOG$p();
        Exception e$iv = null;
        if ($receiver$iv.isDebugEnabled()) {
            logger = $receiver$iv;
            string = "match " + input + ' ' + this.pattern;
            logger.debug(string, (Throwable)e$iv);
        }
        if (this.comment) {
            return false;
        }
        List<String> file = adapter.toArray(input, this.options);
        if (this.empty) {
            return file.isEmpty();
        }
        Logger $receiver$iv2 = MinimatchKt.access$getLOG$p();
        Exception e$iv2 = null;
        if ($receiver$iv2.isDebugEnabled()) {
            logger = $receiver$iv2;
            string = this.pattern + " split " + file;
            logger.debug(string, (Throwable)e$iv2);
        }
        return this.match(file, partial);
    }

    @JvmOverloads
    public static /* synthetic */ boolean match$default(Minimatch minimatch, Object object, PathAdapter pathAdapter, boolean bl, int n, Object object2) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return minimatch.match(object, pathAdapter, bl);
    }

    @JvmOverloads
    public final <T> boolean match(T input, @NotNull PathAdapter<? super T> adapter) {
        return Minimatch.match$default(this, input, adapter, false, 4, null);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(object != null ? object.getClass() : null, this.getClass()) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.util.text.minimatch.Minimatch");
        }
        Minimatch cfr_ignored_0 = (Minimatch)object2;
        if (Intrinsics.areEqual((Object)this.options, (Object)((Minimatch)other).options) ^ true) {
            return false;
        }
        if (this.comment != ((Minimatch)other).comment) {
            return false;
        }
        if (this.empty != ((Minimatch)other).empty) {
            return false;
        }
        if (this.negate != ((Minimatch)other).negate) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.pattern, (Object)((Minimatch)other).pattern) ^ true);
    }

    public int hashCode() {
        int result = this.options.hashCode();
        result = 31 * result + Boolean.hashCode(this.comment);
        result = 31 * result + Boolean.hashCode(this.empty);
        result = 31 * result + Boolean.hashCode(this.negate);
        result = 31 * result + this.pattern.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return this.pattern;
    }

    @NotNull
    public final MinimatchOptions getOptions() {
        return this.options;
    }

    @JvmOverloads
    public Minimatch(@NotNull String pattern, @NotNull MinimatchOptions options) {
        Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        this.options = options;
        String normalizedPattern = this.options.getAllowWindowsPaths() ? MinimatchKt.replaceEscapedBackSlash(pattern) : pattern;
        boolean bl = this.comment = !this.options.getNocomment() && StringsKt.startsWith$default((CharSequence)normalizedPattern, (char)'#', (boolean)false, (int)2, null);
        if (this.comment) {
            this.pattern = normalizedPattern;
            this.set = CollectionsKt.emptyList();
            this.negate = false;
        } else {
            if (this.options.getNonegate()) {
                this.pattern = normalizedPattern;
                this.negate = false;
            } else {
                String string;
                int negateOffset;
                boolean negate = false;
                for (negateOffset = 0; negateOffset < pattern.length() && pattern.charAt(negateOffset) == '!'; ++negateOffset) {
                    negate = !negate;
                }
                this.negate = negate;
                Minimatch minimatch = this;
                if (negateOffset > 0) {
                    String string2 = pattern;
                    Minimatch minimatch2 = minimatch;
                    String string3 = string2.substring(negateOffset);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                    String string4 = string3;
                    minimatch = minimatch2;
                    string = string4;
                } else {
                    string = pattern;
                }
                minimatch.pattern = string;
            }
            this.set = this.make();
        }
    }

    @JvmOverloads
    public /* synthetic */ Minimatch(String string, MinimatchOptions minimatchOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            minimatchOptions = new MinimatchOptions(false, false, false, false, false, false, false, false, false, false, 1023, null);
        }
        this(string, minimatchOptions);
    }

    @JvmOverloads
    public Minimatch(@NotNull String pattern) {
        this(pattern, null, 2, null);
    }
}

