/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.boilerplate.express;

import com.intellij.util.ObjectUtils;
import com.jetbrains.nodejs.util.ui.WithDisplayName;
import gnu.trove.TIntArrayList;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodePackageVersion
implements Comparable<NodePackageVersion>,
WithDisplayName {
    private final String myRawVersion;
    private final TIntArrayList myVersionComponents;
    private final String myLabel;
    private final int myLabelVersion;
    private boolean mySelectByDefault;

    private NodePackageVersion(@NotNull String rawVersion, @NotNull TIntArrayList versionComponents, @Nullable String label, @Nullable Integer labelVersion) {
        if (rawVersion == null) {
            NodePackageVersion.$$$reportNull$$$0(0);
        }
        if (versionComponents == null) {
            NodePackageVersion.$$$reportNull$$$0(1);
        }
        if (label == null && labelVersion != null) {
            throw new IllegalArgumentException("labelVersion can not be not-null when label is null");
        }
        this.myRawVersion = rawVersion;
        this.myVersionComponents = versionComponents;
        this.myLabel = label;
        this.myLabelVersion = (Integer)ObjectUtils.notNull((Object)labelVersion, (Object)-1);
        this.mySelectByDefault = false;
    }

    public boolean isStable() {
        return this.myLabel == null;
    }

    @Nullable
    private static Integer toInteger(@NotNull String str) {
        if (str == null) {
            NodePackageVersion.$$$reportNull$$$0(2);
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public void setSelectedByDefault(boolean selectedByDefault) {
        this.mySelectByDefault = selectedByDefault;
    }

    public boolean isSelectByDefault() {
        return this.mySelectByDefault;
    }

    @NotNull
    public String getRawVersion() {
        String string = this.myRawVersion;
        if (string == null) {
            NodePackageVersion.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public TIntArrayList getVersionComponents() {
        TIntArrayList tIntArrayList = this.myVersionComponents;
        if (tIntArrayList == null) {
            NodePackageVersion.$$$reportNull$$$0(4);
        }
        return tIntArrayList;
    }

    public String toString() {
        return "(rawVersion: '" + this.myRawVersion + "', integerComponents: " + this.myVersionComponents + ", label: " + this.myLabel + ", labelVersion: " + this.myLabelVersion + ", selectedByDefault: " + this.mySelectByDefault + ")";
    }

    @Override
    public int compareTo(@NotNull NodePackageVersion other) {
        if (other == null) {
            NodePackageVersion.$$$reportNull$$$0(5);
        }
        int minSize = Math.min(this.myVersionComponents.size(), other.myVersionComponents.size());
        for (int i = 0; i < minSize; ++i) {
            int otherV;
            int thisV = this.myVersionComponents.get(i);
            if (thisV == (otherV = other.myVersionComponents.get(i))) continue;
            return otherV - thisV;
        }
        int sizeDiff = other.myVersionComponents.size() - this.myVersionComponents.size();
        if (sizeDiff != 0) {
            if (this.myLabel != null) {
                if (other.myLabel != null) {
                    return sizeDiff;
                }
                return 1;
            }
            if (other.myLabel != null) {
                return -1;
            }
            return sizeDiff;
        }
        if (this.myLabel == null) {
            if (other.myLabel == null) {
                return 0;
            }
            return -1;
        }
        if (other.myLabel == null) {
            return 1;
        }
        int cmp = other.myLabel.compareTo(this.myLabel);
        if (cmp != 0) {
            return cmp;
        }
        return other.myLabelVersion - this.myLabelVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodePackageVersion that = (NodePackageVersion)o;
        return this.myRawVersion.equals(that.myRawVersion);
    }

    public int hashCode() {
        return this.myRawVersion.hashCode();
    }

    @NotNull
    public static NodePackageVersion createFromRawVersion(@NotNull String version) {
        if (version == null) {
            NodePackageVersion.$$$reportNull$$$0(6);
        }
        StringTokenizer tokenizer = new StringTokenizer(version, ".", false);
        TIntArrayList versionComponents = new TIntArrayList();
        StringBuilder nonDigitBuffer = new StringBuilder();
        boolean digits = true;
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            Integer intComp = NodePackageVersion.toInteger(token);
            if (intComp != null && digits) {
                versionComponents.add(intComp.intValue());
                continue;
            }
            digits = false;
            if (nonDigitBuffer.length() > 0) {
                nonDigitBuffer.append(".");
            }
            nonDigitBuffer.append(token);
        }
        String label = null;
        Integer labelVersion = null;
        if (nonDigitBuffer.length() > 0) {
            int j;
            int i;
            StringBuilder prefixDigits = new StringBuilder();
            StringBuilder suffixDigits = new StringBuilder();
            for (i = 0; i < nonDigitBuffer.length() && Character.isDigit(nonDigitBuffer.charAt(i)); ++i) {
                prefixDigits.append(nonDigitBuffer.charAt(i));
            }
            for (j = nonDigitBuffer.length() - 1; j >= 0 && Character.isDigit(nonDigitBuffer.charAt(j)); --j) {
                suffixDigits.insert(0, nonDigitBuffer.charAt(j));
            }
            if (i < j) {
                label = nonDigitBuffer.substring(i, j + 1);
                Integer prefix = NodePackageVersion.toInteger(prefixDigits.toString());
                if (prefix != null) {
                    versionComponents.add(prefix.intValue());
                }
                labelVersion = NodePackageVersion.toInteger(suffixDigits.toString());
            }
        }
        NodePackageVersion nodePackageVersion = new NodePackageVersion(version, versionComponents, label, labelVersion);
        if (nodePackageVersion == null) {
            NodePackageVersion.$$$reportNull$$$0(7);
        }
        return nodePackageVersion;
    }

    @Override
    public String getDisplayName() {
        return this.getRawVersion();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawVersion";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionComponents";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/boilerplate/express/NodePackageVersion";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/boilerplate/express/NodePackageVersion";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawVersion";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionComponents";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromRawVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "toInteger";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createFromRawVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

