/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.base;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;

public abstract class BaseAttributeRefactoringHandler
implements RefactoringActionHandler {
    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        XmlAttribute selectedAttribute;
        if (project == null) {
            BaseAttributeRefactoringHandler.$$$reportNull$$$0(0);
        }
        if ((selectedAttribute = BaseAttributeRefactoringHandler.findSelectedAttribute(editor, file)) == null) {
            String message = "Cannot perform the refactoring.\nThe caret should be positioned at the attribute to be refactored.";
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Cannot perform the refactoring.\nThe caret should be positioned at the attribute to be refactored.", (String)this.getRefactoringName(), (String)this.getHelpID());
        } else if (selectedAttribute.getValue() == null) {
            String message = "Cannot perform the refactoring.\nThe attribute is incomplete.";
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Cannot perform the refactoring.\nThe attribute is incomplete.", (String)this.getRefactoringName(), (String)this.getHelpID());
        } else {
            this.handleAttribute(selectedAttribute, project);
        }
    }

    protected abstract String getHelpID();

    protected abstract String getRefactoringName();

    private static XmlAttribute findSelectedAttribute(Editor editor, PsiFile file) {
        ScrollingModel scrollingModel = editor.getScrollingModel();
        scrollingModel.scrollToCaret(ScrollType.MAKE_VISIBLE);
        CaretModel caretModel = editor.getCaretModel();
        int position = caretModel.getOffset();
        for (PsiElement element = file.findElementAt(position); element != null; element = element.getParent()) {
            if (!(element instanceof XmlAttribute)) continue;
            return (XmlAttribute)element;
        }
        return null;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            BaseAttributeRefactoringHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            BaseAttributeRefactoringHandler.$$$reportNull$$$0(2);
        }
        if (elements.length == 1 && elements[0] instanceof XmlAttribute) {
            this.handleAttribute((XmlAttribute)elements[0], project);
        }
    }

    protected abstract void handleAttribute(XmlAttribute var1, Project var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "com/sixrr/xrp/base/BaseAttributeRefactoringHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

