/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduce;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6ReferenceList;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSGenericSignature;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSPackage;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIntroducedExpressionUtil {
    private JSIntroducedExpressionUtil() {
    }

    @Nullable
    public static List<Pair<JSExpression, TextRange>> findExpressionsInRange(@NotNull PsiFile file2, int startOffset, int endOffset) {
        if (file2 == null) {
            JSIntroducedExpressionUtil.$$$reportNull$$$0(0);
        }
        PsiElement element1 = file2.findElementAt(startOffset);
        if (startOffset == endOffset) {
            ArrayList<Pair<JSExpression, TextRange>> result2 = new ArrayList<Pair<JSExpression, TextRange>>();
            element1 = file2.findElementAt(startOffset - 1);
            for (element1 = JSIntroducedExpressionUtil.adjustElement(startOffset, element1); element1 != null && !(element1 instanceof JSStatement); element1 = element1.getParent()) {
                if (element1 instanceof JSExpression) {
                    if (JSIntroducedExpressionUtil.isInvalidExpression(element1) || JSIntroducedExpressionUtil.isMethodExpression(element1)) continue;
                    result2.add((Pair<JSExpression, TextRange>)new Pair((Object)((JSExpression)element1), null));
                    continue;
                }
                if (!(element1 instanceof JSArgumentList) && !result2.isEmpty()) break;
            }
            return result2;
        }
        if (element1 instanceof PsiWhiteSpace) {
            startOffset = element1.getTextRange().getEndOffset();
            element1 = PsiTreeUtil.nextLeaf((PsiElement)element1);
        }
        PsiElement element2 = file2.findElementAt(endOffset - 1);
        while (element2 instanceof PsiWhiteSpace || element2 != null && element2.getNode().getElementType() == JSTokenTypes.SEMICOLON) {
            endOffset = element2.getTextRange().getStartOffset();
            element2 = PsiTreeUtil.prevLeaf((PsiElement)element2);
        }
        TextRange range = new TextRange(startOffset, endOffset);
        JSExpression expression = (JSExpression)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file2, (int)startOffset, (int)endOffset, JSExpression.class);
        if (expression != null && expression.getTextRange().getEndOffset() < range.getEndOffset()) {
            expression = null;
        }
        if (expression != null && JSIntroducedExpressionUtil.isInvalidExpression((PsiElement)expression)) {
            return null;
        }
        if (expression != null && JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)expression) != ReadWriteAccessDetector.Access.Read) {
            return null;
        }
        if (expression != null) {
            return ContainerUtil.list((Object[])new Pair[]{new Pair((Object)expression, null)});
        }
        if (element1 == null || element2 == null) {
            return null;
        }
        JSExpression element1ExpressionParent = (JSExpression)PsiTreeUtil.getParentOfType((PsiElement)element1, JSExpression.class);
        JSExpression element2ExpressionParent = (JSExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, JSExpression.class);
        if (element1ExpressionParent == null || element2ExpressionParent == null) {
            return null;
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)element1ExpressionParent, (PsiElement)element2ExpressionParent);
        if (!(parent instanceof JSExpression)) {
            return null;
        }
        if (parent instanceof JSLiteralExpression) {
            if (parent instanceof JSXmlLiteralExpression && !((JSXmlLiteralExpression)parent).getValue().getTextRange().contains(range)) {
                return null;
            }
            return ContainerUtil.list((Object[])new Pair[]{Pair.create((Object)((JSLiteralExpression)parent), (Object)range)});
        }
        if (range.contains(element1ExpressionParent.getTextRange()) && range.contains(element2ExpressionParent.getTextRange())) {
            PsiElement nextParent;
            while (!(parent instanceof JSBinaryExpression && parent.getTextRange().contains(range) || JSIntroducedExpressionUtil.elementNotAllowedInBinaryExpression(range, parent) || !((nextParent = parent.getParent()) instanceof JSExpression))) {
                parent = nextParent;
            }
            if (parent instanceof JSBinaryExpression) {
                if ((parent = JSIntroducedExpressionUtil.ensureNoIntersection(range, parent, element1ExpressionParent)) != null) {
                    parent = JSIntroducedExpressionUtil.ensureNoIntersection(range, parent, element2ExpressionParent);
                }
                if (parent != null) {
                    return ContainerUtil.list((Object[])new Pair[]{Pair.create((Object)((JSExpression)parent), (Object)range)});
                }
            }
        }
        return null;
    }

    private static PsiElement ensureNoIntersection(TextRange range, PsiElement parent, JSExpression element2ExpressionParent) {
        for (JSExpression e = element2ExpressionParent; e != parent; e = e.getParent()) {
            if (!JSIntroducedExpressionUtil.elementNotAllowedInBinaryExpression(range, (PsiElement)e)) continue;
            parent = null;
            break;
        }
        return parent;
    }

    public static PsiElement adjustElement(int startOffset, PsiElement element1) {
        JSExpression returnedExpression;
        JSReturnStatement ret;
        IElementType element1NodeType;
        if (element1 instanceof PsiWhiteSpace && startOffset == element1.getTextRange().getEndOffset()) {
            element1 = PsiTreeUtil.nextLeaf((PsiElement)element1);
        } else if (element1 != null && element1.getNode() != null && ((element1NodeType = element1.getNode().getElementType()) == JSTokenTypes.LPAR || element1NodeType == JSTokenTypes.LBRACKET || element1NodeType == JSTokenTypes.COMMA)) {
            element1 = PsiTreeUtil.nextLeaf((PsiElement)element1);
        }
        if (element1 != null && element1.getNode() != null && (element1.getNode().getElementType() == JSTokenTypes.SEMICOLON || element1.getNode().getElementType() == JSTokenTypes.RPAR)) {
            element1 = PsiTreeUtil.prevLeaf((PsiElement)element1);
        }
        if (element1 != null && element1.getNode() != null && element1.getNode().getElementType() == JSTokenTypes.RETURN_KEYWORD && (ret = (JSReturnStatement)PsiTreeUtil.getParentOfType((PsiElement)element1, JSReturnStatement.class)) != null && (returnedExpression = ret.getExpression()) != null) {
            element1 = returnedExpression.getFirstChild();
        }
        return element1;
    }

    private static boolean elementNotAllowedInBinaryExpression(TextRange range, PsiElement parent) {
        return parent instanceof JSParenthesizedExpression && !range.contains(parent.getTextRange());
    }

    private static boolean isMethodExpression(PsiElement element1) {
        return element1 instanceof JSReferenceExpression && element1.getParent() instanceof JSCallExpression;
    }

    private static boolean isInvalidExpression(PsiElement element) {
        return element instanceof JSReferenceExpression && JSIntroducedExpressionUtil.isInvalidRefExpr((JSReferenceExpression)element) || element instanceof JSDefinitionExpression || element instanceof JSLiteralExpression && element.getParent() instanceof TypeScriptModule || JSIntroducedExpressionUtil.isReferenceListMember(element) || JSIntroducedExpressionUtil.isInTypeContext(element) || element instanceof JSArrayLiteralExpression && element.getParent() instanceof JSNewExpression || element instanceof JSCallExpression && JSResolveUtil.getExpressionJSType((JSExpression)element) instanceof JSVoidType;
    }

    private static boolean isReferenceListMember(PsiElement element) {
        return element instanceof JSExpression && element.getParent() instanceof JSReferenceListMember && !(element.getParent().getParent() instanceof ES6ReferenceList);
    }

    private static boolean isInTypeContext(PsiElement element) {
        return element instanceof JSReferenceExpression && JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)JSResolveUtil.getTopReferenceExpression(element));
    }

    private static boolean isInvalidRefExpr(JSReferenceExpression element1) {
        PsiElement element1Parent = element1.getParent();
        return element1Parent instanceof JSGenericSignature || element1 instanceof TypeScriptEntityName || element1Parent instanceof JSDefinitionExpression || JSResolveUtil.isSelfReference((PsiElement)element1) || element1.getQualifier() == null && element1.resolve() instanceof JSClass || element1.resolve() instanceof JSPackage || element1Parent instanceof JSImportStatement;
    }

    public static Replacer createReplacer(@NotNull Pair<? extends JSExpression, TextRange> expressionDescriptor) {
        if (expressionDescriptor == null) {
            JSIntroducedExpressionUtil.$$$reportNull$$$0(1);
        }
        return new Replacer(expressionDescriptor);
    }

    public static boolean willReplacePartOfExpression(Pair<JSExpression, TextRange> expressionDescriptor) {
        return JSIntroducedExpressionUtil.willReplacePartOfExpression(JSIntroducedExpressionUtil.isIntroducingPartOfExpression(expressionDescriptor), (JSExpression)expressionDescriptor.first);
    }

    private static boolean willReplacePartOfExpression(boolean partialRangeSelected, @NotNull JSExpression occurrence) {
        if (occurrence == null) {
            JSIntroducedExpressionUtil.$$$reportNull$$$0(2);
        }
        if (occurrence instanceof JSXmlLiteralExpression && (occurrence.getParent() instanceof JSXmlLiteralExpression || partialRangeSelected)) {
            return true;
        }
        if (!partialRangeSelected) {
            return false;
        }
        return occurrence instanceof JSStringTemplateExpression || occurrence instanceof JSLiteralExpression && ((JSLiteralExpression)occurrence).isQuotedLiteral() || occurrence instanceof JSBinaryExpression;
    }

    private static boolean isIntroducingPartOfExpression(@NotNull Pair<? extends JSExpression, TextRange> descriptor2) {
        if (descriptor2 == null) {
            JSIntroducedExpressionUtil.$$$reportNull$$$0(3);
        }
        return descriptor2.second != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrence";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/refactoring/introduce/JSIntroducedExpressionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findExpressionsInRange";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createReplacer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "willReplacePartOfExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isIntroducingPartOfExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Replacer {
        private final JSExpression myExpression;
        private final String myExpressionText;
        private final TextRange myRelativeRange;
        private final boolean myIsIntroducingPartOfExpression;

        public Replacer(@NotNull Pair<? extends JSExpression, TextRange> expressionDescriptor) {
            if (expressionDescriptor == null) {
                Replacer.$$$reportNull$$$0(0);
            }
            this.myExpression = (JSExpression)expressionDescriptor.first;
            this.myIsIntroducingPartOfExpression = JSIntroducedExpressionUtil.isIntroducingPartOfExpression((Pair<? extends JSExpression, TextRange>)expressionDescriptor);
            JSExpression expression = (JSExpression)expressionDescriptor.first;
            TextRange range = (TextRange)expressionDescriptor.second;
            if (range == null) {
                range = expression.getTextRange();
            }
            if (expression instanceof JSXmlLiteralExpression && (expression.getParent() instanceof JSXmlLiteralExpression || this.isIntroducingPartOfExpression())) {
                expression = Replacer.findTopXmlLiteralExpression(expression);
            }
            this.myExpressionText = expression.getText();
            this.myRelativeRange = range.shiftLeft(expression.getTextRange().getStartOffset());
        }

        public JSExpression replaceExpression(@NotNull JSExpression replacementExpression) {
            if (replacementExpression == null) {
                Replacer.$$$reportNull$$$0(1);
            }
            return this.replaceOccurrence(this.myExpression, replacementExpression);
        }

        @Nullable
        public JSExpression replaceOccurrence(@NotNull JSExpression toReplace, @NotNull JSExpression replacementExpression) {
            JSExpression replaced;
            if (toReplace == null) {
                Replacer.$$$reportNull$$$0(2);
            }
            if (replacementExpression == null) {
                Replacer.$$$reportNull$$$0(3);
            }
            if (JSIntroducedExpressionUtil.willReplacePartOfExpression(this.isIntroducingPartOfExpression(), toReplace) && (replaced = this.tryReplacePartOfExpression(toReplace, replacementExpression)) != null) {
                int offset = this.myRelativeRange.getStartOffset();
                return Replacer.findReferenceToIntroduced(replaced, replacementExpression, offset);
            }
            return toReplace.replace(replacementExpression);
        }

        public String getIntroducedExpressionText() {
            String text = this.myExpressionText;
            text = this.myRelativeRange.substring(text);
            JSExpression expression = this.myExpression;
            if (expression instanceof JSXmlLiteralExpression) {
                return "<>" + text + "</>";
            }
            if (expression instanceof JSLiteralExpression) {
                if (((JSLiteralExpression)expression).isQuotedLiteral() && this.isIntroducingPartOfExpression()) {
                    String quote = this.myExpressionText.substring(0, 1);
                    return quote + text + quote;
                }
                return this.myExpressionText;
            }
            return text;
        }

        private static JSExpression findTopXmlLiteralExpression(JSExpression expression) {
            PsiElement myParent;
            while ((myParent = expression.getParent()) instanceof JSXmlLiteralExpression) {
                expression = (JSExpression)myParent;
            }
            return expression;
        }

        private boolean isIntroducingPartOfExpression() {
            return this.myIsIntroducingPartOfExpression;
        }

        @Nullable
        private JSExpression tryReplacePartOfExpression(@NotNull JSExpression toReplace, @NotNull JSExpression replacementExpression) {
            if (toReplace == null) {
                Replacer.$$$reportNull$$$0(4);
            }
            if (replacementExpression == null) {
                Replacer.$$$reportNull$$$0(5);
            }
            if (toReplace instanceof JSXmlLiteralExpression && (toReplace.getParent() instanceof JSXmlLiteralExpression || this.isIntroducingPartOfExpression())) {
                toReplace = Replacer.findTopXmlLiteralExpression(toReplace);
                String prefix = replacementExpression instanceof JSXmlLiteralExpression ? "" : "{";
                String suffix = replacementExpression instanceof JSXmlLiteralExpression ? "" : "}";
                return toReplace.replace(this.buildTextForReplacement(replacementExpression, prefix, suffix));
            }
            if (this.isIntroducingPartOfExpression()) {
                if (toReplace instanceof JSStringTemplateExpression) {
                    String prefix = "${";
                    String replacementText = this.myExpressionText.substring(0, this.myRelativeRange.getStartOffset()) + prefix + replacementExpression.getText() + "}" + this.myExpressionText.substring(this.myRelativeRange.getEndOffset());
                    JSExpression replacement = JSChangeUtil.createExpressionPsiWithContext(replacementText, (PsiElement)replacementExpression, JSExpression.class);
                    return toReplace.replace(replacement);
                }
                if (toReplace instanceof JSLiteralExpression && ((JSLiteralExpression)toReplace).isQuotedLiteral()) {
                    String quote = toReplace.getText().substring(0, 1);
                    return toReplace.replace(this.buildTextForReplacement(replacementExpression, quote + " + ", " + " + quote));
                }
                if (toReplace instanceof JSBinaryExpression) {
                    return toReplace.replace(this.buildTextForReplacement(replacementExpression, "", ""));
                }
            }
            return null;
        }

        @Nullable
        private JSExpression buildTextForReplacement(JSExpression refExpr, String quote, String quote2) {
            String text = "";
            if (this.myRelativeRange.getStartOffset() > 1) {
                text = text + this.myExpressionText.substring(0, this.myRelativeRange.getStartOffset()) + quote;
            }
            text = text + refExpr.getText();
            if (this.myRelativeRange.getEndOffset() < this.myExpressionText.length() - 1) {
                text = text + quote2 + this.myExpressionText.substring(this.myRelativeRange.getEndOffset());
            }
            return JSChangeUtil.createExpressionPsiWithContext(text, (PsiElement)refExpr, JSExpression.class);
        }

        @Nullable
        private static JSExpression findReferenceToIntroduced(@NotNull JSExpression topExpression, @NotNull JSExpression toSearch, int startOffset) {
            if (topExpression == null) {
                Replacer.$$$reportNull$$$0(6);
            }
            if (toSearch == null) {
                Replacer.$$$reportNull$$$0(7);
            }
            Ref result2 = new Ref();
            PsiTreeUtil.processElements((PsiElement)topExpression, element -> {
                if (toSearch == null) {
                    Replacer.$$$reportNull$$$0(8);
                }
                if (element instanceof JSExpression && element.getTextRange().getStartOffset() >= startOffset && StringUtil.equals((CharSequence)element.getText(), (CharSequence)toSearch.getText())) {
                    result2.set((Object)((JSExpression)element));
                    return false;
                }
                return true;
            });
            return (JSExpression)result2.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expressionDescriptor";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replacementExpression";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toReplace";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topExpression";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toSearch";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/refactoring/introduce/JSIntroducedExpressionUtil$Replacer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "replaceExpression";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "replaceOccurrence";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "tryReplacePartOfExpression";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findReferenceToIntroduced";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$findReferenceToIntroduced$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

