/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.util;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpContractUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.php.util.PhpContractUtil");

    private PhpContractUtil() {
    }

    public static void assertFqn(@NotNull String name) {
        if (name == null) {
            PhpContractUtil.$$$reportNull$$$0(0);
        }
        if (!PhpLangUtil.isFqn(name)) {
            LOG.error("The method designed for fully qualified names only. Got \"" + name + "\".");
        }
    }

    public static void assertNoQualifier(@Nullable String name) {
        if (name != null) {
            LOG.assertTrue(!PhpCodeInsightUtil.hasQualifier(name), (Object)("The method designed for unqualified names only. Got \"" + name + "\"."));
        }
    }

    public static void assertHasQualifier(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            PhpContractUtil.$$$reportNull$$$0(1);
        }
        LOG.assertTrue(PhpCodeInsightUtil.hasQualifier(qualifiedName), (Object)("The method designed for names with qualifiers only. Got \"" + qualifiedName + "\"."));
    }

    public static void assertScopeForUseOperator(@NotNull PhpPsiElement phpPsiElement) {
        if (phpPsiElement == null) {
            PhpContractUtil.$$$reportNull$$$0(2);
        }
        LOG.assertTrue(PhpCodeInsightUtil.isScopeForUseOperator(phpPsiElement), (Object)("The method designed for scope for use operator. Got \"" + phpPsiElement.getClass().getSimpleName() + "\"."));
    }

    public static void assertCompleteType(PhpType ... types) {
        if (types == null) {
            PhpContractUtil.$$$reportNull$$$0(3);
        }
        for (PhpType type : types) {
            LOG.assertTrue(type.isComplete(), (Object)"The method designed for complete types only. Please invoke global() before passing the object to the method");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpPsiElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/util/PhpContractUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "assertFqn";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "assertHasQualifier";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "assertScopeForUseOperator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "assertCompleteType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

