/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.docker;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.remote.DockerComposeCredentialsCase;
import com.intellij.docker.remote.DockerComposeCredentialsHolder;
import com.intellij.docker.remote.DockerComposeCredentialsType;
import com.intellij.docker.remote.DockerCredentialsCase;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.docker.remote.DockerCredentialsType;
import com.intellij.docker.remote.run.runtime.DockerUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.config.interpreters.PhpSdkFileTransfer;
import com.jetbrains.php.config.interpreters.PhpSdkHelpersManager;
import com.jetbrains.php.phpunit.coverage.PhpCoverageResultManager;
import com.jetbrains.php.remote.PhpRemoteProcessManager;
import com.jetbrains.php.remote.PhpRemoteProcessRunner;
import com.jetbrains.php.remote.docker.PhpDockerComposeRemoteProcessRunner;
import com.jetbrains.php.remote.docker.PhpDockerHelpersManager;
import com.jetbrains.php.remote.docker.PhpDockerProcessUtil;
import com.jetbrains.php.remote.docker.PhpDockerRemoteProcessRunner;
import com.jetbrains.php.remote.docker.PhpDockerSdkFileTransfer;
import com.jetbrains.php.remote.docker.phpunit.coverage.PhpDockerCoverageResultManager;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkAdditionalData;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDockerRemoteProcessManager
extends PhpRemoteProcessManager {
    private static final Logger LOG = Logger.getInstance(PhpDockerRemoteProcessRunner.class);
    private static final String DOCKER_NETWORK = "docker0";
    private static final String DEFAULT_REMOTE_HOST = "10.0.2.2";

    public boolean accepts(@NotNull PhpRemoteSdkAdditionalData data) {
        if (data == null) {
            PhpDockerRemoteProcessManager.$$$reportNull$$$0(0);
        }
        return data.getRemoteConnectionType() == DockerCredentialsType.getInstance() || data.getRemoteConnectionType() == DockerComposeCredentialsType.getInstance();
    }

    @NotNull
    public PhpRemoteProcessRunner getRemoteProcessRunner(@NotNull PhpRemoteSdkAdditionalData data) {
        if (data == null) {
            PhpDockerRemoteProcessManager.$$$reportNull$$$0(1);
        }
        if (data.getRemoteConnectionType() == DockerComposeCredentialsType.getInstance()) {
            PhpRemoteProcessRunner phpRemoteProcessRunner = PhpDockerComposeRemoteProcessRunner.getInstance();
            if (phpRemoteProcessRunner == null) {
                PhpDockerRemoteProcessManager.$$$reportNull$$$0(2);
            }
            return phpRemoteProcessRunner;
        }
        PhpRemoteProcessRunner phpRemoteProcessRunner = PhpDockerRemoteProcessRunner.getInstance();
        if (phpRemoteProcessRunner == null) {
            PhpDockerRemoteProcessManager.$$$reportNull$$$0(3);
        }
        return phpRemoteProcessRunner;
    }

    @NotNull
    public PhpSdkHelpersManager getSdkHelpersManager(@NotNull PhpRemoteSdkAdditionalData data) {
        if (data == null) {
            PhpDockerRemoteProcessManager.$$$reportNull$$$0(4);
        }
        PhpDockerHelpersManager phpDockerHelpersManager = new PhpDockerHelpersManager(data);
        if (phpDockerHelpersManager == null) {
            PhpDockerRemoteProcessManager.$$$reportNull$$$0(5);
        }
        return phpDockerHelpersManager;
    }

    @NotNull
    public PhpCoverageResultManager getCoverageResultManager(@NotNull PhpRemoteSdkAdditionalData data) {
        if (data == null) {
            PhpDockerRemoteProcessManager.$$$reportNull$$$0(6);
        }
        PhpDockerCoverageResultManager phpDockerCoverageResultManager = new PhpDockerCoverageResultManager(data);
        if (phpDockerCoverageResultManager == null) {
            PhpDockerRemoteProcessManager.$$$reportNull$$$0(7);
        }
        return phpDockerCoverageResultManager;
    }

    @NotNull
    public PhpSdkFileTransfer getSdkFileTransfer(@NotNull PhpRemoteSdkAdditionalData data) {
        if (data == null) {
            PhpDockerRemoteProcessManager.$$$reportNull$$$0(8);
        }
        PhpDockerSdkFileTransfer phpDockerSdkFileTransfer = new PhpDockerSdkFileTransfer();
        if (phpDockerSdkFileTransfer == null) {
            PhpDockerRemoteProcessManager.$$$reportNull$$$0(9);
        }
        return phpDockerSdkFileTransfer;
    }

    @NotNull
    public Map<String, String> getSdkProperties(@NotNull PhpRemoteSdkAdditionalData data) {
        if (data == null) {
            PhpDockerRemoteProcessManager.$$$reportNull$$$0(10);
        }
        final HashMap<String, String> keyToPattern = new HashMap<String, String>();
        data.switchOnConnectionType(new CredentialsCase[]{new DockerCredentialsCase(){

            public void process(DockerCredentialsHolder credentials) {
                String imageName = credentials.getImageName();
                ContainerUtil.putIfNotNull((Object)"image-name", (Object)StringUtil.nullize((String)imageName), (Map)keyToPattern);
                List split = StringUtil.split((String)imageName, (String)":");
                if (split.size() > 1) {
                    ContainerUtil.putIfNotNull((Object)"image-name-short", (Object)StringUtil.nullize((String)((String)split.get(0))), (Map)keyToPattern);
                }
            }
        }, new DockerComposeCredentialsCase(){

            public void process(DockerComposeCredentialsHolder credentials) {
                ContainerUtil.putIfNotNull((Object)"service", (Object)StringUtil.nullize((String)credentials.getComposeServiceName()), (Map)keyToPattern);
            }
        }});
        HashMap<String, String> hashMap = keyToPattern;
        if (hashMap == null) {
            PhpDockerRemoteProcessManager.$$$reportNull$$$0(11);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public String getRemoteHost(@NotNull Project project, @NotNull String interpreterName, @NotNull PhpRemoteSdkAdditionalData data) {
        String string;
        block11: {
            String string2;
            if (project == null) {
                PhpDockerRemoteProcessManager.$$$reportNull$$$0(12);
            }
            if (interpreterName == null) {
                PhpDockerRemoteProcessManager.$$$reportNull$$$0(13);
            }
            if (data == null) {
                PhpDockerRemoteProcessManager.$$$reportNull$$$0(14);
            }
            try {
                RemoteServer<DockerCloudConfiguration> docker = PhpDockerProcessUtil.getAccount((RemoteSdkAdditionalData)data);
                if (SystemInfo.isMac || SystemInfo.isWindows || !DockerUtil.isUnixSocket((DockerCloudConfiguration)((DockerCloudConfiguration)docker.getConfiguration()))) break block11;
                NetworkInterface docker0 = NetworkInterface.getByName(DOCKER_NETWORK);
                if (docker0 == null) {
                    throw new RemoteSdkException("Could not find docker0 network interface");
                }
                String address = PhpDockerRemoteProcessManager.getNetworkAddress(docker0);
                if (StringUtil.isEmpty((String)address)) {
                    throw new RemoteSdkException("No interface addresses for docker0 network interface");
                }
                string2 = address;
            }
            catch (RemoteSdkException | SocketException e) {
                LOG.warn("Failed to find a host from docker0 network interface", e);
                break block11;
            }
            if (string2 != null) return string2;
            PhpDockerRemoteProcessManager.$$$reportNull$$$0(15);
            return string2;
        }
        try {
            String address;
            NetworkInterface network;
            Enumeration<NetworkInterface> networks = NetworkInterface.getNetworkInterfaces();
            do {
                if (!networks.hasMoreElements()) return DEFAULT_REMOTE_HOST;
            } while (!PhpDockerRemoteProcessManager.accepts(network = networks.nextElement()) || !StringUtil.isNotEmpty((String)(address = PhpDockerRemoteProcessManager.getNetworkAddress(network))));
            string = address;
        }
        catch (SocketException e) {
            LOG.warn("Failed to find a local network address", (Throwable)e);
            return DEFAULT_REMOTE_HOST;
        }
        if (string != null) return string;
        PhpDockerRemoteProcessManager.$$$reportNull$$$0(16);
        return string;
    }

    private static boolean accepts(@NotNull NetworkInterface network) {
        if (network == null) {
            PhpDockerRemoteProcessManager.$$$reportNull$$$0(18);
        }
        try {
            return !StringUtil.equalsIgnoreCase((CharSequence)network.getName(), (CharSequence)DOCKER_NETWORK) && !network.isLoopback() && network.isUp();
        }
        catch (SocketException e) {
            LOG.warn("Failed to find a local network address", (Throwable)e);
            return false;
        }
    }

    @Nullable
    private static String getNetworkAddress(NetworkInterface docker0) {
        String resultAddress = null;
        for (InterfaceAddress address : docker0.getInterfaceAddresses()) {
            if (address.getBroadcast() != null) {
                return address.getAddress().getHostAddress();
            }
            resultAddress = address.getAddress().getHostAddress();
        }
        return resultAddress;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/remote/docker/PhpDockerRemoteProcessManager";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "network";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/remote/docker/PhpDockerRemoteProcessManager";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteProcessRunner";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkHelpersManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoverageResultManager";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkFileTransfer";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkProperties";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteHost";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accepts";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteProcessRunner";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSdkHelpersManager";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCoverageResultManager";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSdkFileTransfer";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSdkProperties";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteHost";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

