/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.twig.elements;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.twig.TwigTokenTypes;
import com.jetbrains.twig.elements.TwigBlockReference;
import com.jetbrains.twig.elements.TwigCompositeElement;
import com.jetbrains.twig.elements.TwigElementFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TwigBlockTag
extends TwigCompositeElement
implements PsiNamedElement {
    private TwigBlockReference myReference;

    public TwigBlockTag(@NotNull ASTNode node) {
        if (node == null) {
            TwigBlockTag.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Nullable
    public PsiElement findIdentifier() {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNode().getElementType() != TwigTokenTypes.IDENTIFIER) continue;
            return child;
        }
        return null;
    }

    @Override
    public String toString() {
        PsiElement identifier = this.findIdentifier();
        return "BlockTag('" + (identifier != null ? identifier.getText() : "?") + "')";
    }

    public PsiReference getReference() {
        PsiElement identifier = this.findIdentifier();
        if (identifier == null) {
            this.myReference = null;
        } else if (this.myReference == null || !this.myReference.getIdentifier().equals(identifier.getText())) {
            this.myReference = new TwigBlockReference(this.getProject(), this, new TextRange(0, this.getTextLength()));
        }
        return this.myReference;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        PsiElement identifier;
        PsiElement newIdentifier;
        if (name == null) {
            TwigBlockTag.$$$reportNull$$$0(1);
        }
        if ((newIdentifier = TwigElementFactory.createPsiElement(this.getProject(), "{% block " + name + " %}", TwigTokenTypes.IDENTIFIER)) != null && (identifier = this.findIdentifier()) != null) {
            identifier.replace(newIdentifier);
            return this;
        }
        throw new IncorrectOperationException("Can not rename block '" + this.toString() + "'");
    }

    @Nullable
    public String getName() {
        PsiElement identifier = this.findIdentifier();
        return identifier != null ? identifier.getText() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/twig/elements/TwigBlockTag";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

