/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.graphic.spreadsheet.time;

import com.projectlibre1.pm.graphic.spreadsheet.time.TimeSpreadSheet;
import com.projectlibre1.pm.graphic.spreadsheet.time.TimeSpreadSheetModel;
import com.projectlibre1.pm.graphic.timescale.CoordinatesConverter;
import com.projectlibre1.timescale.TimeInterval;
import com.projectlibre1.timescale.TimeIterator;
import com.projectlibre1.timescale.TimeScaleEvent;
import com.projectlibre1.timescale.TimeScaleListener;
import java.awt.Dimension;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

public class TimeSpreadSheetColumnModel
extends DefaultTableColumnModel
implements TimeScaleListener {
    protected CoordinatesConverter coord;
    protected TimeSpreadSheet spreadSheet;

    public TimeSpreadSheetColumnModel(TimeSpreadSheet timeSpreadSheet) {
        this.spreadSheet = timeSpreadSheet;
    }

    public void updateColumns() {
        while (this.getColumnCount() > 0) {
            this.removeColumn(this.getColumn(0));
            ((TimeSpreadSheetModel)this.spreadSheet.getModel()).decrementColumnCount();
        }
        if (this.coord == null) {
            return;
        }
        TimeSpreadSheetModel timeSpreadSheetModel = (TimeSpreadSheetModel)this.spreadSheet.getModel();
        TimeIterator timeIterator = this.coord.getProjectTimeIterator();
        timeSpreadSheetModel.resetTimeIntervals();
        int n = 1;
        while (timeIterator.hasNext()) {
            TimeInterval timeInterval = timeIterator.next();
            int n2 = (int)Math.round(this.coord.toW(timeInterval.getEnd1() - timeInterval.getStart1()));
            TableColumn tableColumn = new TableColumn(n, n2);
            tableColumn.setMinWidth(n2);
            tableColumn.setMaxWidth(n2);
            this.addColumn(tableColumn);
            timeSpreadSheetModel.incrementColumnCount();
            timeSpreadSheetModel.addTimeInterval(timeInterval);
            ++n;
        }
    }

    public CoordinatesConverter getCoord() {
        return this.coord;
    }

    public void setCoord(CoordinatesConverter coordinatesConverter) {
        if (this.coord != null) {
            this.coord.removeTimeScaleListener(this);
        }
        this.coord = coordinatesConverter;
        coordinatesConverter.addTimeScaleListener(this);
    }

    @Override
    public void timeScaleChanged(TimeScaleEvent timeScaleEvent) {
        this.updateColumns();
        this.spreadSheet.setPreferredSize(new Dimension((int)this.coord.toW(this.coord.getEnd() - this.coord.getOrigin()), this.spreadSheet.getPreferredSize().height));
        this.spreadSheet.revalidate();
    }
}

