/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import gnu.trove.TObjectIntHashMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DeploymentServersUsagesCollector
extends ProjectUsagesCollector {
    @NotNull
    public String getGroupId() {
        if ("statistics.deployment.servers" == null) {
            DeploymentServersUsagesCollector.$$$reportNull$$$0(0);
        }
        return "statistics.deployment.servers";
    }

    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project) {
        if (project == null) {
            DeploymentServersUsagesCollector.$$$reportNull$$$0(1);
        }
        List<WebServerConfig> servers = GroupedServersConfigManager.getInstance(project).getFlattenedServers();
        PublishConfig publishConfig = PublishConfig.getInstance(project);
        TObjectIntHashMap accessTypes = new TObjectIntHashMap();
        HashSet<UsageDescriptor> result = new HashSet<UsageDescriptor>();
        for (WebServerConfig server : servers) {
            if (!server.isUsedInProject(project, publishConfig, true)) continue;
            AccessType type = server.getFileTransferConfig().getAccessType();
            String key = type.name();
            if (type == AccessType.SFTP) {
                key = key + "." + server.getFileTransferConfig().getAuthType().name();
            }
            if (!accessTypes.increment((Object)key)) {
                accessTypes.put((Object)key, 1);
            }
            List<DeploymentPathMapping> mappings = publishConfig.getPathMappings(server.getId());
            int deploy = 0;
            int web = 0;
            for (DeploymentPathMapping mapping : mappings) {
                if (StringUtil.isEmpty((String)mapping.getLocalPath())) continue;
                if (!StringUtil.isEmpty((String)mapping.getDeployPath())) {
                    ++deploy;
                }
                if (StringUtil.isEmpty((String)mapping.getWebPath())) continue;
                ++web;
            }
            result.add(new UsageDescriptor("mappings." + StringUtil.notNullize((String)server.getId()).hashCode(), mappings.size()));
            result.add(new UsageDescriptor("mappings.deploy" + StringUtil.notNullize((String)server.getId()).hashCode(), deploy));
            result.add(new UsageDescriptor("mappings.web" + StringUtil.notNullize((String)server.getId()).hashCode(), web));
            String folder = server.getFileTransferConfig().getRootFolder();
            String rootPathKey = StringUtil.isEmptyOrSpaces((String)folder) ? "empty" : ("/".equals(folder) ? "trivial" : "nontrivial");
            result.add(new UsageDescriptor("root.path." + rootPathKey));
        }
        if (accessTypes.isEmpty()) {
            Set<UsageDescriptor> set = Collections.emptySet();
            if (set == null) {
                DeploymentServersUsagesCollector.$$$reportNull$$$0(2);
            }
            return set;
        }
        accessTypes.forEachEntry((a, b) -> {
            result.add(new UsageDescriptor(a, b));
            return true;
        });
        HashSet<UsageDescriptor> hashSet = result;
        if (hashSet == null) {
            DeploymentServersUsagesCollector.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/DeploymentServersUsagesCollector";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/DeploymentServersUsagesCollector";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsages";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getUsages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

