/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.access;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.database.access.DbCredentialManager;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.ide.passwordSafe.PasswordSafe;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0002J\u001e\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0007J$\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0002J\u001c\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004J\"\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004J0\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/access/DbCredentialManager;", "", "()V", "createServiceName", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "prefix", "get", "Lcom/intellij/credentialStore/Credentials;", "getAsync", "Ljava/util/concurrent/CompletionStage;", "getPasswordAsString", "getPasswordAsStringAsync", "set", "", "credentials", "useMasterKey", "", "intellij.database.impl"})
public final class DbCredentialManager {
    @JvmOverloads
    @Nullable
    public final Credentials get(@NotNull LocalDataSource dataSource, @Nullable String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        CredentialAttributes attributes = new CredentialAttributes(this.createServiceName(dataSource, prefix), dataSource.getUsername(), null, false, 12, null);
        PasswordSafe credentialStore = PasswordSafe.Companion.getInstance();
        Credentials credentials = credentialStore.get(attributes);
        if (credentials != null) {
            Credentials credentials2;
            Credentials it = credentials2 = credentials;
            return it;
        }
        return null;
    }

    @JvmOverloads
    @Nullable
    public static /* synthetic */ Credentials get$default(DbCredentialManager dbCredentialManager, LocalDataSource localDataSource, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return dbCredentialManager.get(localDataSource, string);
    }

    @JvmOverloads
    @Nullable
    public final Credentials get(@NotNull LocalDataSource dataSource) {
        return DbCredentialManager.get$default(this, dataSource, null, 2, null);
    }

    private final CompletionStage<Credentials> getAsync(LocalDataSource dataSource, String prefix) {
        CredentialAttributes attributes = new CredentialAttributes(this.createServiceName(dataSource, prefix), dataSource.getUsername(), null, false, 12, null);
        CompletableFuture completableFuture = CompletableFuture.supplyAsync(AsyncUtil.captureIndicator(new Supplier<T>(attributes){
            final /* synthetic */ CredentialAttributes $attributes;

            @Nullable
            public final Credentials get() {
                return PasswordSafe.Companion.getInstance().get(this.$attributes);
            }
            {
                this.$attributes = credentialAttributes;
            }
        }), AsyncUtil.POOL_EXECUTOR);
        Intrinsics.checkExpressionValueIsNotNull(completableFuture, (String)"supplyAsync(captureIndic\u2026 AsyncUtil.POOL_EXECUTOR)");
        return completableFuture;
    }

    static /* synthetic */ CompletionStage getAsync$default(DbCredentialManager dbCredentialManager, LocalDataSource localDataSource, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return dbCredentialManager.getAsync(localDataSource, string);
    }

    @Nullable
    public final String getPasswordAsString(@NotNull LocalDataSource dataSource, @Nullable String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        Credentials credentials = this.get(dataSource, prefix);
        return credentials != null ? credentials.getPasswordAsString() : null;
    }

    @Nullable
    public static /* synthetic */ String getPasswordAsString$default(DbCredentialManager dbCredentialManager, LocalDataSource localDataSource, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return dbCredentialManager.getPasswordAsString(localDataSource, string);
    }

    @NotNull
    public final CompletionStage<String> getPasswordAsStringAsync(@NotNull LocalDataSource dataSource, @Nullable String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        CompletionStage<String> completionStage = this.getAsync(dataSource, prefix).thenApply(getPasswordAsStringAsync.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(completionStage, (String)"getAsync(dataSource, pre\u2026?.getPasswordAsString() }");
        return completionStage;
    }

    @NotNull
    public static /* synthetic */ CompletionStage getPasswordAsStringAsync$default(DbCredentialManager dbCredentialManager, LocalDataSource localDataSource, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return dbCredentialManager.getPasswordAsStringAsync(localDataSource, string);
    }

    @JvmOverloads
    public final void set(@NotNull LocalDataSource dataSource, @Nullable Credentials credentials, boolean useMasterKey, @Nullable String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        CredentialAttributes attributes = new CredentialAttributes(this.createServiceName(dataSource, prefix), dataSource.getUsername(), null, false, 12, null);
        PasswordSafe.Companion.getInstance().set(attributes, credentials, !useMasterKey);
    }

    @JvmOverloads
    public static /* synthetic */ void set$default(DbCredentialManager dbCredentialManager, LocalDataSource localDataSource, Credentials credentials, boolean bl, String string, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            string = null;
        }
        dbCredentialManager.set(localDataSource, credentials, bl, string);
    }

    @JvmOverloads
    public final void set(@NotNull LocalDataSource dataSource, @Nullable Credentials credentials, boolean useMasterKey) {
        DbCredentialManager.set$default(this, dataSource, credentials, useMasterKey, null, 8, null);
    }

    @JvmOverloads
    public final void set(@NotNull LocalDataSource dataSource, @Nullable Credentials credentials) {
        DbCredentialManager.set$default(this, dataSource, credentials, false, null, 12, null);
    }

    private final String createServiceName(LocalDataSource dataSource, String prefix) {
        return CredentialAttributesKt.generateServiceName((String)"DB", (String)((prefix == null ? "" : String.valueOf(prefix)) + dataSource.getUniqueId()));
    }
}

