/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm;

import com.intellij.ide.actions.CreateFileFromTemplateAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageJsonUtil {
    public static final String FILE_NAME = "package.json";
    public static final String DEPENDENCIES = "dependencies";
    public static final String DEV_DEPENDENCIES = "devDependencies";
    private static final Key<CachedPackageJsonData> CACHED_PACKAGE_JSON_DATA_KEY = Key.create((String)"js.cached.package-json.data");
    private static final String TEMPLATE_NAME = "package.json";
    private static final List<String> DEPENDENCIES_KEY = ContainerUtil.newArrayList((Object[])new String[]{"dependencies", "devDependencies", "optionalDependencies", "peerDependencies", "bundledDependencies", "bundleDependencies"});

    private PackageJsonUtil() {
    }

    public static boolean isInsidePackageJsonFile(@NotNull PsiElement element) {
        if (element == null) {
            PackageJsonUtil.$$$reportNull$$$0(0);
        }
        return PackageJsonUtil.getContainingPackageJsonFile(element) != null;
    }

    @Nullable
    public static JsonFile getContainingPackageJsonFile(@NotNull PsiElement element) {
        PsiFile file2;
        if (element == null) {
            PackageJsonUtil.$$$reportNull$$$0(1);
        }
        return PackageJsonUtil.isPackageJsonFile(file2 = element.getContainingFile()) ? (JsonFile)file2 : null;
    }

    @Contract(value="null -> false")
    public static boolean isPackageJsonFile(@Nullable PsiFile file2) {
        return file2 instanceof JsonFile && "package.json".equals(file2.getName());
    }

    @Contract(value="null -> false")
    public static boolean isPackageJsonFile(@Nullable VirtualFile file2) {
        return file2 != null && !file2.isDirectory() && StringUtil.equals((CharSequence)"package.json", (CharSequence)file2.getNameSequence());
    }

    public static boolean isTopLevelProperty(@NotNull JsonProperty property) {
        PsiElement parent;
        if (property == null) {
            PackageJsonUtil.$$$reportNull$$$0(2);
        }
        return (parent = property.getParent()) != null && parent.getParent() instanceof JsonFile;
    }

    @Nullable
    public static JsonProperty findContainingProperty(@NotNull PsiElement element) {
        if (element == null) {
            PackageJsonUtil.$$$reportNull$$$0(3);
        }
        if (PackageJsonUtil.isInsidePackageJsonFile(element)) {
            return (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)element, JsonProperty.class, (boolean)false);
        }
        return null;
    }

    @Nullable
    public static JsonProperty findContainingTopLevelProperty(@Nullable PsiElement element) {
        if (element == null || !PackageJsonUtil.isInsidePackageJsonFile(element)) {
            return null;
        }
        JsonProperty property = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)element, JsonProperty.class, (boolean)false);
        while (property != null && !PackageJsonUtil.isTopLevelProperty(property)) {
            property = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)property, JsonProperty.class, (boolean)true);
        }
        return property;
    }

    public static boolean isPackageDependencyProperty(@NotNull JsonProperty property) {
        JsonObject obj;
        if (property == null) {
            PackageJsonUtil.$$$reportNull$$$0(4);
        }
        if ((obj = (JsonObject)ObjectUtils.tryCast((Object)property.getParent(), JsonObject.class)) != null) {
            JsonProperty dependenciesProperty = (JsonProperty)ObjectUtils.tryCast((Object)obj.getParent(), JsonProperty.class);
            return dependenciesProperty != null && DEPENDENCIES_KEY.contains(dependenciesProperty.getName()) && PackageJsonUtil.isTopLevelProperty(dependenciesProperty);
        }
        return false;
    }

    public static boolean isPackageDependenciesProperty(@Nullable JsonProperty property) {
        return property != null && DEPENDENCIES_KEY.contains(property.getName());
    }

    public static void processUpPackageJsonFiles(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull Processor<? super VirtualFile> processor) {
        if (project == null) {
            PackageJsonUtil.$$$reportNull$$$0(5);
        }
        if (fileOrDir == null) {
            PackageJsonUtil.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            PackageJsonUtil.$$$reportNull$$$0(7);
        }
        ReadAction.run(() -> {
            VirtualFile dir;
            if (project == null) {
                PackageJsonUtil.$$$reportNull$$$0(25);
            }
            if (fileOrDir == null) {
                PackageJsonUtil.$$$reportNull$$$0(26);
            }
            if (processor == null) {
                PackageJsonUtil.$$$reportNull$$$0(27);
            }
            if (project.isDisposed()) {
                return;
            }
            ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
            VirtualFile virtualFile = dir = fileOrDir.isDirectory() ? fileOrDir : fileOrDir.getParent();
            if (dir == null) {
                return;
            }
            VirtualFile contentRoot = fileIndex.getContentRootForFile(dir, false);
            while (dir != null && contentRoot != null) {
                VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile(dir);
                if (packageJson != null && !processor.process((Object)packageJson)) {
                    return;
                }
                if (dir.equals(contentRoot)) {
                    if ((dir = dir.getParent()) == null) {
                        return;
                    }
                    contentRoot = fileIndex.getContentRootForFile(dir, false);
                    continue;
                }
                dir = dir.getParent();
            }
        });
    }

    @Nullable
    public static VirtualFile findUpPackageJson(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            PackageJsonUtil.$$$reportNull$$$0(8);
        }
        Ref ref = Ref.create();
        PackageJsonUtil.processUpPackageJsonFilesInAllScope(fileOrDir, (Processor<? super VirtualFile>)((Processor)file2 -> {
            ref.set(file2);
            return false;
        }));
        return (VirtualFile)ref.get();
    }

    public static void processUpPackageJsonFilesInAllScope(@NotNull VirtualFile fileOrDir, @NotNull Processor<? super VirtualFile> processor) {
        if (fileOrDir == null) {
            PackageJsonUtil.$$$reportNull$$$0(9);
        }
        if (processor == null) {
            PackageJsonUtil.$$$reportNull$$$0(10);
        }
        ReadAction.run(() -> {
            VirtualFile dir;
            if (fileOrDir == null) {
                PackageJsonUtil.$$$reportNull$$$0(23);
            }
            if (processor == null) {
                PackageJsonUtil.$$$reportNull$$$0(24);
            }
            VirtualFile virtualFile = dir = fileOrDir.isDirectory() ? fileOrDir : fileOrDir.getParent();
            if (dir == null) {
                return;
            }
            while (dir != null) {
                VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile(dir);
                if (packageJson != null && !processor.process((Object)packageJson)) {
                    return;
                }
                dir = dir.getParent();
            }
        });
    }

    @NotNull
    public static List<JsonProperty> listAllPackageProperties(@NotNull JsonFile file2) {
        if (file2 == null) {
            PackageJsonUtil.$$$reportNull$$$0(11);
        }
        JsonObject obj = (JsonObject)ObjectUtils.tryCast((Object)file2.getTopLevelValue(), JsonObject.class);
        ArrayList<JsonProperty> result2 = new ArrayList<JsonProperty>();
        if (obj != null) {
            for (JsonProperty property : obj.getPropertyList()) {
                JsonObject depObj;
                if (!DEPENDENCIES_KEY.contains(property.getName()) || (depObj = (JsonObject)ObjectUtils.tryCast((Object)property.getValue(), JsonObject.class)) == null) continue;
                result2.addAll(depObj.getPropertyList());
            }
        }
        ArrayList<JsonProperty> arrayList = result2;
        if (arrayList == null) {
            PackageJsonUtil.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    public static PackageJsonData getOrCreateData(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            PackageJsonUtil.$$$reportNull$$$0(13);
        }
        PackageJsonData packageJsonData = PackageJsonUtil.getOrCreateData(packageJson, false);
        if (packageJsonData == null) {
            PackageJsonUtil.$$$reportNull$$$0(14);
        }
        return packageJsonData;
    }

    @NotNull
    public static PackageJsonData getOrCreateData(@NotNull VirtualFile packageJson, boolean refresh) {
        long documentModificationStamp;
        if (packageJson == null) {
            PackageJsonUtil.$$$reportNull$$$0(15);
        }
        if (refresh) {
            VfsUtil.markDirtyAndRefresh((ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isReadAccessAllowed() ? 1 : 0) != 0, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{packageJson});
        }
        Document document = FileDocumentManager.getInstance().getCachedDocument(packageJson);
        CachedPackageJsonData cached = (CachedPackageJsonData)CACHED_PACKAGE_JSON_DATA_KEY.get((UserDataHolder)packageJson);
        long l = documentModificationStamp = document != null ? document.getModificationStamp() : -1L;
        if (cached == null || cached.getFileModificationStamp() != packageJson.getModificationStamp() || cached.getDocumentModificationStamp() != documentModificationStamp) {
            PackageJsonData data = PackageJsonData.parse(packageJson, document);
            cached = new CachedPackageJsonData(data, packageJson.getModificationStamp(), documentModificationStamp);
            CACHED_PACKAGE_JSON_DATA_KEY.set((UserDataHolder)packageJson, (Object)cached);
        }
        PackageJsonData packageJsonData = cached.getData();
        if (packageJsonData == null) {
            PackageJsonUtil.$$$reportNull$$$0(16);
        }
        return packageJsonData;
    }

    @Nullable
    public static PsiFile createPackageJson(@NotNull PsiDirectory psiDir, boolean openFile) {
        VirtualFile virtualFile;
        if (psiDir == null) {
            PackageJsonUtil.$$$reportNull$$$0(17);
        }
        FileTemplate template = FileTemplateManager.getInstance((Project)psiDir.getProject()).getInternalTemplate("package.json");
        Map defaultValues = ContainerUtil.newHashMap((Pair)Pair.create((Object)"name", (Object)psiDir.getName()), (Pair[])new Pair[]{Pair.create((Object)"version", (Object)"1.0.0")});
        if (!openFile) {
            String text = template.getText();
            for (Map.Entry entry : defaultValues.entrySet()) {
                text = text.replace("#[[$" + (String)entry.getKey() + "$]]#", (CharSequence)entry.getValue());
            }
            template = template.clone();
            template.setText(text.replace("#[[$END$]]#", ""));
        }
        template.setLiveTemplateEnabled(openFile);
        PsiFile file2 = CreateFileFromTemplateAction.createFileFromTemplate((String)"package.json", (FileTemplate)template, (PsiDirectory)psiDir, null, (boolean)openFile, (Map)defaultValues);
        if (openFile && file2 != null && (virtualFile = file2.getVirtualFile()) != null) {
            FileEditorManager.getInstance((Project)file2.getProject()).openFile(virtualFile, true);
        }
        return file2;
    }

    @Nullable
    public static PackageJsonData getTopLevelPackageJsonData(@NotNull Project project) {
        if (project == null) {
            PackageJsonUtil.$$$reportNull$$$0(18);
        }
        if (project.isDefault() || project.getBaseDir() == null || project.isDisposed()) {
            return null;
        }
        VirtualFile packageJson = project.getBaseDir().findChild("package.json");
        return packageJson == null ? null : PackageJsonUtil.getOrCreateData(packageJson, false);
    }

    public static ThreeState isVersionGreaterOrEqualMajor(@NotNull String versionText, int major) {
        if (versionText == null) {
            PackageJsonUtil.$$$reportNull$$$0(19);
        }
        if ("latest".equals(versionText)) {
            return ThreeState.YES;
        }
        String[] parts = versionText.split("\\s-\\s");
        if (parts.length == 2) {
            String part = parts[1];
            if (PackageJsonUtil.isAny((part = StringUtil.trimStart((String)part, (String)"v")).charAt(0))) {
                return ThreeState.YES;
            }
            int parsedMajor = PackageJsonUtil.getMajorVersion(part);
            if (parsedMajor >= 0) {
                return parsedMajor >= major ? ThreeState.YES : ThreeState.NO;
            }
            return ThreeState.UNSURE;
        }
        ArrayList<Pair> versionWords = new ArrayList<Pair>();
        StringBuilder sb = new StringBuilder();
        StringBuilder prefixBuilder = new StringBuilder();
        for (int i = 0; i < versionText.length(); ++i) {
            char ch = versionText.charAt(i);
            if (Character.isDigit(ch) || '.' == ch || '*' == ch || 'v' == ch || 'x' == ch || 'X' == ch) {
                sb.append(ch);
                continue;
            }
            if (sb.length() > 0) {
                versionWords.add(Pair.create((Object)prefixBuilder.toString(), (Object)sb.toString()));
                sb.setLength(0);
                prefixBuilder.setLength(0);
            }
            prefixBuilder.append(ch);
        }
        if (sb.length() > 0) {
            versionWords.add(Pair.create((Object)prefixBuilder.toString(), (Object)sb.toString()));
        }
        if (versionWords.isEmpty()) {
            return ThreeState.UNSURE;
        }
        boolean greaterThanLess = false;
        boolean lessThanGreater = false;
        for (Pair pair : versionWords) {
            int parsedMajor;
            String word = (String)pair.getSecond();
            word = StringUtil.trimStart((String)word, (String)"v");
            String prefix = (String)pair.getFirst();
            if (!PackageJsonUtil.isPrefixValid(prefix)) {
                return ThreeState.UNSURE;
            }
            if (word.isEmpty()) continue;
            if (PackageJsonUtil.isAny(word.charAt(0))) {
                lessThanGreater = true;
            }
            if ((parsedMajor = PackageJsonUtil.getMajorVersion(word)) < 0) continue;
            if (parsedMajor >= major) {
                char before;
                if (parsedMajor == major && (before = PackageJsonUtil.getVersionComparator(prefix)) == '<') {
                    return ThreeState.NO;
                }
                lessThanGreater = true;
                continue;
            }
            if (PackageJsonUtil.getVersionComparator(prefix) != '>') continue;
            greaterThanLess = true;
        }
        if (greaterThanLess || lessThanGreater) {
            return ThreeState.YES;
        }
        return ThreeState.NO;
    }

    private static int getMajorVersion(@NotNull String version) {
        int idx;
        if (version == null) {
            PackageJsonUtil.$$$reportNull$$$0(20);
        }
        if ((idx = version.indexOf(".")) < 0) {
            return StringUtil.parseInt((String)version, (int)-1);
        }
        return StringUtil.parseInt((String)version.substring(0, idx), (int)-1);
    }

    private static boolean isPrefixValid(@NotNull String prefix) {
        if (prefix == null) {
            PackageJsonUtil.$$$reportNull$$$0(21);
        }
        if (prefix.isEmpty()) {
            return true;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            char ch = prefix.charAt(i);
            if (Character.isWhitespace(ch) || ch == '<' || ch == '>' || ch == '=' || ch == '~' || ch == '^' || ch == '|') continue;
            return false;
        }
        return true;
    }

    private static boolean isAny(char first) {
        return first == '*' || first == 'x' || first == 'X';
    }

    private static char getVersionComparator(@NotNull String prefix) {
        if (prefix == null) {
            PackageJsonUtil.$$$reportNull$$$0(22);
        }
        for (int i = prefix.length() - 1; i >= 0; --i) {
            char ch = prefix.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            if (ch == '=' && i > 0) {
                return prefix.charAt(i - 1);
            }
            return ch;
        }
        return ' ';
    }

    @Contract(value="null -> null")
    @Nullable
    public static VirtualFile findChildPackageJsonFile(@Nullable VirtualFile dir) {
        VirtualFile packageJson;
        if (dir != null && (packageJson = dir.findChild("package.json")) != null && packageJson.isValid() && !packageJson.isDirectory()) {
            return packageJson;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 5: 
            case 18: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 7: 
            case 10: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDir";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionText";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "listAllPackageProperties";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInsidePackageJsonFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getContainingPackageJsonFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isTopLevelProperty";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findContainingProperty";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isPackageDependencyProperty";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processUpPackageJsonFiles";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findUpPackageJson";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processUpPackageJsonFilesInAllScope";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "listAllPackageProperties";
                break;
            }
            case 12: 
            case 14: 
            case 16: {
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateData";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createPackageJson";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelPackageJsonData";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isVersionGreaterOrEqualMajor";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getMajorVersion";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isPrefixValid";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getVersionComparator";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processUpPackageJsonFilesInAllScope$2";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processUpPackageJsonFiles$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CachedPackageJsonData {
        private final PackageJsonData myData;
        private final long myFileModificationStamp;
        private final long myDocumentModificationStamp;

        /*
         * WARNING - void declaration
         */
        CachedPackageJsonData(@NotNull PackageJsonData data, long fileModificationStamp, long l) {
            void documentModificationStamp;
            if (data == null) {
                CachedPackageJsonData.$$$reportNull$$$0(0);
            }
            this.myData = data;
            this.myFileModificationStamp = fileModificationStamp;
            this.myDocumentModificationStamp = documentModificationStamp;
        }

        @NotNull
        public PackageJsonData getData() {
            PackageJsonData packageJsonData = this.myData;
            if (packageJsonData == null) {
                CachedPackageJsonData.$$$reportNull$$$0(1);
            }
            return packageJsonData;
        }

        public long getFileModificationStamp() {
            return this.myFileModificationStamp;
        }

        public long getDocumentModificationStamp() {
            return this.myDocumentModificationStamp;
        }

        public String toString() {
            return "data=" + this.myData + ", fileModificationStamp=" + this.myFileModificationStamp + ", documentModificationStamp=" + this.myDocumentModificationStamp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil$CachedPackageJsonData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil$CachedPackageJsonData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

