/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.inline;

import b.h.la;
import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.MultiMap;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyOverrideImplementUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.Scope;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeVariable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.RMethodSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.RemoveReturnFix;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyUnnecessaryReturnStatementInspection;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyCommentsUtil;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.RControlFlowUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RReturnStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods.RSingletonMethodImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.references.RReferenceNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RArrayToArguments;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RFid;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RPseudoConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RClassVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RField;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RInstanceVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;
import org.jetbrains.plugins.ruby.ruby.refactoring.RubyReplaceExpressionUtil;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.NamesSuggestor;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.parameter.RubyIntroduceParameterProcessor;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.variable.RubyIntroduceVariableHandler;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public class RubyInlineMethodProcessor
extends BaseRefactoringProcessor {
    private static final Logger i;
    public static final String REFACTORING_NAME;
    private static final String f;
    public static final String HELP_ID = "refactoring.inlineMethod";
    private final RMethod a;
    private final Editor g;
    private final String b;
    private final PsiReference h;
    private final boolean d;
    private static final Key<String> e;
    private static final Key<Set<String>> c;
    private static final long j;

    public RubyInlineMethodProcessor(Project project, Editor editor, RMethod method, PsiReference reference, boolean invokeThisOnly) {
        super(project);
        this.a = method;
        this.g = editor;
        this.h = reference;
        this.d = invokeThisOnly;
        this.b = DescriptiveNameUtil.getDescriptiveName((PsiElement)this.a);
    }

    @NotNull
    protected String getCommandName() {
        long l2 = j ^ 0x528047084E3CL;
        String string = RefactoringBundle.message((String)"inline.method.command", (Object[])new Object[]{this.b});
        if (string == null) {
            RubyInlineMethodProcessor.a(0);
        }
        return string;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            RubyInlineMethodProcessor.a(1);
        }
        UsageViewDescriptorAdapter usageViewDescriptorAdapter = new UsageViewDescriptorAdapter(){
            private static final long a = la.a(-1492219022483853060L, 554539519644650970L, MethodHandles.lookup().lookupClass()).a(116281435267626L);

            @NotNull
            public PsiElement[] getElements() {
                PsiElement[] psiElementArray = new PsiElement[]{RubyInlineMethodProcessor.this.a};
                if (psiElementArray == null) {
                    1.a(0);
                }
                return psiElementArray;
            }

            public String getProcessedElementsHeader() {
                long l2 = a ^ 0x18B61584359AL;
                return RefactoringBundle.message((String)"all.invocations.in.project");
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x50E23B9271BDL;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/ruby/refactoring/inline/RubyInlineMethodProcessor$1", "getElements"));
            }
        };
        if (usageViewDescriptorAdapter == null) {
            RubyInlineMethodProcessor.a(2);
        }
        return usageViewDescriptorAdapter;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        UsageInfo[] usageInfoArray = RubyInlineMethodProcessor.findUsages(this.a, this.h, this.d);
        if (usageInfoArray == null) {
            RubyInlineMethodProcessor.a(3);
        }
        return usageInfoArray;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            RubyInlineMethodProcessor.a(4);
        }
        UsageInfo[] usageInfoArray = (UsageInfo[])refUsages.get();
        MultiMap multiMap = new MultiMap();
        RubyInlineMethodProcessor.inspectUsages(this.a, (MultiMap<PsiElement, String>)multiMap, usageInfoArray);
        return this.showConflicts(multiMap, usageInfoArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        LocalHistoryAction localHistoryAction;
        if (usages == null) {
            RubyInlineMethodProcessor.a(5);
        }
        int n2 = -1;
        int n3 = -1;
        if (this.g != null) {
            n2 = this.g.getCaretModel().getLogicalPosition().column;
            n3 = this.g.getCaretModel().getLogicalPosition().line;
            localHistoryAction = new LogicalPosition(0, 0);
            this.g.getCaretModel().moveToLogicalPosition((LogicalPosition)localHistoryAction);
        }
        localHistoryAction = LocalHistory.getInstance().startAction(this.getCommandName());
        try {
            this.a(usages);
        }
        finally {
            localHistoryAction.finish();
        }
        if (this.g != null) {
            LogicalPosition logicalPosition = new LogicalPosition(n3, n2);
            this.g.getCaretModel().moveToLogicalPosition(logicalPosition);
        }
    }

    private void a(UsageInfo[] usageInfoArray) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed(RubyInlineMethodProcessor.a());
        RubyInlineMethodProcessor.invoke(this.myProject, this.a, this.d, usageInfoArray);
    }

    private static String a() {
        long l2 = j ^ 0x3AC62F2DD1BFL;
        return HELP_ID;
    }

    public static void invoke(@NotNull Project project, @NotNull RMethod method, boolean inlineThisOnly, @NotNull UsageInfo[] usages) {
        long l2 = j ^ 0x1FFF336399A4L;
        if (project == null) {
            RubyInlineMethodProcessor.a(6);
        }
        if (method == null) {
            RubyInlineMethodProcessor.a(7);
        }
        if (usages == null) {
            RubyInlineMethodProcessor.a(8);
        }
        CommandProcessor.getInstance().executeCommand(project, () -> {
            if (usages == null) {
                RubyInlineMethodProcessor.a(24);
            }
            if (method == null) {
                RubyInlineMethodProcessor.a(25);
            }
            if (project == null) {
                RubyInlineMethodProcessor.a(26);
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                long l2 = j ^ 0x267B08D56F4CL;
                if (usages == null) {
                    RubyInlineMethodProcessor.a(27);
                }
                if (method == null) {
                    RubyInlineMethodProcessor.a(28);
                }
                if (project == null) {
                    RubyInlineMethodProcessor.a(29);
                }
                if (i.isDebugEnabled()) {
                    i.info("Fix all the usages include super calls");
                }
                Object object = usages;
                int n2 = ((UsageInfo[])object).length;
                for (int i10 = 0; i10 < n2; ++i10) {
                    Object object2;
                    RContainer rContainer;
                    RCall rCall;
                    UsageInfo usageInfo = object[i10];
                    RPsiElement rPsiElement = (RPsiElement)usageInfo.getElement();
                    boolean bl3 = RubyInlineMethodProcessor.b((PsiElement)rPsiElement);
                    RPsiElement rPsiElement2 = null;
                    if (bl3) {
                        rPsiElement2 = ((RReference)rPsiElement).getReceiver();
                    }
                    if ((rCall = RCallNavigator.getByCommand((PsiElement)rPsiElement)) != null) {
                        rPsiElement = rCall;
                    }
                    if ((rContainer = RubyPsiUtil.getContainingRClassOrModule((PsiElement)rPsiElement)) == null) {
                        rContainer = RubyPsiUtil.getRFile((PsiElement)rPsiElement);
                    }
                    if (bl3) {
                        object2 = (Set)method.getUserData(c);
                        assert (object2 != null) : "fqn data should be initialized before inspecting all the references";
                        Iterator iterator = object2.iterator();
                        while (iterator.hasNext()) {
                            String string = (String)iterator.next();
                            RubyPsiUtil.addIncludeFQNCall(rContainer, string);
                        }
                    }
                    if (RubyInlineMethodProcessor.a(project, (String)(object2 = RubyInlineMethodProcessor.a(project, method, rPsiElement2, bl3)), rPsiElement)) continue;
                    return;
                }
                method.accept((PsiElementVisitor)new RubyRecursiveElementVisitor(){

                    @Override
                    public void visitElement(PsiElement element) {
                        element.putUserData(e, null);
                        super.visitElement(element);
                    }
                });
                method.putUserData(c, null);
                if (!inlineThisOnly) {
                    if (i.isDebugEnabled()) {
                        i.info("Removing method with comments");
                    }
                    if (!(object = RubyCommentsUtil.getPsiComments((PsiElement)method)).isEmpty()) {
                        PsiElement psiElement = (PsiElement)object.get(0);
                        PsiElement psiElement2 = ((PsiComment)object.get(object.size() - 1)).getNextSibling();
                        psiElement.getParent().deleteChildRange(psiElement, psiElement2);
                    }
                    method.delete();
                }
            });
        }, RefactoringBundle.message((String)"inline.method.command", (Object[])new Object[]{method.getName()}), null);
    }

    private static boolean b(PsiElement psiElement) {
        if (!(psiElement instanceof RReference)) {
            return false;
        }
        RPsiElement rPsiElement = ((RReference)psiElement).getReceiver();
        return rPsiElement != null && !RubyTokenTypes.kSUPER.toString().equals(rPsiElement.getName());
    }

    private static String a(@NotNull Project project, @NotNull RMethod rMethod, @Nullable RPsiElement rPsiElement, boolean bl2) {
        String string;
        StringBuilder stringBuilder;
        long l2 = j ^ 0x7F4694934832L;
        if (project == null) {
            RubyInlineMethodProcessor.a(9);
        }
        if (rMethod == null) {
            RubyInlineMethodProcessor.a(10);
        }
        final String string2 = RubyInlineMethodProcessor.a(rMethod, rPsiElement);
        if (bl2) {
            stringBuilder = new StringBuilder();
            rMethod.accept((PsiElementVisitor)new RubyRecursiveElementVisitor(){
                private static final long a = la.a(3393101514974231735L, -7690638186858698736L, MethodHandles.lookup().lookupClass()).a(241308787574715L);

                @Override
                public void visitElement(PsiElement element) {
                    long l2 = a ^ 0x43D2E48B6357L;
                    if (string2 != null && element instanceof RPseudoConstant && RubyTokenTypes.kSELF.toString().equals(element.getText())) {
                        stringBuilder.append(string2);
                        return;
                    }
                    String string = (String)element.getUserData(e);
                    if (string != null) {
                        if (string2 != null && "self".equals(string)) {
                            string = string2 + "." + element.getText();
                        }
                        stringBuilder.append(string);
                        return;
                    }
                    if (element instanceof LeafPsiElement) {
                        stringBuilder.append(element.getText());
                        return;
                    }
                    super.visitElement(element);
                }
            });
            string = stringBuilder.toString();
        } else {
            string = rMethod.getText();
        }
        stringBuilder = (RMethod)RubyElementFactory.createElementFromText(project, string, rMethod.getLanguageLevel());
        if (string2 != null && !rPsiElement.getText().equals(string2)) {
            stringBuilder.getCompoundStatement().addBefore((PsiElement)RubyElementFactory.createExpressionFromText((PsiElement)rMethod, string2 + " = " + rPsiElement.getText()), stringBuilder.getCompoundStatement().getFirstChild());
        }
        for (RReturnStatement rReturnStatement : RubyUnnecessaryReturnStatementInspection.inspectMethod((RMethod)stringBuilder, true)) {
            ApplicationManager.getApplication().runWriteAction(() -> RemoveReturnFix.removeUnnecessaryReturn(rReturnStatement));
        }
        return stringBuilder.getText();
    }

    private static String a(@NotNull RMethod rMethod, @Nullable RPsiElement rPsiElement) {
        String string;
        long l2 = j ^ 0x204F55005265L;
        if (rMethod == null) {
            RubyInlineMethodProcessor.a(11);
        }
        if (rPsiElement == null) {
            return null;
        }
        boolean bl2 = false;
        final Ref ref = new Ref((Object)0);
        if (RubyPsiUtil.isConstantValue((PsiElement)rPsiElement) || rPsiElement instanceof RField) {
            string = rPsiElement.getText();
            bl2 = true;
        } else {
            String string2;
            String[] stringArray = NamesSuggestor.getSuggestedNames((PsiElement)rPsiElement);
            string = string2 = stringArray.length != 0 ? stringArray[0] : "new_object";
            Set set = rMethod.getScope().getAllDeclaredVariables().keySet();
            int n2 = 1;
            while (string.equals(rPsiElement.getName()) || set.contains(string)) {
                string = string2 + n2;
                ++n2;
            }
        }
        rMethod.accept((PsiElementVisitor)new RubyRecursiveElementVisitor(){
            private static final long a = la.a(-921809981803413787L, -959834110090831705L, MethodHandles.lookup().lookupClass()).a(211865747356994L);

            @Override
            public void visitElement(PsiElement element) {
                long l2 = a ^ 0x1E82CDB9CAC0L;
                if (element instanceof RPseudoConstant && RubyTokenTypes.kSELF.toString().equals(element.getText()) || "self".equals(element.getUserData(e))) {
                    ref.set((Object)((Integer)ref.get() + 1));
                    return;
                }
                super.visitElement(element);
            }
        });
        boolean bl3 = (Integer)ref.get() > 1;
        return bl3 && !bl2 ? string : rPsiElement.getText();
    }

    public static UsageInfo[] findUsages(RMethod method, PsiReference reference, boolean inlineThisOnly) {
        Collection<Object> collection;
        long l2 = j ^ 0x6A7B4C87F748L;
        ArrayList<UsageInfo> arrayList = new ArrayList<UsageInfo>();
        if (inlineThisOnly) {
            arrayList.add(new UsageInfo(reference.getElement()));
        } else {
            collection = RubyIntroduceParameterProcessor.findUsages(Collections.singletonList(method));
            if (i.isDebugEnabled()) {
                i.info("References Found: " + collection.size());
            }
            arrayList.addAll(collection);
        }
        collection = RubyOverrideImplementUtil.getOverridingElements((RContainer)method);
        if (i.isDebugEnabled()) {
            i.info("Overriding Methods Found: " + collection.size());
        }
        for (RContainer rContainer : collection) {
            List list2 = rContainer.getCompoundStatement().getStatements();
            if (list2.isEmpty()) continue;
            RPsiElement rPsiElement = (RPsiElement)list2.get(0);
            if (rPsiElement instanceof RIdentifier && f.equals(rPsiElement.getText())) {
                arrayList.add(new UsageInfo((PsiElement)rPsiElement));
                continue;
            }
            if (!(rPsiElement instanceof RCall) || !f.equals(((RCall)rPsiElement).getCommand())) continue;
            arrayList.add(new UsageInfo((PsiElement)rPsiElement));
        }
        return (UsageInfo[])ArrayUtil.toObjectArray(arrayList, UsageInfo.class);
    }

    private static boolean a(@NotNull Project project, @NotNull String string2, @NotNull RPsiElement rPsiElement) {
        ASTNode aSTNode;
        Object object32;
        Object object222;
        ScopeVariable scopeVariable22;
        Scope scope;
        long l2 = j ^ 0x35C609C2E36FL;
        if (project == null) {
            RubyInlineMethodProcessor.a(12);
        }
        if (string2 == null) {
            RubyInlineMethodProcessor.a(13);
        }
        if (rPsiElement == null) {
            RubyInlineMethodProcessor.a(14);
        }
        i.assertTrue((scope = ScopeUtil.getScope(rPsiElement)) != null, (Object)"Null scope is not expected here");
        HashSet<String> hashSet = new HashSet<String>();
        for (ScopeVariable scopeVariable22 : scope.getDeclaredVariables((PsiElement)rPsiElement)) {
            hashSet.add(scopeVariable22.getName());
        }
        for (ScopeVariable scopeVariable22 : scope.getImplicitLocalVariables((PsiElement)rPsiElement)) {
            if (!RubyPsiUtil.isBefore((PsiElement)scopeVariable22, (PsiElement)rPsiElement)) continue;
            hashSet.add(scopeVariable22.getName());
        }
        if (rPsiElement instanceof RCall) {
            RubyInlineMethodProcessor.a((RCall)rPsiElement);
        }
        LanguageLevel languageLevel = rPsiElement.getLanguageLevel();
        scopeVariable22 = (RMethod)RubyElementFactory.createElementFromText(project, string2, languageLevel);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Consumer<String> consumer = string -> {
            int n2 = 1;
            while (hashSet.contains(string + n2)) {
                ++n2;
            }
            hashMap.put((String)string, string + n2);
            hashSet.add(string + n2);
        };
        Collection collection = scopeVariable22.getScope().getAllDeclaredVariables().values();
        for (Object object222 : collection) {
            object32 = object222.getName();
            if (!hashSet.contains(object32)) continue;
            consumer.accept((String)object32);
        }
        scopeVariable22.accept((PsiElementVisitor)new RubyRecursiveElementVisitor((RMethod)scopeVariable22, hashMap, hashSet, consumer){
            final /* synthetic */ RMethod val$method;
            final /* synthetic */ Map val$renameMap;
            final /* synthetic */ Set val$reservedLocalNames;
            final /* synthetic */ Consumer val$rename;
            {
                this.val$method = rMethod;
                this.val$renameMap = map;
                this.val$reservedLocalNames = set;
                this.val$rename = consumer;
            }

            @Override
            public void visitRIdentifier(RIdentifier rIdentifier) {
                String string;
                if (rIdentifier.isBlockParameterDeclaration() && RubyPsiUtil.getParentContainer((PsiElement)rIdentifier) == this.val$method && !this.val$renameMap.containsKey(string = rIdentifier.getName()) && this.val$reservedLocalNames.contains(string)) {
                    this.val$rename.accept(string);
                }
            }
        });
        HashSet hashSet2 = new HashSet();
        scopeVariable22.accept((PsiElementVisitor)new RubyRecursiveElementVisitor((RMethod)scopeVariable22, hashMap, hashSet2){
            final /* synthetic */ RMethod val$method;
            final /* synthetic */ Map val$renameMap;
            final /* synthetic */ Set val$identifiers2rename;
            {
                this.val$method = rMethod;
                this.val$renameMap = map;
                this.val$identifiers2rename = set;
            }

            @Override
            public void visitRIdentifier(RIdentifier identifier) {
                if (RubyPsiUtil.getParentContainer((PsiElement)identifier) != this.val$method || identifier.getParent() instanceof RReference && ((RReference)identifier.getParent()).getValue() == identifier) {
                    return;
                }
                String string = identifier.getName();
                if (this.val$renameMap.containsKey(string)) {
                    this.val$identifiers2rename.add(Pair.create((Object)identifier, this.val$renameMap.get(string)));
                }
            }
        });
        if (rPsiElement instanceof RCall) {
            for (Object object32 : ((RCall)rPsiElement).getCallArguments().getElements()) {
                String string32;
                if (!(object32 instanceof RAssoc) || !hashMap.containsKey(string32 = ((RAssoc)object32).getKeyText())) continue;
                hashSet2.add(Pair.create((Object)((PsiNamedElement)((RAssoc)object32).getKey()), hashMap.get(string32)));
            }
        }
        object222 = hashSet2.iterator();
        while (object222.hasNext()) {
            object32 = (Pair)object222.next();
            ((PsiNamedElement)((Pair)object32).first).setName((String)((Pair)object32).second);
        }
        object222 = new ArrayList();
        for (PsiElement psiElement : RubyInlineMethodProcessor.a(project, rPsiElement, languageLevel, (RMethod)scopeVariable22, hashMap)) {
            object222.add(psiElement.getNode());
            object222.add(RubyElementFactory.createNewLine((PsiElement)rPsiElement).getNode());
        }
        object32 = scopeVariable22.getCompoundStatement().getStatements();
        RPsiElement rPsiElement2 = RubyPsiUtil.getStatement((PsiElement)rPsiElement);
        String string3 = scopeVariable22.getName() + "_value";
        if (hashSet.contains(string3)) {
            consumer.accept(string3);
            string3 = (String)hashMap.get(string3);
        }
        if (rPsiElement2 != rPsiElement && object32.size() > 1) {
            aSTNode = (RPsiElement)object32.get(object32.size() - 1);
            aSTNode.replace((PsiElement)RubyElementFactory.createExpressionFromText(project, string3 + " = " + aSTNode.getText(), languageLevel));
        }
        aSTNode = RubyPsiUtil.getCompoundStatement((PsiElement)rPsiElement).getNode();
        ASTNode aSTNode2 = rPsiElement2.getNode();
        if (!object222.isEmpty()) {
            ASTNode[] aSTNodeArray = object222.iterator();
            while (aSTNodeArray.hasNext()) {
                ASTNode aSTNode3 = (ASTNode)aSTNodeArray.next();
                aSTNode.addChild(aSTNode3, aSTNode2);
            }
        }
        if (rPsiElement2 == rPsiElement) {
            for (ASTNode aSTNode4 : scopeVariable22.getCompoundStatement().getNode().getChildren(null)) {
                aSTNode.addChild(aSTNode4, aSTNode2);
            }
            RubyInlineMethodProcessor.a((PsiElement)rPsiElement);
            rPsiElement.delete();
        } else if (object32.isEmpty()) {
            rPsiElement.replace((PsiElement)RubyElementFactory.createExpressionFromText(project, RubyTokenTypes.kNIL.toString(), languageLevel));
        } else if (object32.size() == 1) {
            if (RubyReplaceExpressionUtil.isNeedParenthesis(rPsiElement, (RPsiElement)object32.get(0))) {
                rPsiElement.replace((PsiElement)RubyElementFactory.createExpressionFromText(project, "(" + ((RPsiElement)object32.get(0)).getText() + ")", languageLevel));
            } else {
                rPsiElement.replace((PsiElement)object32.get(0));
            }
        } else {
            for (ASTNode aSTNode5 : scopeVariable22.getCompoundStatement().getNode().getChildren(null)) {
                aSTNode.addChild(aSTNode5, aSTNode2);
            }
            aSTNode.addChild(RubyElementFactory.createNewLine((PsiElement)rPsiElement).getNode(), aSTNode2);
            rPsiElement.replace((PsiElement)RubyElementFactory.createExpressionFromText(project, string3, languageLevel));
        }
        return true;
    }

    private static void a(@NotNull RCall rCall) {
        if (rCall == null) {
            RubyInlineMethodProcessor.a(15);
        }
        for (RPsiElement rPsiElement : rCall.getCallArguments().getElements()) {
            RPsiElement rPsiElement2;
            if (!(rPsiElement instanceof RAssignmentExpression) || (rPsiElement2 = ((RAssignmentExpression)rPsiElement).getValue()) == null) continue;
            RubyIntroduceVariableHandler.insertDeclaration((PsiElement)rPsiElement, (PsiElement)rCall, null, false, RubyIntroduceVariableHandler.STANDARD_BODY_PRODUCER);
            rPsiElement.replace((PsiElement)rPsiElement2);
        }
    }

    private static void a(PsiElement psiElement) {
        PsiElement psiElement2 = psiElement.getPrevSibling();
        if (psiElement2 != null && psiElement2.getNode().getElementType() == RubyTokenTypes.tEOL) {
            psiElement2.delete();
        }
    }

    private static List<PsiElement> a(Project project, RPsiElement rPsiElement, LanguageLevel languageLevel, RMethod rMethod, Map<String, String> map) {
        long l2 = j ^ 0x42C75C1F06EL;
        ArrayList<PsiElement> arrayList = new ArrayList<PsiElement>();
        List list2 = rPsiElement instanceof RCall ? ((RCall)rPsiElement).getArguments() : Collections.emptyList();
        List list3 = rMethod.getArguments();
        int n2 = 0;
        for (int i10 = 0; i10 < list3.size(); ++i10) {
            StringBuilder stringBuilder;
            RArgument rArgument = (RArgument)list3.get(i10);
            ArgumentInfo.Type type = rArgument.getType();
            if (type == ArgumentInfo.Type.SIMPLE || type == ArgumentInfo.Type.PREDEFINED || type == ArgumentInfo.Type.NAMED || type == ArgumentInfo.Type.KEYREQ) {
                RPsiElement rPsiElement2;
                stringBuilder = new StringBuilder();
                if (n2 < list2.size()) {
                    if (list2.get(n2) instanceof RArrayToArguments) {
                        RubyInlineMethodProcessor.a(stringBuilder, list3, i10, list2, n2);
                        i10 = list3.size();
                        arrayList.add((PsiElement)RubyElementFactory.createExpressionFromText(project, stringBuilder.toString(), languageLevel));
                        continue;
                    }
                    rPsiElement2 = new Ref((Object)true);
                    if (RubyInlineMethodProcessor.tryToInlineArgument(rMethod, rArgument.getName(), (PsiElement)list2.get(n2), map, (Ref<Boolean>)rPsiElement2)) {
                        if (!((Boolean)rPsiElement2.get()).booleanValue()) continue;
                        ++n2;
                        continue;
                    }
                    stringBuilder.append(rArgument.getName()).append(" = ").append(((RPsiElement)list2.get(n2)).getText());
                    arrayList.add((PsiElement)RubyElementFactory.createExpressionFromText(project, stringBuilder.toString(), languageLevel));
                    ++n2;
                    continue;
                }
                rPsiElement2 = type == ArgumentInfo.Type.PREDEFINED || type == ArgumentInfo.Type.NAMED ? rArgument.getValue() : RubyElementFactory.createExpressionFromText(project, RubyTokenTypes.kNIL.toString(), languageLevel);
                Ref ref = new Ref((Object)true);
                if (RubyInlineMethodProcessor.tryToInlineArgument(rMethod, rArgument.getName(), (PsiElement)rPsiElement2, map, (Ref<Boolean>)ref)) {
                    if (!((Boolean)ref.get()).booleanValue()) continue;
                    ++n2;
                    continue;
                }
                stringBuilder.append(rArgument.getName()).append(" = ").append(rPsiElement2.getText());
                arrayList.add((PsiElement)RubyElementFactory.createExpressionFromText(project, stringBuilder.toString(), languageLevel));
                continue;
            }
            if (type != ArgumentInfo.Type.ARRAY) continue;
            stringBuilder = new StringBuilder();
            RubyInlineMethodProcessor.a(stringBuilder, list3, i10, list2, n2);
            i10 = list3.size();
            arrayList.add((PsiElement)RubyElementFactory.createExpressionFromText(project, stringBuilder.toString(), languageLevel));
        }
        return arrayList;
    }

    private static void a(StringBuilder stringBuilder, List<RArgument> list2, int n2, List<RPsiElement> list3, int n3) {
        long l2 = j ^ 0x566EDB9825B5L;
        while (n2 < list2.size()) {
            RArgument rArgument;
            if (stringBuilder.length() != 0) {
                stringBuilder.append(", ");
            }
            if ((rArgument = list2.get(n2)).getType() == ArgumentInfo.Type.ARRAY) {
                stringBuilder.append("*");
            }
            stringBuilder.append(rArgument.getName());
            ++n2;
        }
        stringBuilder.append(" = ");
        if (n3 < list3.size()) {
            while (n3 < list3.size()) {
                stringBuilder.append(list3.get(n3).getText());
                if (n3 < list3.size() - 1) {
                    stringBuilder.append(", ");
                }
                ++n3;
            }
        } else {
            stringBuilder.append("[]");
        }
    }

    public static boolean tryToInlineArgument(RMethod method, final String argumentName, PsiElement value, Map<String, String> renameMap, Ref<Boolean> matchCallArgument) {
        final ArrayList arrayList = new ArrayList();
        final Ref ref = new Ref((Object)true);
        method.getCompoundStatement().accept((PsiElementVisitor)new RubyRecursiveElementVisitor(){

            @Override
            public void visitRIdentifier(RIdentifier identifier) {
                if (argumentName.equals(identifier.getName()) && (identifier.isParameter() || identifier.isLocalVariable())) {
                    arrayList.add(identifier);
                    ref.set((Object)((Boolean)ref.get() != false && !RubyPsiUtil.isDeclaration((PsiElement)identifier) ? 1 : 0));
                }
            }
        });
        if (((Boolean)ref.get()).booleanValue() && (RubyPsiUtil.isConstantValue(value) || arrayList.size() <= 1)) {
            PsiElement psiElement = RubyInlineMethodProcessor.a(method, argumentName, value, renameMap, matchCallArgument);
            if (psiElement == null) {
                return false;
            }
            for (RIdentifier rIdentifier : arrayList) {
                rIdentifier.replace(psiElement);
            }
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiElement a(@NotNull RMethod rMethod, @NotNull String string, @NotNull PsiElement psiElement, @NotNull Map<String, String> map, @NotNull Ref<Boolean> ref) {
        if (rMethod == null) {
            RubyInlineMethodProcessor.a(16);
        }
        if (string == null) {
            RubyInlineMethodProcessor.a(17);
        }
        if (psiElement == null) {
            RubyInlineMethodProcessor.a(18);
        }
        if (map == null) {
            RubyInlineMethodProcessor.a(19);
        }
        if (ref == null) {
            RubyInlineMethodProcessor.a(20);
        }
        LanguageLevel languageLevel = rMethod.getLanguageLevel();
        Object object = psiElement;
        if (languageLevel != null) {
            RPsiElement rPsiElement = null;
            if (!languageLevel.isLessThan(LanguageLevel.RUBY20) && psiElement instanceof RAssoc) {
                rPsiElement = ((RAssoc)psiElement).getKey();
                if (rPsiElement != null && string.equals(rPsiElement.getText())) {
                    object = ((RAssoc)psiElement).getValue();
                } else {
                    object = RubyInlineMethodProcessor.a(string, psiElement);
                    if (object == null && (object = (PsiElement)rMethod.getArguments().stream().filter(rArgument -> {
                        if (string == null) {
                            RubyInlineMethodProcessor.a(23);
                        }
                        return rArgument.getType() == ArgumentInfo.Type.NAMED && string.equals(rArgument.getName());
                    }).findFirst().orElse(null)) != null) {
                        object = ((RArgument)object).getValue();
                        ref.set((Object)false);
                    }
                }
            } else if (psiElement instanceof RAssignmentExpression) {
                String string2 = ((RAssignmentExpression)psiElement).getObject().getText();
                object = string.equals(string2 = map.getOrDefault(string2, string2)) ? ((RAssignmentExpression)psiElement).getValue() : RubyInlineMethodProcessor.a(string, psiElement);
            }
        }
        if (object instanceof RBinaryExpression) {
            object = RubyElementFactory.createElementFromText(object, "(" + object.getText() + ")");
        }
        return object;
    }

    private static PsiElement a(@NotNull String string, @NotNull PsiElement psiElement) {
        PsiElement[] psiElementArray;
        if (string == null) {
            RubyInlineMethodProcessor.a(21);
        }
        if (psiElement == null) {
            RubyInlineMethodProcessor.a(22);
        }
        RPsiElement rPsiElement = null;
        PsiElement psiElement2 = psiElement.getParent();
        for (PsiElement psiElement3 : psiElementArray = psiElement2.getChildren()) {
            RPsiElement rPsiElement2;
            if (psiElement3 instanceof RAssoc && (rPsiElement2 = ((RAssoc)psiElement3).getKey()) != null && string.equals(rPsiElement2.getText())) {
                rPsiElement = ((RAssoc)psiElement3).getValue();
            }
            if (!(psiElement3 instanceof RAssignmentExpression) || !string.equals((rPsiElement2 = ((RAssignmentExpression)psiElement3).getObject()).getText())) continue;
            rPsiElement = ((RAssignmentExpression)psiElement3).getValue();
        }
        return rPsiElement;
    }

    public static void inspectUsages(RMethod method, final MultiMap<PsiElement, String> conflicts, UsageInfo[] usagesIn) {
        Object object;
        RCompoundStatement rCompoundStatement;
        Object object2;
        long l2 = j ^ 0x4650C0D377A8L;
        Collection<PsiElement> collection = RControlFlowUtil.findExitPointsAndStatements((ControlFlow)method.getControlFlow());
        if (collection.size() > 1) {
            object2 = RefactoringBundle.message((String)"refactoring.is.not.supported.when.return.statement.interrupts.the.execution.flow", (Object[])new Object[]{REFACTORING_NAME});
            for (UsageInfo usageInfo : usagesIn) {
                PsiElement psiElement = usageInfo.getElement();
                RPsiElement rPsiElement = RubyPsiUtil.getStatement(psiElement);
                if (rPsiElement != psiElement) {
                    conflicts.putValue((Object)psiElement, object2);
                    continue;
                }
                rCompoundStatement = (RCompoundStatement)rPsiElement.getParent();
                if (PsiTreeUtil.getParentOfType((PsiElement)rCompoundStatement, (Class[])new Class[]{RContainer.class, RCompoundStatement.class}) instanceof RCompoundStatement) {
                    conflicts.putValue((Object)psiElement, object2);
                    continue;
                }
                object = rCompoundStatement.getStatements();
                if (object.get(object.size() - 1) == rPsiElement) continue;
                conflicts.putValue((Object)psiElement, object2);
            }
        }
        object2 = new HashSet();
        UsageInfo[] usageInfoArray = new HashSet();
        Ref ref = new Ref((Object)false);
        method.acceptChildren((PsiElementVisitor)new RubyRecursiveElementVisitor((Set)usageInfoArray, (Set)object2, ref){
            final /* synthetic */ Set val$classFieldsUsed;
            final /* synthetic */ Set val$instanceFieldsUsed;
            final /* synthetic */ Ref val$superCallUsed;
            {
                this.val$classFieldsUsed = set;
                this.val$instanceFieldsUsed = set2;
                this.val$superCallUsed = ref;
            }

            @Override
            public void visitRClassVariable(RClassVariable rClassVariable) {
                this.val$classFieldsUsed.add(rClassVariable.getText());
            }

            @Override
            public void visitRInstanceVariable(RInstanceVariable rInstanceVariable) {
                this.val$instanceFieldsUsed.add(rInstanceVariable.getText());
            }

            @Override
            public void visitRPseudoConstant(RPseudoConstant rPseudoConstant) {
                if (RubyTokenTypes.kSUPER.toString().equals(rPseudoConstant.getText())) {
                    this.val$superCallUsed.set((Object)true);
                }
            }
        });
        if (!object2.isEmpty() || !usageInfoArray.isEmpty() || ((Boolean)ref.get()).booleanValue()) {
            for (UsageInfo usageInfo : usagesIn) {
                rCompoundStatement = usageInfo.getElement();
                if (!(rCompoundStatement instanceof RReference)) continue;
                object = object2.iterator();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    conflicts.putValue((Object)rCompoundStatement, (Object)RefactoringBundle.message((String)"0.that.is.used.in.inlined.method.is.not.accessible.from.call.site.s.in.1", (Object[])new Object[]{string, rCompoundStatement.getText()}));
                }
                for (String string : usageInfoArray) {
                    conflicts.putValue((Object)rCompoundStatement, (Object)RefactoringBundle.message((String)"0.that.is.used.in.inlined.method.is.not.accessible.from.call.site.s.in.1", (Object[])new Object[]{string, rCompoundStatement.getText()}));
                }
                if (!((Boolean)ref.get()).booleanValue()) continue;
                conflicts.putValue((Object)rCompoundStatement, (Object)RefactoringBundle.message((String)"0.that.is.used.in.inlined.method.is.not.accessible.from.call.site.s.in.1", (Object[])new Object[]{RubyTokenTypes.kSUPER.toString(), rCompoundStatement.getText()}));
            }
        }
        method.putUserData(c, new HashSet());
        for (UsageInfo usageInfo : usagesIn) {
            rCompoundStatement = usageInfo.getElement();
            if (!RubyInlineMethodProcessor.b((PsiElement)rCompoundStatement)) continue;
            method.acceptChildren((PsiElementVisitor)new RubyRecursiveElementVisitor((PsiElement)rCompoundStatement, method){
                final /* synthetic */ PsiElement val$callElement;
                final /* synthetic */ RMethod val$method;
                private static final long a = la.a(7085343964675053845L, 5816876362186845397L, MethodHandles.lookup().lookupClass()).a(26475613460362L);
                {
                    this.val$callElement = psiElement;
                    this.val$method = rMethod;
                }

                @Override
                public void visitRIdentifier(RIdentifier rIdentifier) {
                    if (rIdentifier.isParameter() || rIdentifier.isLocalVariable()) {
                        return;
                    }
                    this.inspectElement((RPsiElement)rIdentifier);
                }

                @Override
                public void visitRFid(RFid rFid) {
                    this.inspectElement((RPsiElement)rFid);
                }

                @Override
                public void visitRConstant(RConstant rConstant) {
                    this.inspectElement((RPsiElement)rConstant);
                }

                public void inspectElement(RPsiElement psiElement) {
                    long l2 = a ^ 0x45CE721002F4L;
                    if (RReferenceNavigator.getRRefenceOrTopReference((PsiElement)psiElement) != null) {
                        return;
                    }
                    PsiReference psiReference = psiElement.getReference();
                    if (psiReference == null) {
                        return;
                    }
                    Symbol symbol = ResolveUtil.resolveToSymbolWithCaching(psiReference);
                    if (symbol == null) {
                        return;
                    }
                    if (SymbolUtil.isTopLevelSymbol(symbol)) {
                        return;
                    }
                    Symbol symbol2 = symbol.getParentSymbol();
                    if (symbol2 != null && SymbolUtil.isTopLevelSymbol(symbol2) && ("Kernel".equals(symbol2.getName()) || "Object".equals(symbol2.getName()))) {
                        return;
                    }
                    if (symbol.getType() == Type.CLASS_METHOD) {
                        if (((RMethodSymbol)symbol).getVisibility() != Visibility.PUBLIC) {
                            conflicts.putValue((Object)psiElement, (Object)RefactoringBundle.message((String)"0.that.is.used.in.inlined.method.is.not.accessible.from.call.site.s.in.1", (Object[])new Object[]{psiElement.getText(), this.val$callElement.getText()}));
                        }
                        String string = RSingletonMethodImpl.makeRubyCallableFQN(symbol.getFQNWithNesting()).getFullPath();
                        psiElement.putUserData(e, (Object)string);
                        return;
                    }
                    if (symbol.getType() == Type.CONSTANT) {
                        String string = symbol.getFQNWithNesting().getFullPath();
                        psiElement.putUserData(e, (Object)string);
                        return;
                    }
                    if (symbol.getType() == Type.INSTANCE_METHOD) {
                        if (((RMethodSymbol)symbol).getVisibility() != Visibility.PUBLIC) {
                            conflicts.putValue((Object)psiElement, (Object)RefactoringBundle.message((String)"0.that.is.used.in.inlined.method.is.not.accessible.from.call.site.s.in.1", (Object[])new Object[]{psiElement.getText(), this.val$callElement.getText()}));
                        }
                        if (symbol2 != null && Types.MODULE_OR_CLASS.contains(symbol2.getType())) {
                            if (symbol2.getType() == Type.CLASS) {
                                psiElement.putUserData(e, (Object)"self");
                                return;
                            }
                            Set set = (Set)this.val$method.getUserData(c);
                            String string = symbol2.getFQNWithNesting().getFullPath();
                            assert (set != null) : "data should be initialized before inspection";
                            set.add(string);
                            return;
                        }
                    }
                    conflicts.putValue((Object)psiElement, (Object)RefactoringBundle.message((String)"0.that.is.used.in.inlined.method.is.not.accessible.from.call.site.s.in.1", (Object[])new Object[]{psiElement.getText(), this.val$callElement.getText()}));
                }
            });
        }
    }

    public static boolean inspectMethod(Project project, Editor editor, final RMethod method) {
        long l2 = j ^ 0x6FEC4108BC71L;
        if (!ApplicationManager.getApplication().isUnitTestMode() && !CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)method)) {
            return false;
        }
        if (RailsUtil.isUnderVendor((PsiElement)method) || ModuleUtil.findModuleForPsiElement((PsiElement)method) == null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Cannot perform refactoring with method in libraries", (String)REFACTORING_NAME, (String)HELP_ID);
            return false;
        }
        if (method.isConstructor()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Cannot perform refactoring with constructor", (String)REFACTORING_NAME, (String)HELP_ID);
            return false;
        }
        List list2 = method.getArgumentInfos();
        for (ArgumentInfo argumentInfo : list2) {
            if (argumentInfo.getType() != ArgumentInfo.Type.BLOCK) continue;
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Cannot perform refactoring with method that has block parameter", (String)REFACTORING_NAME, (String)HELP_ID);
            return false;
        }
        final Ref ref = new Ref((Object)false);
        method.accept((PsiElementVisitor)new RubyRecursiveElementVisitor(){

            @Override
            public void visitRFid(RFid rFid) {
                PsiReference psiReference = rFid.getReference();
                if (psiReference != null && ResolveUtil.isReferenceTo(psiReference, (PsiElement)method)) {
                    ref.set((Object)true);
                }
            }

            @Override
            public void visitRIdentifier(RIdentifier rIdentifier) {
                PsiReference psiReference = rIdentifier.getReference();
                if (psiReference != null && ResolveUtil.isReferenceTo(psiReference, (PsiElement)method)) {
                    ref.set((Object)true);
                }
            }
        });
        if (((Boolean)ref.get()).booleanValue()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.message((String)"refactoring.is.not.supported.for.recursive.methods", (Object[])new Object[]{REFACTORING_NAME}), (String)REFACTORING_NAME, (String)HELP_ID);
            return false;
        }
        return true;
    }

    static {
        j = la.a(-5744652817905835133L, -8102959473744125242L, MethodHandles.lookup().lookupClass()).a(64156270260194L);
        long l2 = j ^ 0x79A14A34B0C8L;
        i = Logger.getInstance(RubyInlineMethodProcessor.class);
        REFACTORING_NAME = RefactoringBundle.message((String)"inline.method.title");
        f = RubyTokenTypes.kSUPER.toString();
        e = Key.create((String)"ruby.inline.method.fqn.transformation");
        c = Key.create((String)"ruby.inline.method.include.transformation");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = j ^ 0xDA669F0B6A6L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/refactoring/inline/RubyInlineMethodProcessor";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 16: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodText";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 17: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageText";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renameMap";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchCallArgument";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/inline/RubyInlineMethodProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "prepareMethodForInline";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getReplacement";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateReference";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "extractAssignmentParameters";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "tryParsePredefinedParams";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findPredefinedParameter";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$tryParsePredefinedParams$4";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$1";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

