/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.utils;

import b.h.la;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;

public class RubyVirtualFileScanner {
    @NonNls
    public static final String DIRECTORY_UP_PREFIX = "../";
    @NonNls
    private static final String a = "(_|[a-z]).*";
    private static final long b = la.a(4112116060214315181L, 5613023262214736643L, MethodHandles.lookup().lookupClass()).a(260398427788763L);

    private RubyVirtualFileScanner() {
    }

    public static void addRubyFiles(@Nullable VirtualFile file, final @NotNull Collection<? super VirtualFile> allFiles) {
        if (allFiles == null) {
            RubyVirtualFileScanner.a(0);
        }
        if (file == null) {
            return;
        }
        final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){
            private static final long a = la.a(6012419992300695134L, 6409043590450553438L, MethodHandles.lookup().lookupClass()).a(26592601649713L);

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    1.a(0);
                }
                ProgressManager.checkCanceled();
                if (fileTypeManager.isFileIgnored(file)) {
                    return false;
                }
                if (!file.isDirectory() && RubyVirtualFileScanner.isRubyFile(file)) {
                    allFiles.add(file);
                }
                return true;
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x67BDFE8239A2L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/ruby/utils/RubyVirtualFileScanner$1", "visitFile"));
            }
        });
    }

    public static void addRubyFiles(@Nullable PsiFileSystemItem fileOrDir, @NotNull Collection<? super RFile> allFiles) {
        boolean bl2;
        if (allFiles == null) {
            RubyVirtualFileScanner.a(1);
        }
        ProgressManager.checkCanceled();
        if (fileOrDir == null) {
            return;
        }
        VirtualFile virtualFile = fileOrDir.getVirtualFile();
        boolean bl3 = bl2 = virtualFile != null ? FileTypeManager.getInstance().isFileIgnored(virtualFile) : FileTypeManager.getInstance().isFileIgnored(fileOrDir.getName());
        if (bl2) {
            return;
        }
        if (!fileOrDir.isDirectory()) {
            if (fileOrDir instanceof RFile) {
                allFiles.add((RFile)((RFile)fileOrDir));
            }
            return;
        }
        for (PsiElement psiElement : fileOrDir.getChildren()) {
            RubyVirtualFileScanner.addRubyFiles((PsiFileSystemItem)psiElement, allFiles);
        }
    }

    public static boolean isRubyFile(@Nullable VirtualFile fileOrDir) {
        return fileOrDir != null && !fileOrDir.isDirectory() && fileOrDir.getFileType() instanceof RubyFileType;
    }

    public static boolean isRubyFile(@NotNull String fileName) {
        if (fileName == null) {
            RubyVirtualFileScanner.a(2);
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        return fileType instanceof RubyFileType;
    }

    public static List<VirtualFile> getRelativeFilesUnderRoot(@NotNull VirtualFile fileRoot, boolean checkName, boolean addRubyFiles, boolean addDirectories) {
        if (fileRoot == null) {
            RubyVirtualFileScanner.a(3);
        }
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        RubyVirtualFileScanner.a(fileRoot, arrayList, checkName, addRubyFiles, addDirectories);
        return arrayList;
    }

    private static void a(@NotNull VirtualFile virtualFile, final @NotNull List<? super VirtualFile> list2, final boolean bl2, final boolean bl3, final boolean bl4) {
        if (virtualFile == null) {
            RubyVirtualFileScanner.a(4);
        }
        if (list2 == null) {
            RubyVirtualFileScanner.a(5);
        }
        final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)virtualFile, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){
            private static final long a = la.a(-237688545057905992L, -5652184931410756989L, MethodHandles.lookup().lookupClass()).a(236729195090824L);

            public boolean visitFile(@NotNull VirtualFile file) {
                long l2 = a ^ 0x28C2EE82FD30L;
                if (file == null) {
                    2.a(0);
                }
                ProgressManager.checkCanceled();
                if (fileTypeManager.isFileIgnored(file)) {
                    return false;
                }
                if (file.isDirectory()) {
                    if (bl2 && !file.getName().matches(RubyVirtualFileScanner.a)) {
                        return false;
                    }
                    if (bl4) {
                        list2.add(file);
                    }
                } else if (RubyVirtualFileScanner.isRubyFile(file) && bl3) {
                    list2.add(file);
                }
                return true;
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x3254038CF1B0L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/ruby/utils/RubyVirtualFileScanner$2", "visitFile"));
            }
        });
    }

    public static List<VirtualFile> findLibsSubDirectories(VirtualFile[] dirs) {
        long l2 = b ^ 0x235D2871A8EBL;
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : dirs) {
            VirtualFile virtualFile2 = virtualFile.findChild("lib");
            if (virtualFile2 == null) continue;
            arrayList.add(virtualFile2);
        }
        return arrayList;
    }

    public static List<VirtualFile> searchFilesUnderDirectory(@Nullable Module module, @NotNull VirtualFile rootDir, boolean includeDirs, boolean includeRoot) {
        if (rootDir == null) {
            RubyVirtualFileScanner.a(6);
        }
        if (module == null) {
            return Collections.emptyList();
        }
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance((Module)module).getFileIndex();
        if (moduleFileIndex.isInContent(rootDir)) {
            if (rootDir.isDirectory()) {
                for (VirtualFile virtualFile : rootDir.getChildren()) {
                    if (!moduleFileIndex.isInContent(virtualFile) || FileTypeManager.getInstance().isFileIgnored(virtualFile) || virtualFile.isDirectory() && !includeDirs) continue;
                    arrayList.add(virtualFile);
                }
            }
            if (includeRoot && includeDirs) {
                arrayList.add(rootDir);
            }
        }
        return arrayList;
    }

    public static List<String> getRelativeUrls(@NotNull VirtualFile root) {
        long l2 = b ^ 0xA67DDA8782L;
        if (root == null) {
            RubyVirtualFileScanner.a(7);
        }
        assert (root.isDirectory()) : "'" + root + "' should be a directory.";
        ArrayList<String> arrayList = new ArrayList<String>();
        return RubyVirtualFileScanner.a(root, arrayList);
    }

    private static List<String> a(@NotNull VirtualFile virtualFile, @NotNull List<String> list2) {
        if (virtualFile == null) {
            RubyVirtualFileScanner.a(8);
        }
        if (list2 == null) {
            RubyVirtualFileScanner.a(9);
        }
        String string = virtualFile.getUrl() + '/';
        int n2 = string.length();
        HashSet hashSet = new HashSet();
        RubyVirtualFileScanner.addRubyFiles(virtualFile, hashSet);
        for (VirtualFile virtualFile2 : hashSet) {
            String string2 = virtualFile2.getUrl();
            list2.add(string2.substring(n2));
        }
        return list2;
    }

    public static List<String> getRelativeUrlsInProject(@NotNull ProjectFileIndex fileIndex, @NotNull VirtualFile directory) {
        long l2 = b ^ 0x6E6FB7EE1AD3L;
        if (fileIndex == null) {
            RubyVirtualFileScanner.a(10);
        }
        if (directory == null) {
            RubyVirtualFileScanner.a(11);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "";
        for (VirtualFile virtualFile = directory; virtualFile != null && fileIndex.isInContent(virtualFile); virtualFile = virtualFile.getParent()) {
            for (String string2 : RubyVirtualFileScanner.getRelativeUrls(virtualFile)) {
                arrayList.add(string + string2);
            }
            string = DIRECTORY_UP_PREFIX + string;
        }
        return arrayList;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = b ^ 0x3094D2A2E982L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allFiles";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileRoot";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDir";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDirectory";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeUrls";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIndex";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/utils/RubyVirtualFileScanner";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addRubyFiles";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isRubyFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getRelativeFilesUnderRoot";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getRelativeFilesUnderRootRec";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "searchFilesUnderDirectory";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getRelativeUrls";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addRelativeUrls";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getRelativeUrlsInProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

