/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons;

import b.h.la;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.ServerSocket;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rubyforge.debugcommons.model.Message;
import org.rubyforge.debugcommons.model.RubyDebugTarget;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class Util {
    private static final Pattern a;
    private static final Logger b;
    private static final long c;

    public static int findFreePort() {
        long l2 = c ^ 0x66993A89AC90L;
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(0);
            int n2 = serverSocket.getLocalPort();
            return n2;
        }
        catch (IOException iOException) {
        }
        finally {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException iOException) {
                    b.error("Cannot close socket.", (Throwable)iOException);
                }
            }
        }
        return -1;
    }

    public static boolean isRunning(Process process) {
        try {
            process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
    }

    public static int compareVersions(String version1, String version2) {
        if (version1.equals(version2)) {
            return 0;
        }
        Matcher matcher = a.matcher(version1);
        if (matcher.matches()) {
            int n2 = Integer.parseInt(matcher.group(1));
            int n3 = Integer.parseInt(matcher.group(2));
            int n4 = Integer.parseInt(matcher.group(3));
            Matcher matcher2 = a.matcher(version2);
            if (matcher2.matches()) {
                int n5 = Integer.parseInt(matcher2.group(1));
                int n6 = Integer.parseInt(matcher2.group(2));
                int n7 = Integer.parseInt(matcher2.group(3));
                if (n2 != n5) {
                    return n2 - n5;
                }
                if (n3 != n6) {
                    return n3 - n6;
                }
                if (n4 != n7) {
                    return n4 - n7;
                }
            }
        }
        return version1.compareTo(version2);
    }

    static String getProcessAsString(List<? extends String> process) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : process) {
            stringBuilder.append(string).append(' ');
        }
        return stringBuilder.toString().trim();
    }

    public static String dumpAndDestroyProcess(RubyDebugTarget target) {
        long l2 = c ^ 0x7E45CA43A6CBL;
        StringBuilder stringBuilder = new StringBuilder();
        if (target.isRemote()) {
            stringBuilder.append("Remote process");
        } else {
            boolean bl2 = target.isRunning();
            if (bl2) {
                stringBuilder.append("Dumping and destroying process, when the debuggee process is running. You might try to increase the timeout. Killing...\n\n");
            }
            Process process = target.getProcess();
            stringBuilder.append(Util.a(process.getInputStream(), "Standard Output: ", bl2));
            stringBuilder.append(Util.a(process.getErrorStream(), "Error Output: ", bl2));
            if (bl2) {
                process.destroy();
            }
        }
        return stringBuilder.toString();
    }

    private static String a(InputStream inputStream, String string, boolean bl2) {
        Object object;
        long l2 = c ^ 0x15F26D54FFBEL;
        StringBuilder stringBuilder = new StringBuilder();
        if (bl2) {
            object = new Thread(() -> Util.a(inputStream, stringBuilder), "dump stream");
            ((Thread)object).start();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                b.info(interruptedException.getLocalizedMessage(), (Throwable)interruptedException);
            }
            ((Thread)object).interrupt();
        } else {
            Util.a(inputStream, stringBuilder);
        }
        if (stringBuilder.length() > 0) {
            b.warn(string);
            object = stringBuilder.toString();
            b.warn((String)object);
            return string + '\n' + (String)object;
        }
        return "";
    }

    private static void a(InputStream inputStream, StringBuilder stringBuilder) {
        try {
            int n2;
            while ((n2 = inputStream.read()) != -1) {
                stringBuilder.append((char)n2);
            }
        }
        catch (IOException iOException) {
            b.info(iOException.getLocalizedMessage(), (Throwable)iOException);
        }
    }

    public static void logEvent(XmlPullParser xpp) {
        long l2 = c ^ 0xEBEEAD09EAAL;
        if (b.isDebugEnabled()) {
            try {
                int n2 = xpp.getEventType();
                if (n2 == 1) {
                    b.debug("Received: END_DOCUMENT event");
                    return;
                }
                if ("message".equals(xpp.getName())) {
                    return;
                }
                if (xpp.getName() == null) {
                    b.warn("Unexpected type: (" + Util.getType(xpp) + ") encountered in logEvent");
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder();
                if (n2 == 4) {
                    return;
                }
                stringBuilder.append("<");
                if (n2 == 3) {
                    stringBuilder.append('/');
                }
                stringBuilder.append(xpp.getName());
                for (int i10 = 0; i10 < xpp.getAttributeCount(); ++i10) {
                    stringBuilder.append(' ').append(xpp.getAttributeName(i10)).append("='").append(xpp.getAttributeValue(i10)).append("'");
                }
                stringBuilder.append('>');
                b.debug("Received: " + stringBuilder.toString());
            }
            catch (XmlPullParserException xmlPullParserException) {
                b.error(xmlPullParserException.getLocalizedMessage(), (Throwable)xmlPullParserException);
            }
        }
    }

    public static void logMessage(Message message) {
        long l2 = c ^ 0x542910967789L;
        if (b.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder("<message");
            if (message.isDebug()) {
                stringBuilder.append(" debug='true'");
            }
            stringBuilder.append('>');
            stringBuilder.append(message.getText());
            stringBuilder.append("</message>");
            b.debug("Received message: " + stringBuilder.toString());
        }
    }

    public static String getType(XmlPullParser xpp) {
        long l2 = c ^ 0x32CE25C2C8E0L;
        try {
            if (xpp.getEventType() == 3) {
                return "END_TAG";
            }
            if (xpp.getEventType() == 2) {
                return "START_TAG";
            }
            if (xpp.getEventType() == 4) {
                return "TEXT";
            }
            if (xpp.getEventType() == 0) {
                return "START_DOCUMENT";
            }
            if (xpp.getEventType() == 1) {
                return "END_DOCUMENT";
            }
            return "UNKNOWN: " + xpp.getEventType();
        }
        catch (XmlPullParserException xmlPullParserException) {
            b.error((Throwable)xmlPullParserException);
            return "<Unable to find a type>";
        }
    }

    public static boolean isEndTag(XmlPullParser xpp, String name) throws XmlPullParserException, IOException {
        return 3 == xpp.getEventType() && name.equals(xpp.getName());
    }

    static {
        c = la.a(-3600667924465403689L, -5795129832528153585L, MethodHandles.lookup().lookupClass()).a(235139043280718L);
        long l2 = c ^ 0x4246E533942EL;
        a = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)(-\\S+)?");
        b = Logger.getInstance(Util.class);
    }
}

