/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.resolve;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.resolve.StylesheetFileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class StylesheetFileReferenceSet
extends FileReferenceSet {
    private final Condition<PsiFileSystemItem> COMPLETION_FILTER;
    private final boolean myIsImageReference;

    public StylesheetFileReferenceSet(@NotNull PsiElement element, @NotNull String referenceText, @NotNull TextRange textRange, FileType ... suitableFileTypes) {
        if (element == null) {
            StylesheetFileReferenceSet.$$$reportNull$$$0(0);
        }
        if (referenceText == null) {
            StylesheetFileReferenceSet.$$$reportNull$$$0(1);
        }
        if (textRange == null) {
            StylesheetFileReferenceSet.$$$reportNull$$$0(2);
        }
        this(element, referenceText, textRange, false, suitableFileTypes);
    }

    public StylesheetFileReferenceSet(@NotNull PsiElement element, @NotNull String referenceText, @NotNull TextRange textRange, boolean isImageReference, FileType ... suitableFileTypes) {
        if (element == null) {
            StylesheetFileReferenceSet.$$$reportNull$$$0(3);
        }
        if (referenceText == null) {
            StylesheetFileReferenceSet.$$$reportNull$$$0(4);
        }
        if (textRange == null) {
            StylesheetFileReferenceSet.$$$reportNull$$$0(5);
        }
        super(referenceText, element, textRange.getStartOffset(), null, SystemInfo.isFileSystemCaseSensitive, true, suitableFileTypes);
        this.COMPLETION_FILTER = new Condition<PsiFileSystemItem>(){

            public boolean value(PsiFileSystemItem item) {
                if (item.isDirectory()) {
                    return true;
                }
                PsiElement element = StylesheetFileReferenceSet.this.getElement();
                if (!element.isValid() || item.equals(element.getContainingFile().getOriginalFile())) {
                    return false;
                }
                FileType[] fileTypes = StylesheetFileReferenceSet.this.getSuitableFileTypes();
                if (fileTypes.length == 0) {
                    return item instanceof StylesheetFile;
                }
                VirtualFile itemVirtualFile = item.getVirtualFile();
                FileType itemFileType = itemVirtualFile.getFileType();
                for (FileType type : fileTypes) {
                    if (itemFileType == type) {
                        return true;
                    }
                    if (!StylesheetFileReferenceSet.this.myIsImageReference || itemFileType != XmlFileType.INSTANCE || !"svg".equals(itemVirtualFile.getExtension())) continue;
                    return true;
                }
                return false;
            }
        };
        this.myIsImageReference = isImageReference;
    }

    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        LinkedHashSet result = ContainerUtil.newLinkedHashSet();
        Collection defaultContexts = super.computeDefaultContexts();
        PsiFileSystemItem parentDirectoryContext = (PsiFileSystemItem)ContainerUtil.getFirstItem((Collection)this.getParentDirectoryContext());
        if (parentDirectoryContext != null) {
            boolean parentDirectoryAdded = false;
            for (PsiFileSystemItem defaultContext : defaultContexts) {
                if (!Comparing.equal((Object)defaultContext.getVirtualFile(), (Object)parentDirectoryContext.getVirtualFile())) continue;
                result.add(defaultContext);
                parentDirectoryAdded = true;
            }
            if (!parentDirectoryAdded) {
                result.add(parentDirectoryContext);
            }
        }
        result.addAll(defaultContexts);
        ContainerUtil.addAllNotNull((Collection)result, this.getJavaResourceRoots());
        LinkedHashSet linkedHashSet = result;
        if (linkedHashSet == null) {
            StylesheetFileReferenceSet.$$$reportNull$$$0(6);
        }
        return linkedHashSet;
    }

    @NotNull
    private Collection<PsiFileSystemItem> getJavaResourceRoots() {
        if (!PlatformUtils.isIdeaUltimate()) {
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                StylesheetFileReferenceSet.$$$reportNull$$$0(7);
            }
            return list;
        }
        PsiElement element = this.getElement();
        if (!element.isValid()) {
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                StylesheetFileReferenceSet.$$$reportNull$$$0(8);
            }
            return list;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                StylesheetFileReferenceSet.$$$reportNull$$$0(9);
            }
            return list;
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        List list = ContainerUtil.map((Collection)moduleRootManager.getSourceRoots((JpsModuleSourceRootType)JavaResourceRootType.RESOURCE), file -> FileReferenceHelper.getPsiFileSystemItem((PsiManager)element.getManager(), (VirtualFile)file));
        if (list == null) {
            StylesheetFileReferenceSet.$$$reportNull$$$0(10);
        }
        return list;
    }

    protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
        return this.COMPLETION_FILTER;
    }

    public FileReference createFileReference(TextRange range, int index, String text) {
        return new StylesheetFileReference(this, range, index, text);
    }

    protected boolean useIncludingFileAsContext() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceText";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/resolve/StylesheetFileReferenceSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/resolve/StylesheetFileReferenceSet";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDefaultContexts";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaResourceRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

