/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logging;

import com.intellij.diagnostic.logging.LogConsoleManager;
import com.intellij.execution.configurations.AdditionalTabComponentManager;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Alarm;
import com.intellij.util.SingleAlarm;
import gnu.trove.THashSet;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogFilesManager {
    private final LogConsoleManager myManager;
    private final List<LogFile> myLogFiles;
    private final SingleAlarm myUpdateAlarm;

    public LogFilesManager(final @NotNull Project project, @NotNull LogConsoleManager manager, @NotNull Disposable parentDisposable) {
        if (project == null) {
            LogFilesManager.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            LogFilesManager.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            LogFilesManager.$$$reportNull$$$0(2);
        }
        this.myLogFiles = new ArrayList<LogFile>();
        this.myManager = manager;
        this.myUpdateAlarm = new SingleAlarm(new Runnable(){

            @Override
            public void run() {
                if (project.isDisposed()) {
                    return;
                }
                for (LogFile logFile : new ArrayList(LogFilesManager.this.myLogFiles)) {
                    ProcessHandler process2 = logFile.getProcess();
                    if (process2 != null && process2.isProcessTerminated()) {
                        LogFilesManager.this.myLogFiles.remove(logFile);
                        continue;
                    }
                    Set<String> oldPaths = logFile.getPaths();
                    Set newPaths = logFile.getOptions().getPaths();
                    logFile.setPaths(newPaths);
                    THashSet obsoletePaths = new THashSet(oldPaths);
                    obsoletePaths.removeAll(newPaths);
                    try {
                        SwingUtilities.invokeAndWait(() -> this.lambda$run$1(project, logFile, oldPaths, newPaths, (Set)obsoletePaths));
                    }
                    catch (InterruptedException | InvocationTargetException exception) {}
                }
                if (!LogFilesManager.this.myLogFiles.isEmpty()) {
                    LogFilesManager.this.myUpdateAlarm.cancelAndRequest();
                }
            }

            private /* synthetic */ void lambda$run$1(@NotNull Project project2, LogFile logFile, Set oldPaths, Set newPaths, Set obsoletePaths) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (project2.isDisposed()) {
                    return;
                }
                LogFilesManager.this.addConfigurationConsoles(logFile.getOptions(), (Condition<? super String>)file2 -> !oldPaths.contains(file2), newPaths, logFile.getConfiguration());
                for (String each : obsoletePaths) {
                    LogFilesManager.this.myManager.removeLogConsole(each);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/diagnostic/logging/LogFilesManager$1", "lambda$run$1"));
            }
        }, 500, Alarm.ThreadToUse.POOLED_THREAD, parentDisposable);
    }

    public void addLogConsoles(@NotNull RunConfigurationBase<?> runConfiguration, @Nullable ProcessHandler startedProcess) {
        if (runConfiguration == null) {
            LogFilesManager.$$$reportNull$$$0(3);
        }
        for (LogFileOptions logFileOptions : runConfiguration.getAllLogFiles()) {
            if (!logFileOptions.isEnabled()) continue;
            this.myLogFiles.add(new LogFile(logFileOptions, runConfiguration, startedProcess));
        }
        this.myUpdateAlarm.request();
        runConfiguration.createAdditionalTabComponents((AdditionalTabComponentManager)this.myManager, startedProcess);
    }

    private void addConfigurationConsoles(@NotNull LogFileOptions logFile, @NotNull Condition<? super String> shouldInclude, @NotNull Set<String> paths, @NotNull RunConfigurationBase runConfiguration) {
        if (logFile == null) {
            LogFilesManager.$$$reportNull$$$0(4);
        }
        if (shouldInclude == null) {
            LogFilesManager.$$$reportNull$$$0(5);
        }
        if (paths == null) {
            LogFilesManager.$$$reportNull$$$0(6);
        }
        if (runConfiguration == null) {
            LogFilesManager.$$$reportNull$$$0(7);
        }
        if (paths.isEmpty()) {
            return;
        }
        TreeMap<String, String> titleToPath = new TreeMap<String, String>();
        if (paths.size() == 1) {
            String path = paths.iterator().next();
            if (shouldInclude.value((Object)path)) {
                titleToPath.put(logFile.getName(), path);
            }
        } else {
            for (String path : paths) {
                if (!shouldInclude.value((Object)path)) continue;
                String title = new File(path).getName();
                if (titleToPath.containsKey(title)) {
                    title = path;
                }
                titleToPath.put(title, path);
            }
        }
        for (String title : titleToPath.keySet()) {
            String path = (String)titleToPath.get(title);
            assert (path != null);
            this.myManager.addLogConsole(title, path, logFile.getCharset(), logFile.isSkipContent() ? new File(path).length() : 0L, runConfiguration);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shouldInclude";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diagnostic/logging/LogFilesManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addLogConsoles";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addConfigurationConsoles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class LogFile {
        private final LogFileOptions myOptions;
        private final RunConfigurationBase myConfiguration;
        private final ProcessHandler myProcess;
        private Set<String> myPaths = new HashSet<String>();

        LogFile(LogFileOptions options, RunConfigurationBase configuration, ProcessHandler process2) {
            this.myOptions = options;
            this.myConfiguration = configuration;
            this.myProcess = process2;
        }

        public LogFileOptions getOptions() {
            return this.myOptions;
        }

        public RunConfigurationBase getConfiguration() {
            return this.myConfiguration;
        }

        public ProcessHandler getProcess() {
            return this.myProcess;
        }

        public Set<String> getPaths() {
            return this.myPaths;
        }

        public void setPaths(Set<String> paths) {
            this.myPaths = paths;
        }
    }
}

