/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.TerminationException;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Message
extends Instruction {
    private Expression terminate;
    private Expression select;
    private Expression errorCode;
    private NamespaceResolver nsResolver;
    private boolean isAssert;

    public Message(Expression select, Expression terminate, Expression errorCode) {
        this.terminate = terminate;
        this.select = select;
        this.errorCode = errorCode;
        this.adoptChildExpression(terminate);
        this.adoptChildExpression(select);
    }

    public void setIsAssert(boolean isAssert) {
        this.isAssert = isAssert;
    }

    public void setNamespaceResolver(NamespaceResolver resolver) {
        this.nsResolver = resolver;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.select = visitor.simplify(this.select);
        this.terminate = visitor.simplify(this.terminate);
        this.errorCode = visitor.simplify(this.errorCode);
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        this.select = visitor.typeCheck(this.select, contextItemType);
        this.adoptChildExpression(this.select);
        this.terminate = visitor.typeCheck(this.terminate, contextItemType);
        this.adoptChildExpression(this.terminate);
        this.errorCode = visitor.typeCheck(this.errorCode, contextItemType);
        this.adoptChildExpression(this.errorCode);
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        this.select = visitor.optimize(this.select, contextItemType);
        this.adoptChildExpression(this.select);
        this.terminate = visitor.optimize(this.terminate, contextItemType);
        this.adoptChildExpression(this.terminate);
        this.errorCode = visitor.optimize(this.errorCode, contextItemType);
        this.adoptChildExpression(this.errorCode);
        return this;
    }

    @Override
    public Expression copy() {
        return new Message(this.select.copy(), this.terminate.copy(), this.errorCode.copy());
    }

    @Override
    public int getInstructionNameCode() {
        return this.isAssert ? 133 : 173;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return AnyItemType.getInstance();
    }

    @Override
    public int getCardinality() {
        return 24576;
    }

    @Override
    public final boolean createsNewNodes() {
        return true;
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        this.select = this.doPromotion(this.select, offer);
        this.terminate = this.doPromotion(this.terminate, offer);
        this.errorCode = this.doPromotion(this.errorCode, offer);
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        Expression[] children = new Expression[]{this.select, this.terminate, this.errorCode};
        return Arrays.asList(children).iterator();
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.select == original) {
            this.select = replacement;
            found = true;
        }
        if (this.terminate == original) {
            this.terminate = replacement;
            found = true;
        }
        if (this.errorCode == original) {
            this.errorCode = replacement;
            found = true;
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        assert (controller != null);
        Receiver emitter = controller.getMessageEmitter();
        if (emitter != null) {
            Receiver receiver = emitter;
            synchronized (receiver) {
                Item item;
                SequenceReceiver rec = new TreeReceiver(emitter);
                rec = new AttributeMasker(rec);
                SequenceReceiver saved = context.getReceiver();
                Properties props = new Properties();
                props.setProperty("omit-xml-declaration", "yes");
                SerializerFactory sf = context.getConfiguration().getSerializerFactory();
                PipelineConfiguration pipe = controller.makePipelineConfiguration();
                pipe.setHostLanguage(50);
                Receiver receiver2 = sf.getReceiver(rec, pipe, props);
                context.changeOutputDestination(receiver2, null);
                boolean abort = false;
                String term = this.terminate.evaluateAsString(context).toString();
                if (!term.equals("no")) {
                    if (term.equals("yes")) {
                        abort = true;
                    } else {
                        XPathException e = new XPathException("The terminate attribute of xsl:message must be 'yes' or 'no'");
                        e.setXPathContext(context);
                        e.setErrorCode("XTDE0030");
                        throw e;
                    }
                }
                rec.startDocument(abort ? 16384 : 0);
                SequenceIterator<? extends Item> iter = this.select.iterate(context);
                while ((item = iter.next()) != null) {
                    rec.append(item, this.locationId, 2);
                }
                rec.endDocument();
                context.setReceiver(saved);
                if (abort) {
                    TerminationException te = new TerminationException("Processing terminated by " + StandardErrorListener.getInstructionName(this) + " at line " + this.getLineNumber() + " in " + StandardErrorListener.abbreviatePath(this.getSystemId()));
                    try {
                        String code = this.errorCode.evaluateAsString(context).toString();
                        StructuredQName errorCode = StructuredQName.fromLexicalQName(code, false, true, context.getConfiguration().getNameChecker(), this.nsResolver);
                        te.setErrorCodeQName(errorCode);
                        te.setLocator(this);
                    }
                    catch (XPathException err) {
                        // empty catch block
                    }
                    throw te;
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("xslMessage");
        out.endElement();
    }

    private static class AttributeMasker
    extends ProxyReceiver {
        private boolean contentStarted = true;

        public AttributeMasker(SequenceReceiver next) {
            super(next);
        }

        public void startElement(NodeName nameCode, SchemaType typeCode, int locationId, int properties) throws XPathException {
            this.contentStarted = false;
            super.startElement(nameCode, typeCode, locationId, properties);
        }

        public void startContent() throws XPathException {
            this.contentStarted = true;
            super.startContent();
        }

        public void attribute(NodeName attributeName, SimpleType typeCode, CharSequence value, int locationId, int properties) throws XPathException {
            if (this.contentStarted) {
                String attName = attributeName.getDisplayName();
                this.processingInstruction("attribute", "name=\"" + attName + "\" value=\"" + value + "\"", 0, 0);
            } else {
                super.attribute(attributeName, typeCode, value, locationId, properties);
            }
        }

        public void namespace(NamespaceBinding namespaceBinding, int properties) throws XPathException {
            if (this.contentStarted) {
                String prefix = namespaceBinding.getPrefix();
                String uri = namespaceBinding.getURI();
                this.processingInstruction("namespace", "prefix=\"" + prefix + "\" uri=\"" + uri + "\"", 0, 0);
            } else {
                super.namespace(namespaceBinding, properties);
            }
        }

        public void append(Item item, int locationId, int copyNamespaces) throws XPathException {
            int kind;
            if (item instanceof NodeInfo && ((kind = ((NodeInfo)item).getNodeKind()) == 2 || kind == 13)) {
                ((NodeInfo)item).copy(this, 0, 0);
                return;
            }
            ((SequenceReceiver)this.nextReceiver).append(item, locationId, copyNamespaces);
        }
    }
}

