/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.StreamWriterToReceiver;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.ResultDocument;
import net.sf.saxon.lib.SaxonOutputKeys;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trans.XPathException;

public class Serializer
implements Destination {
    private Configuration config;
    private Map<Property, String> properties = new HashMap<Property, String>(10);
    private StreamResult result = new StreamResult();
    private boolean mustClose = false;

    public Serializer() {
    }

    public Serializer(OutputStream stream) {
        this.setOutputStream(stream);
    }

    public Serializer(Writer writer) {
        this.setOutputWriter(writer);
    }

    public Serializer(File file) {
        this.setOutputFile(file);
    }

    public void setProcessor(Processor processor) {
        this.config = processor.getUnderlyingConfiguration();
    }

    public void setOutputProperty(Property property, String value) {
        try {
            SaxonOutputKeys.checkOutputProperty(property.toString(), value, null);
        }
        catch (XPathException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        if (value == null) {
            this.properties.remove((Object)property);
        } else {
            this.properties.put(property, value);
        }
    }

    public String getOutputProperty(Property property) {
        return this.properties.get((Object)property);
    }

    public void setOutputWriter(Writer writer) {
        this.result.setOutputStream(null);
        this.result.setSystemId((String)null);
        this.result.setWriter(writer);
        this.mustClose = false;
    }

    public void setOutputStream(OutputStream stream) {
        this.result.setWriter(null);
        this.result.setSystemId((String)null);
        this.result.setOutputStream(stream);
        this.mustClose = false;
    }

    public void setOutputFile(File file) {
        this.result.setOutputStream(null);
        this.result.setWriter(null);
        this.result.setSystemId(file);
        this.mustClose = true;
    }

    public void serializeNode(XdmNode node) throws SaxonApiException {
        StreamResult res = this.result;
        if (res.getOutputStream() == null && res.getWriter() == null && res.getSystemId() == null) {
            throw new IllegalStateException("Either an outputStream, or a Writer, or a File must be supplied");
        }
        this.serializeNodeToResult(node, res);
    }

    public void serializeXdmValue(XdmValue value) throws SaxonApiException {
        if (value instanceof XdmNode) {
            this.serializeNode((XdmNode)value);
        } else {
            if (this.config == null) {
                throw new IllegalStateException("The serializer is not associated with any s9api Processor (need to call setProcessor())");
            }
            try {
                QueryResult.serializeSequence(value.getUnderlyingValue().iterate(), this.config, this.result, this.getOutputProperties());
            }
            catch (XPathException e) {
                throw new SaxonApiException(e);
            }
        }
    }

    public String serializeNodeToString(XdmNode node) throws SaxonApiException {
        StringWriter sw = new StringWriter();
        StreamResult sr = new StreamResult(sw);
        this.serializeNodeToResult(node, sr);
        return sw.toString();
    }

    private void serializeNodeToResult(XdmNode node, Result res) throws SaxonApiException {
        try {
            QueryResult.serialize(node.getUnderlyingNode(), res, this.getOutputProperties());
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public StreamWriterToReceiver getXMLStreamWriter() throws SaxonApiException {
        if (this.config == null) {
            throw new IllegalStateException("This method is available only if a Processor has been set");
        }
        Receiver r = this.getReceiver(this.config);
        r = new NamespaceReducer(r);
        return new StreamWriterToReceiver(r);
    }

    public Object getOutputDestination() {
        if (this.result.getOutputStream() != null) {
            return this.result.getOutputStream();
        }
        if (this.result.getWriter() != null) {
            return this.result.getWriter();
        }
        String systemId = this.result.getSystemId();
        if (systemId != null) {
            try {
                return new File(new URI(systemId));
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
        return null;
    }

    public Receiver getReceiver(Configuration config) throws SaxonApiException {
        try {
            SerializerFactory sf = config.getSerializerFactory();
            PipelineConfiguration pipe = config.makePipelineConfiguration();
            Properties props = this.getOutputProperties();
            Receiver target = sf.getReceiver(this.result, pipe, props);
            if (target.getSystemId() == null) {
                target.setSystemId(this.result.getSystemId());
            }
            return target;
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    protected Receiver getReceiver(Executable executable) throws SaxonApiException {
        try {
            Configuration config = executable.getConfiguration();
            SerializerFactory sf = config.getSerializerFactory();
            PipelineConfiguration pipe = config.makePipelineConfiguration();
            pipe.setSerializing(true);
            pipe.setHostLanguage(executable.getHostLanguage());
            Properties baseProps = executable.getDefaultOutputProperties();
            for (Map.Entry<Property, String> entry : this.properties.entrySet()) {
                QName name = entry.getKey().getQName();
                ResultDocument.setSerializationProperty(baseProps, name.getNamespaceURI(), name.getLocalName(), entry.getValue(), null, true, config);
            }
            Receiver target = sf.getReceiver(this.result, pipe, baseProps, executable.getCharacterMapIndex());
            if (target.getSystemId() == null) {
                target.setSystemId(this.result.getSystemId());
            }
            return target;
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    protected Properties getOutputProperties() {
        Properties props = new Properties();
        for (Property p : this.properties.keySet()) {
            String value = this.properties.get((Object)p);
            props.setProperty(p.toString(), value);
        }
        return props;
    }

    protected Result getResult() {
        return this.result;
    }

    public void close() throws SaxonApiException {
        if (this.mustClose) {
            Writer writer;
            OutputStream stream = this.result.getOutputStream();
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException err) {
                    throw new SaxonApiException("Failed while closing output file", err);
                }
            }
            if ((writer = this.result.getWriter()) != null) {
                try {
                    writer.close();
                }
                catch (IOException err) {
                    throw new SaxonApiException("Failed while closing output file", err);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        METHOD("method"),
        VERSION("version"),
        ENCODING("encoding"),
        OMIT_XML_DECLARATION("omit-xml-declaration"),
        STANDALONE("standalone"),
        DOCTYPE_PUBLIC("doctype-public"),
        DOCTYPE_SYSTEM("doctype-system"),
        CDATA_SECTION_ELEMENTS("cdata-section-elements"),
        INDENT("indent"),
        MEDIA_TYPE("media-type"),
        USE_CHARACTER_MAPS("use-character-maps"),
        INCLUDE_CONTENT_TYPE("include-content-type"),
        UNDECLARE_PREFIXES("undeclare-prefixes"),
        ESCAPE_URI_ATTRIBUTES("escape-uri-attributes"),
        BYTE_ORDER_MARK("byte-order-mark"),
        NORMALIZATION_FORM("normalization-form"),
        SAXON_INDENT_SPACES("{http://saxon.sf.net/}indent-spaces"),
        SAXON_LINE_LENGTH("{http://saxon.sf.net/}line-length"),
        SAXON_ATTRIBUTE_ORDER("{http://saxon.sf.net/}attribute-order"),
        SAXON_SUPPRESS_INDENTATION("suppress-indentation"),
        SAXON_DOUBLE_SPACE("{http://saxon.sf.net/}double-space"),
        SAXON_STYLESHEET_VERSION("{http://saxon.sf.net/}stylesheet-version"),
        SAXON_CHARACTER_REPRESENTATION("{http://saxon.sf.net/}character-representation"),
        SAXON_RECOGNIZE_BINARY("{http://saxon.sf.net/}recognize-binary"),
        SAXON_REQUIRE_WELL_FORMED("{http://saxon.sf.net/}require-well-formed"),
        SAXON_WRAP("{http://saxon.sf.net/}wrap-result-sequence"),
        SAXON_IMPLICIT_RESULT_DOCUMENT("{http://saxon.sf.net/}implicit-result-document"),
        SAXON_SUPPLY_SOURCE_LOCATOR("{http://saxon.sf.net/}supply-source-locator");

        private String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public QName getQName() {
            return QName.fromClarkName(this.name);
        }
    }
}

