/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.AbstractRefactoringTabbedDialog;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.AddUniqueConstraintColumnTableModel;

public class AddUniqueConstraintDialog
extends AbstractRefactoringTabbedDialog {
    private static final long serialVersionUID = -8499959410488757334L;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AddUniqueConstraintDialog.class);
    private final String _localTableName;
    private final String[] _localTableColumns;
    private ColumnsTab _columnTab;
    private PropertiesTab _propertiesTab;

    public AddUniqueConstraintDialog(String localTable, String[] localTableColumns) {
        super(new Dimension(430, 300));
        this._localTableName = localTable;
        this._localTableColumns = localTableColumns;
        this.init();
    }

    private void init() {
        this._columnTab = new ColumnsTab();
        this._propertiesTab = new PropertiesTab();
        this.pane.addTab(i18n.TABBEDPANE_PROPERTIES_LABEL, this._propertiesTab);
        this.pane.addTab(i18n.TABBEDPANE_COLUMNS_LABEL, this._columnTab);
        this.setAllButtonEnabled(false);
        this.setTitle(i18n.DIALOG_TITLE);
    }

    private void checkInputCompletion() {
        if (this._columnTab._columTable.getRowCount() == 0 || this.getConstraintName().equals("")) {
            this.setAllButtonEnabled(false);
            return;
        }
        this.setAllButtonEnabled(true);
    }

    public String getConstraintName() {
        return this._propertiesTab.getNameField();
    }

    public List<String> getUniqueColumns() {
        return this._columnTab.getUniqueColumns();
    }

    public static void main(String[] args) {
        AddUniqueConstraintDialog dialog = new AddUniqueConstraintDialog("local Table", new String[]{"id", "name", "street", "streetnr", "zip", "city"});
        dialog.setVisible(true);
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    class ColumnsTab
    extends JPanel {
        private static final long serialVersionUID = 3381783567015647873L;
        private JTable _columTable;
        private final AddUniqueConstraintColumnTableModel _columnTableModel = new AddUniqueConstraintColumnTableModel();
        private JComboBox localColumBox;
        private JButton removeButton;
        private JButton addButton;

        public ColumnsTab() {
            this.init();
            this.initData();
        }

        private void init() {
            this.setLayout(new GridBagLayout());
            this._columTable = new JTable();
            this._columTable.setModel(this._columnTableModel);
            this._columTable.setRowSelectionAllowed(true);
            this._columTable.setColumnSelectionAllowed(false);
            this._columTable.getTableHeader().setReorderingAllowed(false);
            this._columTable.setCellSelectionEnabled(false);
            this._columTable.setSelectionMode(0);
            this._columTable.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent event) {
                    ColumnsTab.this.removeButton.setEnabled(true);
                }
            });
            JScrollPane scrollTablePane = new JScrollPane(this._columTable);
            this.localColumBox = new JComboBox();
            this.localColumBox.setPreferredSize(AddUniqueConstraintDialog.this.mediumField);
            JPanel buttonPanel = new JPanel(new GridLayout(1, 0, 10, 10));
            this.addButton = new JButton(i18n.COLUMNS_ADD_BUTTON_LABEL);
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String local = (String)ColumnsTab.this.localColumBox.getSelectedItem();
                    ColumnsTab.this.localColumBox.removeItem(local);
                    ColumnsTab.this._columnTableModel.addColumn(local);
                    if (ColumnsTab.this.localColumBox.getItemCount() == 0) {
                        ColumnsTab.this.addButton.setEnabled(false);
                    }
                    AddUniqueConstraintDialog.this.checkInputCompletion();
                }
            });
            this.removeButton = new JButton(i18n.COLUMNS_REMOVE_BUTTON_LABEL);
            this.removeButton.setEnabled(false);
            this.removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = ColumnsTab.this._columTable.getSelectedRow();
                    if (index != -1) {
                        String removed = ColumnsTab.this._columnTableModel.deleteRow(index);
                        ColumnsTab.this.localColumBox.addItem(removed);
                        ColumnsTab.this.addButton.setEnabled(true);
                        if (ColumnsTab.this._columnTableModel.getRowCount() == 0) {
                            ColumnsTab.this.removeButton.setEnabled(false);
                        } else {
                            int deleteIndex = 0;
                            if (index > 0) {
                                deleteIndex = index - 1;
                            }
                            ColumnsTab.this._columTable.getSelectionModel().setSelectionInterval(0, deleteIndex);
                        }
                    }
                    AddUniqueConstraintDialog.this.checkInputCompletion();
                }
            });
            buttonPanel.add(this.addButton);
            buttonPanel.add(this.removeButton);
            Insets boxesInsets = new Insets(5, 5, 0, 5);
            this.add((Component)scrollTablePane, new GridBagConstraints(0, 0, 3, 3, 1.0, 1.0, 17, 1, boxesInsets, 0, 0));
            boxesInsets.bottom = 5;
            this.add((Component)this.localColumBox, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, boxesInsets, 0, 0));
            this.add((Component)buttonPanel, new GridBagConstraints(1, 3, 2, 0, 0.0, 0.0, 14, 0, boxesInsets, 0, 0));
        }

        private void initData() {
            this.setLocalColumns(AddUniqueConstraintDialog.this._localTableColumns);
        }

        private void setLocalColumns(String[] localColums) {
            this.localColumBox.removeAllItems();
            for (String colum : localColums) {
                this.localColumBox.addItem(colum);
            }
        }

        public List<String> getUniqueColumns() {
            return this._columnTableModel.getRowData();
        }
    }

    class PropertiesTab
    extends JPanel {
        private static final long serialVersionUID = 1949077865903781457L;
        private JTextField _nameField;

        public PropertiesTab() {
            this.init();
        }

        private void init() {
            this.setLayout(new GridBagLayout());
            JLabel tableLabel = AddUniqueConstraintDialog.this.getBorderedLabel(i18n.PROPERTIES_TABLE_NAME_LABEL, AddUniqueConstraintDialog.this.emptyBorder);
            JTextField _tableField = new JTextField();
            _tableField.setPreferredSize(AddUniqueConstraintDialog.this.mediumField);
            _tableField.setText(AddUniqueConstraintDialog.this._localTableName);
            _tableField.setEnabled(false);
            JLabel nameLabel = AddUniqueConstraintDialog.this.getBorderedLabel(i18n.PROPERTIES_NAME_LABEL, AddUniqueConstraintDialog.this.emptyBorder);
            this._nameField = new JTextField();
            this._nameField.setPreferredSize(AddUniqueConstraintDialog.this.mediumField);
            this._nameField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    AddUniqueConstraintDialog.this.checkInputCompletion();
                }
            });
            GridBagConstraints gbc = AddUniqueConstraintDialog.this.c;
            gbc.insets = new Insets(5, 5, 0, 5);
            gbc.gridx = 0;
            gbc.gridy = -1;
            this.add((Component)tableLabel, AddUniqueConstraintDialog.this.getLabelConstraints(gbc));
            this.add((Component)_tableField, AddUniqueConstraintDialog.this.getFieldConstraints(gbc));
            this.add((Component)nameLabel, AddUniqueConstraintDialog.this.getLabelConstraints(gbc));
            this.add((Component)this._nameField, AddUniqueConstraintDialog.this.getFieldConstraints(gbc));
            this.add((Component)new JPanel(), new GridBagConstraints(0, 2, 2, 1, 0.0, 2.0, 18, 3, gbc.insets, 0, 0));
        }

        public String getNameField() {
            return this._nameField.getText();
        }
    }

    protected static interface i18n {
        public static final String DIALOG_TITLE = AddUniqueConstraintDialog.access$000().getString("AddUniqueConstraintDialog.title");
        public static final String TABBEDPANE_PROPERTIES_LABEL = AddUniqueConstraintDialog.access$000().getString("AddUniqueConstraintDialog.propertiesTabName");
        public static final String TABBEDPANE_COLUMNS_LABEL = AddUniqueConstraintDialog.access$000().getString("AddUniqueConstraintDialog.columnsTabName");
        public static final String PROPERTIES_NAME_LABEL = AddUniqueConstraintDialog.access$000().getString("AddUniqueConstraintDialog.nameLabel");
        public static final String PROPERTIES_TABLE_NAME_LABEL = AddUniqueConstraintDialog.access$000().getString("AddUniqueConstraintDialog.tableNameLabel");
        public static final String COLUMNS_LOCAL_COLUMN_HEADER = AddUniqueConstraintDialog.access$000().getString("AddUniqueConstraintDialog.columnsTableHeader");
        public static final String COLUMNS_ADD_BUTTON_LABEL = AddUniqueConstraintDialog.access$000().getString("AddUniqueConstraintDialog.addButtonLabel");
        public static final String COLUMNS_REMOVE_BUTTON_LABEL = AddUniqueConstraintDialog.access$000().getString("AddUniqueConstraintDialog.removeButtonLabel");
    }
}

