/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.overview;

import java.util.ArrayList;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScaleTable;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.IndexedColumnFactory;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;

public class ColumnComboModel {
    private ColumnDisplayDefinition _columnDefinition;
    private int _columnIndexInDataScale;

    public ColumnComboModel(ColumnDisplayDefinition columnDefinition, int columnIndexInDataScale) {
        this._columnDefinition = columnDefinition;
        this._columnIndexInDataScale = columnIndexInDataScale;
    }

    public static ColumnComboModel[] createColumnComboModels(DataScaleTable dataScaleTable, boolean numbersOnly) {
        ArrayList<ColumnComboModel> ret = new ArrayList<ColumnComboModel>();
        for (int i = 0; i < dataScaleTable.getColumnDisplayDefinitions().length; ++i) {
            ColumnDisplayDefinition columnDisplayDefinition = dataScaleTable.getColumnDisplayDefinitions()[i];
            if (numbersOnly && !IndexedColumnFactory.isNumber(columnDisplayDefinition)) continue;
            ret.add(new ColumnComboModel(columnDisplayDefinition, i));
        }
        return ret.toArray(new ColumnComboModel[ret.size()]);
    }

    public String toString() {
        return this._columnDefinition.getColumnName();
    }

    public int hashCode() {
        return (this._columnDefinition.getFullTableColumnName() + "+++" + this._columnIndexInDataScale).hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnComboModel that = (ColumnComboModel)o;
        return this._columnDefinition.getFullTableColumnName().equals(that._columnDefinition.getFullTableColumnName()) && this._columnIndexInDataScale == that._columnIndexInDataScale;
    }

    public ColumnDisplayDefinition getColumnDisplayDefinition() {
        return this._columnDefinition;
    }

    public int getColumnIndexInDataScale() {
        return this._columnIndexInDataScale;
    }
}

