/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.util.ArrayList;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class XmlRefomatter {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(XmlRefomatter.class);
    private static String DEFAULT_MESSAGE;
    private static String _message;
    private static boolean _showWarningMessages;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String reformatXml(String xml) {
        if (xml.indexOf("<") == -1 || xml.equals("<null>")) {
            JOptionPane.showMessageDialog(null, s_stringMgr.getString("xmlRefomatter.noXml"), s_stringMgr.getString("xmlRefomatter.xmlWarning"), 2);
            return xml;
        }
        try {
            StringBuffer ret = new StringBuffer();
            int depth = 0;
            ParseRes parseRes = XmlRefomatter.getParseRes(xml, 0);
            if (parseRes == null) {
                XmlRefomatter.showWarning(_message);
                String string = xml;
                return string;
            }
            xml = xml.trim();
            ArrayList<String> tagList = new ArrayList<String>();
            while (null != parseRes) {
                if (0 == parseRes.type) {
                    tagList.add(parseRes.item);
                    ret.append(XmlRefomatter.getIndent(depth)).append(parseRes.item);
                    ParseRes nextRes = XmlRefomatter.getParseRes(xml, parseRes.pos);
                    if (nextRes == null) {
                        XmlRefomatter.showWarning(_message);
                        String string = xml;
                        return string;
                    }
                    if (3 != nextRes.type) {
                        ret.append("\n");
                    }
                    ++depth;
                } else if (1 == parseRes.type) {
                    if (tagList.size() > 0) {
                        String endTag;
                        String startTag = (String)tagList.remove(tagList.size() - 1);
                        String testableStartTag = startTag.substring(1, startTag.length() - 1).trim().toUpperCase();
                        if (testableStartTag.indexOf(32) > -1) {
                            testableStartTag = testableStartTag.substring(0, testableStartTag.indexOf(32));
                        }
                        if (!testableStartTag.equals(endTag = parseRes.item.substring(2, parseRes.item.length() - 1).trim().toUpperCase())) {
                            Object[] args = new Object[]{startTag, parseRes.item};
                            String msg = s_stringMgr.getString("xmlRefomatter.malformedXml", args);
                            XmlRefomatter.showWarning(msg);
                        }
                    }
                    --depth;
                    if (ret.toString().endsWith("\n")) {
                        ret.append(XmlRefomatter.getIndent(depth));
                    }
                    ret.append(parseRes.item).append("\n");
                } else if (2 == parseRes.type) {
                    ret.append(XmlRefomatter.getIndent(depth)).append(parseRes.item).append("\n");
                } else if (3 == parseRes.type) {
                    ret.append(parseRes.item);
                }
                parseRes = XmlRefomatter.getParseRes(xml, parseRes.pos);
            }
            String string = ret.toString();
            return string;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, DEFAULT_MESSAGE, s_stringMgr.getString("xmlReformatter.xmlWarning2"), 2);
            e.printStackTrace();
        }
        finally {
            _message = DEFAULT_MESSAGE;
            _showWarningMessages = true;
        }
        return xml;
    }

    private static void showWarning(String message) {
        if (!_showWarningMessages) {
            return;
        }
        Object[] options = new Object[]{s_stringMgr.getString("xmlReformatter.yes"), s_stringMgr.getString("xmlReformatter.no")};
        int ret = JOptionPane.showOptionDialog(null, s_stringMgr.getString("xmlReformatter.seeOtherErrs", message), s_stringMgr.getString("xmlReformatter.xmlWarning5"), -1, 2, null, options, options[0]);
        if (0 != ret) {
            _showWarningMessages = false;
        }
    }

    private static ParseRes getParseRes(String xml, int pos) {
        if (pos >= xml.length()) {
            return null;
        }
        pos = XmlRefomatter.moveOverWhiteSpaces(xml, pos);
        int ltIndex = xml.indexOf("<", pos);
        int gtIndex = xml.indexOf(">", pos);
        ParseRes ret = new ParseRes();
        if (pos == ltIndex) {
            ret.item = xml.substring(ltIndex, gtIndex + 1);
            ret.type = xml.length() > ltIndex + 1 && xml.charAt(ltIndex + 1) == '/' ? 1 : (pos < gtIndex - 1 && xml.charAt(gtIndex - 1) == '/' ? 2 : 0);
            ret.pos = gtIndex + 1;
        } else {
            if (ltIndex == -1) {
                int lengthToPrint = xml.length() - pos;
                if (lengthToPrint > 40) {
                    lengthToPrint = 40;
                }
                _message = s_stringMgr.getString("xmlReformatter.malformedXmlAt", xml.substring(pos, pos + lengthToPrint));
                return null;
            }
            ret.type = 3;
            ret.item = xml.substring(pos, ltIndex);
            ret.pos = ltIndex;
        }
        return ret;
    }

    private static int moveOverWhiteSpaces(String xml, int pos) {
        int ret = pos;
        while (Character.isWhitespace(xml.charAt(ret))) {
            ++ret;
        }
        return ret;
    }

    private static String getIndent(int depth) {
        StringBuffer ret = new StringBuffer("");
        for (int i = 0; i < depth; ++i) {
            ret.append("   ");
        }
        return ret.toString();
    }

    static {
        _message = DEFAULT_MESSAGE = s_stringMgr.getString("xmlRefomatter.unexpectedProblem");
        _showWarningMessages = true;
    }

    static class ParseRes {
        public static final int BEGIN_TAG = 0;
        public static final int END_TAG = 1;
        public static final int CLOSED_TAG = 2;
        public static final int TEXT = 3;
        String item;
        int type;
        int pos;

        ParseRes() {
        }
    }
}

