package TDS::PIM::Base;
# $Id: Base.pm,v 1.2 2000/12/20 14:59:42 tom Exp $
################################################################
#
# TDS::PIM::Base : base class for PIM(todo, schedule)
#
#  derived from TDS::Cache::Base
#
################################################################

use strict;
use vars qw(@ISA @EXPORT
	    $MaxNum
	    $BeginTemplate $EndTemplate $ContentTemplate
	    $Delim
	    $NormalColor $EmphasisColor $StrongColor);
use Exporter;

use Template;
use JConv;

use TDS::Cache::Base;

@ISA = qw(TDS::Cache::Base);
@EXPORT = qw(attributes);

attributes qw(content);

################################################################
sub initialize($)
{
    my $self = shift;

    # $self->cache_basename("todo");  # override
    die "cache_basename MUST be set"
	unless $self->cache_basename;
    $self->cache_suffix("html");
    $self->content([]);
    
    $self->SUPER::initialize;
}
################################################################
# Read: called by AsHTML only
sub Read($)
{
    my $self = shift;

    $self->ReadFile($self->GetDataFilename);
}
sub ReadFile($$)
{
    my ($self, $filename) = @_;

    require TDS::Collection;
    open(F, $filename) || return;
    *conv = mkjconv($TDS::Collection::TdfJcode, $TDS::System::InternalJcode);
    while (<F>){
	next if /^#/ || /^$/;
	my $tmp = $_;
	conv(\$tmp);
	$self->AddContentByLine($tmp);
    }
    close (F);
}
sub AddContentByLine($$)
{
    die "MUST override";
}
sub AddContent($$)
{
    my ($self, $content) = @_;
    
    push(@{$self->content}, $content);
}
################################################################
sub AsHTML($)
{
    my $self = shift;
    my $html;

    if ($self->IsFresh){
#	warn "pim: is fresh: ", ref $self;
	$html = $self->ReadCache;
    } else {
	$self->Read;

	$html = $self->AsContentHTML;
	
	if ($TDS::Collection::AutoReplace){
	    require TDS::Replacer;
	    ;TDS::Replacer->ReplaceLine(\$html);
	}
	$self->WriteCache($html);
    }
    return $html;
}

################
# override TDS::Cache
sub GetDataFilename($)
{
    my $self = shift;
    
    require TDS::DirInfo;
    return sprintf("%s/%s.dat",
		   &TDS::DirInfo::GetDataDir(),
		   $self->cache_basename);
}
    

1;
