#!/usr/pkg/bin/perl

use strict;

use lib qw(lib);

use TDS;
use TDS::DirInfo;
use TDS::Cache::DirInfo;
use TDS::AccessLog::DirInfo;

{
    my $wdd = $TDS::DirInfo::WebDiaryDir;
    my $dd = $TDS::DirInfo::DiaryDir;
    
    # log
    print "log dir\n";
    chmod(GetLogDir(), 0700);
    chmod(GetLogDir() . "/LastMmodified", 0700);

    # cache
    my $dynamic_cachedir = "$wdd/$TDS::Cache::DirInfo::DyanmicCacheDir";
    if (-d $dynamic_cachedir){
	print "dynamic cache dir\n";
	chmod($dynamic_cachedir, 0700);
    }

    # diary dir
    print "diary dir\n";
    chmod($dd, 0700);
    chmod("$dd/conf/author_id.txt", 0600);
}
    
print "done\n";

