/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool.stats;

import java.io.PrintStream;
import java.util.Collections;
import java.util.Map;
import org.apache.cassandra.tools.nodetool.stats.StatsPrinter;
import org.apache.cassandra.tools.nodetool.stats.TpStatsHolder;

public class TpStatsPrinter {
    public static StatsPrinter from(String format) {
        switch (format) {
            case "json": {
                return new StatsPrinter.JsonPrinter();
            }
            case "yaml": {
                return new StatsPrinter.YamlPrinter();
            }
        }
        return new DefaultPrinter();
    }

    public static class DefaultPrinter
    implements StatsPrinter<TpStatsHolder> {
        @Override
        public void print(TpStatsHolder data, PrintStream out) {
            Map<String, Object> convertData = data.convert2Map();
            out.printf("%-30s%10s%10s%15s%10s%18s%n", "Pool Name", "Active", "Pending", "Completed", "Blocked", "All time blocked");
            Map threadPools = convertData.get("ThreadPools") instanceof Map ? (Map)convertData.get("ThreadPools") : Collections.emptyMap();
            for (Map.Entry entry : threadPools.entrySet()) {
                Map values = entry.getValue() instanceof Map ? (Map)entry.getValue() : Collections.emptyMap();
                out.printf("%-30s%10s%10s%15s%10s%18s%n", entry.getKey(), values.get("ActiveTasks"), values.get("PendingTasks"), values.get("CompletedTasks"), values.get("CurrentlyBlockedTasks"), values.get("TotalBlockedTasks"));
            }
            out.printf("%n%-20s%10s%n", "Message type", "Dropped");
            Map droppedMessages = convertData.get("DroppedMessage") instanceof Map ? (Map)convertData.get("DroppedMessage") : Collections.emptyMap();
            for (Map.Entry entry : droppedMessages.entrySet()) {
                out.printf("%-20s%10s%n", entry.getKey(), entry.getValue());
            }
        }
    }
}

