/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.operators;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Iterator;
import java.util.Map;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.exception.JsonQueryTypeException;
import net.thisptr.jackson.jq.internal.misc.JsonNodeUtils;
import net.thisptr.jackson.jq.internal.operators.BinaryOperator;

public class PlusOperator
implements BinaryOperator {
    @Override
    public JsonNode apply(ObjectMapper mapper, JsonNode lhs, JsonNode rhs) throws JsonQueryException {
        if (lhs.isIntegralNumber() && rhs.isIntegralNumber()) {
            long r = lhs.asLong() + rhs.asLong();
            return JsonNodeUtils.asNumericNode(r);
        }
        if (lhs.isNumber() && rhs.isNumber()) {
            double r = lhs.asDouble() + rhs.asDouble();
            return JsonNodeUtils.asNumericNode(r);
        }
        if (lhs.isArray() && rhs.isArray()) {
            ArrayNode result = mapper.createArrayNode();
            result.addAll((ArrayNode)lhs);
            result.addAll((ArrayNode)rhs);
            return result;
        }
        if (lhs.isTextual() && rhs.isTextual()) {
            return new TextNode(lhs.asText() + rhs.asText());
        }
        if (lhs.isObject() && rhs.isObject()) {
            ObjectNode result = mapper.createObjectNode();
            Iterator liter = lhs.fields();
            while (liter.hasNext()) {
                Map.Entry e = (Map.Entry)liter.next();
                result.set((String)e.getKey(), (JsonNode)e.getValue());
            }
            Iterator riter = rhs.fields();
            while (riter.hasNext()) {
                Map.Entry e = (Map.Entry)riter.next();
                result.set((String)e.getKey(), (JsonNode)e.getValue());
            }
            return result;
        }
        if (lhs.isNull()) {
            return rhs;
        }
        if (rhs.isNull()) {
            return lhs;
        }
        throw new JsonQueryTypeException(lhs, rhs, "cannot be added");
    }

    @Override
    public String image() {
        return "+";
    }
}

