/*
 * Decompiled with CFR 0.152.
 */
package phase;

import blbutil.FloatArray;
import ints.IntArray;
import ints.IntList;
import ints.WrappedIntArray;
import phase.PhaseData;
import phase.SamplePhase;

public class MarkerCluster {
    private final int[] clusterToEnd;
    private final IntArray hetClusters;
    private final int nMissingGTClusters;
    private final boolean[] clustHasMissingGT;
    private final FloatArray pRecomb;

    public MarkerCluster(PhaseData phaseData, int n) {
        SamplePhase samplePhase = phaseData.estPhase().get(n);
        this.clusterToEnd = samplePhase.clustEnds();
        this.hetClusters = MarkerCluster.unphHetClusters(samplePhase, this.clusterToEnd);
        boolean[] blArray = new boolean[this.clusterToEnd.length];
        this.nMissingGTClusters = MarkerCluster.setClustHasMissingGT(samplePhase.missing(), this.clusterToEnd, blArray);
        this.clustHasMissingGT = blArray;
        this.pRecomb = MarkerCluster.pClustRecomb(phaseData.pRecomb(), this.clusterToEnd);
    }

    private static IntArray unphHetClusters(SamplePhase samplePhase, int[] nArray) {
        IntArray intArray = samplePhase.unphased();
        int n = intArray.size();
        IntList intList = new IntList(n);
        int n2 = 0;
        int n3 = n2 < n ? intArray.get(n2++) : Integer.MAX_VALUE;
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = nArray[i];
            if (n3 >= n4) continue;
            intList.add(i);
            int n5 = n3 = n2 < n ? intArray.get(n2++) : Integer.MAX_VALUE;
            while (n3 < n4) {
                n3 = n2 < n ? intArray.get(n2++) : Integer.MAX_VALUE;
            }
        }
        return new WrappedIntArray(intList);
    }

    private static int setClustHasMissingGT(IntArray intArray, int[] nArray, boolean[] blArray) {
        int n = 0;
        int n2 = 0;
        int n3 = intArray.size();
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = nArray[i];
            while (n2 < n3 && intArray.get(n2) < n4) {
                blArray[i] = true;
                ++n2;
            }
            if (!blArray[i]) continue;
            ++n;
        }
        return n;
    }

    private static FloatArray pClustRecomb(FloatArray floatArray, int[] nArray) {
        int n = nArray.length;
        float[] fArray = new float[n];
        int n2 = 0;
        for (int i = 1; i < n; ++i) {
            int n3 = nArray[i];
            float f = 1.0f;
            for (int j = n2; j < n3; ++j) {
                f *= 1.0f - floatArray.get(j);
            }
            fArray[i] = 1.0f - f;
            n2 = n3;
        }
        return new FloatArray(fArray);
    }

    public int nClusters() {
        return this.clusterToEnd.length;
    }

    public int clusterStart(int n) {
        return n == 0 ? 0 : this.clusterToEnd[n - 1];
    }

    public int clusterEnd(int n) {
        return this.clusterToEnd[n];
    }

    public FloatArray pRecomb() {
        return this.pRecomb;
    }

    public IntArray unphClusters() {
        return this.hetClusters;
    }

    public boolean clustHasMissingGT(int n) {
        return this.clustHasMissingGT[n];
    }

    public int nMissingGTClusters() {
        return this.nMissingGTClusters;
    }
}

