/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.file;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import org.diylc.common.DrawOption;
import org.diylc.common.IComponentFiler;
import org.diylc.common.IPlugInPort;
import org.diylc.common.PCBLayer;
import org.diylc.core.IDIYComponent;
import org.diylc.presenter.PCBLayerFiler;
import org.diylc.swingframework.IDrawingProvider;

public class TraceMaskDrawingProvider
implements IDrawingProvider {
    private IPlugInPort plugInPort;

    public TraceMaskDrawingProvider(IPlugInPort iPlugInPort) {
        this.plugInPort = iPlugInPort;
    }

    public Dimension getSize() {
        return this.plugInPort.getCanvasDimensions(false);
    }

    public void draw(int n, Graphics graphics) {
        this.plugInPort.draw((Graphics2D)graphics, EnumSet.of(DrawOption.ANTIALIASING), (IComponentFiler)new PCBLayerFiler(this.getUsedLayers()[n]));
    }

    public int getPageCount() {
        return this.getUsedLayers().length;
    }

    private PCBLayer[] getUsedLayers() {
        EnumSet<PCBLayer> enumSet = EnumSet.noneOf(PCBLayer.class);
        for (IDIYComponent iDIYComponent : this.plugInPort.getCurrentProject().getComponents()) {
            Class<?> clazz = iDIYComponent.getClass();
            try {
                Method method = clazz.getMethod("getLayer", new Class[0]);
                PCBLayer pCBLayer = (PCBLayer)method.invoke((Object)iDIYComponent, new Object[0]);
                enumSet.add(pCBLayer);
            }
            catch (Exception exception) {}
        }
        ArrayList<PCBLayer> arrayList = new ArrayList<PCBLayer>(enumSet);
        Collections.sort(arrayList);
        return arrayList.toArray(new PCBLayer[0]);
    }
}

